/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.api.python;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PickleUtils;
import net.razorvine.pickle.Pickler;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.api.python.SerDe$;
import org.apache.spark.mllib.api.python.SerDeBase;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uvAB\u0001\u0003\u0011\u0003Aa\"A\u0003TKJ$UM\u0003\u0002\u0004\t\u00051\u0001/\u001f;i_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)Q\u000e\u001c7jE*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014x\r\u0005\u0002\u0010!5\t!A\u0002\u0004\u0012\u0005!\u0005\u0001B\u0005\u0002\u0006'\u0016\u0014H)Z\n\u0004!M1\u0002CA\b\u0015\u0013\t)\"AA\u0005TKJ$UMQ1tKB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\ta1+\u001a:jC2L'0\u00192mK\")Q\u0004\u0005C\u0001?\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u000f\u0011\u001d\t\u0003C1A\u0005B\t\nq\u0002U-T!\u0006\u00136j\u0018)B\u0007.\u000bu)R\u000b\u0002GA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0005Y\u0006twMC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#AB*ue&tw\r\u0003\u0004-!\u0001\u0006IaI\u0001\u0011!f\u001b\u0006+\u0011*L?B\u000b5iS!H\u000b\u00022QA\f\t\u0001\u0005=\u0012!\u0003R3og\u00164Vm\u0019;peBK7m\u001b7feN\u0011Q\u0006\r\t\u0004cI\"T\"\u0001\t\n\u0005M\"\"a\u0003\"bg\u0016\u0004\u0016nY6mKJ\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0004\u0002\r1Lg.\u00197h\u0013\tIdGA\u0006EK:\u001cXMV3di>\u0014\b\"B\u000f.\t\u0003YD#\u0001\u001f\u0011\u0005Ej\u0003\"\u0002 .\t\u0003y\u0014!C:bm\u0016\u001cF/\u0019;f)\u0011\u00015\t\u0013)\u0011\u0005]\t\u0015B\u0001\"\u0019\u0005\u0011)f.\u001b;\t\u000b\u0011k\u0004\u0019A#\u0002\u0007=\u0014'\u000e\u0005\u0002%\r&\u0011q)\n\u0002\u0007\u001f\nTWm\u0019;\t\u000b%k\u0004\u0019\u0001&\u0002\u0007=,H\u000f\u0005\u0002L\u001d6\tAJ\u0003\u0002NO\u0005\u0011\u0011n\\\u0005\u0003\u001f2\u0013AbT;uaV$8\u000b\u001e:fC6DQ!U\u001fA\u0002I\u000bq\u0001]5dW2,'\u000f\u0005\u0002T56\tAK\u0003\u0002V-\u00061\u0001/[2lY\u0016T!a\u0016-\u0002\u0013I\f'p\u001c:wS:,'\"A-\u0002\u00079,G/\u0003\u0002\\)\n9\u0001+[2lY\u0016\u0014\b\"B/.\t\u0003q\u0016!C2p]N$(/^2u)\t)u\fC\u0003a9\u0002\u0007\u0011-\u0001\u0003be\u001e\u001c\bcA\fc\u000b&\u00111\r\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\u0004\u0006KB\u0001!A\u001a\u0002\u0013\t\u0016t7/Z'biJL\u0007\u0010U5dW2,'o\u0005\u0002eOB\u0019\u0011G\r5\u0011\u0005UJ\u0017B\u000167\u0005-!UM\\:f\u001b\u0006$(/\u001b=\t\u000bu!G\u0011\u00017\u0015\u00035\u0004\"!\r3\t\u000by\"G\u0011A8\u0015\t\u0001\u0003\u0018O\u001d\u0005\u0006\t:\u0004\r!\u0012\u0005\u0006\u0013:\u0004\rA\u0013\u0005\u0006#:\u0004\rA\u0015\u0005\u0006;\u0012$\t\u0001\u001e\u000b\u0003\u000bVDQ\u0001Y:A\u0002\u00054Qa\u001e\t\u0001\u0005a\u00141c\u00159beN,W*\u0019;sSb\u0004\u0016nY6mKJ\u001c\"A^=\u0011\u0007E\u0012$\u0010\u0005\u00026w&\u0011AP\u000e\u0002\r'B\f'o]3NCR\u0014\u0018\u000e\u001f\u0005\u0006;Y$\tA \u000b\u0002\u007fB\u0011\u0011G\u001e\u0005\u0007}Y$\t!a\u0001\u0015\u000f\u0001\u000b)!a\u0002\u0002\n!1A)!\u0001A\u0002\u0015Ca!SA\u0001\u0001\u0004Q\u0005BB)\u0002\u0002\u0001\u0007!\u000b\u0003\u0004^m\u0012\u0005\u0011Q\u0002\u000b\u0004\u000b\u0006=\u0001B\u00021\u0002\f\u0001\u0007\u0011MB\u0004\u0002\u0014A\u0001!!!\u0006\u0003'M\u0003\u0018M]:f-\u0016\u001cGo\u001c:QS\u000e\\G.\u001a:\u0014\t\u0005E\u0011q\u0003\t\u0005cI\nI\u0002E\u00026\u00037I1!!\b7\u00051\u0019\u0006/\u0019:tKZ+7\r^8s\u0011\u001di\u0012\u0011\u0003C\u0001\u0003C!\"!a\t\u0011\u0007E\n\t\u0002C\u0004?\u0003#!\t!a\n\u0015\u000f\u0001\u000bI#a\u000b\u0002.!1A)!\nA\u0002\u0015Ca!SA\u0013\u0001\u0004Q\u0005BB)\u0002&\u0001\u0007!\u000bC\u0004^\u0003#!\t!!\r\u0015\u0007\u0015\u000b\u0019\u0004\u0003\u0004a\u0003_\u0001\r!\u0019\u0004\b\u0003o\u0001\u0002AAA\u001d\u0005Ma\u0015MY3mK\u0012\u0004v.\u001b8u!&\u001c7\u000e\\3s'\u0011\t)$a\u000f\u0011\tE\u0012\u0014Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111\t\u0004\u0002\u0015I,wM]3tg&|g.\u0003\u0003\u0002H\u0005\u0005#\u0001\u0004'bE\u0016dW\r\u001a)pS:$\bbB\u000f\u00026\u0011\u0005\u00111\n\u000b\u0003\u0003\u001b\u00022!MA\u001b\u0011\u001dq\u0014Q\u0007C\u0001\u0003#\"r\u0001QA*\u0003+\n9\u0006\u0003\u0004E\u0003\u001f\u0002\r!\u0012\u0005\u0007\u0013\u0006=\u0003\u0019\u0001&\t\rE\u000by\u00051\u0001S\u0011\u001di\u0016Q\u0007C\u0001\u00037\"2!RA/\u0011\u0019\u0001\u0017\u0011\fa\u0001C\u001a9\u0011\u0011\r\t\u0001\u0005\u0005\r$!\u0004*bi&tw\rU5dW2,'o\u0005\u0003\u0002`\u0005\u0015\u0004\u0003B\u00193\u0003O\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[2\u0011A\u0004:fG>lW.\u001a8eCRLwN\\\u0005\u0005\u0003c\nYG\u0001\u0004SCRLgn\u001a\u0005\b;\u0005}C\u0011AA;)\t\t9\bE\u00022\u0003?BqAPA0\t\u0003\tY\bF\u0004A\u0003{\ny(!!\t\r\u0011\u000bI\b1\u0001F\u0011\u0019I\u0015\u0011\u0010a\u0001\u0015\"1\u0011+!\u001fA\u0002ICq!XA0\t\u0003\t)\tF\u0002F\u0003\u000fCa\u0001YAB\u0001\u0004\t\u0007\u0002CAF\u0003?\"I!!$\u0002%I\fG/\u001b8hg&#7\t[3dW2{gn\u001a\u000b\u0005\u0003\u001f\u000b)\nE\u0002\u0018\u0003#K1!a%\u0019\u0005\rIe\u000e\u001e\u0005\u0007\t\u0006%\u0005\u0019A#\t\u0013\u0005e\u0005\u00031A\u0005\u0002\u0005m\u0015aC5oSRL\u0017\r\\5{K\u0012,\"!!(\u0011\u0007]\ty*C\u0002\u0002\"b\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002&B\u0001\r\u0011\"\u0001\u0002(\u0006y\u0011N\\5uS\u0006d\u0017N_3e?\u0012*\u0017\u000fF\u0002A\u0003SC!\"a+\u0002$\u0006\u0005\t\u0019AAO\u0003\rAH%\r\u0005\t\u0003_\u0003\u0002\u0015)\u0003\u0002\u001e\u0006a\u0011N\\5uS\u0006d\u0017N_3eA!9\u00111\u0017\t\u0005B\u0005U\u0016AC5oSRL\u0017\r\\5{KR\t\u0001\tC\u0005\u0002:B\t\t\u0011\"\u0003\u0002<\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005)\u0005")
public final class SerDe {
    public static void initialize() {
        SerDe$.MODULE$.initialize();
    }

    public static void initialized_$eq(boolean bl) {
        SerDe$.MODULE$.initialized_$eq(bl);
    }

    public static boolean initialized() {
        return SerDe$.MODULE$.initialized();
    }

    public static String PYSPARK_PACKAGE() {
        return SerDe$.MODULE$.PYSPARK_PACKAGE();
    }

    public static JavaRDD<Object> pythonToJava(JavaRDD<byte[]> javaRDD, boolean bl) {
        return SerDe$.MODULE$.pythonToJava(javaRDD, bl);
    }

    public static JavaRDD<byte[]> javaToPython(JavaRDD<Object> javaRDD) {
        return SerDe$.MODULE$.javaToPython(javaRDD);
    }

    public static RDD<Object[]> fromTuple2RDD(RDD<Tuple2<Object, Object>> rDD) {
        return SerDe$.MODULE$.fromTuple2RDD(rDD);
    }

    public static RDD<Tuple2<Object, Object>> asTupleRDD(RDD<Object[]> rDD) {
        return SerDe$.MODULE$.asTupleRDD(rDD);
    }

    public static Object loads(byte[] byArray) {
        return SerDe$.MODULE$.loads(byArray);
    }

    public static byte[] dumps(Object object) {
        return SerDe$.MODULE$.dumps(object);
    }

    public static class RatingPickler
    extends SerDeBase.BasePickler<Rating> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            Rating rating = (Rating)obj;
            this.saveObjects(out, pickler, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rating.user()), BoxesRunTime.boxToInteger((int)rating.product()), BoxesRunTime.boxToDouble((double)rating.rating())}));
        }

        public Object construct(Object[] args) {
            if (args.length != 3) {
                throw new PickleException("should be 3");
            }
            return new Rating(this.ratingsIdCheckLong(args[0]), this.ratingsIdCheckLong(args[1]), BoxesRunTime.unboxToDouble((Object)args[2]));
        }

        private int ratingsIdCheckLong(Object obj) {
            try {
                return BoxesRunTime.unboxToInt((Object)obj);
            }
            catch (ClassCastException classCastException) {
                throw new PickleException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ratings id ", " exceeds "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{obj.toString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max integer value of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)}))).toString(), (Throwable)classCastException);
            }
        }

        public RatingPickler() {
            super(SerDe$.MODULE$, ClassTag$.MODULE$.apply(Rating.class));
        }
    }

    public static class DenseVectorPickler
    extends SerDeBase.BasePickler<DenseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseVector vector = (DenseVector)obj;
            byte[] bytes = new byte[8 * vector.size()];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            db.put(vector.values());
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(133);
        }

        public Object construct(Object[] args) {
            Predef$.MODULE$.require(args.length == 1);
            if (args.length != 1) {
                throw new PickleException("should be 1");
            }
            byte[] bytes = this.getBytes(args[0]);
            ByteBuffer bb = ByteBuffer.wrap(bytes, 0, bytes.length);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            double[] ans = new double[bytes.length / 8];
            db.get(ans);
            return Vectors$.MODULE$.dense(ans);
        }

        public DenseVectorPickler() {
            super(SerDe$.MODULE$, ClassTag$.MODULE$.apply(DenseVector.class));
        }
    }

    public static class DenseMatrixPickler
    extends SerDeBase.BasePickler<DenseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseMatrix m = (DenseMatrix)obj;
            byte[] bytes = new byte[8 * m.values().length];
            ByteOrder order = ByteOrder.nativeOrder();
            int isTransposed = m.isTransposed() ? 1 : 0;
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().put(m.values());
            out.write(40);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)isTransposed));
            out.write(116);
        }

        public Object construct(Object[] args) {
            if (args.length != 4) {
                throw new PickleException("should be 4");
            }
            byte[] bytes = this.getBytes(args[2]);
            int n = bytes.length / 8;
            double[] values = new double[n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().get(values);
            boolean isTransposed = BoxesRunTime.unboxToInt((Object)args[3]) == 1;
            return new DenseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), values, isTransposed);
        }

        public DenseMatrixPickler() {
            super(SerDe$.MODULE$, ClassTag$.MODULE$.apply(DenseMatrix.class));
        }
    }

    public static class SparseMatrixPickler
    extends SerDeBase.BasePickler<SparseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseMatrix s = (SparseMatrix)obj;
            ByteOrder order = ByteOrder.nativeOrder();
            byte[] colPtrsBytes = new byte[4 * s.colPtrs().length];
            byte[] indicesBytes = new byte[4 * s.rowIndices().length];
            byte[] valuesBytes = new byte[8 * s.values().length];
            int isTransposed = s.isTransposed() ? 1 : 0;
            ByteBuffer.wrap(colPtrsBytes).order(order).asIntBuffer().put(s.colPtrs());
            ByteBuffer.wrap(indicesBytes).order(order).asIntBuffer().put(s.rowIndices());
            ByteBuffer.wrap(valuesBytes).order(order).asDoubleBuffer().put(s.values());
            out.write(40);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)s.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)s.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)colPtrsBytes.length));
            out.write(colPtrsBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indicesBytes.length));
            out.write(indicesBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valuesBytes.length));
            out.write(valuesBytes);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)isTransposed));
            out.write(116);
        }

        public Object construct(Object[] args) {
            if (args.length != 6) {
                throw new PickleException("should be 6");
            }
            ByteOrder order = ByteOrder.nativeOrder();
            byte[] colPtrsBytes = this.getBytes(args[2]);
            byte[] indicesBytes = this.getBytes(args[3]);
            byte[] valuesBytes = this.getBytes(args[4]);
            int[] colPtrs = new int[colPtrsBytes.length / 4];
            int[] rowIndices = new int[indicesBytes.length / 4];
            double[] values = new double[valuesBytes.length / 8];
            ByteBuffer.wrap(colPtrsBytes).order(order).asIntBuffer().get(colPtrs);
            ByteBuffer.wrap(indicesBytes).order(order).asIntBuffer().get(rowIndices);
            ByteBuffer.wrap(valuesBytes).order(order).asDoubleBuffer().get(values);
            boolean isTransposed = BoxesRunTime.unboxToInt((Object)args[5]) == 1;
            return new SparseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), colPtrs, rowIndices, values, isTransposed);
        }

        public SparseMatrixPickler() {
            super(SerDe$.MODULE$, ClassTag$.MODULE$.apply(SparseMatrix.class));
        }
    }

    public static class SparseVectorPickler
    extends SerDeBase.BasePickler<SparseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseVector v = (SparseVector)obj;
            int n = v.indices().length;
            byte[] indiceBytes = new byte[4 * n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().put(v.indices());
            byte[] valueBytes = new byte[8 * n];
            ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().put(v.values());
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)v.size()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indiceBytes.length));
            out.write(indiceBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valueBytes.length));
            out.write(valueBytes);
            out.write(135);
        }

        public Object construct(Object[] args) {
            Object object;
            if (args.length != 3) {
                throw new PickleException("should be 3");
            }
            int size = BoxesRunTime.unboxToInt((Object)args[0]);
            byte[] indiceBytes = this.getBytes(args[1]);
            byte[] valueBytes = this.getBytes(args[2]);
            int n = indiceBytes.length / 4;
            int[] indices = new int[n];
            double[] values = new double[n];
            if (n > 0) {
                ByteOrder order = ByteOrder.nativeOrder();
                ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().get(indices);
                object = ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().get(values);
            } else {
                object = BoxedUnit.UNIT;
            }
            return new SparseVector(size, indices, values);
        }

        public SparseVectorPickler() {
            super(SerDe$.MODULE$, ClassTag$.MODULE$.apply(SparseVector.class));
        }
    }

    public static class LabeledPointPickler
    extends SerDeBase.BasePickler<LabeledPoint> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            LabeledPoint point = (LabeledPoint)obj;
            this.saveObjects(out, pickler, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)point.label()), point.features()}));
        }

        public Object construct(Object[] args) {
            if (args.length != 2) {
                throw new PickleException("should be 2");
            }
            return new LabeledPoint(BoxesRunTime.unboxToDouble((Object)args[0]), (Vector)args[1]);
        }

        public LabeledPointPickler() {
            super(SerDe$.MODULE$, ClassTag$.MODULE$.apply(LabeledPoint.class));
        }
    }
}

