/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.graphite;

import com.codahale.metrics.graphite.GraphiteSender;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class GraphiteUDP
implements GraphiteSender {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String hostname;
    private final int port;
    private InetSocketAddress address;
    private DatagramChannel datagramChannel = null;
    private int failures;

    public GraphiteUDP(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.address = null;
    }

    public GraphiteUDP(InetSocketAddress address) {
        this.hostname = null;
        this.port = -1;
        this.address = address;
    }

    @Override
    public void connect() throws IllegalStateException, IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        if (this.hostname != null) {
            this.address = new InetSocketAddress(this.hostname, this.port);
        }
        this.datagramChannel = DatagramChannel.open();
    }

    @Override
    public boolean isConnected() {
        return this.datagramChannel != null && !this.datagramChannel.socket().isClosed();
    }

    @Override
    public void send(String name, String value, long timestamp) throws IOException {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(this.sanitize(name));
            buf.append(' ');
            buf.append(this.sanitize(value));
            buf.append(' ');
            buf.append(Long.toString(timestamp));
            buf.append('\n');
            String str = buf.toString();
            ByteBuffer byteBuffer = ByteBuffer.wrap(str.getBytes(UTF_8));
            this.datagramChannel.send(byteBuffer, this.address);
            this.failures = 0;
        }
        catch (IOException e) {
            ++this.failures;
            throw e;
        }
    }

    @Override
    public int getFailures() {
        return this.failures;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.datagramChannel != null) {
            try {
                this.datagramChannel.close();
            }
            finally {
                this.datagramChannel = null;
            }
        }
    }

    protected String sanitize(String s) {
        return WHITESPACE.matcher(s).replaceAll("-");
    }

    DatagramChannel getDatagramChannel() {
        return this.datagramChannel;
    }

    void setDatagramChannel(DatagramChannel datagramChannel) {
        this.datagramChannel = datagramChannel;
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    void setAddress(InetSocketAddress address) {
        this.address = address;
    }
}

