/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.graphite;

import com.codahale.metrics.graphite.GraphiteSender;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultSocketConfigurator;
import com.rabbitmq.client.SocketConfigurator;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class GraphiteRabbitMQ
implements GraphiteSender {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Integer DEFAULT_RABBIT_CONNECTION_TIMEOUT_MS = 500;
    private static final Integer DEFAULT_RABBIT_SOCKET_TIMEOUT_MS = 5000;
    private static final Integer DEFAULT_RABBIT_REQUESTED_HEARTBEAT_SEC = 10;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Channel channel;
    private String exchange;
    private int failures;

    public GraphiteRabbitMQ(ConnectionFactory connectionFactory, String exchange) {
        this.connectionFactory = connectionFactory;
        this.exchange = exchange;
    }

    public GraphiteRabbitMQ(String rabbitHost, Integer rabbitPort, String rabbitUsername, String rabbitPassword, String exchange) {
        this(rabbitHost, rabbitPort, rabbitUsername, rabbitPassword, exchange, DEFAULT_RABBIT_CONNECTION_TIMEOUT_MS, DEFAULT_RABBIT_SOCKET_TIMEOUT_MS, DEFAULT_RABBIT_REQUESTED_HEARTBEAT_SEC);
    }

    public GraphiteRabbitMQ(String rabbitHost, Integer rabbitPort, String rabbitUsername, String rabbitPassword, String exchange, Integer rabbitConnectionTimeoutMS, final Integer rabbitSocketTimeoutMS, Integer rabbitRequestedHeartbeatInSeconds) {
        this.exchange = exchange;
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setSocketConfigurator((SocketConfigurator)new DefaultSocketConfigurator(){

            public void configure(Socket socket) throws IOException {
                super.configure(socket);
                socket.setSoTimeout(rabbitSocketTimeoutMS);
            }
        });
        this.connectionFactory.setConnectionTimeout(rabbitConnectionTimeoutMS.intValue());
        this.connectionFactory.setRequestedHeartbeat(rabbitRequestedHeartbeatInSeconds.intValue());
        this.connectionFactory.setHost(rabbitHost);
        this.connectionFactory.setPort(rabbitPort.intValue());
        this.connectionFactory.setUsername(rabbitUsername);
        this.connectionFactory.setPassword(rabbitPassword);
    }

    @Override
    public void connect() throws IllegalStateException, IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        this.connection = this.connectionFactory.newConnection();
        this.channel = this.connection.createChannel();
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isOpen();
    }

    @Override
    public void send(String name, String value, long timestamp) throws IOException {
        try {
            String sanitizedName = this.sanitize(name);
            String sanitizedValue = this.sanitize(value);
            String message = sanitizedName + ' ' + sanitizedValue + ' ' + Long.toString(timestamp) + '\n';
            this.channel.basicPublish(this.exchange, sanitizedName, null, message.getBytes(UTF_8));
        }
        catch (IOException e) {
            ++this.failures;
            throw e;
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    public int getFailures() {
        return this.failures;
    }

    public String sanitize(String s) {
        return WHITESPACE.matcher(s).replaceAll("-");
    }
}

