/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Minute$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp) - Returns the minute component of the string/timestamp.", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 12:58:59');\n       58\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u0001>\u0011a!T5okR,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001Bc\u0006\u000e!!\t\t\"#D\u0001\u0003\u0013\t\u0019\"AA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#aI!!\u0007\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u001a!C\u0001K\u0005)1\r[5mIV\ta\u0005\u0005\u0002\u0012O%\u0011\u0001F\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002\u0003\u0016\u0001\u0005#\u0005\u000b\u0011\u0002\u0014\u0002\r\rD\u0017\u000e\u001c3!\u0011!a\u0003A!f\u0001\n\u0003i\u0013A\u0003;j[\u0016TvN\\3JIV\ta\u0006E\u0002\u001c_EJ!\u0001\r\u000f\u0003\r=\u0003H/[8o!\t\u0011TG\u0004\u0002\u001cg%\u0011A\u0007H\u0001\u0007!J,G-\u001a4\n\u0005Y:$AB*ue&twM\u0003\u000259!A\u0011\b\u0001B\tB\u0003%a&A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0003\"B\u001e\u0001\t\u0003a\u0014A\u0002\u001fj]&$h\bF\u0002>}}\u0002\"!\u0005\u0001\t\u000b\u0011R\u0004\u0019\u0001\u0014\t\u000f1R\u0004\u0013!a\u0001]!)1\b\u0001C\u0001\u0003R\u0011QH\u0011\u0005\u0006I\u0001\u0003\rA\n\u0005\u0006\t\u0002!\t%R\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001$\u0011\u0007\u001d{%K\u0004\u0002I\u001b:\u0011\u0011\nT\u0007\u0002\u0015*\u00111JD\u0001\u0007yI|w\u000e\u001e \n\u0003uI!A\u0014\u000f\u0002\u000fA\f7m[1hK&\u0011\u0001+\u0015\u0002\u0004'\u0016\f(B\u0001(\u001d!\t\u0019f+D\u0001U\u0015\t)f!A\u0003usB,7/\u0003\u0002X)\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/\u001a\u0005\u00063\u0002!\tEW\u0001\tI\u0006$\u0018\rV=qKV\t1\f\u0005\u0002T9&\u0011Q\f\u0016\u0002\t\t\u0006$\u0018\rV=qK\")q\f\u0001C!A\u0006aq/\u001b;i)&lWMW8oKR\u0011A#\u0019\u0005\u0006Yy\u0003\r!\r\u0005\u0006G\u0002!\t\u0006Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0003K\"\u0004\"a\u00074\n\u0005\u001dd\"aA!os\")\u0011N\u0019a\u0001K\u0006IA/[7fgR\fW\u000e\u001d\u0005\u0006W\u0002!\t\u0005\\\u0001\nI><UM\\\"pI\u0016$2!\\:y!\tq\u0017/D\u0001p\u0015\t\u0001(!A\u0004d_\u0012,w-\u001a8\n\u0005I|'\u0001C#yaJ\u001cu\u000eZ3\t\u000bQT\u0007\u0019A;\u0002\u0007\r$\b\u0010\u0005\u0002om&\u0011qo\u001c\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015I(\u000e1\u0001n\u0003\t)g\u000fC\u0004|\u0001\u0005\u0005I\u0011\u0001?\u0002\t\r|\u0007/\u001f\u000b\u0004{ut\bb\u0002\u0013{!\u0003\u0005\rA\n\u0005\bYi\u0004\n\u00111\u0001/\u0011%\t\t\u0001AI\u0001\n\u0003\t\u0019!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015!f\u0001\u0014\u0002\b-\u0012\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0014q\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9\"!\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u001c\u0001\t\n\u0011\"\u0001\u0002\u001e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0010U\rq\u0013q\u0001\u0005\n\u0003G\u0001\u0011\u0011!C!\u0003K\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0014!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tA\u0001\\1oO*\u0011\u0011\u0011G\u0001\u0005U\u00064\u0018-C\u00027\u0003WA\u0011\"a\u000e\u0001\u0003\u0003%\t!!\u000f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0002cA\u000e\u0002>%\u0019\u0011q\b\u000f\u0003\u0007%sG\u000fC\u0005\u0002D\u0001\t\t\u0011\"\u0001\u0002F\u0005q\u0001O]8ek\u000e$X\t\\3nK:$HcA3\u0002H!Q\u0011\u0011JA!\u0003\u0003\u0005\r!a\u000f\u0002\u0007a$\u0013\u0007C\u0005\u0002N\u0001\t\t\u0011\"\u0011\u0002P\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002RA)\u00111KA-K6\u0011\u0011Q\u000b\u0006\u0004\u0003/b\u0012AC2pY2,7\r^5p]&!\u00111LA+\u0005!IE/\u001a:bi>\u0014\b\"CA0\u0001\u0005\u0005I\u0011AA1\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA2\u0003S\u00022aGA3\u0013\r\t9\u0007\b\u0002\b\u0005>|G.Z1o\u0011%\tI%!\u0018\u0002\u0002\u0003\u0007Q\rC\u0005\u0002n\u0001\t\t\u0011\"\u0011\u0002p\u00051Q-];bYN$B!a\u0019\u0002r!I\u0011\u0011JA6\u0003\u0003\u0005\r!\u001a\u0015\u0010\u0001\u0005U\u00141PA?\u0003\u0003\u000b\u0019)a\"\u0002\nB\u0019\u0011#a\u001e\n\u0007\u0005e$AA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005}\u0014!S0G+:\u001bu\f\u000b;j[\u0016\u001cH/Y7qS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002j\u0017N\\;uK\u0002\u001aw.\u001c9p]\u0016tG\u000fI8gAQDW\rI:ue&twm\f;j[\u0016\u001cH/Y7q]\u0005AQ\r_1na2,7/\t\u0002\u0002\u0006\u0006I%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aAJT\u0006M\u001c.gA\u0002\u0013G\r\u001e6qi*\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AUB$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005-\u0015!B\u0019/k9\u0002t!CAH\u0005\u0005\u0005\t\u0012AAI\u0003\u0019i\u0015N\\;uKB\u0019\u0011#a%\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003+\u001bR!a%\u0002\u0018\u0002\u0002r!!'\u0002 \u001arS(\u0004\u0002\u0002\u001c*\u0019\u0011Q\u0014\u000f\u0002\u000fI,h\u000e^5nK&!\u0011\u0011UAN\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bw\u0005ME\u0011AAS)\t\t\t\n\u0003\u0006\u0002*\u0006M\u0015\u0011!C#\u0003W\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003OA!\"a,\u0002\u0014\u0006\u0005I\u0011QAY\u0003\u0015\t\u0007\u000f\u001d7z)\u0015i\u00141WA[\u0011\u0019!\u0013Q\u0016a\u0001M!AA&!,\u0011\u0002\u0003\u0007a\u0006\u0003\u0006\u0002:\u0006M\u0015\u0011!CA\u0003w\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002>\u0006\u0015\u0007\u0003B\u000e0\u0003\u007f\u0003RaGAaM9J1!a1\u001d\u0005\u0019!V\u000f\u001d7fe!I\u0011qYA\\\u0003\u0003\u0005\r!P\u0001\u0004q\u0012\u0002\u0004BCAf\u0003'\u000b\n\u0011\"\u0001\u0002\u001e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIIB!\"a4\u0002\u0014F\u0005I\u0011AA\u000f\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0004BCAj\u0003'\u000b\t\u0011\"\u0003\u0002V\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u000e\u0005\u0003\u0002*\u0005e\u0017\u0002BAn\u0003W\u0011aa\u00142kK\u000e$\b")
public class Minute
extends UnaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final Option<String> timeZoneId;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$2() {
        return Minute$.MODULE$.apply$default$2();
    }

    public static Option<String> $lessinit$greater$default$2() {
        return Minute$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<String>>> unapply(Minute minute) {
        return Minute$.MODULE$.unapply(minute);
    }

    public static Function1<Tuple2<Expression, Option<String>>, Minute> tupled() {
        return Minute$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<String>, Minute>> curried() {
        return Minute$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    private boolean resolved$lzycompute() {
        Minute minute = this;
        synchronized (minute) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = true;
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return this.bitmap$0 ? this.resolved : this.resolved$lzycompute();
    }

    private TimeZone timeZone$lzycompute() {
        Minute minute = this;
        synchronized (minute) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = true;
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return this.bitmap$trans$0 ? this.timeZone : this.timeZone$lzycompute();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimestampType$[]{TimestampType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$7 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$8 = this.copy$default$1();
        return this.copy(x$8, (Option<String>)x$7);
    }

    @Override
    public Object nullSafeEval(Object timestamp) {
        return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(BoxesRunTime.unboxToLong((Object)timestamp), this.timeZone()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)new Serializable(this, tz, dtu){
            public static final long serialVersionUID = 0L;
            private final String tz$2;
            private final String dtu$2;

            public final String apply(String c) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getMinutes(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dtu$2, c, this.tz$2}));
            }
            {
                this.tz$2 = tz$2;
                this.dtu$2 = dtu$2;
            }
        });
    }

    public Minute copy(Expression child, Option<String> timeZoneId) {
        return new Minute(child, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<String> copy$default$2() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "Minute";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.timeZoneId();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Minute;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Minute)) return false;
        boolean bl = true;
        if (!bl) return false;
        Minute minute = (Minute)x$1;
        Expression expression = this.child();
        Expression expression2 = minute.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = minute.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!minute.canEqual(this)) return false;
        return true;
    }

    public Minute(Expression child, Option<String> timeZoneId) {
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
    }

    public Minute(Expression child) {
        this(child, (Option<String>)None$.MODULE$);
    }
}

