/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet;
import org.apache.spark.sql.catalyst.expressions.ExpressionSet$;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.datasources.CatalogFileIndex;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.PruneFileSourcePartitions$$anonfun$apply$1$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.package$;

public final class PruneFileSourcePartitions$
extends Rule<LogicalPlan> {
    public static final PruneFileSourcePartitions$ MODULE$;

    static {
        new PruneFileSourcePartitions$();
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return plan.transformDown((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = PhysicalOperation$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    LogicalRelation logicalRelation;
                    BaseRelation fsRelation;
                    Seq projects = (Seq)((Tuple3)option.get())._1();
                    Seq filters = (Seq)((Tuple3)option.get())._2();
                    LogicalPlan logicalRelation2 = (LogicalPlan)((Tuple3)option.get())._3();
                    if (logicalRelation2 instanceof LogicalRelation && (fsRelation = (logicalRelation = (LogicalRelation)logicalRelation2).relation()) instanceof HadoopFsRelation) {
                        HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
                        FileIndex catalogFileIndex = hadoopFsRelation.location();
                        StructType partitionSchema = hadoopFsRelation.partitionSchema();
                        if (catalogFileIndex instanceof CatalogFileIndex) {
                            CatalogFileIndex catalogFileIndex2 = (CatalogFileIndex)catalogFileIndex;
                            if (filters.nonEmpty() && hadoopFsRelation.partitionSchemaOption().isDefined()) {
                                Object object2;
                                Seq normalizedFilters = (Seq)filters.map((Function1)new Serializable(this, logicalRelation){
                                    public static final long serialVersionUID = 0L;
                                    public final LogicalRelation x3$1;

                                    public final Expression apply(Expression e) {
                                        return (Expression)e.transform((PartialFunction)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$apply$1$$anonfun$1 $outer;

                                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                                Object object;
                                                A1 A1 = x2;
                                                if (A1 instanceof AttributeReference) {
                                                    AttributeReference attributeReference = (AttributeReference)A1;
                                                    object = attributeReference.withName(((AttributeReference)this.$outer.x3$1.output().find((Function1)new Serializable(this, attributeReference){
                                                        public static final long serialVersionUID = 0L;
                                                        private final AttributeReference x2$1;

                                                        public final boolean apply(AttributeReference x$1) {
                                                            return x$1.semanticEquals((Expression)this.x2$1);
                                                        }
                                                        {
                                                            this.x2$1 = x2$1;
                                                        }
                                                    }).get()).name());
                                                } else {
                                                    object = function1.apply(x2);
                                                }
                                                return (B1)object;
                                            }

                                            public final boolean isDefinedAt(Expression x2) {
                                                Expression expression = x2;
                                                boolean bl = expression instanceof AttributeReference;
                                                return bl;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                    }
                                    {
                                        this.x3$1 = x3$1;
                                    }
                                }, Seq$.MODULE$.canBuildFrom());
                                SparkSession sparkSession = hadoopFsRelation.sparkSession();
                                Seq partitionColumns = logicalRelation.resolve(partitionSchema, sparkSession.sessionState().analyzer().resolver());
                                AttributeSet partitionSet = AttributeSet$.MODULE$.apply((Iterable)partitionColumns);
                                ExpressionSet partitionKeyFilters = ExpressionSet$.MODULE$.apply((TraversableOnce)((TraversableLike)normalizedFilters.filterNot((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Expression x$2) {
                                        return SubqueryExpression$.MODULE$.hasSubquery(x$2);
                                    }
                                })).filter((Function1)new Serializable(this, partitionSet){
                                    public static final long serialVersionUID = 0L;
                                    private final AttributeSet partitionSet$1;

                                    public final boolean apply(Expression x$3) {
                                        return x$3.references().subsetOf(this.partitionSet$1);
                                    }
                                    {
                                        this.partitionSet$1 = partitionSet$1;
                                    }
                                }));
                                if (partitionKeyFilters.nonEmpty()) {
                                    InMemoryFileIndex prunedFileIndex = catalogFileIndex2.filterPartitions((Seq<Expression>)partitionKeyFilters.toSeq());
                                    HadoopFsRelation prunedFsRelation = hadoopFsRelation.copy(prunedFileIndex, hadoopFsRelation.copy$default$2(), hadoopFsRelation.copy$default$3(), hadoopFsRelation.copy$default$4(), hadoopFsRelation.copy$default$5(), hadoopFsRelation.copy$default$6(), sparkSession);
                                    Option withStats = logicalRelation.catalogTable().map((Function1)new Serializable(this, prunedFileIndex){
                                        public static final long serialVersionUID = 0L;
                                        private final InMemoryFileIndex prunedFileIndex$1;

                                        public final CatalogTable apply(CatalogTable x$4) {
                                            Some x$5 = new Some((Object)new CatalogStatistics(package$.MODULE$.BigInt().apply(this.prunedFileIndex$1.sizeInBytes()), CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3()));
                                            TableIdentifier x$6 = x$4.copy$default$1();
                                            CatalogTableType x$7 = x$4.copy$default$2();
                                            CatalogStorageFormat x$8 = x$4.copy$default$3();
                                            StructType x$9 = x$4.copy$default$4();
                                            Option x$10 = x$4.copy$default$5();
                                            Seq x$11 = x$4.copy$default$6();
                                            Option x$12 = x$4.copy$default$7();
                                            String x$13 = x$4.copy$default$8();
                                            long x$14 = x$4.copy$default$9();
                                            long x$15 = x$4.copy$default$10();
                                            String x$16 = x$4.copy$default$11();
                                            Map x$17 = x$4.copy$default$12();
                                            Option x$18 = x$4.copy$default$14();
                                            Option x$19 = x$4.copy$default$15();
                                            Seq x$20 = x$4.copy$default$16();
                                            boolean x$21 = x$4.copy$default$17();
                                            boolean x$22 = x$4.copy$default$18();
                                            Map x$23 = x$4.copy$default$19();
                                            return x$4.copy(x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, (Option)x$5, x$18, x$19, x$20, x$21, x$22, x$23);
                                        }
                                        {
                                            this.prunedFileIndex$1 = prunedFileIndex$1;
                                        }
                                    });
                                    HadoopFsRelation x$24 = prunedFsRelation;
                                    Option x$25 = withStats;
                                    Seq<AttributeReference> x$26 = logicalRelation.copy$default$2();
                                    boolean x$27 = logicalRelation.copy$default$4();
                                    LogicalRelation prunedLogicalRelation = logicalRelation.copy(x$24, x$26, (Option<CatalogTable>)x$25, x$27);
                                    Expression filterExpression = (Expression)filters.reduceLeft((Function2)And$.MODULE$);
                                    Filter filter = new Filter(filterExpression, (LogicalPlan)prunedLogicalRelation);
                                    object2 = new Project(projects, (LogicalPlan)filter);
                                } else {
                                    object2 = A1;
                                }
                                object = object2;
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan2);
                if (option.isEmpty()) return false;
                Seq filters = (Seq)((Tuple3)option.get())._2();
                LogicalPlan logicalRelation = (LogicalPlan)((Tuple3)option.get())._3();
                if (!(logicalRelation instanceof LogicalRelation)) return false;
                LogicalRelation logicalRelation2 = (LogicalRelation)logicalRelation;
                BaseRelation fsRelation = logicalRelation2.relation();
                if (!(fsRelation instanceof HadoopFsRelation)) return false;
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)fsRelation;
                FileIndex catalogFileIndex = hadoopFsRelation.location();
                if (!(catalogFileIndex instanceof CatalogFileIndex)) return false;
                if (!filters.nonEmpty()) return false;
                if (!hadoopFsRelation.partitionSchemaOption().isDefined()) return false;
                return true;
            }
        });
    }

    private PruneFileSourcePartitions$() {
        MODULE$ = this;
    }
}

