/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import java.nio.ByteBuffer;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.ShuffleClient;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.EncryptedManagedBuffer;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005UcAB\u0001\u0003\u0003\u0003!!B\u0001\u000bCY>\u001c7\u000e\u0016:b]N4WM]*feZL7-\u001a\u0006\u0003\u0007\u0011\tqA\\3uo>\u00148N\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\u0011\u00011\"E\r\u0011\u00051yQ\"A\u0007\u000b\u00059\u0011\u0011aB:ik\u001a4G.Z\u0005\u0003!5\u0011Qb\u00155vM\u001adWm\u00117jK:$\bC\u0001\n\u0018\u001b\u0005\u0019\"B\u0001\u000b\u0016\u0003\tIwNC\u0001\u0017\u0003\u0011Q\u0017M^1\n\u0005a\u0019\"!C\"m_N,\u0017M\u00197f!\tQR$D\u0001\u001c\u0015\taB!\u0001\u0005j]R,'O\\1m\u0013\tq2DA\u0004M_\u001e<\u0017N\\4\t\u000b\u0001\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?\u0007\u0001!\u0012a\t\t\u0003I\u0001i\u0011A\u0001\u0005\u0006M\u00011\taJ\u0001\u0005S:LG\u000f\u0006\u0002)]A\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t!QK\\5u\u0011\u0015yS\u00051\u00011\u0003A\u0011Gn\\2l\t\u0006$\u0018-T1oC\u001e,'\u000f\u0005\u0002%c%\u0011!G\u0001\u0002\u0011\u00052|7m\u001b#bi\u0006l\u0015M\\1hKJDQ\u0001\u000e\u0001\u0007\u0002U\nQa\u00197pg\u0016$\u0012\u0001\u000b\u0005\u0006o\u00011\t\u0001O\u0001\u0005a>\u0014H/F\u0001:!\tI#(\u0003\u0002<U\t\u0019\u0011J\u001c;\t\u000bu\u0002a\u0011\u0001 \u0002\u0011!|7\u000f\u001e(b[\u0016,\u0012a\u0010\t\u0003\u0001\u000es!!K!\n\u0005\tS\u0013A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n11\u000b\u001e:j]\u001eT!A\u0011\u0016\t\u000b\u001d\u0003a\u0011\t%\u0002\u0017\u0019,Go\u00195CY>\u001c7n\u001d\u000b\bQ%[EJT*Y\u0011\u0015Qe\t1\u0001@\u0003\u0011Awn\u001d;\t\u000b]2\u0005\u0019A\u001d\t\u000b53\u0005\u0019A \u0002\r\u0015DXmY%e\u0011\u0015ye\t1\u0001Q\u0003!\u0011Gn\\2l\u0013\u0012\u001c\bcA\u0015R\u007f%\u0011!K\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006)\u001a\u0003\r!V\u0001\tY&\u001cH/\u001a8feB\u0011ABV\u0005\u0003/6\u0011QC\u00117pG.4U\r^2iS:<G*[:uK:,'\u000fC\u0003Z\r\u0002\u0007!,A\buK6\u0004h)\u001b7f\u001b\u0006t\u0017mZ3s!\ta1,\u0003\u0002]\u001b\t\u0019Bi\\<oY>\fGMR5mK6\u000bg.Y4fe\")a\f\u0001D\u0001?\u0006YQ\u000f\u001d7pC\u0012\u0014En\\2l)!\u0001g\r[5kej|\bcA1eQ5\t!M\u0003\u0002dU\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0015\u0014'A\u0002$viV\u0014X\rC\u0003h;\u0002\u0007q(\u0001\u0005i_N$h.Y7f\u0011\u00159T\f1\u0001:\u0011\u0015iU\f1\u0001@\u0011\u0015YW\f1\u0001m\u0003\u001d\u0011Gn\\2l\u0013\u0012\u0004\"!\u001c9\u000e\u00039T!a\u001c\u0003\u0002\u000fM$xN]1hK&\u0011\u0011O\u001c\u0002\b\u00052|7m[%e\u0011\u0015\u0019X\f1\u0001u\u0003%\u0011Gn\\2l\t\u0006$\u0018\r\u0005\u0002vq6\taO\u0003\u0002x\u0005\u00051!-\u001e4gKJL!!\u001f<\u0003\u001b5\u000bg.Y4fI\n+hMZ3s\u0011\u0015YX\f1\u0001}\u0003\u0015aWM^3m!\tiW0\u0003\u0002\u007f]\na1\u000b^8sC\u001e,G*\u001a<fY\"9\u0011\u0011A/A\u0002\u0005\r\u0011\u0001C2mCN\u001cH+Y41\t\u0005\u0015\u0011Q\u0003\t\u0007\u0003\u000f\ti!!\u0005\u000e\u0005\u0005%!bAA\u0006U\u00059!/\u001a4mK\u000e$\u0018\u0002BA\b\u0003\u0013\u0011\u0001b\u00117bgN$\u0016m\u001a\t\u0005\u0003'\t)\u0002\u0004\u0001\u0005\u0017\u0005]q0!A\u0001\u0002\u000b\u0005\u0011\u0011\u0004\u0002\u0004?\u0012\n\u0014\u0003BA\u000e\u0003C\u00012!KA\u000f\u0013\r\tyB\u000b\u0002\b\u001d>$\b.\u001b8h!\rI\u00131E\u0005\u0004\u0003KQ#aA!os\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012A\u00044fi\u000eD'\t\\8dWNKhn\u0019\u000b\fi\u00065\u0012qFA\u0019\u0003g\t)\u0004\u0003\u0004K\u0003O\u0001\ra\u0010\u0005\u0007o\u0005\u001d\u0002\u0019A\u001d\t\r5\u000b9\u00031\u0001@\u0011\u0019Y\u0017q\u0005a\u0001\u007f!1\u0011,a\nA\u0002iCq!!\u000f\u0001\t\u0003\tY$A\bva2|\u0017\r\u001a\"m_\u000e\\7+\u001f8d)=A\u0013QHA \u0003\u0003\n\u0019%!\u0012\u0002H\u0005%\u0003BB4\u00028\u0001\u0007q\b\u0003\u00048\u0003o\u0001\r!\u000f\u0005\u0007\u001b\u0006]\u0002\u0019A \t\r-\f9\u00041\u0001m\u0011\u0019\u0019\u0018q\u0007a\u0001i\"110a\u000eA\u0002qD\u0001\"!\u0001\u00028\u0001\u0007\u00111\n\u0019\u0005\u0003\u001b\n\t\u0006\u0005\u0004\u0002\b\u00055\u0011q\n\t\u0005\u0003'\t\t\u0006\u0002\u0007\u0002T\u0005%\u0013\u0011!A\u0001\u0006\u0003\tIBA\u0002`II\u0002")
public abstract class BlockTransferService
extends ShuffleClient
implements Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging$class.initializeLogIfNecessary(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging$class.initializeLogIfNecessary$default$2(this);
    }

    public abstract void init(BlockDataManager var1);

    public abstract void close();

    public abstract int port();

    public abstract String hostName();

    public abstract void fetchBlocks(String var1, int var2, String var3, String[] var4, BlockFetchingListener var5, DownloadFileManager var6);

    public abstract Future<BoxedUnit> uploadBlock(String var1, int var2, String var3, BlockId var4, ManagedBuffer var5, StorageLevel var6, ClassTag<?> var7);

    public ManagedBuffer fetchBlockSync(String host, int port, String execId, String blockId, DownloadFileManager tempFileManager) {
        Promise result2 = Promise$.MODULE$.apply();
        this.fetchBlocks(host, port, execId, (String[])((Object[])new String[]{blockId}), new BlockFetchingListener(this, result2){
            private final Promise result$1;

            public void onBlockFetchFailure(String blockId, Throwable exception2) {
                this.result$1.failure(exception2);
            }

            public void onBlockFetchSuccess(String blockId, ManagedBuffer data) {
                ManagedBuffer managedBuffer = data;
                if (managedBuffer instanceof FileSegmentManagedBuffer) {
                    FileSegmentManagedBuffer fileSegmentManagedBuffer = (FileSegmentManagedBuffer)managedBuffer;
                    this.result$1.success((Object)fileSegmentManagedBuffer);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (managedBuffer instanceof EncryptedManagedBuffer) {
                    EncryptedManagedBuffer encryptedManagedBuffer = (EncryptedManagedBuffer)managedBuffer;
                    this.result$1.success((Object)((Object)encryptedManagedBuffer));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit;
                    try {
                        ByteBuffer ret = ByteBuffer.allocate((int)data.size());
                        ret.put(data.nioByteBuffer());
                        ret.flip();
                        this.result$1.success((Object)new NioManagedBuffer(ret));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        this.result$1.failure(throwable);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                }
            }
            {
                this.result$1 = result$1;
            }
        }, tempFileManager);
        return (ManagedBuffer)ThreadUtils$.MODULE$.awaitResult(result2.future(), (Duration)Duration$.MODULE$.Inf());
    }

    public void uploadBlockSync(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        Future<BoxedUnit> future = this.uploadBlock(hostname, port, execId, blockId, blockData, level, classTag);
        ThreadUtils$.MODULE$.awaitResult(future, (Duration)Duration$.MODULE$.Inf());
    }

    public BlockTransferService() {
        Logging$class.$init$(this);
    }
}

