/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Array;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.Interval;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "intervals", "arrays"})
@XmlRootElement(name="ContStats", namespace="http://www.dmg.org/PMML-4_2")
public class ContStats
extends PMMLObject
implements HasExtensions {
    @XmlAttribute(name="totalValuesSum")
    private Double totalValuesSum;
    @XmlAttribute(name="totalSquaresSum")
    private Double totalSquaresSum;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="Interval", namespace="http://www.dmg.org/PMML-4_2")
    private List<Interval> intervals;
    @XmlElement(name="Array", namespace="http://www.dmg.org/PMML-4_2")
    private List<Array> arrays;

    public Double getTotalValuesSum() {
        return this.totalValuesSum;
    }

    public ContStats setTotalValuesSum(Double totalValuesSum) {
        this.totalValuesSum = totalValuesSum;
        return this;
    }

    public Double getTotalSquaresSum() {
        return this.totalSquaresSum;
    }

    public ContStats setTotalSquaresSum(Double totalSquaresSum) {
        this.totalSquaresSum = totalSquaresSum;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Interval> getIntervals() {
        if (this.intervals == null) {
            this.intervals = new ArrayList<Interval>();
        }
        return this.intervals;
    }

    public List<Array> getArrays() {
        if (this.arrays == null) {
            this.arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public ContStats addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasIntervals() {
        return this.intervals != null && this.intervals.size() > 0;
    }

    public ContStats addIntervals(Interval ... intervals) {
        this.getIntervals().addAll(Arrays.asList(intervals));
        return this;
    }

    public boolean hasArrays() {
        return this.arrays != null && this.arrays.size() > 0;
    }

    public ContStats addArrays(Array ... arrays) {
        this.getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasIntervals()) {
                status = PMMLObject.traverse(visitor, this.getIntervals());
            }
            if (status == VisitorAction.CONTINUE && this.hasArrays()) {
                status = PMMLObject.traverse(visitor, this.getArrays());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

