/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u00015\u0011Ac\u0012:bI&,g\u000e\u001e\"p_N$X\r\u001a+sK\u0016\u001c(BA\u0002\u0005\u0003\u0011!(/Z3\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001H\r\u0003\u000f1{wmZ5oO\"Aa\u0004\u0001BC\u0002\u0013%q$\u0001\tc_>\u001cH/\u001b8h'R\u0014\u0018\r^3hsV\t\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$\u0005\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\n\u0012\u0003!\t{wn\u001d;j]\u001e\u001cFO]1uK\u001eL\b\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002#\t|wn\u001d;j]\u001e\u001cFO]1uK\u001eL\b\u0005\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0003+\u0003\u0011\u0019X-\u001a3\u0016\u0003-\u0002\"a\u0004\u0017\n\u00055\u0002\"aA%oi\"Aq\u0006\u0001B\u0001B\u0003%1&A\u0003tK\u0016$\u0007\u0005\u0003\u00042\u0001\u0011\u0005aAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M*d\u0007\u0005\u00025\u00015\t!\u0001C\u0003\u001fa\u0001\u0007\u0001\u0005C\u0003*a\u0001\u00071\u0006C\u00032\u0001\u0011\u0005\u0001\b\u0006\u00024s!)ad\u000ea\u0001A!\u001aqgO!\u0011\u0005qzT\"A\u001f\u000b\u0005y2\u0011AC1o]>$\u0018\r^5p]&\u0011\u0001)\u0010\u0002\u0006'&t7-Z\u0011\u0002\u0005\u0006)\u0011G\f\u001a/a!)A\t\u0001C\u0001\u000b\u0006\u0019!/\u001e8\u0015\u0005\u0019c\u0005CA$K\u001b\u0005A%BA%\u0003\u0003\u0015iw\u000eZ3m\u0013\tY\u0005JA\rHe\u0006$\u0017.\u001a8u\u0005>|7\u000f^3e)J,Wm]'pI\u0016d\u0007\"B'D\u0001\u0004q\u0015!B5oaV$\bcA(S)6\t\u0001K\u0003\u0002R\r\u0005\u0019!\u000f\u001a3\n\u0005M\u0003&a\u0001*E\tB\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bB\u0001\u000be\u0016<'/Z:tS>t\u0017BA-W\u00051a\u0015MY3mK\u0012\u0004v.\u001b8uQ\r\u00195(\u0011\u0005\u0006\t\u0002!\t\u0001\u0018\u000b\u0003\rvCQ!T.A\u0002y\u00032a\u00183U\u001b\u0005\u0001'BA1c\u0003\u0011Q\u0017M^1\u000b\u0005\r4\u0011aA1qS&\u0011Q\r\u0019\u0002\b\u0015\u00064\u0018M\u0015#EQ\rY6(\u0011\u0005\u0006Q\u0002!\t![\u0001\u0012eVtw+\u001b;i-\u0006d\u0017\u000eZ1uS>tGc\u0001$kW\")Qj\u001aa\u0001\u001d\")An\u001aa\u0001\u001d\u0006ya/\u00197jI\u0006$\u0018n\u001c8J]B,H\u000fK\u0002hw9\f\u0013a\\\u0001\u0006c9\"d\u0006\r\u0005\u0006Q\u0002!\t!\u001d\u000b\u0004\rJ\u001c\b\"B'q\u0001\u0004q\u0006\"\u00027q\u0001\u0004q\u0006f\u00019<]\"\u001a\u0001aO!\b\u000b]\u0014\u0001\u0012\u0001=\u0002)\u001d\u0013\u0018\rZ5f]R\u0014un\\:uK\u0012$&/Z3t!\t!\u0014PB\u0003\u0002\u0005!\u0005!p\u0005\u0003z\u001d]!\u0002\"B\u0019z\t\u0003aH#\u0001=\t\u000byLH\u0011A@\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u000b\u0019\u000b\t!a\u0001\t\u000b5k\b\u0019\u0001(\t\u000byi\b\u0019\u0001\u0011)\u0007u\\\u0014\t\u0003\u0004\u007fs\u0012\u0005\u0011\u0011\u0002\u000b\u0006\r\u0006-\u0011Q\u0002\u0005\u0007\u001b\u0006\u001d\u0001\u0019\u00010\t\ry\t9\u00011\u0001!Q\u0011\t9aO!\t\u0013\u0005M\u00110!A\u0005\n\u0005U\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0006\u0011\t\u0005e\u0011\u0011E\u0007\u0003\u00037QA!!\b\u0002 \u0005!A.\u00198h\u0015\u0005\t\u0017\u0002BA\u0012\u00037\u0011aa\u00142kK\u000e$\bfA=<\u0003\"\u001aaoO!")
public class GradientBoostedTrees
implements Serializable,
Logging {
    private final BoostingStrategy boostingStrategy;
    private final int seed;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static GradientBoostedTreesModel train(JavaRDD<LabeledPoint> javaRDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(javaRDD, boostingStrategy);
    }

    public static GradientBoostedTreesModel train(RDD<LabeledPoint> rDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(rDD, boostingStrategy);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private BoostingStrategy boostingStrategy() {
        return this.boostingStrategy;
    }

    private int seed() {
        return this.seed;
    }

    public GradientBoostedTreesModel run(RDD<LabeledPoint> input) {
        Enumeration.Value algo = this.boostingStrategy().treeStrategy().algo();
        Tuple2<DecisionTreeRegressionModel[], double[]> tuple2 = org.apache.spark.ml.tree.impl.GradientBoostedTrees$.MODULE$.run((RDD<org.apache.spark.ml.feature.LabeledPoint>)input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final org.apache.spark.ml.feature.LabeledPoint apply(LabeledPoint point) {
                return new org.apache.spark.ml.feature.LabeledPoint(point.label(), point.features().asML());
            }
        }, ClassTag$.MODULE$.apply(org.apache.spark.ml.feature.LabeledPoint.class)), this.boostingStrategy(), this.seed(), "all");
        if (tuple2 != null) {
            Tuple2 tuple22;
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])tuple2._1();
            double[] treeWeights = (double[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)trees, (Object)treeWeights);
            DecisionTreeRegressionModel[] trees2 = (DecisionTreeRegressionModel[])tuple23._1();
            double[] treeWeights2 = (double[])tuple23._2();
            return new GradientBoostedTreesModel(algo, (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])trees2).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final DecisionTreeModel apply(DecisionTreeRegressionModel x$2) {
                    return x$2.toOld();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), treeWeights2);
        }
        throw new MatchError(tuple2);
    }

    public GradientBoostedTreesModel run(JavaRDD<LabeledPoint> input) {
        return this.run((RDD<LabeledPoint>)input.rdd());
    }

    public GradientBoostedTreesModel runWithValidation(RDD<LabeledPoint> input, RDD<LabeledPoint> validationInput) {
        Enumeration.Value algo = this.boostingStrategy().treeStrategy().algo();
        Tuple2<DecisionTreeRegressionModel[], double[]> tuple2 = org.apache.spark.ml.tree.impl.GradientBoostedTrees$.MODULE$.runWithValidation((RDD<org.apache.spark.ml.feature.LabeledPoint>)input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final org.apache.spark.ml.feature.LabeledPoint apply(LabeledPoint point) {
                return new org.apache.spark.ml.feature.LabeledPoint(point.label(), point.features().asML());
            }
        }, ClassTag$.MODULE$.apply(org.apache.spark.ml.feature.LabeledPoint.class)), (RDD<org.apache.spark.ml.feature.LabeledPoint>)validationInput.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final org.apache.spark.ml.feature.LabeledPoint apply(LabeledPoint point) {
                return new org.apache.spark.ml.feature.LabeledPoint(point.label(), point.features().asML());
            }
        }, ClassTag$.MODULE$.apply(org.apache.spark.ml.feature.LabeledPoint.class)), this.boostingStrategy(), this.seed(), "all");
        if (tuple2 != null) {
            Tuple2 tuple22;
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])tuple2._1();
            double[] treeWeights = (double[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)trees, (Object)treeWeights);
            DecisionTreeRegressionModel[] trees2 = (DecisionTreeRegressionModel[])tuple23._1();
            double[] treeWeights2 = (double[])tuple23._2();
            return new GradientBoostedTreesModel(algo, (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])trees2).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final DecisionTreeModel apply(DecisionTreeRegressionModel x$4) {
                    return x$4.toOld();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), treeWeights2);
        }
        throw new MatchError(tuple2);
    }

    public GradientBoostedTreesModel runWithValidation(JavaRDD<LabeledPoint> input, JavaRDD<LabeledPoint> validationInput) {
        return this.runWithValidation((RDD<LabeledPoint>)input.rdd(), (RDD<LabeledPoint>)validationInput.rdd());
    }

    public GradientBoostedTrees(BoostingStrategy boostingStrategy, int seed) {
        this.boostingStrategy = boostingStrategy;
        this.seed = seed;
        Logging.class.$init$((Logging)this);
    }

    public GradientBoostedTrees(BoostingStrategy boostingStrategy) {
        this(boostingStrategy, 0);
    }
}

