/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.feature.StandardScaler;
import org.apache.spark.mllib.feature.StandardScalerModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005}e!B\u0001\u0003\u0003\u0003i!AG$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be\u0006cwm\u001c:ji\"l'BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\tqQe\u0005\u0003\u0001\u001fUY\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001b/\t9Aj\\4hS:<\u0007C\u0001\t\u001d\u0013\ti\u0012C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0019!\u0005A\u0012\u000e\u0003\t\u0001\"\u0001J\u0013\r\u0001\u0011)a\u0005\u0001b\u0001O\t\tQ*\u0005\u0002)WA\u0011\u0001#K\u0005\u0003UE\u0011qAT8uQ&tw\r\u0005\u0002#Y%\u0011QF\u0001\u0002\u0017\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014Xj\u001c3fY\"9q\u0006\u0001b\u0001\n#\u0001\u0014A\u0003<bY&$\u0017\r^8sgV\t\u0011\u0007E\u00023uur!a\r\u001d\u000f\u0005Q:T\"A\u001b\u000b\u0005Yb\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\tI\u0014#A\u0004qC\u000e\\\u0017mZ3\n\u0005mb$aA*fc*\u0011\u0011(\u0005\t\u0005!y\u0002\u0015*\u0003\u0002@#\tIa)\u001e8di&|g.\r\t\u0004\u0003\u00123U\"\u0001\"\u000b\u0005\r3\u0011a\u0001:eI&\u0011QI\u0011\u0002\u0004%\u0012#\u0005C\u0001\u0012H\u0013\tA%A\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u0005\u0002\u0011\u0015&\u00111*\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019i\u0005\u0001)A\u0005c\u0005Ya/\u00197jI\u0006$xN]:!\u0011\u0015y\u0005A\"\u0001Q\u0003%y\u0007\u000f^5nSj,'/F\u0001R!\t\u0011V+D\u0001T\u0015\t!F!\u0001\u0007paRLW.\u001b>bi&|g.\u0003\u0002W'\nIq\n\u001d;j[&TXM\u001d\u0015\u0004\u001dbs\u0006CA-]\u001b\u0005Q&BA.\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003;j\u0013QaU5oG\u0016\f\u0013aX\u0001\u0006a9Bd\u0006\r\u0005\bC\u0002\u0001\r\u0011\"\u0005c\u00031\tG\rZ%oi\u0016\u00148-\u001a9u+\u0005I\u0005b\u00023\u0001\u0001\u0004%\t\"Z\u0001\u0011C\u0012$\u0017J\u001c;fe\u000e,\u0007\u000f^0%KF$\"AZ5\u0011\u0005A9\u0017B\u00015\u0012\u0005\u0011)f.\u001b;\t\u000f)\u001c\u0017\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010J\u0019\t\r1\u0004\u0001\u0015)\u0003J\u00035\tG\rZ%oi\u0016\u00148-\u001a9uA!9a\u000e\u0001a\u0001\n#\u0011\u0017\u0001\u0004<bY&$\u0017\r^3ECR\f\u0007b\u00029\u0001\u0001\u0004%\t\"]\u0001\u0011m\u0006d\u0017\u000eZ1uK\u0012\u000bG/Y0%KF$\"A\u001a:\t\u000f)|\u0017\u0011!a\u0001\u0013\"1A\u000f\u0001Q!\n%\u000bQB^1mS\u0012\fG/\u001a#bi\u0006\u0004\u0003b\u0002<\u0001\u0001\u0004%\tb^\u0001\u0015]VlwJ\u001a'j]\u0016\f'\u000f\u0015:fI&\u001cGo\u001c:\u0016\u0003a\u0004\"\u0001E=\n\u0005i\f\"aA%oi\"9A\u0010\u0001a\u0001\n#i\u0018\u0001\u00078v[>3G*\u001b8fCJ\u0004&/\u001a3jGR|'o\u0018\u0013fcR\u0011aM \u0005\bUn\f\t\u00111\u0001y\u0011\u001d\t\t\u0001\u0001Q!\na\fQC\\;n\u001f\u001ad\u0015N\\3beB\u0013X\rZ5di>\u0014\b\u0005C\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0001\u0005E\u0006\tRo]3GK\u0006$XO]3TG\u0006d\u0017N\\4\t\u0015\u0005%\u0001\u00011A\u0005\u0002\u0011\tY!A\u000bvg\u00164U-\u0019;ve\u0016\u001c6-\u00197j]\u001e|F%Z9\u0015\u0007\u0019\fi\u0001\u0003\u0005k\u0003\u000f\t\t\u00111\u0001J\u0011\u001d\t\t\u0002\u0001Q!\n%\u000b!#^:f\r\u0016\fG/\u001e:f'\u000e\fG.\u001b8hA!1\u0011Q\u0003\u0001\u0005\u0002]\fabZ3u\u001dVlg)Z1ukJ,7\u000fK\u0003\u0002\u0014a\u000bI\"\t\u0002\u0002\u001c\u0005)\u0011G\f\u001b/a!A\u0011q\u0004\u0001A\u0002\u0013Eq/A\u0006ok64U-\u0019;ve\u0016\u001c\b\"CA\u0012\u0001\u0001\u0007I\u0011CA\u0013\u0003=qW/\u001c$fCR,(/Z:`I\u0015\fHc\u00014\u0002(!A!.!\t\u0002\u0002\u0003\u0007\u0001\u0010C\u0004\u0002,\u0001\u0001\u000b\u0015\u0002=\u0002\u00199,XNR3biV\u0014Xm\u001d\u0011\t\u0011\u0005=\u0002\u0001\"\u0001\u0005\u0003c\t\u0011c]3u\r\u0016\fG/\u001e:f'\u000e\fG.\u001b8h)\u0011\t\u0019$!\u000e\u000e\u0003\u0001Aq!!\u0002\u0002.\u0001\u0007\u0011\nC\u0004\u0002:\u00011\t\"a\u000f\u0002\u0017\r\u0014X-\u0019;f\u001b>$W\r\u001c\u000b\u0006G\u0005u\u0012Q\n\u0005\t\u0003\u007f\t9\u00041\u0001\u0002B\u00059q/Z5hQR\u001c\b\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dC!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003\u0017\n)E\u0001\u0004WK\u000e$xN\u001d\u0005\t\u0003\u001f\n9\u00041\u0001\u0002R\u0005I\u0011N\u001c;fe\u000e,\u0007\u000f\u001e\t\u0004!\u0005M\u0013bAA+#\t1Ai\\;cY\u0016Da!!\u0017\u0001\t\u0003\u0011\u0017AD5t\u0003\u0012$\u0017J\u001c;fe\u000e,\u0007\u000f\u001e\u0015\u0006\u0003/B\u0016\u0011\u0004\u0005\b\u0003?\u0002A\u0011AA1\u00031\u0019X\r^%oi\u0016\u00148-\u001a9u)\u0011\t\u0019$a\u0019\t\r\u0005\fi\u00061\u0001JQ\u0011\ti\u0006\u00170\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l\u0005y1/\u001a;WC2LG-\u0019;f\t\u0006$\u0018\r\u0006\u0003\u00024\u00055\u0004B\u00028\u0002h\u0001\u0007\u0011\n\u000b\u0003\u0002has\u0006bBA:\u0001\u0011E\u0011QO\u0001\u0017O\u0016tWM]1uK&s\u0017\u000e^5bY^+\u0017n\u001a5ugR!\u0011\u0011IA<\u0011\u001d\tI(!\u001dA\u0002\u0001\u000bQ!\u001b8qkRDq!! \u0001\t\u0003\ty(A\u0002sk:$2aIAA\u0011\u001d\tI(a\u001fA\u0002\u0001CC!a\u001fY=\"9\u0011Q\u0010\u0001\u0005\u0002\u0005\u001dE#B\u0012\u0002\n\u0006-\u0005bBA=\u0003\u000b\u0003\r\u0001\u0011\u0005\t\u0003\u001b\u000b)\t1\u0001\u0002B\u0005q\u0011N\\5uS\u0006dw+Z5hQR\u001c\b&BAC1\u0006E\u0015EAAJ\u0003\u0015\td\u0006\r\u00181Q\r\u0001\u0011q\u0013\t\u00043\u0006e\u0015bAAN5\naA)\u001a<fY>\u0004XM]!qS\"\u001a\u0001\u0001\u00170")
public abstract class GeneralizedLinearAlgorithm<M extends GeneralizedLinearModel>
implements Logging,
Serializable {
    private final Seq<Function1<RDD<LabeledPoint>, Object>> validators;
    private boolean addIntercept;
    private boolean validateData;
    private int numOfLinearPredictor;
    private boolean useFeatureScaling;
    private int numFeatures;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Seq<Function1<RDD<LabeledPoint>, Object>> validators() {
        return this.validators;
    }

    public abstract Optimizer optimizer();

    public boolean addIntercept() {
        return this.addIntercept;
    }

    public void addIntercept_$eq(boolean x$1) {
        this.addIntercept = x$1;
    }

    public boolean validateData() {
        return this.validateData;
    }

    public void validateData_$eq(boolean x$1) {
        this.validateData = x$1;
    }

    public int numOfLinearPredictor() {
        return this.numOfLinearPredictor;
    }

    public void numOfLinearPredictor_$eq(int x$1) {
        this.numOfLinearPredictor = x$1;
    }

    public boolean useFeatureScaling() {
        return this.useFeatureScaling;
    }

    public void useFeatureScaling_$eq(boolean x$1) {
        this.useFeatureScaling = x$1;
    }

    public int getNumFeatures() {
        return this.numFeatures();
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public void numFeatures_$eq(int x$1) {
        this.numFeatures = x$1;
    }

    public GeneralizedLinearAlgorithm<M> setFeatureScaling(boolean useFeatureScaling) {
        this.useFeatureScaling_$eq(useFeatureScaling);
        return this;
    }

    public abstract M createModel(Vector var1, double var2);

    public boolean isAddIntercept() {
        return this.addIntercept();
    }

    public GeneralizedLinearAlgorithm<M> setIntercept(boolean addIntercept) {
        this.addIntercept_$eq(addIntercept);
        return this;
    }

    public GeneralizedLinearAlgorithm<M> setValidateData(boolean validateData) {
        this.validateData_$eq(validateData);
        return this;
    }

    public Vector generateInitialWeights(RDD<LabeledPoint> input) {
        if (this.numFeatures() < 0) {
            this.numFeatures_$eq(BoxesRunTime.unboxToInt((Object)input.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LabeledPoint x$1) {
                    return x$1.features().size();
                }
            }, ClassTag$.MODULE$.Int()).first()));
        }
        return this.numOfLinearPredictor() == 1 ? Vectors$.MODULE$.zeros(this.numFeatures()) : (this.addIntercept() ? Vectors$.MODULE$.zeros((this.numFeatures() + 1) * this.numOfLinearPredictor()) : Vectors$.MODULE$.zeros(this.numFeatures() * this.numOfLinearPredictor()));
    }

    public M run(RDD<LabeledPoint> input) {
        return this.run(input, this.generateInitialWeights(input));
    }

    public M run(RDD<LabeledPoint> input, Vector initialWeights) {
        Vector weights;
        StandardScalerModel scaler;
        StandardScalerModel standardScalerModel;
        if (this.numFeatures() < 0) {
            this.numFeatures_$eq(BoxesRunTime.unboxToInt((Object)input.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LabeledPoint x$2) {
                    return x$2.features().size();
                }
            }, ClassTag$.MODULE$.Int()).first()));
        }
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        if (this.validateData() && !this.validators().forall((Function1)new Serializable(this, input){
            public static final long serialVersionUID = 0L;
            private final RDD input$1;

            public final boolean apply(Function1<RDD<LabeledPoint>, Object> func) {
                return BoxesRunTime.unboxToBoolean((Object)func.apply((Object)this.input$1));
            }
            {
                this.input$1 = input$1;
            }
        })) {
            throw new SparkException("Input validation failed.");
        }
        if (this.useFeatureScaling()) {
            boolean x$4 = true;
            boolean x$5 = false;
            standardScalerModel = new StandardScaler(x$5, x$4).fit((RDD<Vector>)input.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Vector apply(LabeledPoint x$3) {
                    return x$3.features();
                }
            }, ClassTag$.MODULE$.apply(Vector.class)));
        } else {
            standardScalerModel = scaler = null;
        }
        RDD data = this.addIntercept() ? (this.useFeatureScaling() ? input.map((Function1)new Serializable(this, scaler){
            public static final long serialVersionUID = 0L;
            private final StandardScalerModel scaler$1;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)MLUtils$.MODULE$.appendBias(this.scaler$1.transform(lp.features())));
            }
            {
                this.scaler$1 = scaler$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache() : input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)MLUtils$.MODULE$.appendBias(lp.features()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache()) : (this.useFeatureScaling() ? input.map((Function1)new Serializable(this, scaler){
            public static final long serialVersionUID = 0L;
            private final StandardScalerModel scaler$1;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)this.scaler$1.transform(lp.features()));
            }
            {
                this.scaler$1 = scaler$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache() : input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)lp.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        Vector initialWeightsWithIntercept = this.addIntercept() && this.numOfLinearPredictor() == 1 ? MLUtils$.MODULE$.appendBias(initialWeights) : initialWeights;
        Vector weightsWithIntercept = this.optimizer().optimize((RDD<Tuple2<Object, Vector>>)data, initialWeightsWithIntercept);
        double intercept = this.addIntercept() && this.numOfLinearPredictor() == 1 ? weightsWithIntercept.apply(weightsWithIntercept.size() - 1) : 0.0;
        Vector vector = weights = this.addIntercept() && this.numOfLinearPredictor() == 1 ? Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(weightsWithIntercept.toArray()).slice(0, weightsWithIntercept.size() - 1)) : weightsWithIntercept;
        if (this.useFeatureScaling()) {
            if (this.numOfLinearPredictor() == 1) {
                weights = scaler.transform(weights);
            } else {
                int n = weights.size() / this.numOfLinearPredictor();
                double[] weightsArray = weights.toArray();
                for (int i = 0; i < this.numOfLinearPredictor(); ++i) {
                    int start2 = i * n;
                    int end = (i + 1) * n - (this.addIntercept() ? 1 : 0);
                    double[] partialWeightsArray = scaler.transform(Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(weightsArray).slice(start2, end))).toArray();
                    System.arraycopy(partialWeightsArray, 0, weightsArray, start2, partialWeightsArray.length);
                }
                weights = Vectors$.MODULE$.dense(weightsArray);
            }
        }
        StorageLevel storageLevel3 = input.getStorageLevel();
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        StorageLevel storageLevel5 = data.getStorageLevel();
        StorageLevel storageLevel6 = StorageLevel$.MODULE$.NONE();
        Object object = !(storageLevel5 != null ? !storageLevel5.equals(storageLevel6) : storageLevel6 != null) ? BoxedUnit.UNIT : data.unpersist(false);
        return this.createModel(weights, intercept);
    }

    public GeneralizedLinearAlgorithm() {
        Logging.class.$init$((Logging)this);
        this.validators = Nil$.MODULE$;
        this.addIntercept = false;
        this.validateData = true;
        this.numOfLinearPredictor = 1;
        this.useFeatureScaling = false;
        this.numFeatures = -1;
    }
}

