/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.EuclideanDistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001m4Q!\u0001\u0002\u0001\r1\u0011\u0001$R;dY&$W-\u00198ESN$\u0018M\\2f\u001b\u0016\f7/\u001e:f\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\"\u0001A\u0007\u0011\u00059yQ\"\u0001\u0002\n\u0005A\u0011!a\u0004#jgR\fgnY3NK\u0006\u001cXO]3\t\u000bI\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\u0006\t\u0003\u001d\u0001AQa\u0006\u0001\u0005Ba\t1BZ5oI\u000ecwn]3tiR\u0019\u0011$\n\u001c\u0011\tiirDI\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1A+\u001e9mKJ\u0002\"A\u0007\u0011\n\u0005\u0005Z\"aA%oiB\u0011!dI\u0005\u0003Im\u0011a\u0001R8vE2,\u0007\"\u0002\u0014\u0017\u0001\u00049\u0013aB2f]R,'o\u001d\t\u0004QA\u001adBA\u0015/\u001d\tQS&D\u0001,\u0015\ta3#\u0001\u0004=e>|GOP\u0005\u00029%\u0011qfG\u0001\ba\u0006\u001c7.Y4f\u0013\t\t$GA\bUe\u00064XM]:bE2,wJ\\2f\u0015\ty3\u0004\u0005\u0002\u000fi%\u0011QG\u0001\u0002\u000f-\u0016\u001cGo\u001c:XSRDgj\u001c:n\u0011\u00159d\u00031\u00014\u0003\u0015\u0001x.\u001b8u\u0011\u0015I\u0004\u0001\"\u0011;\u0003EI7oQ3oi\u0016\u00148i\u001c8wKJ<W\r\u001a\u000b\u0005wy\u0002%\t\u0005\u0002\u001by%\u0011Qh\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015y\u0004\b1\u00014\u0003%yG\u000eZ\"f]R,'\u000fC\u0003Bq\u0001\u00071'A\u0005oK^\u001cUM\u001c;fe\")1\t\u000fa\u0001E\u00059Q\r]:jY>t\u0007\"B#\u0001\t\u00032\u0015\u0001\u00033jgR\fgnY3\u0015\u0007\t:\u0015\nC\u0003I\t\u0002\u00071'\u0001\u0002wc!)!\n\u0012a\u0001g\u0005\u0011aO\r\u0005\u0006\u0019\u0002!\t%T\u0001\fG2,8\u000f^3s\u0007>\u001cH\u000fF\u0003#\u001dB\u0013v\u000bC\u0003P\u0017\u0002\u00071'\u0001\u0005dK:$(o\\5e\u0011\u0015\t6\n1\u00014\u0003%\u0001x.\u001b8ugN+X\u000eC\u0003T\u0017\u0002\u0007A+\u0001\bok6\u0014WM](g!>Lg\u000e^:\u0011\u0005i)\u0016B\u0001,\u001c\u0005\u0011auN\\4\t\u000ba[\u0005\u0019\u0001\u0012\u0002#A|\u0017N\u001c;t'F,\u0018M]3e\u001d>\u0014X\u000eC\u0003[\u0001\u0011\u00053,\u0001\u0003d_N$Hc\u0001\u0012];\")q'\u0017a\u0001g!)q*\u0017a\u0001g\u001d1qL\u0001E\u0001\r\u0001\f\u0001$R;dY&$W-\u00198ESN$\u0018M\\2f\u001b\u0016\f7/\u001e:f!\tq\u0011M\u0002\u0004\u0002\u0005!\u0005aAY\n\u0004C\u000e4\u0007C\u0001\u000ee\u0013\t)7D\u0001\u0004B]f\u0014VM\u001a\t\u00035\u001dL!\u0001[\u000e\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bI\tG\u0011\u00016\u0015\u0003\u0001Da\u0001\\1\u0005\u0002\ti\u0017a\u00054bgR\u001c\u0016/^1sK\u0012$\u0015n\u001d;b]\u000e,Gc\u0001\u0012o_\")\u0001j\u001ba\u0001g!)!j\u001ba\u0001g!9\u0011/YA\u0001\n\u0013\u0011\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012a\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fA\u0001\\1oO*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005\u0019y%M[3di\u0002")
public class EuclideanDistanceMeasure
extends DistanceMeasure {
    @Override
    public Tuple2<Object, Object> findClosest(TraversableOnce<VectorWithNorm> centers, VectorWithNorm point) {
        DoubleRef bestDistance = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        IntRef bestIndex = IntRef.create((int)0);
        IntRef i = IntRef.create((int)0);
        centers.foreach((Function1)new Serializable(this, point, bestDistance, bestIndex, i){
            public static final long serialVersionUID = 0L;
            private final VectorWithNorm point$2;
            private final DoubleRef bestDistance$2;
            private final IntRef bestIndex$2;
            private final IntRef i$2;

            public final void apply(VectorWithNorm center) {
                double distance2;
                double lowerBoundOfSqDist = center.norm() - this.point$2.norm();
                if ((lowerBoundOfSqDist *= lowerBoundOfSqDist) < this.bestDistance$2.elem && (distance2 = EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(center, this.point$2)) < this.bestDistance$2.elem) {
                    this.bestDistance$2.elem = distance2;
                    this.bestIndex$2.elem = this.i$2.elem;
                }
                ++this.i$2.elem;
            }
            {
                this.point$2 = point$2;
                this.bestDistance$2 = bestDistance$2;
                this.bestIndex$2 = bestIndex$2;
                this.i$2 = i$2;
            }
        });
        return new Tuple2.mcID.sp(bestIndex.elem, bestDistance.elem);
    }

    @Override
    public boolean isCenterConverged(VectorWithNorm oldCenter, VectorWithNorm newCenter, double epsilon) {
        return EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(newCenter, oldCenter) <= epsilon * epsilon;
    }

    @Override
    public double distance(VectorWithNorm v1, VectorWithNorm v2) {
        return Math.sqrt(EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(v1, v2));
    }

    @Override
    public double clusterCost(VectorWithNorm centroid, VectorWithNorm pointsSum, long numberOfPoints, double pointsSquaredNorm) {
        return package$.MODULE$.max(pointsSquaredNorm - (double)numberOfPoints * centroid.norm() * centroid.norm(), 0.0);
    }

    @Override
    public double cost(VectorWithNorm point, VectorWithNorm centroid) {
        return EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(point, centroid);
    }
}

