/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.image;

import java.io.Closeable;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.image.ImageSchema$;
import org.apache.spark.ml.source.image.ImageOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.spark_project.guava.io.ByteStreams;
import org.spark_project.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]b!B\u0001\u0003\u0001\tq!aD%nC\u001e,g)\u001b7f\r>\u0014X.\u0019;\u000b\u0005\r!\u0011!B5nC\u001e,'BA\u0003\u0007\u0003\u0019\u0019x.\u001e:dK*\u0011q\u0001C\u0001\u0003[2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0005\u0001=)r\u0004\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0003-ui\u0011a\u0006\u0006\u00031e\t1\u0002Z1uCN|WO]2fg*\u0011!dG\u0001\nKb,7-\u001e;j_:T!\u0001\b\u0005\u0002\u0007M\fH.\u0003\u0002\u001f/\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tZ\u0012aB:pkJ\u001cWm]\u0005\u0003I\u0005\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\")a\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001*!\tQ\u0003!D\u0001\u0003\u0011\u0015a\u0003\u0001\"\u0011.\u0003-IgNZ3s'\u000eDW-\\1\u0015\t9:T(\u0013\t\u0004!=\n\u0014B\u0001\u0019\u0012\u0005\u0019y\u0005\u000f^5p]B\u0011!'N\u0007\u0002g)\u0011AgG\u0001\u0006if\u0004Xm]\u0005\u0003mM\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015A4\u00061\u0001:\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tQ4(D\u0001\u001c\u0013\ta4D\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003?W\u0001\u0007q(A\u0004paRLwN\\:\u0011\t\u0001\u001beI\u0012\b\u0003!\u0005K!AQ\t\u0002\rA\u0013X\rZ3g\u0013\t!UIA\u0002NCBT!AQ\t\u0011\u0005\u0001;\u0015B\u0001%F\u0005\u0019\u0019FO]5oO\")!j\u000ba\u0001\u0017\u0006)a-\u001b7fgB\u0019A\nV,\u000f\u00055\u0013fB\u0001(R\u001b\u0005y%B\u0001)(\u0003\u0019a$o\\8u}%\t!#\u0003\u0002T#\u00059\u0001/Y2lC\u001e,\u0017BA+W\u0005\r\u0019V-\u001d\u0006\u0003'F\u0001\"\u0001W/\u000e\u0003eS!AW.\u0002\u0005\u0019\u001c(B\u0001/\u000b\u0003\u0019A\u0017\rZ8pa&\u0011a,\u0017\u0002\u000b\r&dWm\u0015;biV\u001c\b\"\u00021\u0001\t\u0003\n\u0017\u0001\u00049sKB\f'/Z,sSR,G#\u00022fM:|\u0007C\u0001\fd\u0013\t!wCA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u00039?\u0002\u0007\u0011\bC\u0003h?\u0002\u0007\u0001.A\u0002k_\n\u0004\"!\u001b7\u000e\u0003)T!a[.\u0002\u00135\f\u0007O]3ek\u000e,\u0017BA7k\u0005\rQuN\u0019\u0005\u0006}}\u0003\ra\u0010\u0005\u0006a~\u0003\r!M\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007\"\u0002:\u0001\t\u0003\u001a\u0018!C:i_J$h*Y7f)\u00051\u0005\"B;\u0001\t#2\u0018a\u00032vS2$'+Z1eKJ$rb^A\u0007\u0003\u001f\t\t\"!\u0006\u0002\u001a\u0005\u0015\u0012q\u0005\t\u0005!aTX0\u0003\u0002z#\tIa)\u001e8di&|g.\r\t\u0003-mL!\u0001`\f\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004B\u0001\u0014@\u0002\u0002%\u0011qP\u0016\u0002\t\u0013R,'/\u0019;peB!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\bm\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003\u0017\t)AA\u0006J]R,'O\\1m%><\b\"\u0002\u001du\u0001\u0004I\u0004\"\u00029u\u0001\u0004\t\u0004BBA\ni\u0002\u0007\u0011'A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0011\u0019\t9\u0002\u001ea\u0001c\u0005q!/Z9vSJ,GmU2iK6\f\u0007bBA\u000ei\u0002\u0007\u0011QD\u0001\bM&dG/\u001a:t!\u0011aE+a\b\u0011\u0007\u0001\n\t#C\u0002\u0002$\u0005\u0012aAR5mi\u0016\u0014\b\"\u0002 u\u0001\u0004y\u0004bBA\u0015i\u0002\u0007\u00111F\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BA\u0017\u0003gi!!a\f\u000b\u0007\u0005E2,\u0001\u0003d_:4\u0017\u0002BA\u001b\u0003_\u0011QbQ8oM&<WO]1uS>t\u0007")
public class ImageFileFormat
implements FileFormat,
DataSourceRegister {
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.class.supportBatch((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.class.vectorTypes((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return FileFormat.class.isSplitable((FileFormat)this, (SparkSession)sparkSession, options, (Path)path);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.class.buildReaderWithPartitionValues((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        return FileFormat.class.supportDataType((FileFormat)this, (DataType)dataType, (boolean)isReadPath);
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)ImageSchema$.MODULE$.imageSchema());
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        throw new UnsupportedOperationException("Write is not supported for image data source");
    }

    public String shortName() {
        return "image";
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Image data source only produces a single data column named \"image\".";
            }
        });
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        ImageOptions imageSourceOptions = new ImageOptions(options);
        return new Serializable(this, requiredSchema, broadcastedHadoopConf, imageSourceOptions){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedHadoopConf$1;
            private final ImageOptions imageSourceOptions$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                FSDataInputStream stream;
                Iterator iterator;
                UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
                if (!this.imageSourceOptions$1.dropInvalid() && this.requiredSchema$1.isEmpty()) {
                    iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnsafeRow[]{emptyUnsafeRow}));
                } else {
                    Iterator filteredResult;
                    String origin = file.filePath();
                    Path path = new Path(origin);
                    FileSystem fs = path.getFileSystem(((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value());
                    stream = fs.open(path);
                    byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
                    Option<Row> resultOpt = ImageSchema$.MODULE$.decode(origin, bytes);
                    Iterator iterator2 = filteredResult = this.imageSourceOptions$1.dropInvalid() ? Option$.MODULE$.option2Iterable(resultOpt).toIterator() : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{(Row)resultOpt.getOrElse((Function0)new Serializable(this, origin){
                        public static final long serialVersionUID = 0L;
                        private final String origin$1;

                        public final Row apply() {
                            return ImageSchema$.MODULE$.invalidImageRow(this.origin$1);
                        }
                        {
                            this.origin$1 = origin$1;
                        }
                    })}));
                    if (this.requiredSchema$1.isEmpty()) {
                        iterator = filteredResult.map((Function1)new Serializable(this, emptyUnsafeRow){
                            public static final long serialVersionUID = 0L;
                            private final UnsafeRow emptyUnsafeRow$1;

                            public final UnsafeRow apply(Row x$1) {
                                return this.emptyUnsafeRow$1;
                            }
                            {
                                this.emptyUnsafeRow$1 = emptyUnsafeRow$1;
                            }
                        });
                    } else {
                        ExpressionEncoder converter = RowEncoder$.MODULE$.apply(this.requiredSchema$1);
                        iterator = filteredResult.map((Function1)new Serializable(this, converter){
                            public static final long serialVersionUID = 0L;
                            private final ExpressionEncoder converter$1;

                            public final InternalRow apply(Row row) {
                                return this.converter$1.toRow((Object)row);
                            }
                            {
                                this.converter$1 = converter$1;
                            }
                        });
                    }
                }
                return iterator;
                finally {
                    Closeables.close((Closeable)stream, (boolean)true);
                }
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.imageSourceOptions$1 = imageSourceOptions$1;
            }
        };
    }

    public ImageFileFormat() {
        FileFormat.class.$init$((FileFormat)this);
    }
}

