/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jdo.spi.JDOImplHelper;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.state.ObjectProviderFactory;
import org.datanucleus.store.FieldValues;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class ObjectProviderFactoryImpl
implements ObjectProviderFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    Class opClass = null;
    public static Class[] OBJECT_PROVIDER_CTR_ARG_CLASSES = new Class[]{ExecutionContext.class, AbstractClassMetaData.class};

    public ObjectProviderFactoryImpl(NucleusContext nucCtx) {
        PersistenceConfiguration conf = nucCtx.getPersistenceConfiguration();
        String opClassName = conf.getStringProperty("datanucleus.objectProvider.className");
        if (StringUtils.isWhitespace(opClassName)) {
            opClassName = nucCtx.getStoreManager().getDefaultObjectProviderClassName();
        }
        this.opClass = nucCtx.getClassLoaderResolver(null).classForName(opClassName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JDOImplHelper.registerAuthorizedStateManagerClass((Class)ObjectProviderFactoryImpl.this.opClass);
                return null;
            }
        });
    }

    @Override
    public void close() {
    }

    @Override
    public ObjectProvider newForHollow(ExecutionContext ec, Class pcClass, Object id) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForHollow(id, null, cls);
        return op;
    }

    @Override
    public ObjectProvider newForHollow(ExecutionContext ec, Class pcClass, Object id, FieldValues fv) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForHollow(id, fv, cls);
        return op;
    }

    @Override
    public ObjectProvider newForHollowPreConstructed(ExecutionContext ec, Object id, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForHollowPreConstructed(id, pc);
        return op;
    }

    @Override
    public ObjectProvider newForHollowPopulatedAppId(ExecutionContext ec, Class pcClass, FieldValues fv) {
        Class cls = this.getInitialisedClassForClass(pcClass, ec.getClassLoaderResolver());
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pcClass, ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForHollowAppId(fv, cls);
        return op;
    }

    @Override
    public ObjectProvider newForPersistentClean(ExecutionContext ec, Object id, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForPersistentClean(id, pc);
        return op;
    }

    @Override
    public ObjectProvider newForEmbedded(ExecutionContext ec, Object pc, boolean copyPc, ObjectProvider ownerOP, int ownerFieldNumber) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForEmbedded(pc, copyPc);
        if (ownerOP != null) {
            ec.registerEmbeddedRelation(ownerOP, ownerFieldNumber, op);
        }
        return op;
    }

    @Override
    public ObjectProvider newForEmbedded(ExecutionContext ec, AbstractClassMetaData cmd, ObjectProvider ownerOP, int ownerFieldNumber) {
        Class pcClass = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        ObjectProvider op = this.newForHollow(ec, pcClass, null);
        op.initialiseForEmbedded(op.getObject(), false);
        if (ownerOP != null) {
            ec.registerEmbeddedRelation(ownerOP, ownerFieldNumber, op);
        }
        return op;
    }

    @Override
    public ObjectProvider newForPersistentNew(ExecutionContext ec, Object pc, FieldValues preInsertChanges) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForPersistentNew(pc, preInsertChanges);
        return op;
    }

    @Override
    public ObjectProvider newForTransactionalTransient(ExecutionContext ec, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForTransactionalTransient(pc);
        return op;
    }

    @Override
    public ObjectProvider newForDetached(ExecutionContext ec, Object pc, Object id, Object version) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForDetached(pc, id, version);
        return op;
    }

    @Override
    public ObjectProvider newForPNewToBeDeleted(ExecutionContext ec, Object pc) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(pc.getClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForPNewToBeDeleted(pc);
        return op;
    }

    @Override
    public ObjectProvider newForCachedPC(ExecutionContext ec, Object id, CachedPC cachedPC) {
        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(cachedPC.getObjectClass(), ec.getClassLoaderResolver());
        ObjectProvider op = this.getObjectProvider(ec, cmd);
        op.initialiseForCachedPC(cachedPC, id);
        return op;
    }

    @Override
    public void disconnectObjectProvider(ObjectProvider op) {
    }

    protected ObjectProvider getObjectProvider(ExecutionContext ec, AbstractClassMetaData cmd) {
        return (ObjectProvider)ClassUtils.newInstance(this.opClass, OBJECT_PROVIDER_CTR_ARG_CLASSES, new Object[]{ec, cmd});
    }

    private Class getInitialisedClassForClass(Class pcCls, ClassLoaderResolver clr) {
        try {
            return clr.classForName(pcCls.getName(), pcCls.getClassLoader(), true);
        }
        catch (ClassNotResolvedException e) {
            throw new NucleusUserException(LOCALISER.msg("026015", (Object)pcCls.getName())).setFatal();
        }
    }
}

