/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.FileFormatException;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class OrcUtils$
implements Logging {
    public static final OrcUtils$ MODULE$;
    private final Map<String, String> extensionsForCompressionCodecNames;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new OrcUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Map<String, String> extensionsForCompressionCodecNames() {
        return this.extensionsForCompressionCodecNames;
    }

    public Seq<Path> listOrcFiles(String pathStr, Configuration conf) {
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        Seq paths = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)SparkHadoopUtil$.MODULE$.get().listLeafStatuses(fs, origPath).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$1) {
                return x$1.isDirectory();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$2) {
                return x$2.getPath();
            }
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$3) {
                return x$3.getName().startsWith("_");
            }
        })).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$4) {
                return x$4.getName().startsWith(".");
            }
        });
        return paths;
    }

    public Option<TypeDescription> readSchema(Path file, Configuration conf, boolean ignoreCorruptFiles) {
        FileFormatException fileFormatException2;
        block2: {
            Object object;
            FileSystem fs = file.getFileSystem(conf);
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
            try {
                Reader reader = OrcFile.createReader((Path)file, (OrcFile.ReaderOptions)readerOptions);
                TypeDescription schema2 = reader.getSchema();
                object = schema2.getFieldNames().size() == 0 ? None$.MODULE$ : new Some((Object)schema2);
            }
            catch (FileFormatException fileFormatException2) {
                if (!ignoreCorruptFiles) break block2;
                this.logWarning((Function0<String>)new Serializable(file){
                    public static final long serialVersionUID = 0L;
                    private final Path file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped the footer in the corrupted file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                }, fileFormatException2);
                object = None$.MODULE$;
            }
            return object;
        }
        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read footer for file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})), (Throwable)fileFormatException2);
    }

    public Option<StructType> readSchema(SparkSession sparkSession, Seq<FileStatus> files) {
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        Configuration conf = sparkSession.sessionState().newHadoopConf();
        return files.toIterator().map((Function1)new Serializable(ignoreCorruptFiles, conf){
            public static final long serialVersionUID = 0L;
            private final boolean ignoreCorruptFiles$1;
            private final Configuration conf$1;

            public final Option<TypeDescription> apply(FileStatus file) {
                return OrcUtils$.MODULE$.readSchema(file.getPath(), this.conf$1, this.ignoreCorruptFiles$1);
            }
            {
                this.ignoreCorruptFiles$1 = ignoreCorruptFiles$1;
                this.conf$1 = conf$1;
            }
        }).collectFirst((PartialFunction)new Serializable(files){
            public static final long serialVersionUID = 0L;
            public final Seq files$1;

            public final <A1 extends Option<TypeDescription>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    TypeDescription schema2 = (TypeDescription)some.x();
                    OrcUtils$.MODULE$.logDebug((Function0<String>)new Serializable(this, schema2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.readSchema.1 $outer;
                        private final TypeDescription schema$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading schema from file ", ", got Hive schema string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.files$1, this.schema$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.schema$1 = schema$1;
                        }
                    });
                    object = (StructType)CatalystSqlParser$.MODULE$.parseDataType(schema2.toString());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<TypeDescription> x1) {
                Option<TypeDescription> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
            {
                this.files$1 = files$1;
            }
        });
    }

    public Option<int[]> requestedColumnIds(boolean isCaseSensitive, StructType dataSchema, StructType requiredSchema, Reader reader, Configuration conf) {
        None$ none$;
        Buffer orcFieldNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(reader.getSchema().getFieldNames()).asScala();
        if (orcFieldNames.isEmpty()) {
            none$ = None$.MODULE$;
        } else if (orcFieldNames.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return x$5.startsWith("_col");
            }
        })) {
            Predef$.MODULE$.assert(orcFieldNames.length() <= dataSchema.length(), (Function0)new Serializable(dataSchema){
                public static final long serialVersionUID = 0L;
                private final StructType dataSchema$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"The given data schema ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " has less fields than the actual ORC physical schema, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataSchema$1.catalogString()}))).append((Object)"no idea which columns were dropped, fail to read.").toString();
                }
                {
                    this.dataSchema$1 = dataSchema$1;
                }
            });
            none$ = new Some(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames()).map((Function1)new Serializable(dataSchema, orcFieldNames){
                public static final long serialVersionUID = 0L;
                private final StructType dataSchema$1;
                private final Buffer orcFieldNames$1;

                public final int apply(String name2) {
                    int index = this.dataSchema$1.fieldIndex(name2);
                    return index < this.orcFieldNames$1.length() ? index : -1;
                }
                {
                    this.dataSchema$1 = dataSchema$1;
                    this.orcFieldNames$1 = orcFieldNames$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        } else if (isCaseSensitive) {
            none$ = new Some(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames()).map((Function1)new Serializable(orcFieldNames){
                public static final long serialVersionUID = 0L;
                private final Buffer orcFieldNames$1;

                public final int apply(String name2) {
                    return this.orcFieldNames$1.indexWhere((Function1)new Serializable(this, name2){
                        public static final long serialVersionUID = 0L;
                        private final String name$1;

                        public final boolean apply(String x$6) {
                            return BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.caseSensitiveResolution().apply((Object)x$6, (Object)this.name$1));
                        }
                        {
                            this.name$1 = name$1;
                        }
                    });
                }
                {
                    this.orcFieldNames$1 = orcFieldNames$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        } else {
            Map caseInsensitiveOrcFieldMap = ((TraversableLike)orcFieldNames.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, Object> x$7) {
                    return ((String)x$7._1()).toLowerCase(Locale.ROOT);
                }
            });
            none$ = new Some(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fieldNames()).map((Function1)new Serializable(caseInsensitiveOrcFieldMap){
                public static final long serialVersionUID = 0L;
                private final Map caseInsensitiveOrcFieldMap$1;

                public final int apply(String requiredFieldName) {
                    return BoxesRunTime.unboxToInt((Object)this.caseInsensitiveOrcFieldMap$1.get((Object)requiredFieldName.toLowerCase(Locale.ROOT)).map((Function1)new Serializable(this, requiredFieldName){
                        public static final long serialVersionUID = 0L;
                        private final String requiredFieldName$1;

                        public final int apply(Buffer<Tuple2<String, Object>> matchedOrcFields) {
                            if (matchedOrcFields.size() > 1) {
                                String matchedOrcFieldsString = ((TraversableOnce)matchedOrcFields.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Tuple2<String, Object> x$8) {
                                        return (String)x$8._1();
                                    }
                                }, Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                                throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found duplicate field(s) \"", "\": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.requiredFieldName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " in case-insensitive mode"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{matchedOrcFieldsString}))).toString());
                            }
                            return ((Tuple2)matchedOrcFields.head())._2$mcI$sp();
                        }
                        {
                            this.requiredFieldName$1 = requiredFieldName$1;
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return -1;
                        }
                    }));
                }
                {
                    this.caseInsensitiveOrcFieldMap$1 = caseInsensitiveOrcFieldMap$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        }
        return none$;
    }

    private OrcUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.extensionsForCompressionCodecNames = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NONE"), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SNAPPY"), (Object)".snappy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ZLIB"), (Object)".zlib"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LZO"), (Object)".lzo")}));
    }
}

