/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="parse_url_tuple", value="_FUNC_(url, partname1, partname2, ..., partnameN) - extracts N (N>=1) parts from a URL.\nIt takes a URL and one or multiple partnames, and returns a tuple. All the input parameters and output column types are string.", extended="Partname: HOST, PATH, QUERY, REF, PROTOCOL, AUTHORITY, FILE, USERINFO, QUERY:<KEY_NAME>\nNote: Partnames are case-sensitive, and should not contain unnecessary white spaces.\nExample:\n  > SELECT b.* FROM src LATERAL VIEW _FUNC_(fullurl, 'HOST', 'PATH', 'QUERY', 'QUERY:id') b as host, path, query, query_id LIMIT 1;\n  > SELECT _FUNC_(a.fullurl, 'HOST', 'PATH', 'QUERY', 'REF', 'PROTOCOL', 'FILE',  'AUTHORITY', 'USERINFO', 'QUERY:k1') as (ho, pa, qu, re, pr, fi, au, us, qk1) from src a;")
public class GenericUDTFParseUrlTuple
extends GenericUDTF {
    private static Log LOG = LogFactory.getLog((String)GenericUDTFParseUrlTuple.class.getName());
    int numCols;
    String[] paths;
    PARTNAME[] partnames;
    Text[] retCols;
    Text[] cols;
    private transient Object[] nullCols;
    private transient ObjectInspector[] inputOIs;
    boolean pathParsed = false;
    boolean seenErrors = false;
    private transient URL url = null;
    private transient Pattern p = null;
    private transient String lastKey = null;

    @Override
    public void close() throws HiveException {
    }

    @Override
    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        int i;
        this.inputOIs = args;
        this.numCols = args.length - 1;
        if (this.numCols < 1) {
            throw new UDFArgumentException("parse_url_tuple() takes at least two arguments: the url string and a part name");
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].getCategory() == ObjectInspector.Category.PRIMITIVE && args[i].getTypeName().equals("string")) continue;
            throw new UDFArgumentException("parse_url_tuple()'s arguments have to be string type");
        }
        this.seenErrors = false;
        this.pathParsed = false;
        this.url = null;
        this.p = null;
        this.lastKey = null;
        this.paths = new String[this.numCols];
        this.partnames = new PARTNAME[this.numCols];
        this.cols = new Text[this.numCols];
        this.retCols = new Text[this.numCols];
        this.nullCols = new Object[this.numCols];
        for (i = 0; i < this.numCols; ++i) {
            this.cols[i] = new Text();
            this.retCols[i] = this.cols[i];
            this.nullCols[i] = null;
        }
        ArrayList<String> fieldNames = new ArrayList<String>(this.numCols);
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>(this.numCols);
        for (int i2 = 0; i2 < this.numCols; ++i2) {
            fieldNames.add("c" + i2);
            fieldOIs.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    @Override
    public void process(Object[] o) throws HiveException {
        String urlStr;
        if (o[0] == null) {
            this.forward(this.nullCols);
            return;
        }
        if (!this.pathParsed) {
            for (int i = 0; i < this.numCols; ++i) {
                this.paths[i] = ((StringObjectInspector)this.inputOIs[i + 1]).getPrimitiveJavaObject(o[i + 1]);
                if (this.paths[i] == null) {
                    this.partnames[i] = PARTNAME.NULLNAME;
                    continue;
                }
                if (this.paths[i].equals("HOST")) {
                    this.partnames[i] = PARTNAME.HOST;
                    continue;
                }
                if (this.paths[i].equals("PATH")) {
                    this.partnames[i] = PARTNAME.PATH;
                    continue;
                }
                if (this.paths[i].equals("QUERY")) {
                    this.partnames[i] = PARTNAME.QUERY;
                    continue;
                }
                if (this.paths[i].equals("REF")) {
                    this.partnames[i] = PARTNAME.REF;
                    continue;
                }
                if (this.paths[i].equals("PROTOCOL")) {
                    this.partnames[i] = PARTNAME.PROTOCOL;
                    continue;
                }
                if (this.paths[i].equals("FILE")) {
                    this.partnames[i] = PARTNAME.FILE;
                    continue;
                }
                if (this.paths[i].equals("AUTHORITY")) {
                    this.partnames[i] = PARTNAME.AUTHORITY;
                    continue;
                }
                if (this.paths[i].equals("USERINFO")) {
                    this.partnames[i] = PARTNAME.USERINFO;
                    continue;
                }
                if (this.paths[i].startsWith("QUERY:")) {
                    this.partnames[i] = PARTNAME.QUERY_WITH_KEY;
                    this.paths[i] = this.paths[i].substring(6);
                    continue;
                }
                this.partnames[i] = PARTNAME.NULLNAME;
            }
            this.pathParsed = true;
        }
        if ((urlStr = ((StringObjectInspector)this.inputOIs[0]).getPrimitiveJavaObject(o[0])) == null) {
            this.forward(this.nullCols);
            return;
        }
        try {
            String ret = null;
            this.url = new URL(urlStr);
            for (int i = 0; i < this.numCols; ++i) {
                ret = this.evaluate(this.url, i);
                if (ret == null) {
                    this.retCols[i] = null;
                    continue;
                }
                if (this.retCols[i] == null) {
                    this.retCols[i] = this.cols[i];
                }
                this.retCols[i].set(ret);
            }
            this.forward(this.retCols);
            return;
        }
        catch (MalformedURLException e) {
            if (!this.seenErrors) {
                LOG.error((Object)("The input is not a valid url string: " + urlStr + ". Skipping such error messages in the future."));
                this.seenErrors = true;
            }
            this.forward(this.nullCols);
            return;
        }
    }

    public String toString() {
        return "parse_url_tuple";
    }

    private String evaluate(URL url, int index) {
        if (url == null || index < 0 || index >= this.partnames.length) {
            return null;
        }
        switch (this.partnames[index]) {
            case HOST: {
                return url.getHost();
            }
            case PATH: {
                return url.getPath();
            }
            case QUERY: {
                return url.getQuery();
            }
            case REF: {
                return url.getRef();
            }
            case PROTOCOL: {
                return url.getProtocol();
            }
            case FILE: {
                return url.getFile();
            }
            case AUTHORITY: {
                return url.getAuthority();
            }
            case USERINFO: {
                return url.getUserInfo();
            }
            case QUERY_WITH_KEY: {
                return this.evaluateQuery(url.getQuery(), this.paths[index]);
            }
        }
        return null;
    }

    private String evaluateQuery(String query, String key) {
        if (query == null || key == null) {
            return null;
        }
        if (!key.equals(this.lastKey)) {
            this.p = Pattern.compile("(&|^)" + key + "=([^&]*)");
        }
        this.lastKey = key;
        Matcher m = this.p.matcher(query);
        if (m.find()) {
            return m.group(2);
        }
        return null;
    }

    static enum PARTNAME {
        HOST,
        PATH,
        QUERY,
        REF,
        PROTOCOL,
        AUTHORITY,
        FILE,
        USERINFO,
        QUERY_WITH_KEY,
        NULLNAME;

    }
}

