/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.io;

import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.spark.network.util.AbstractFileRegion;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4Q!\u0001\u0002\u0001\u00051\u00111d\u00115v].,GMQ=uK\n+hMZ3s\r&dWMU3hS>t'BA\u0002\u0005\u0003\tIwN\u0003\u0002\u0006\r\u0005!Q\u000f^5m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7C\u0001\u0001\u000e!\tq!#D\u0001\u0010\u0015\t)\u0001C\u0003\u0002\u0012\r\u00059a.\u001a;x_J\\\u0017BA\n\u0010\u0005I\t%m\u001d;sC\u000e$h)\u001b7f%\u0016<\u0017n\u001c8\t\u0011U\u0001!Q1A\u0005\n]\t\u0011c\u00195v].,GMQ=uK\n+hMZ3s\u0007\u0001)\u0012\u0001\u0007\t\u00033ii\u0011AA\u0005\u00037\t\u0011\u0011c\u00115v].,GMQ=uK\n+hMZ3s\u0011!i\u0002A!A!\u0002\u0013A\u0012AE2ik:\\W\r\u001a\"zi\u0016\u0014UO\u001a4fe\u0002B\u0001b\b\u0001\u0003\u0006\u0004%I\u0001I\u0001\fS>\u001c\u0005.\u001e8l'&TX-F\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\rIe\u000e\u001e\u0005\tQ\u0001\u0011\t\u0011)A\u0005C\u0005a\u0011n\\\"ik:\\7+\u001b>fA!)!\u0006\u0001C\u0001W\u00051A(\u001b8jiz\"2\u0001L\u0017/!\tI\u0002\u0001C\u0003\u0016S\u0001\u0007\u0001\u0004C\u0003 S\u0001\u0007\u0011\u0005C\u00041\u0001\u0001\u0007I\u0011B\u0019\u0002\u0019}#(/\u00198tM\u0016\u0014(/\u001a3\u0016\u0003I\u0002\"AI\u001a\n\u0005Q\u001a#\u0001\u0002'p]\u001eDqA\u000e\u0001A\u0002\u0013%q'\u0001\t`iJ\fgn\u001d4feJ,Gm\u0018\u0013fcR\u0011\u0001h\u000f\t\u0003EeJ!AO\u0012\u0003\tUs\u0017\u000e\u001e\u0005\byU\n\t\u00111\u00013\u0003\rAH%\r\u0005\u0007}\u0001\u0001\u000b\u0015\u0002\u001a\u0002\u001b}#(/\u00198tM\u0016\u0014(/\u001a3!\u0011\u001d\u0001\u0005A1A\u0005\n\u0005\u000baa\u00195v].\u001cX#\u0001\"\u0011\u0007\t\u001aU)\u0003\u0002EG\t)\u0011I\u001d:bsB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0004]&|'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013!BQ=uK\n+hMZ3s\u0011\u0019q\u0005\u0001)A\u0005\u0005\u000691\r[;oWN\u0004\u0003b\u0002)\u0001\u0005\u0004%I!M\u0001\u0005g&TX\r\u0003\u0004S\u0001\u0001\u0006IAM\u0001\u0006g&TX\r\t\u0005\u0006)\u0002!\t\"V\u0001\u000bI\u0016\fG\u000e\\8dCR,G#\u0001\u001d\t\u000b]\u0003A\u0011\t-\u0002\u000b\r|WO\u001c;\u0015\u0003IBQA\u0017\u0001\u0005Ba\u000b\u0001\u0002]8tSRLwN\u001c\u0005\u00069\u0002!\t\u0005W\u0001\fiJ\fgn\u001d4feJ,G\rC\u0004_\u0001\u0001\u0007I\u0011\u0002\u0011\u0002\u001f\r,(O]3oi\u000eCWO\\6JIbDq\u0001\u0019\u0001A\u0002\u0013%\u0011-A\ndkJ\u0014XM\u001c;DQVt7.\u00133y?\u0012*\u0017\u000f\u0006\u00029E\"9AhXA\u0001\u0002\u0004\t\u0003B\u00023\u0001A\u0003&\u0011%\u0001\tdkJ\u0014XM\u001c;DQVt7.\u00133yA!)a\r\u0001C\u0001O\u0006QAO]1og\u001a,'\u000fV8\u0015\u0007IB\u0007\u000fC\u0003jK\u0002\u0007!.\u0001\u0004uCJ<W\r\u001e\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[\u001e\u000b\u0001b\u00195b]:,Gn]\u0005\u0003_2\u00141c\u0016:ji\u0006\u0014G.\u001a\"zi\u0016\u001c\u0005.\u00198oK2DQAW3A\u0002I\u0002")
public class ChunkedByteBufferFileRegion
extends AbstractFileRegion {
    private final ChunkedByteBuffer chunkedByteBuffer;
    private final int ioChunkSize;
    private long _transferred;
    private final ByteBuffer[] chunks;
    private final long size;
    private int currentChunkIdx;

    private ChunkedByteBuffer chunkedByteBuffer() {
        return this.chunkedByteBuffer;
    }

    private int ioChunkSize() {
        return this.ioChunkSize;
    }

    private long _transferred() {
        return this._transferred;
    }

    private void _transferred_$eq(long x$1) {
        this._transferred = x$1;
    }

    private ByteBuffer[] chunks() {
        return this.chunks;
    }

    private long size() {
        return this.size;
    }

    public void deallocate() {
    }

    public long count() {
        return this.size();
    }

    public long position() {
        return 0L;
    }

    public long transferred() {
        return this._transferred();
    }

    private int currentChunkIdx() {
        return this.currentChunkIdx;
    }

    private void currentChunkIdx_$eq(int x$1) {
        this.currentChunkIdx = x$1;
    }

    public long transferTo(WritableByteChannel target, long position) {
        Predef$.MODULE$.assert(position == this._transferred());
        if (position == this.size()) {
            return 0L;
        }
        boolean keepGoing = true;
        long written = 0L;
        ByteBuffer currentChunk = this.chunks()[this.currentChunkIdx()];
        while (keepGoing) {
            while (currentChunk.hasRemaining() && keepGoing) {
                int ioSize = Math.min(currentChunk.remaining(), this.ioChunkSize());
                int originalLimit = currentChunk.limit();
                currentChunk.limit(currentChunk.position() + ioSize);
                int thisWriteSize = target.write(currentChunk);
                currentChunk.limit(originalLimit);
                written += (long)thisWriteSize;
                if (thisWriteSize >= ioSize) continue;
                keepGoing = false;
            }
            if (!keepGoing) continue;
            this.currentChunkIdx_$eq(this.currentChunkIdx() + 1);
            if (this.currentChunkIdx() == Predef$.MODULE$.refArrayOps((Object[])this.chunks()).size()) {
                keepGoing = false;
                continue;
            }
            currentChunk = this.chunks()[this.currentChunkIdx()];
        }
        this._transferred_$eq(this._transferred() + written);
        return written;
    }

    public ChunkedByteBufferFileRegion(ChunkedByteBuffer chunkedByteBuffer, int ioChunkSize) {
        this.chunkedByteBuffer = chunkedByteBuffer;
        this.ioChunkSize = ioChunkSize;
        this._transferred = 0L;
        this.chunks = chunkedByteBuffer.getChunks();
        this.size = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])this.chunks()).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$1, ByteBuffer x$2) {
                return x$1 + (long)x$2.remaining();
            }
        }));
        this.currentChunkIdx = 0;
    }
}

