/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.BlockStatus$;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageStatus$NonRddStorageInfo$;
import org.apache.spark.storage.StorageStatus$RddStorageInfo$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.MapLike;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t]g!B\u0001\u0003\u0001\u0011Q!!D*u_J\fw-Z*uCR,8O\u0003\u0002\u0004\t\u000591\u000f^8sC\u001e,'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0003\u0005\u0013\u0001\t\u0015\r\u0011\"\u0001\u0015\u00039\u0011Gn\\2l\u001b\u0006t\u0017mZ3s\u0013\u0012\u001c\u0001!F\u0001\u0016!\t1r#D\u0001\u0003\u0013\tA\"A\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\t\u0011i\u0001!\u0011!Q\u0001\nU\tqB\u00197pG.l\u0015M\\1hKJLE\r\t\u0005\t9\u0001\u0011)\u0019!C\u0001;\u0005IQ.\u0019=NK6|'/_\u000b\u0002=A\u0011AbH\u0005\u0003A5\u0011A\u0001T8oO\"A!\u0005\u0001B\u0001B\u0003%a$\u0001\u0006nCblU-\\8ss\u0002B\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!J\u0001\r[\u0006DxJ\u001c%fCBlU-\\\u000b\u0002MA\u0019Ab\n\u0010\n\u0005!j!AB(qi&|g\u000e\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003'\u00035i\u0017\r_(o\u0011\u0016\f\u0007/T3nA!AA\u0006\u0001BC\u0002\u0013\u0005Q%A\u0007nCb|eM\u001a%fCBlU-\u001c\u0005\t]\u0001\u0011\t\u0011)A\u0005M\u0005qQ.\u0019=PM\u001aDU-\u00199NK6\u0004\u0003\"\u0002\u0019\u0001\t\u0003\t\u0014A\u0002\u001fj]&$h\bF\u00033gQ*d\u0007\u0005\u0002\u0017\u0001!)!c\fa\u0001+!)Ad\fa\u0001=!)Ae\fa\u0001M!)Af\fa\u0001M!9\u0001\b\u0001b\u0001\n\u0013I\u0014AC0sI\u0012\u0014En\\2lgV\t!\b\u0005\u0003<\u0001\n+U\"\u0001\u001f\u000b\u0005ur\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003\u007f5\t!bY8mY\u0016\u001cG/[8o\u0013\t\tEHA\u0004ICNDW*\u00199\u0011\u00051\u0019\u0015B\u0001#\u000e\u0005\rIe\u000e\u001e\t\u0005w\u0019C5*\u0003\u0002Hy\t\u0019Q*\u00199\u0011\u0005YI\u0015B\u0001&\u0003\u0005\u001d\u0011En\\2l\u0013\u0012\u0004\"A\u0006'\n\u00055\u0013!a\u0003\"m_\u000e\\7\u000b^1ukNDaa\u0014\u0001!\u0002\u0013Q\u0014aC0sI\u0012\u0014En\\2lg\u0002Bq!\u0015\u0001C\u0002\u0013%!+A\u0007`]>t'\u000b\u001a3CY>\u001c7n]\u000b\u0002'B!1\b\u0011%L\u0011\u0019)\u0006\u0001)A\u0005'\u0006qqL\\8o%\u0012$'\t\\8dWN\u0004c\u0001B,\u0001\tb\u0013aB\u00153e'R|'/Y4f\u0013:4wn\u0005\u0003W\u0017ec\u0006C\u0001\u0007[\u0013\tYVBA\u0004Qe>$Wo\u0019;\u0011\u00051i\u0016B\u00010\u000e\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\u0001gK!f\u0001\n\u0003i\u0012aC7f[>\u0014\u00180V:bO\u0016D\u0001B\u0019,\u0003\u0012\u0003\u0006IAH\u0001\r[\u0016lwN]=Vg\u0006<W\r\t\u0005\tIZ\u0013)\u001a!C\u0001;\u0005IA-[:l+N\fw-\u001a\u0005\tMZ\u0013\t\u0012)A\u0005=\u0005QA-[:l+N\fw-\u001a\u0011\t\u0011!4&Q3A\u0005\u0002%\fQ\u0001\\3wK2,\u0012A\u001b\t\u0003--L!\u0001\u001c\u0002\u0003\u0019M#xN]1hK2+g/\u001a7\t\u001194&\u0011#Q\u0001\n)\fa\u0001\\3wK2\u0004\u0003\"\u0002\u0019W\t\u0003\u0001H\u0003B9tiV\u0004\"A\u001d,\u000e\u0003\u0001AQ\u0001Y8A\u0002yAQ\u0001Z8A\u0002yAQ\u0001[8A\u0002)Dqa\u001e,\u0002\u0002\u0013\u0005\u00010\u0001\u0003d_BLH\u0003B9zunDq\u0001\u0019<\u0011\u0002\u0003\u0007a\u0004C\u0004emB\u0005\t\u0019\u0001\u0010\t\u000f!4\b\u0013!a\u0001U\"9QPVI\u0001\n\u0003q\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0002\u007f*\u001aa$!\u0001,\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0004\u000e\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\t9AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0001\"!\u0006W#\u0003%\tA`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011%\tIBVI\u0001\n\u0003\tY\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u!f\u00016\u0002\u0002!I\u0011\u0011\u0005,\u0002\u0002\u0013\u0005\u00131E\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u0005Y\u0006twM\u0003\u0002\u00020\u0005!!.\u0019<b\u0013\u0011\t\u0019$!\u000b\u0003\rM#(/\u001b8h\u0011%\t9DVA\u0001\n\u0003\tI$\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001C\u0011%\tiDVA\u0001\n\u0003\ty$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0005\u0013q\t\t\u0004\u0019\u0005\r\u0013bAA#\u001b\t\u0019\u0011I\\=\t\u0013\u0005%\u00131HA\u0001\u0002\u0004\u0011\u0015a\u0001=%c!I\u0011Q\n,\u0002\u0002\u0013\u0005\u0013qJ\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u000b\t\u0007\u0003'\n)&!\u0011\u000e\u0003yJ1!a\u0016?\u0005!IE/\u001a:bi>\u0014\b\"CA.-\u0006\u0005I\u0011AA/\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA0\u0003K\u00022\u0001DA1\u0013\r\t\u0019'\u0004\u0002\b\u0005>|G.Z1o\u0011)\tI%!\u0017\u0002\u0002\u0003\u0007\u0011\u0011\t\u0005\n\u0003S2\u0016\u0011!C!\u0003W\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u0005\"I\u0011q\u000e,\u0002\u0002\u0013\u0005\u0013\u0011O\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u0005\u0005\n\u0003k2\u0016\u0011!C!\u0003o\na!Z9vC2\u001cH\u0003BA0\u0003sB!\"!\u0013\u0002t\u0005\u0005\t\u0019AA!\u000f%\ti\bAA\u0001\u0012\u0013\ty(\u0001\bSI\u0012\u001cFo\u001c:bO\u0016LeNZ8\u0011\u0007I\f\tI\u0002\u0005X\u0001\u0005\u0005\t\u0012BAB'\u0015\t\t)!\"]!!\t9)!$\u001f=)\fXBAAE\u0015\r\tY)D\u0001\beVtG/[7f\u0013\u0011\ty)!#\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u00041\u0003\u0003#\t!a%\u0015\u0005\u0005}\u0004BCA8\u0003\u0003\u000b\t\u0011\"\u0012\u0002r!Q\u0011\u0011TAA\u0003\u0003%\t)a'\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fE\fi*a(\u0002\"\"1\u0001-a&A\u0002yAa\u0001ZAL\u0001\u0004q\u0002B\u00025\u0002\u0018\u0002\u0007!\u000e\u0003\u0006\u0002&\u0006\u0005\u0015\u0011!CA\u0003O\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002*\u0006E\u0006\u0003\u0002\u0007(\u0003W\u0003b\u0001DAW=yQ\u0017bAAX\u001b\t1A+\u001e9mKNB\u0011\"a-\u0002$\u0006\u0005\t\u0019A9\u0002\u0007a$\u0003\u0007C\u0005\u00028\u0002\u0011\r\u0011\"\u0003\u0002:\u0006yqL\u001d3e'R|'/Y4f\u0013:4w.\u0006\u0002\u0002<B!1\b\u0011\"r\u0011!\ty\f\u0001Q\u0001\n\u0005m\u0016\u0001E0sI\u0012\u001cFo\u001c:bO\u0016LeNZ8!\r\u0019\t\u0019\r\u0001#\u0002F\n\tbj\u001c8SI\u0012\u001cFo\u001c:bO\u0016LeNZ8\u0014\u000b\u0005\u00057\"\u0017/\t\u0015\u0005%\u0017\u0011\u0019BI\u0002\u0013\u0005Q$A\u0006p]\"+\u0017\r]+tC\u001e,\u0007bCAg\u0003\u0003\u0014\t\u0019!C\u0001\u0003\u001f\fqb\u001c8IK\u0006\u0004Xk]1hK~#S-\u001d\u000b\u0005\u0003#\f9\u000eE\u0002\r\u0003'L1!!6\u000e\u0005\u0011)f.\u001b;\t\u0013\u0005%\u00131ZA\u0001\u0002\u0004q\u0002BCAn\u0003\u0003\u0014\t\u0012)Q\u0005=\u0005aqN\u001c%fCB,6/Y4fA!Q\u0011q\\Aa\u0005#\u0007I\u0011A\u000f\u0002\u0019=4g\rS3baV\u001b\u0018mZ3\t\u0017\u0005\r\u0018\u0011\u0019BA\u0002\u0013\u0005\u0011Q]\u0001\u0011_\u001a4\u0007*Z1q+N\fw-Z0%KF$B!!5\u0002h\"I\u0011\u0011JAq\u0003\u0003\u0005\rA\b\u0005\u000b\u0003W\f\tM!E!B\u0013q\u0012!D8gM\"+\u0017\r]+tC\u001e,\u0007\u0005C\u0005e\u0003\u0003\u0014\t\u001a!C\u0001;!Y\u0011\u0011_Aa\u0005\u0003\u0007I\u0011AAz\u00035!\u0017n]6Vg\u0006<Wm\u0018\u0013fcR!\u0011\u0011[A{\u0011%\tI%a<\u0002\u0002\u0003\u0007a\u0004C\u0005g\u0003\u0003\u0014\t\u0012)Q\u0005=!9\u0001'!1\u0005\u0002\u0005mH\u0003CA\u007f\u0003\u007f\u0014\tAa\u0001\u0011\u0007I\f\t\rC\u0004\u0002J\u0006e\b\u0019\u0001\u0010\t\u000f\u0005}\u0017\u0011 a\u0001=!1A-!?A\u0002yA\u0011b^Aa\u0003\u0003%\tAa\u0002\u0015\u0011\u0005u(\u0011\u0002B\u0006\u0005\u001bA\u0011\"!3\u0003\u0006A\u0005\t\u0019\u0001\u0010\t\u0013\u0005}'Q\u0001I\u0001\u0002\u0004q\u0002\u0002\u00033\u0003\u0006A\u0005\t\u0019\u0001\u0010\t\u0011u\f\t-%A\u0005\u0002yD\u0011\"!\u0006\u0002BF\u0005I\u0011\u0001@\t\u0013\u0005e\u0011\u0011YI\u0001\n\u0003q\bBCA\u0011\u0003\u0003\f\t\u0011\"\u0011\u0002$!Q\u0011qGAa\u0003\u0003%\t!!\u000f\t\u0015\u0005u\u0012\u0011YA\u0001\n\u0003\u0011Y\u0002\u0006\u0003\u0002B\tu\u0001\"CA%\u00053\t\t\u00111\u0001C\u0011)\ti%!1\u0002\u0002\u0013\u0005\u0013q\n\u0005\u000b\u00037\n\t-!A\u0005\u0002\t\rB\u0003BA0\u0005KA!\"!\u0013\u0003\"\u0005\u0005\t\u0019AA!\u0011)\tI'!1\u0002\u0002\u0013\u0005\u00131\u000e\u0005\u000b\u0003_\n\t-!A\u0005B\u0005E\u0004BCA;\u0003\u0003\f\t\u0011\"\u0011\u0003.Q!\u0011q\fB\u0018\u0011)\tIEa\u000b\u0002\u0002\u0003\u0007\u0011\u0011I\u0004\n\u0005g\u0001\u0011\u0011!E\u0005\u0005k\t\u0011CT8o%\u0012$7\u000b^8sC\u001e,\u0017J\u001c4p!\r\u0011(q\u0007\u0004\n\u0003\u0007\u0004\u0011\u0011!E\u0005\u0005s\u0019RAa\u000e\u0003<q\u0003\u0012\"a\"\u0002\u000ezqb$!@\t\u000fA\u00129\u0004\"\u0001\u0003@Q\u0011!Q\u0007\u0005\u000b\u0003_\u00129$!A\u0005F\u0005E\u0004BCAM\u0005o\t\t\u0011\"!\u0003FQA\u0011Q B$\u0005\u0013\u0012Y\u0005C\u0004\u0002J\n\r\u0003\u0019\u0001\u0010\t\u000f\u0005}'1\ta\u0001=!1AMa\u0011A\u0002yA!\"!*\u00038\u0005\u0005I\u0011\u0011B()\u0011\u0011\tF!\u0016\u0011\t19#1\u000b\t\u0007\u0019\u00055fD\b\u0010\t\u0015\u0005M&QJA\u0001\u0002\u0004\ti\u0010C\u0005\u0003Z\u0001\u0011\r\u0011\"\u0003\u0003\\\u0005\u0011rL\\8o%\u0012$7\u000b^8sC\u001e,\u0017J\u001c4p+\t\ti\u0010\u0003\u0005\u0003`\u0001\u0001\u000b\u0011BA\u007f\u0003Myfn\u001c8SI\u0012\u001cFo\u001c:bO\u0016LeNZ8!\u0011\u0019\u0001\u0004\u0001\"\u0001\u0003dQY!G!\u001a\u0003j\t-$Q\u000eB8\u0011\u001d\u00119G!\u0019A\u0002U\tAAY7jI\"1AD!\u0019A\u0002yAa\u0001\nB1\u0001\u00041\u0003B\u0002\u0017\u0003b\u0001\u0007a\u0005\u0003\u0005\u0003r\t\u0005\u0004\u0019\u0001B:\u00035Ig.\u001b;jC2\u0014En\\2lgB1\u00111\u000bB;\u0011.K!a\u0012 \t\u000f\te\u0004\u0001\"\u0001\u0003|\u00051!\r\\8dWN,\"Aa\u001d\t\u000f\t}\u0004\u0001\"\u0001\u0003|\u0005I!\u000f\u001a3CY>\u001c7n\u001d\u0005\t\u0005\u0007\u0003A\u0011\u0001\u0003\u0003\u0006\u0006A\u0011\r\u001a3CY>\u001c7\u000e\u0006\u0004\u0002R\n\u001d%1\u0012\u0005\b\u0005\u0013\u0013\t\t1\u0001I\u0003\u001d\u0011Gn\\2l\u0013\u0012DqA!$\u0003\u0002\u0002\u00071*A\u0006cY>\u001c7n\u0015;biV\u001c\bb\u0002BI\u0001\u0011\u0005!1S\u0001\tO\u0016$(\t\\8dWR!!Q\u0013BL!\raqe\u0013\u0005\b\u0005\u0013\u0013y\t1\u0001I\u0011\u0019\u0011Y\n\u0001C\u0001;\u00051Q.\u0019=NK6DaAa(\u0001\t\u0003i\u0012\u0001D7f[J+W.Y5oS:<\u0007B\u0002BR\u0001\u0011\u0005Q$A\u0004nK6,6/\u001a3\t\r\t\u001d\u0006\u0001\"\u0001&\u0003Iyg\u000eS3ba6+WNU3nC&t\u0017N\\4\t\r\t-\u0006\u0001\"\u0001&\u0003MygM\u001a%fCBlU-\u001c*f[\u0006Lg.\u001b8h\u0011\u0019\u0011y\u000b\u0001C\u0001K\u0005iqN\u001c%fCBlU-\\+tK\u0012DaAa-\u0001\t\u0003)\u0013AD8gM\"+\u0017\r]'f[V\u001bX\r\u001a\u0005\u0007\u0005o\u0003A\u0011A\u0013\u0002\u001f=t\u0007*Z1q\u0007\u0006\u001c\u0007.Z*ju\u0016DaAa/\u0001\t\u0003)\u0013\u0001E8gM\"+\u0017\r]\"bG\",7+\u001b>f\u0011\u0019\u0011y\f\u0001C\u0001;\u0005AA-[:l+N,G\rC\u0004\u0003D\u0002!\tA!2\u0002\u001b\u0011L7o[+tK\u0012\u0014\u0015P\u00153e)\rq\"q\u0019\u0005\b\u0005\u0013\u0014\t\r1\u0001C\u0003\u0015\u0011H\rZ%e\u0011\u001d\u0011i\r\u0001C\u0005\u0005\u001f\f\u0011#\u001e9eCR,7\u000b^8sC\u001e,\u0017J\u001c4p)\u0019\t\tN!5\u0003T\"9!\u0011\u0012Bf\u0001\u0004A\u0005b\u0002Bk\u0005\u0017\u0004\raS\u0001\u000f]\u0016<(\t\\8dWN#\u0018\r^;t\u0001")
public class StorageStatus {
    private final BlockManagerId blockManagerId;
    private final long maxMemory;
    private final Option<Object> maxOnHeapMem;
    private final Option<Object> maxOffHeapMem;
    private final HashMap<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> _rddBlocks;
    private final HashMap<BlockId, BlockStatus> _nonRddBlocks;
    private final HashMap<Object, RddStorageInfo> org$apache$spark$storage$StorageStatus$$_rddStorageInfo;
    private final NonRddStorageInfo org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo;
    private volatile StorageStatus$RddStorageInfo$ org$apache$spark$storage$StorageStatus$$RddStorageInfo$module;
    private volatile StorageStatus$NonRddStorageInfo$ org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StorageStatus$RddStorageInfo$ org$apache$spark$storage$StorageStatus$$RddStorageInfo$lzycompute() {
        StorageStatus storageStatus2 = this;
        synchronized (storageStatus2) {
            if (this.org$apache$spark$storage$StorageStatus$$RddStorageInfo$module != null) return this.org$apache$spark$storage$StorageStatus$$RddStorageInfo$module;
            this.org$apache$spark$storage$StorageStatus$$RddStorageInfo$module = new StorageStatus$RddStorageInfo$(this);
            return this.org$apache$spark$storage$StorageStatus$$RddStorageInfo$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StorageStatus$NonRddStorageInfo$ org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$lzycompute() {
        StorageStatus storageStatus2 = this;
        synchronized (storageStatus2) {
            if (this.org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$module != null) return this.org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$module;
            this.org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$module = new StorageStatus$NonRddStorageInfo$(this);
            return this.org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$module;
        }
    }

    public BlockManagerId blockManagerId() {
        return this.blockManagerId;
    }

    public long maxMemory() {
        return this.maxMemory;
    }

    public Option<Object> maxOnHeapMem() {
        return this.maxOnHeapMem;
    }

    public Option<Object> maxOffHeapMem() {
        return this.maxOffHeapMem;
    }

    private HashMap<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> _rddBlocks() {
        return this._rddBlocks;
    }

    private HashMap<BlockId, BlockStatus> _nonRddBlocks() {
        return this._nonRddBlocks;
    }

    public StorageStatus$RddStorageInfo$ org$apache$spark$storage$StorageStatus$$RddStorageInfo() {
        return this.org$apache$spark$storage$StorageStatus$$RddStorageInfo$module == null ? this.org$apache$spark$storage$StorageStatus$$RddStorageInfo$lzycompute() : this.org$apache$spark$storage$StorageStatus$$RddStorageInfo$module;
    }

    public HashMap<Object, RddStorageInfo> org$apache$spark$storage$StorageStatus$$_rddStorageInfo() {
        return this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo;
    }

    public StorageStatus$NonRddStorageInfo$ org$apache$spark$storage$StorageStatus$$NonRddStorageInfo() {
        return this.org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$module == null ? this.org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$lzycompute() : this.org$apache$spark$storage$StorageStatus$$NonRddStorageInfo$module;
    }

    public NonRddStorageInfo org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo() {
        return this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo;
    }

    public Map<BlockId, BlockStatus> blocks() {
        return this._nonRddBlocks().$plus$plus(this.rddBlocks());
    }

    public Map<BlockId, BlockStatus> rddBlocks() {
        return (Map)this._rddBlocks().flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Map<BlockId, BlockStatus> apply(Tuple2<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> x0$2) {
                Tuple2<Object, scala.collection.mutable.Map<BlockId, BlockStatus>> tuple2 = x0$2;
                if (tuple2 != null) {
                    scala.collection.mutable.Map blocks;
                    scala.collection.mutable.Map map2 = blocks = (scala.collection.mutable.Map)tuple2._2();
                    return map2;
                }
                throw new MatchError(tuple2);
            }
        }, HashMap$.MODULE$.canBuildFrom());
    }

    public void addBlock(BlockId blockId, BlockStatus blockStatus2) {
        this.updateStorageInfo(blockId, blockStatus2);
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            ((MapLike)this._rddBlocks().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rddId), (Function0)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final HashMap<BlockId, BlockStatus> apply() {
                    return new HashMap();
                }
            })).update((Object)blockId, (Object)blockStatus2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this._nonRddBlocks().update((Object)blockId, (Object)blockStatus2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<BlockStatus> getBlock(BlockId blockId) {
        Option option;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            option = this._rddBlocks().get((Object)BoxesRunTime.boxToInteger((int)rddId)).flatMap((Function1)new scala.Serializable(this, blockId){
                public static final long serialVersionUID = 0L;
                private final BlockId blockId$1;

                public final Option<BlockStatus> apply(scala.collection.mutable.Map<BlockId, BlockStatus> x$1) {
                    return x$1.get((Object)this.blockId$1);
                }
                {
                    this.blockId$1 = blockId$1;
                }
            });
        } else {
            option = this._nonRddBlocks().get((Object)blockId);
        }
        return option;
    }

    public long maxMem() {
        return this.maxMemory();
    }

    public long memRemaining() {
        return this.maxMem() - this.memUsed();
    }

    public long memUsed() {
        return BoxesRunTime.unboxToLong((Object)this.onHeapMemUsed().getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })) + BoxesRunTime.unboxToLong((Object)this.offHeapMemUsed().getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public Option<Object> onHeapMemRemaining() {
        return this.maxOnHeapMem().flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final Option<Object> apply(long m) {
                return this.$outer.onHeapMemUsed().map((Function1)new scala.Serializable(this, m){
                    public static final long serialVersionUID = 0L;
                    private final long m$1;

                    public final long apply(long o) {
                        return this.apply$mcJJ$sp(o);
                    }

                    public long apply$mcJJ$sp(long o) {
                        return this.m$1 - o;
                    }
                    {
                        this.m$1 = m$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> offHeapMemRemaining() {
        return this.maxOffHeapMem().flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final Option<Object> apply(long m) {
                return this.$outer.offHeapMemUsed().map((Function1)new scala.Serializable(this, m){
                    public static final long serialVersionUID = 0L;
                    private final long m$2;

                    public final long apply(long o) {
                        return this.apply$mcJJ$sp(o);
                    }

                    public long apply$mcJJ$sp(long o) {
                        return this.m$2 - o;
                    }
                    {
                        this.m$2 = m$2;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> onHeapMemUsed() {
        return this.onHeapCacheSize().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(long x$2) {
                return this.apply$mcJJ$sp(x$2);
            }

            public long apply$mcJJ$sp(long x$2) {
                return x$2 + this.$outer.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().onHeapUsage();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> offHeapMemUsed() {
        return this.offHeapCacheSize().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(long x$3) {
                return this.apply$mcJJ$sp(x$3);
            }

            public long apply$mcJJ$sp(long x$3) {
                return x$3 + this.$outer.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().offHeapUsage();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> onHeapCacheSize() {
        return this.maxOnHeapMem().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(long x$4) {
                return this.apply$mcJJ$sp(x$4);
            }

            public long apply$mcJJ$sp(long x$4) {
                return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.$outer.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().collect((PartialFunction)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Tuple2<Object, RddStorageInfo>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        RddStorageInfo storageInfo;
                        A1 A1 = x1;
                        Object object = A1 != null && !(storageInfo = (RddStorageInfo)A1._2()).level().useOffHeap() ? BoxesRunTime.boxToLong((long)storageInfo.memoryUsage()) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<Object, RddStorageInfo> x1) {
                        RddStorageInfo storageInfo;
                        Tuple2<Object, RddStorageInfo> tuple2 = x1;
                        boolean bl = tuple2 != null && !(storageInfo = (RddStorageInfo)tuple2._2()).level().useOffHeap();
                        return bl;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Object> offHeapCacheSize() {
        return this.maxOffHeapMem().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(long x$5) {
                return this.apply$mcJJ$sp(x$5);
            }

            public long apply$mcJJ$sp(long x$5) {
                return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.$outer.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().collect((PartialFunction)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Tuple2<Object, RddStorageInfo>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        RddStorageInfo storageInfo;
                        A1 A1 = x2;
                        Object object = A1 != null && (storageInfo = (RddStorageInfo)A1._2()).level().useOffHeap() ? BoxesRunTime.boxToLong((long)storageInfo.memoryUsage()) : function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<Object, RddStorageInfo> x2) {
                        RddStorageInfo storageInfo;
                        Tuple2<Object, RddStorageInfo> tuple2 = x2;
                        boolean bl = tuple2 != null && (storageInfo = (RddStorageInfo)tuple2._2()).level().useOffHeap();
                        return bl;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public long diskUsed() {
        return this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().diskUsage() + BoxesRunTime.unboxToLong((Object)((TraversableOnce)this._rddBlocks().keys().toSeq().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final long apply(int rddId) {
                return this.apply$mcJI$sp(rddId);
            }

            public long apply$mcJI$sp(int rddId) {
                return this.$outer.diskUsedByRdd(rddId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long diskUsedByRdd(int rddId) {
        return BoxesRunTime.unboxToLong((Object)this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(RddStorageInfo x$6) {
                return x$6.diskUsage();
            }
        }).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateStorageInfo(BlockId blockId, BlockStatus newBlockStatus) {
        Tuple2.mcJJ.sp sp2;
        Tuple2.mcJJ.sp sp3;
        BlockStatus oldBlockStatus = (BlockStatus)this.getBlock(blockId).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BlockStatus apply() {
                return BlockStatus$.MODULE$.empty();
            }
        });
        long changeInMem = newBlockStatus.memSize() - oldBlockStatus.memSize();
        long changeInDisk = newBlockStatus.diskSize() - oldBlockStatus.diskSize();
        StorageLevel level = newBlockStatus.storageLevel();
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            int rddId = rDDBlockId.rddId();
            sp3 = (Tuple2)this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().get((Object)BoxesRunTime.boxToInteger((int)rddId)).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(RddStorageInfo x0$3) {
                    RddStorageInfo rddStorageInfo = x0$3;
                    if (rddStorageInfo != null) {
                        long mem = rddStorageInfo.memoryUsage();
                        long disk = rddStorageInfo.diskUsage();
                        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(mem, disk);
                        return sp2;
                    }
                    throw new MatchError((Object)rddStorageInfo);
                }
            }).getOrElse((Function0)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply() {
                    return new Tuple2.mcJJ.sp(0L, 0L);
                }
            });
        } else if (level.useOffHeap()) {
            if (!level.useOffHeap()) throw new MatchError((Object)blockId2);
            sp3 = new Tuple2.mcJJ.sp(this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().offHeapUsage(), this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().diskUsage());
        } else {
            sp3 = new Tuple2.mcJJ.sp(this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().onHeapUsage(), this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().diskUsage());
        }
        Tuple2.mcJJ.sp sp4 = sp3;
        if (sp4 == null) throw new MatchError((Object)sp4);
        long oldMem = sp4._1$mcJ$sp();
        long oldDisk = sp4._2$mcJ$sp();
        Tuple2.mcJJ.sp sp5 = sp2 = new Tuple2.mcJJ.sp(oldMem, oldDisk);
        long oldMem2 = sp5._1$mcJ$sp();
        long oldDisk2 = sp5._2$mcJ$sp();
        long newMem = package$.MODULE$.max(oldMem2 + changeInMem, 0L);
        long newDisk = package$.MODULE$.max(oldDisk2 + changeInDisk, 0L);
        BlockId blockId3 = blockId;
        if (blockId3 instanceof RDDBlockId) {
            BoxedUnit boxedUnit;
            RDDBlockId rDDBlockId = (RDDBlockId)blockId3;
            int rddId = rDDBlockId.rddId();
            if (newMem + newDisk == 0L) {
                this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().remove((Object)BoxesRunTime.boxToInteger((int)rddId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo().update((Object)BoxesRunTime.boxToInteger((int)rddId), (Object)this.org$apache$spark$storage$StorageStatus$$RddStorageInfo().apply(newMem, newDisk, level));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        } else {
            if (level.useOffHeap()) {
                this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().offHeapUsage_$eq(newMem);
            } else {
                this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().onHeapUsage_$eq(newMem);
            }
            this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo().diskUsage_$eq(newDisk);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public StorageStatus(BlockManagerId blockManagerId, long maxMemory, Option<Object> maxOnHeapMem, Option<Object> maxOffHeapMem) {
        this.blockManagerId = blockManagerId;
        this.maxMemory = maxMemory;
        this.maxOnHeapMem = maxOnHeapMem;
        this.maxOffHeapMem = maxOffHeapMem;
        this._rddBlocks = new HashMap();
        this._nonRddBlocks = new HashMap();
        this.org$apache$spark$storage$StorageStatus$$_rddStorageInfo = new HashMap();
        this.org$apache$spark$storage$StorageStatus$$_nonRddStorageInfo = this.org$apache$spark$storage$StorageStatus$$NonRddStorageInfo().apply(0L, 0L, 0L);
    }

    public StorageStatus(BlockManagerId bmid, long maxMemory, Option<Object> maxOnHeapMem, Option<Object> maxOffHeapMem, Map<BlockId, BlockStatus> initialBlocks) {
        this(bmid, maxMemory, maxOnHeapMem, maxOffHeapMem);
        initialBlocks.foreach((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StorageStatus $outer;

            public final void apply(Tuple2<BlockId, BlockStatus> x0$1) {
                Tuple2<BlockId, BlockStatus> tuple2 = x0$1;
                if (tuple2 != null) {
                    BlockId bid = (BlockId)tuple2._1();
                    BlockStatus bstatus = (BlockStatus)tuple2._2();
                    this.$outer.addBlock(bid, bstatus);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class RddStorageInfo
    implements Product,
    scala.Serializable {
        private final long memoryUsage;
        private final long diskUsage;
        private final StorageLevel level;
        public final /* synthetic */ StorageStatus $outer;

        public long memoryUsage() {
            return this.memoryUsage;
        }

        public long diskUsage() {
            return this.diskUsage;
        }

        public StorageLevel level() {
            return this.level;
        }

        public RddStorageInfo copy(long memoryUsage, long diskUsage, StorageLevel level) {
            return new RddStorageInfo(this.org$apache$spark$storage$StorageStatus$RddStorageInfo$$$outer(), memoryUsage, diskUsage, level);
        }

        public long copy$default$1() {
            return this.memoryUsage();
        }

        public long copy$default$2() {
            return this.diskUsage();
        }

        public StorageLevel copy$default$3() {
            return this.level();
        }

        public String productPrefix() {
            return "RddStorageInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Serializable serializable;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    serializable = this.level();
                    break;
                }
                case 1: {
                    serializable = BoxesRunTime.boxToLong((long)this.diskUsage());
                    break;
                }
                case 0: {
                    serializable = BoxesRunTime.boxToLong((long)this.memoryUsage());
                }
            }
            return serializable;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RddStorageInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.memoryUsage()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.diskUsage()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.level()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RddStorageInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            RddStorageInfo rddStorageInfo = (RddStorageInfo)x$1;
            if (this.memoryUsage() != rddStorageInfo.memoryUsage()) return false;
            if (this.diskUsage() != rddStorageInfo.diskUsage()) return false;
            StorageLevel storageLevel = this.level();
            StorageLevel storageLevel2 = rddStorageInfo.level();
            if (storageLevel == null) {
                if (storageLevel2 != null) {
                    return false;
                }
            } else if (!((Object)storageLevel).equals(storageLevel2)) return false;
            if (!rddStorageInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ StorageStatus org$apache$spark$storage$StorageStatus$RddStorageInfo$$$outer() {
            return this.$outer;
        }

        public RddStorageInfo(StorageStatus $outer, long memoryUsage, long diskUsage, StorageLevel level) {
            this.memoryUsage = memoryUsage;
            this.diskUsage = diskUsage;
            this.level = level;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }

    public class NonRddStorageInfo
    implements Product,
    scala.Serializable {
        private long onHeapUsage;
        private long offHeapUsage;
        private long diskUsage;
        public final /* synthetic */ StorageStatus $outer;

        public long onHeapUsage() {
            return this.onHeapUsage;
        }

        public void onHeapUsage_$eq(long x$1) {
            this.onHeapUsage = x$1;
        }

        public long offHeapUsage() {
            return this.offHeapUsage;
        }

        public void offHeapUsage_$eq(long x$1) {
            this.offHeapUsage = x$1;
        }

        public long diskUsage() {
            return this.diskUsage;
        }

        public void diskUsage_$eq(long x$1) {
            this.diskUsage = x$1;
        }

        public NonRddStorageInfo copy(long onHeapUsage, long offHeapUsage, long diskUsage) {
            return new NonRddStorageInfo(this.org$apache$spark$storage$StorageStatus$NonRddStorageInfo$$$outer(), onHeapUsage, offHeapUsage, diskUsage);
        }

        public long copy$default$1() {
            return this.onHeapUsage();
        }

        public long copy$default$2() {
            return this.offHeapUsage();
        }

        public long copy$default$3() {
            return this.diskUsage();
        }

        public String productPrefix() {
            return "NonRddStorageInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Long l;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    l = BoxesRunTime.boxToLong((long)this.diskUsage());
                    break;
                }
                case 1: {
                    l = BoxesRunTime.boxToLong((long)this.offHeapUsage());
                    break;
                }
                case 0: {
                    l = BoxesRunTime.boxToLong((long)this.onHeapUsage());
                }
            }
            return l;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NonRddStorageInfo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.onHeapUsage()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.offHeapUsage()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.diskUsage()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NonRddStorageInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            NonRddStorageInfo nonRddStorageInfo = (NonRddStorageInfo)x$1;
            if (this.onHeapUsage() != nonRddStorageInfo.onHeapUsage()) return false;
            if (this.offHeapUsage() != nonRddStorageInfo.offHeapUsage()) return false;
            if (this.diskUsage() != nonRddStorageInfo.diskUsage()) return false;
            if (!nonRddStorageInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ StorageStatus org$apache$spark$storage$StorageStatus$NonRddStorageInfo$$$outer() {
            return this.$outer;
        }

        public NonRddStorageInfo(StorageStatus $outer, long onHeapUsage, long offHeapUsage, long diskUsage) {
            this.onHeapUsage = onHeapUsage;
            this.offHeapUsage = offHeapUsage;
            this.diskUsage = diskUsage;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

