/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.spark.SparkConf;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.ReadableChannelFileRegion;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.spark_project.guava.io.Closeables;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ListBuffer;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0001\t)\u0011!#\u00128def\u0004H/\u001a3CY>\u001c7\u000eR1uC*\u00111\u0001B\u0001\bgR|'/Y4f\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7c\u0001\u0001\f#A\u0011AbD\u0007\u0002\u001b)\ta\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0011\u001b\t1\u0011I\\=SK\u001a\u0004\"AE\n\u000e\u0003\tI!\u0001\u0006\u0002\u0003\u0013\tcwnY6ECR\f\u0007\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\t\u0019LG.Z\u0002\u0001!\tIb$D\u0001\u001b\u0015\tYB$\u0001\u0002j_*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u00111\u0015\u000e\\3\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\n\u0011B\u00197pG.\u001c\u0016N_3\u0011\u00051\u0019\u0013B\u0001\u0013\u000e\u0005\u0011auN\\4\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001d\nAaY8oMB\u0011\u0001&K\u0007\u0002\t%\u0011!\u0006\u0002\u0002\n'B\f'o[\"p]\u001aD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0004W\u0016L\bc\u0001\u0007/a%\u0011q&\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0019EJ!AM\u0007\u0003\t\tKH/\u001a\u0005\u0006i\u0001!\t!N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bY:\u0004(\u000f\u001e\u0011\u0005I\u0001\u0001\"\u0002\f4\u0001\u0004A\u0002\"B\u00114\u0001\u0004\u0011\u0003\"\u0002\u00144\u0001\u00049\u0003\"\u0002\u00174\u0001\u0004i\u0003\"\u0002\u001f\u0001\t\u0003j\u0014!\u0004;p\u0013:\u0004X\u000f^*ue\u0016\fW\u000eF\u0001?!\tIr(\u0003\u0002A5\tY\u0011J\u001c9viN#(/Z1n\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0003\u001d!xNT3uif$\u0012\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fr\tA\u0001\\1oO&\u0011\u0011J\u0012\u0002\u0007\u001f\nTWm\u0019;\t\u000b-\u0003A\u0011\t'\u0002'Q|7\t[;oW\u0016$')\u001f;f\u0005V4g-\u001a:\u0015\u00055#\u0006C\u0001(S\u001b\u0005y%BA\u000eQ\u0015\t\tF!\u0001\u0003vi&d\u0017BA*P\u0005E\u0019\u0005.\u001e8lK\u0012\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006+*\u0003\rAV\u0001\nC2dwnY1u_J\u0004B\u0001D,Z9&\u0011\u0001,\u0004\u0002\n\rVt7\r^5p]F\u0002\"\u0001\u0004.\n\u0005mk!aA%oiB\u0011Q\fY\u0007\u0002=*\u0011q\fH\u0001\u0004]&|\u0017BA1_\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006G\u0002!\t\u0005Z\u0001\ri>\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u000b\u00029\")a\r\u0001C!O\u0006!1/\u001b>f+\u0005\u0011\u0003\"B5\u0001\t\u0003R\u0017a\u00023jgB|7/\u001a\u000b\u0002WB\u0011A\u0002\\\u0005\u0003[6\u0011A!\u00168ji\")q\u000e\u0001C\u0005a\u0006!q\u000e]3o)\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;_\u0003!\u0019\u0007.\u00198oK2\u001c\u0018B\u0001<t\u0005M\u0011V-\u00193bE2,')\u001f;f\u0007\"\fgN\\3m\u0001")
public class EncryptedBlockData
implements BlockData {
    private final File file;
    private final long blockSize;
    private final SparkConf conf;
    private final byte[] key;

    @Override
    public InputStream toInputStream() {
        return Channels.newInputStream(this.open());
    }

    @Override
    public Object toNetty() {
        return new ReadableChannelFileRegion(this.open(), this.blockSize);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ChunkedByteBuffer toChunkedByteBuffer(Function1<Object, ByteBuffer> allocator) {
        ChunkedByteBuffer chunkedByteBuffer;
        ReadableByteChannel source = this.open();
        try {
            long chunkSize;
            ListBuffer chunks = new ListBuffer();
            for (long remaining = this.blockSize; remaining > 0L; remaining -= chunkSize) {
                chunkSize = package$.MODULE$.min(remaining, (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH);
                ByteBuffer chunk = (ByteBuffer)allocator.apply((Object)BoxesRunTime.boxToInteger((int)((int)chunkSize)));
                JavaUtils.readFully((ReadableByteChannel)source, (ByteBuffer)chunk);
                chunk.flip();
                chunks.$plus$eq((Object)chunk);
            }
            chunkedByteBuffer = new ChunkedByteBuffer((ByteBuffer[])chunks.toArray(ClassTag$.MODULE$.apply(ByteBuffer.class)));
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        source.close();
        return chunkedByteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer;
        Predef$.MODULE$.assert(this.blockSize <= (long)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Block is too large to be wrapped in a byte buffer.";
            }
        });
        ByteBuffer dst = ByteBuffer.allocate((int)this.blockSize);
        ReadableByteChannel in = this.open();
        try {
            JavaUtils.readFully((ReadableByteChannel)in, (ByteBuffer)dst);
            dst.flip();
            byteBuffer = dst;
        }
        catch (Throwable throwable) {
            void var2_2;
            Closeables.close((Closeable)var2_2, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)in, (boolean)true);
        return byteBuffer;
    }

    @Override
    public long size() {
        return this.blockSize;
    }

    @Override
    public void dispose() {
    }

    private ReadableByteChannel open() {
        FileChannel channel = new FileInputStream(this.file).getChannel();
        try {
            return CryptoStreamUtils$.MODULE$.createReadableChannel(channel, this.conf, this.key);
        }
        catch (Exception exception2) {
            Closeables.close((Closeable)channel, (boolean)true);
            throw exception2;
        }
    }

    public EncryptedBlockData(File file, long blockSize, SparkConf conf, byte[] key) {
        this.file = file;
        this.blockSize = blockSize;
        this.conf = conf;
        this.key = key;
    }
}

