/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import java.io.OutputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.status.api.v1.AbstractApplicationResource$;
import org.apache.spark.status.api.v1.ApiRequestContext$class;
import org.apache.spark.status.api.v1.ApplicationEnvironmentInfo;
import org.apache.spark.status.api.v1.BadParameterException;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.BaseAppResource$class;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.OneApplicationAttemptResource;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.status.api.v1.ServiceUnavailable;
import org.apache.spark.status.api.v1.StagesResource;
import org.apache.spark.status.api.v1.ThreadStackTrace;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.ui.SparkUI;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005mf!B\u0001\u0003\u0001\tq!aG!cgR\u0014\u0018m\u0019;BaBd\u0017nY1uS>t'+Z:pkJ\u001cWM\u0003\u0002\u0004\t\u0005\u0011a/\r\u0006\u0003\u000b\u0019\t1!\u00199j\u0015\t9\u0001\"\u0001\u0004ti\u0006$Xo\u001d\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\t1r#D\u0001\u0003\u0013\tA\"AA\bCCN,\u0017\t\u001d9SKN|WO]2f\u0011\u0015Q\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u000f\u0011\u0005Y\u0001\u0001\"B\u0010\u0001\t\u0003\u0001\u0013\u0001\u00036pENd\u0015n\u001d;\u0015\u0005\u0005\u0002\u0004c\u0001\u0012+[9\u00111\u0005\u000b\b\u0003I\u001dj\u0011!\n\u0006\u0003Mm\ta\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u0005%\n\u0012a\u00029bG.\fw-Z\u0005\u0003W1\u00121aU3r\u0015\tI\u0013\u0003\u0005\u0002\u0017]%\u0011qF\u0001\u0002\b\u0015>\u0014G)\u0019;b\u0011\u0015\td\u00041\u00013\u0003!\u0019H/\u0019;vg\u0016\u001c\bcA\u001a9u5\tAG\u0003\u00026m\u0005!Q\u000f^5m\u0015\u00059\u0014\u0001\u00026bm\u0006L!!\u000f\u001b\u0003\t1K7\u000f\u001e\t\u0003wqj\u0011\u0001C\u0005\u0003{!\u0011!CS8c\u000bb,7-\u001e;j_:\u001cF/\u0019;vg\"\"\u0001gP%K!\t\u0001u)D\u0001B\u0015\t\u00115)\u0001\u0002sg*\u0011A)R\u0001\u0003oNT\u0011AR\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0011\u0006\u0013!\"U;fef\u0004\u0016M]1n\u0003\u00151\u0018\r\\;fC\u00059\u0001\u0006\u0002\u0010M\u0013>\u0003\"\u0001Q'\n\u00059\u000b%\u0001\u0002)bi\"\f\u0013\u0001U\u0001\u0005U>\u00147\u000f\u000b\u0002\u001f%B\u0011\u0001iU\u0005\u0003)\u0006\u00131aR#U\u0011\u00151\u0006\u0001\"\u0001X\u0003\u0019yg.\u001a&pER\u0011Q\u0006\u0017\u0005\u00063V\u0003\rAW\u0001\u0006U>\u0014\u0017\n\u001a\t\u0003!mK!\u0001X\t\u0003\u0007%sG\u000f\u000b\u0003Y=&\u000b\u0007C\u0001!`\u0013\t\u0001\u0017IA\u0005QCRD\u0007+\u0019:b[\u0006\n\u0011\f\u000b\u0003V\u0019&\u001b\u0017%\u00013\u0002#)|'m]\u0018|U>\u0014\u0017\n\u001a\u001e!9\u0012\\S\u0010\u000b\u0002V%\")q\r\u0001C\u0001Q\u0006aQ\r_3dkR|'\u000fT5tiR\t\u0011\u000eE\u0002#U)\u0004\"AF6\n\u00051\u0014!aD#yK\u000e,Ho\u001c:Tk6l\u0017M]=)\t\u0019d\u0015J\\\u0011\u0002_\u0006IQ\r_3dkR|'o\u001d\u0015\u0003MJCQA\u001d\u0001\u0005\u0002M\f!\u0002\u001e5sK\u0006$G)^7q)\t!(\u0010E\u0002\u0011k^L!A^\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005YA\u0018BA=\u0003\u0005A!\u0006N]3bIN#\u0018mY6Ue\u0006\u001cW\rC\u0003|c\u0002\u0007A0\u0001\u0004fq\u0016\u001c\u0017\n\u001a\t\u0004{\u0006\u0005aB\u0001\t\u007f\u0013\ty\u0018#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fFASA\u001f0J\u0003\u0013\t#!a\u0003\u0002\u0015\u0015DXmY;u_JLE\rK\u0003r\u0019&\u000by!\t\u0002\u0002\u0012\u0005qR\r_3dkR|'o]\u0018|Kb,7-\u001e;pe&#Wp\f;ie\u0016\fGm\u001d\u0015\u0003cJCa!a\u0006\u0001\t\u0003A\u0017aD1mY\u0016CXmY;u_Jd\u0015n\u001d;)\r\u0005UA*SA\u000eC\t\ti\"\u0001\u0007bY2,\u00070Z2vi>\u00148\u000fK\u0002\u0002\u0016ICq!a\t\u0001\t\u0003\t)#\u0001\u0004ti\u0006<Wm\u001d\u000b\u0003\u0003O\u0001R!`A\u0015\u0003[IA!a\u000b\u0002\u0006\t)1\t\\1tgB\u0019a#a\f\n\u0007\u0005E\"A\u0001\bTi\u0006<Wm\u001d*fg>,(oY3)\r\u0005\u0005B*SA\u001bC\t\t\u0019\u0003C\u0004\u0002:\u0001!\t!a\u000f\u0002\u000fI$G\rT5tiR\u0011\u0011Q\b\t\u0005E)\ny\u0004E\u0002\u0017\u0003\u0003J1!a\u0011\u0003\u00059\u0011F\tR*u_J\fw-Z%oM>Dc!a\u000eM\u0013\u0006\u001d\u0013EAA%\u0003-\u0019Ho\u001c:bO\u0016|#\u000f\u001a3)\u0007\u0005]\"\u000bC\u0004\u0002P\u0001!\t!!\u0015\u0002\u000fI$G\rR1uCR!\u0011qHA*\u0011\u001d\t)&!\u0014A\u0002i\u000bQA\u001d3e\u0013\u0012Dc!a\u0015_\u0013\u0006e\u0013EAA+Q\u0019\ti\u0005T%\u0002^\u0005\u0012\u0011qL\u0001\u0019gR|'/Y4f_I$GmL>sI\u0012LEM\u000f\u0011]I.j\bfAA'%\"9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014aD3om&\u0014xN\\7f]RLeNZ8\u0015\u0005\u0005%\u0004c\u0001\f\u0002l%\u0019\u0011Q\u000e\u0002\u00035\u0005\u0003\b\u000f\\5dCRLwN\\#om&\u0014xN\\7f]RLeNZ8)\r\u0005\rD*SA9C\t\t\u0019(A\u0006f]ZL'o\u001c8nK:$\bfAA2%\"9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0014\u0001D4fi\u00163XM\u001c;M_\u001e\u001cHCAA?!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAAB\u0003\u0006!1m\u001c:f\u0013\u0011\t9)!!\u0003\u0011I+7\u000f]8og\u0016Ds!a\u001e\u0002\f&\u000b\t\nE\u0002A\u0003\u001bK1!a$B\u0005!\u0001&o\u001c3vG\u0016\u001cHFAAJC\t\t)*\u0001\rbaBd\u0017nY1uS>twf\\2uKRl3\u000f\u001e:fC6Dc!a\u001eM\u0013\u0006e\u0015EAAN\u0003\u0011awnZ:)\u0007\u0005]$\u000bC\u0004\u0002\"\u0002!\t!a)\u0002%\u0005\u0004\b\u000f\\5dCRLwN\\!ui\u0016l\u0007\u000f\u001e\u000b\u0003\u0003K\u0003R!`A\u0015\u0003O\u00032AFAU\u0013\r\tYK\u0001\u0002\u001e\u001f:,\u0017\t\u001d9mS\u000e\fG/[8o\u0003R$X-\u001c9u%\u0016\u001cx.\u001e:dK\"2\u0011q\u0014'J\u0003_\u000b#!!-\u0002\u0017m\fG\u000f^3naRLE- \u0015\u0007\u0001\u0005-\u0015*!.-\u0005\u0005]\u0016EAA]\u0003A\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80UN|g\u000e")
public class AbstractApplicationResource
implements BaseAppResource {
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public String appId() {
        return this.appId;
    }

    @Override
    @TraitSetter
    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    @Override
    public String attemptId() {
        return this.attemptId;
    }

    @Override
    @TraitSetter
    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    @Override
    public <T> T withUI(Function1<SparkUI, T> fn2) {
        return (T)BaseAppResource$class.withUI(this, fn2);
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    @TraitSetter
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    @TraitSetter
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext$class.uiRoot(this);
    }

    @GET
    @Path(value="jobs")
    public Seq<JobData> jobsList(@QueryParam(value="status") List<JobExecutionStatus> statuses) {
        return (Seq)this.withUI((Function1)new Serializable(this, statuses){
            public static final long serialVersionUID = 0L;
            private final List statuses$1;

            public final Seq<JobData> apply(SparkUI x$1) {
                return x$1.store().jobsList(this.statuses$1);
            }
            {
                this.statuses$1 = statuses$1;
            }
        });
    }

    @GET
    @Path(value="jobs/{jobId: \\d+}")
    public JobData oneJob(@PathParam(value="jobId") int jobId) {
        return (JobData)this.withUI((Function1)new Serializable(this, jobId){
            public static final long serialVersionUID = 0L;
            private final int jobId$1;

            public final JobData apply(SparkUI ui) {
                try {
                    return ui.store().job(this.jobId$1);
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new NotFoundException(new StringBuilder().append((Object)"unknown job: ").append((Object)BoxesRunTime.boxToInteger((int)this.jobId$1)).toString());
                }
            }
            {
                this.jobId$1 = jobId$1;
            }
        });
    }

    @GET
    @Path(value="executors")
    public Seq<ExecutorSummary> executorList() {
        return (Seq)this.withUI((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<ExecutorSummary> apply(SparkUI x$2) {
                return x$2.store().executorList(true);
            }
        });
    }

    @GET
    @Path(value="executors/{executorId}/threads")
    public ThreadStackTrace[] threadDump(@PathParam(value="executorId") String execId) {
        return (ThreadStackTrace[])this.withUI((Function1)new Serializable(this, execId){
            public static final long serialVersionUID = 0L;
            public final String execId$1;

            public final ThreadStackTrace[] apply(SparkUI ui) {
                String string = this.execId$1;
                String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                if (!(string == null ? string2 != null : !string.equals(string2)) || new StringOps(Predef$.MODULE$.augmentString(this.execId$1)).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$1) {
                        return Character.isDigit(x$1);
                    }
                })) {
                    SparkContext safeSparkContext = (SparkContext)ui.sc().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Nothing$ apply() {
                            throw new ServiceUnavailable("Thread dumps not available through the history server.");
                        }
                    });
                    boolean bl = false;
                    Some some = null;
                    Option<T> option = ui.store().asOption(new Serializable(this, ui){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$threadDump$1 $outer;
                        private final SparkUI ui$1;

                        public final ExecutorSummary apply() {
                            return this.ui$1.store().executorSummary(this.$outer.execId$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.ui$1 = ui$1;
                        }
                    });
                    if (option instanceof Some) {
                        bl = true;
                        some = (Some)option;
                        ExecutorSummary executorSummary2 = (ExecutorSummary)some.x();
                        if (executorSummary2.isActive()) {
                            ThreadStackTrace[] safeThreadDump;
                            ThreadStackTrace[] threadStackTraceArray = safeThreadDump = (ThreadStackTrace[])safeSparkContext.getExecutorThreadDump(this.execId$1).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Nothing$ apply() {
                                    throw new NotFoundException("No thread dump is available.");
                                }
                            });
                            return threadStackTraceArray;
                        }
                    }
                    if (bl) {
                        throw new BadParameterException("Executor is not active.");
                    }
                    throw new NotFoundException("Executor does not exist.");
                }
                throw new BadParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid executorId: neither '", "' nor number."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkContext$.MODULE$.DRIVER_IDENTIFIER()})));
            }
            {
                this.execId$1 = execId$1;
            }
        });
    }

    @GET
    @Path(value="allexecutors")
    public Seq<ExecutorSummary> allExecutorList() {
        return (Seq)this.withUI((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<ExecutorSummary> apply(SparkUI x$3) {
                return x$3.store().executorList(false);
            }
        });
    }

    @Path(value="stages")
    public Class<StagesResource> stages() {
        return StagesResource.class;
    }

    @GET
    @Path(value="storage/rdd")
    public Seq<RDDStorageInfo> rddList() {
        return (Seq)this.withUI((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<RDDStorageInfo> apply(SparkUI x$4) {
                return x$4.store().rddList(x$4.store().rddList$default$1());
            }
        });
    }

    @GET
    @Path(value="storage/rdd/{rddId: \\d+}")
    public RDDStorageInfo rddData(@PathParam(value="rddId") int rddId) {
        return (RDDStorageInfo)this.withUI((Function1)new Serializable(this, rddId){
            public static final long serialVersionUID = 0L;
            private final int rddId$1;

            public final RDDStorageInfo apply(SparkUI ui) {
                try {
                    return ui.store().rdd(this.rddId$1);
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no rdd found w/ id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.rddId$1)})));
                }
            }
            {
                this.rddId$1 = rddId$1;
            }
        });
    }

    @GET
    @Path(value="environment")
    public ApplicationEnvironmentInfo environmentInfo() {
        return (ApplicationEnvironmentInfo)this.withUI((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ApplicationEnvironmentInfo apply(SparkUI x$5) {
                return x$5.store().environmentInfo();
            }
        });
    }

    @GET
    @Path(value="logs")
    @Produces(value={"application/octet-stream"})
    public Response getEventLogs() {
        Throwable throwable2;
        block5: {
            Object object;
            try {
                object = this.withUI((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(SparkUI x$6) {
                    }
                });
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof NotFoundException) || this.attemptId() != null) break block5;
                this.attemptId_$eq("1");
                this.withUI((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(SparkUI x$7) {
                    }
                });
                this.attemptId_$eq(null);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                object = BoxedUnit.UNIT;
            }
            try {
                String fileName = this.attemptId() == null ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"eventLogs-", ".zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appId()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"eventLogs-", "-", ".zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appId(), this.attemptId()}));
                StreamingOutput stream = new StreamingOutput(this){
                    private final /* synthetic */ AbstractApplicationResource $outer;

                    /*
                     * WARNING - void declaration
                     */
                    public void write(OutputStream output) {
                        ZipOutputStream zipStream = new ZipOutputStream(output);
                        try {
                            this.$outer.uiRoot().writeEventLogs(this.$outer.appId(), (Option<String>)Option$.MODULE$.apply((Object)this.$outer.attemptId()), zipStream);
                        }
                        catch (Throwable throwable) {
                            void var2_2;
                            var2_2.close();
                            throw throwable;
                        }
                        zipStream.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                return Response.ok((Object)stream).header("Content-Disposition", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"attachment; filename=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName}))).header("Content-Type", (Object)"application/octet-stream").build();
            }
            catch (Throwable throwable4) {
                Throwable throwable5 = throwable4;
                Option option = NonFatal$.MODULE$.unapply(throwable5);
                if (option.isEmpty()) {
                    throw throwable4;
                }
                throw new ServiceUnavailable(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Event logs are not available for app: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appId()})));
            }
        }
        throw throwable2;
    }

    @Path(value="{attemptId}")
    public Class<OneApplicationAttemptResource> applicationAttempt() {
        if (this.attemptId() == null) {
            return OneApplicationAttemptResource.class;
        }
        throw new NotFoundException(this.httpRequest().getRequestURI());
    }

    public AbstractApplicationResource() {
        ApiRequestContext$class.$init$(this);
        BaseAppResource$class.$init$(this);
    }
}

