/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DateTimeUtils$ {
    public static final DateTimeUtils$ MODULE$;
    private final int JULIAN_DAY_OF_EPOCH;
    private final long SECONDS_PER_DAY;
    private final long MICROS_PER_MILLIS;
    private final long MICROS_PER_SECOND;
    private final long MILLIS_PER_SECOND;
    private final long NANOS_PER_SECOND;
    private final long MICROS_PER_DAY;
    private final long NANOS_PER_MICROS;
    private final long MILLIS_PER_DAY;
    private final int daysIn400Years;
    private final int to2001;
    private final int YearZero;
    private final int toYearZero;
    private final TimeZone TimeZoneGMT;
    private final TimeZone TimeZoneUTC;
    private final Set<Object> MonthOf31Days;
    private final String TIMEZONE_OPTION;
    private final ThreadLocal<Calendar> threadLocalGmtCalendar;
    private final ThreadLocal<DateFormat> threadLocalTimestampFormat;
    private final ThreadLocal<DateFormat> threadLocalDateFormat;
    private final ConcurrentHashMap<String, TimeZone> computedTimeZones;
    private final Object computeTimeZone;
    private final int[] monthDays;
    private final int SUNDAY;
    private final int MONDAY;
    private final int TUESDAY;
    private final int WEDNESDAY;
    private final int THURSDAY;
    private final int FRIDAY;
    private final int SATURDAY;
    private final int TRUNC_TO_YEAR;
    private final int TRUNC_TO_MONTH;
    private final int TRUNC_TO_QUARTER;
    private final int TRUNC_TO_WEEK;
    private final int TRUNC_TO_DAY;
    private final int TRUNC_TO_HOUR;
    private final int TRUNC_TO_MINUTE;
    private final int TRUNC_TO_SECOND;
    private final int TRUNC_INVALID;

    static {
        new DateTimeUtils$();
    }

    public final int JULIAN_DAY_OF_EPOCH() {
        return 2440588;
    }

    public final long SECONDS_PER_DAY() {
        return 86400L;
    }

    public final long MICROS_PER_MILLIS() {
        return 1000L;
    }

    public final long MICROS_PER_SECOND() {
        return 1000000L;
    }

    public final long MILLIS_PER_SECOND() {
        return 1000L;
    }

    public final long NANOS_PER_SECOND() {
        return 1000000000L;
    }

    public final long MICROS_PER_DAY() {
        return 86400000000L;
    }

    public final long NANOS_PER_MICROS() {
        return 1000L;
    }

    public final long MILLIS_PER_DAY() {
        return 86400000L;
    }

    public final int daysIn400Years() {
        return this.daysIn400Years;
    }

    public final int to2001() {
        return -11323;
    }

    public final int YearZero() {
        return -17999;
    }

    public final int toYearZero() {
        return 7293527;
    }

    public final TimeZone TimeZoneGMT() {
        return this.TimeZoneGMT;
    }

    public final TimeZone TimeZoneUTC() {
        return this.TimeZoneUTC;
    }

    public final Set<Object> MonthOf31Days() {
        return this.MonthOf31Days;
    }

    public String TIMEZONE_OPTION() {
        return this.TIMEZONE_OPTION;
    }

    public TimeZone defaultTimeZone() {
        return TimeZone.getDefault();
    }

    private ThreadLocal<Calendar> threadLocalGmtCalendar() {
        return this.threadLocalGmtCalendar;
    }

    private ThreadLocal<DateFormat> threadLocalTimestampFormat() {
        return this.threadLocalTimestampFormat;
    }

    /*
     * WARNING - void declaration
     */
    public DateFormat getThreadLocalTimestampFormat(TimeZone timeZone) {
        void var2_2;
        DateFormat sdf = this.threadLocalTimestampFormat().get();
        sdf.setTimeZone(timeZone);
        return var2_2;
    }

    private ThreadLocal<DateFormat> threadLocalDateFormat() {
        return this.threadLocalDateFormat;
    }

    /*
     * WARNING - void declaration
     */
    public DateFormat getThreadLocalDateFormat(TimeZone timeZone) {
        void var2_2;
        DateFormat sdf = this.threadLocalDateFormat().get();
        sdf.setTimeZone(timeZone);
        return var2_2;
    }

    private ConcurrentHashMap<String, TimeZone> computedTimeZones() {
        return this.computedTimeZones;
    }

    private Object computeTimeZone() {
        return this.computeTimeZone;
    }

    public TimeZone getTimeZone(String timeZoneId) {
        return this.computedTimeZones().computeIfAbsent(timeZoneId, (Function<String, TimeZone>)this.computeTimeZone());
    }

    /*
     * WARNING - void declaration
     */
    public DateFormat newDateFormat(String formatString, TimeZone timeZone) {
        void var3_3;
        SimpleDateFormat sdf = new SimpleDateFormat(formatString, Locale.US);
        sdf.setTimeZone(timeZone);
        sdf.setLenient(false);
        return var3_3;
    }

    public int millisToDays(long millisUtc) {
        return this.millisToDays(millisUtc, this.defaultTimeZone());
    }

    public int millisToDays(long millisUtc, TimeZone timeZone) {
        long millisLocal = millisUtc + (long)timeZone.getOffset(millisUtc);
        return (int)Math.floor((double)millisLocal / (double)86400000L);
    }

    public long daysToMillis(int days) {
        return this.daysToMillis(days, this.defaultTimeZone());
    }

    public long daysToMillis(int days, TimeZone timeZone) {
        long millisLocal = (long)days * 86400000L;
        return millisLocal - this.getOffsetFromLocalMillis(millisLocal, timeZone);
    }

    public String dateToString(int days) {
        return this.getThreadLocalDateFormat(this.defaultTimeZone()).format(this.toJavaDate(days));
    }

    public String dateToString(int days, TimeZone timeZone) {
        return this.getThreadLocalDateFormat(timeZone).format(this.toJavaDate(days));
    }

    public String timestampToString(long us) {
        return this.timestampToString(us, this.defaultTimeZone());
    }

    /*
     * Enabled aggressive block sorting
     */
    public String timestampToString(long us, TimeZone timeZone) {
        String string;
        Timestamp ts = this.toJavaTimestamp(us);
        String timestampString = ts.toString();
        DateFormat timestampFormat = this.getThreadLocalTimestampFormat(timeZone);
        String formatted = timestampFormat.format(ts);
        if (timestampString.length() > 19) {
            String string2 = timestampString.substring(19);
            String string3 = ".0";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                string = new StringBuilder().append((Object)formatted).append((Object)timestampString.substring(19)).toString();
                return string;
            }
        }
        string = formatted;
        return string;
    }

    public java.util.Date stringToTime(String s) {
        int indexOfGMT;
        while ((indexOfGMT = s.indexOf("GMT")) != -1) {
            String s0 = s.substring(0, indexOfGMT);
            String s1 = s.substring(indexOfGMT + 3);
            s = new StringBuilder().append((Object)s0).append((Object)s1).toString();
        }
        return new StringOps(Predef$.MODULE$.augmentString(s)).contains((Object)BoxesRunTime.boxToCharacter((char)'T')) ? DatatypeConverter.parseDateTime((String)s).getTime() : (new StringOps(Predef$.MODULE$.augmentString(s)).contains((Object)BoxesRunTime.boxToCharacter((char)' ')) ? Timestamp.valueOf(s) : Date.valueOf(s));
    }

    public int fromJavaDate(Date date) {
        return this.millisToDays(date.getTime());
    }

    public Date toJavaDate(int daysSinceEpoch) {
        return new Date(this.daysToMillis(daysSinceEpoch));
    }

    public Timestamp toJavaTimestamp(long us) {
        long seconds = us / 1000000L;
        long micros = us % 1000000L;
        if (micros < 0L) {
            micros += 1000000L;
            --seconds;
        }
        Timestamp t = new Timestamp(seconds * 1000L);
        t.setNanos((int)micros * 1000);
        return t;
    }

    public long fromJavaTimestamp(Timestamp t) {
        return t == null ? 0L : t.getTime() * 1000L + (long)t.getNanos() / 1000L % 1000L;
    }

    public long fromJulianDay(int day, long nanoseconds) {
        long seconds = (long)(day - 2440588) * 86400L;
        return seconds * 1000000L + nanoseconds / 1000L;
    }

    public Tuple2<Object, Object> toJulianDay(long us) {
        long julian_us = us + 210866803200000000L;
        long day = julian_us / 86400000000L;
        long micros = julian_us % 86400000000L;
        return new Tuple2.mcIJ.sp((int)day, micros * 1000L);
    }

    public long toMillis(long us) {
        return (long)Math.floor((double)us / (double)1000L);
    }

    public long fromMillis(long millis) {
        return millis * 1000L;
    }

    public Option<Object> stringToTimestamp(UTF8String s) {
        return this.stringToTimestamp(s, this.defaultTimeZone());
    }

    public Option<Object> stringToTimestamp(UTF8String s, TimeZone timeZone) {
        Calendar calendar;
        int j;
        if (s == null) {
            return None$.MODULE$;
        }
        None$ tz = None$.MODULE$;
        int[] segments = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Int());
        int i = 0;
        int currentSegmentValue = 0;
        byte[] bytes = s.getBytes();
        int digitsMilli = 0;
        boolean justTime = false;
        for (j = 0; j < bytes.length; ++j) {
            int parsedValue;
            block25: {
                byte b;
                block26: {
                    block30: {
                        block28: {
                            block29: {
                                block27: {
                                    b = bytes[j];
                                    parsedValue = b - (byte)48;
                                    if (parsedValue >= 0 && parsedValue <= 9) break block25;
                                    if (j == 0 && b == 84) {
                                        justTime = true;
                                        i += 3;
                                        continue;
                                    }
                                    if (i < 2) {
                                        if (b == 45) {
                                            if (i == 0 && j != 4) {
                                                return None$.MODULE$;
                                            }
                                            segments[i] = currentSegmentValue;
                                            currentSegmentValue = 0;
                                            ++i;
                                            continue;
                                        }
                                        if (i == 0 && b == 58) {
                                            justTime = true;
                                            segments[3] = currentSegmentValue;
                                            currentSegmentValue = 0;
                                            i = 4;
                                            continue;
                                        }
                                        return None$.MODULE$;
                                    }
                                    if (i == 2) {
                                        if (b == 32 || b == 84) {
                                            segments[i] = currentSegmentValue;
                                            currentSegmentValue = 0;
                                            ++i;
                                            continue;
                                        }
                                        return None$.MODULE$;
                                    }
                                    if (i == 3 || i == 4) {
                                        if (b == 58) {
                                            segments[i] = currentSegmentValue;
                                            currentSegmentValue = 0;
                                            ++i;
                                            continue;
                                        }
                                        return None$.MODULE$;
                                    }
                                    if (i != 5 && i != 6) break block26;
                                    if (b != 90) break block27;
                                    segments[i] = currentSegmentValue;
                                    currentSegmentValue = 0;
                                    ++i;
                                    tz = new Some((Object)BoxesRunTime.boxToByte((byte)43));
                                    break block28;
                                }
                                if (b != 45 && b != 43) break block29;
                                segments[i] = currentSegmentValue;
                                currentSegmentValue = 0;
                                ++i;
                                tz = new Some((Object)BoxesRunTime.boxToByte((byte)b));
                                break block28;
                            }
                            if (b != 46 || i != 5) break block30;
                            segments[i] = currentSegmentValue;
                            currentSegmentValue = 0;
                            ++i;
                        }
                        if (i != 6 || b == 46) continue;
                        ++i;
                        continue;
                    }
                    return None$.MODULE$;
                }
                if (i < segments.length && (b == 58 || b == 32)) {
                    segments[i] = currentSegmentValue;
                    currentSegmentValue = 0;
                    ++i;
                    continue;
                }
                return None$.MODULE$;
            }
            if (i == 6) {
                ++digitsMilli;
            }
            currentSegmentValue = currentSegmentValue * 10 + parsedValue;
        }
        segments[i] = currentSegmentValue;
        if (!justTime && i == 0 && j != 4) {
            return None$.MODULE$;
        }
        while (digitsMilli < 6) {
            segments[6] = segments[6] * 10;
            ++digitsMilli;
        }
        while (digitsMilli > 6) {
            segments[6] = segments[6] / 10;
            --digitsMilli;
        }
        if (!justTime && this.isInvalidDate(segments[0], segments[1], segments[2])) {
            return None$.MODULE$;
        }
        if (segments[3] < 0 || segments[3] > 23 || segments[4] < 0 || segments[4] > 59 || segments[5] < 0 || segments[5] > 59 || segments[6] < 0 || segments[6] > 999999 || segments[7] < 0 || segments[7] > 23 || segments[8] < 0 || segments[8] > 59) {
            return None$.MODULE$;
        }
        if (tz.isEmpty()) {
            calendar = Calendar.getInstance(timeZone);
        } else {
            Character arg$macro$5 = BoxesRunTime.boxToCharacter((char)((char)BoxesRunTime.unboxToByte((Object)tz.get())));
            int arg$macro$6 = segments[7];
            int arg$macro$7 = segments[8];
            calendar = Calendar.getInstance(this.getTimeZone(new StringOps("GMT%s%02d:%02d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$5, BoxesRunTime.boxToInteger((int)arg$macro$6), BoxesRunTime.boxToInteger((int)arg$macro$7)}))));
        }
        Calendar c = calendar;
        c.set(14, 0);
        if (justTime) {
            c.set(11, segments[3]);
            c.set(12, segments[4]);
            c.set(13, segments[5]);
        } else {
            c.set(segments[0], segments[1] - 1, segments[2], segments[3], segments[4], segments[5]);
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L + (long)segments[6])));
    }

    public long instantToMicros(Instant instant) {
        long sec = Math.multiplyExact(instant.getEpochSecond(), 1000000L);
        long result = Math.addExact(sec, (long)instant.getNano() / 1000L);
        return result;
    }

    public int instantToDays(Instant instant) {
        long seconds = instant.getEpochSecond();
        long days = Math.floorDiv(seconds, 86400L);
        return (int)days;
    }

    public Option<Object> stringToDate(UTF8String s) {
        int j;
        if (s == null) {
            return None$.MODULE$;
        }
        int[] segments = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1}), ClassTag$.MODULE$.Int());
        int i = 0;
        int currentSegmentValue = 0;
        byte[] bytes = s.getBytes();
        for (j = 0; j < bytes.length && i < 3 && bytes[j] != 32 && bytes[j] != 84; ++j) {
            byte b = bytes[j];
            if (i < 2 && b == 45) {
                if (i == 0 && j != 4) {
                    return None$.MODULE$;
                }
                segments[i] = currentSegmentValue;
                currentSegmentValue = 0;
                ++i;
                continue;
            }
            int parsedValue = b - (byte)48;
            if (parsedValue < 0 || parsedValue > 9) {
                return None$.MODULE$;
            }
            currentSegmentValue = currentSegmentValue * 10 + parsedValue;
        }
        if (i == 0 && j != 4) {
            return None$.MODULE$;
        }
        if (i < 2 && j < bytes.length) {
            return None$.MODULE$;
        }
        segments[i] = currentSegmentValue;
        if (this.isInvalidDate(segments[0], segments[1], segments[2])) {
            return None$.MODULE$;
        }
        Calendar c = this.threadLocalGmtCalendar().get();
        c.clear();
        c.set(segments[0], segments[1] - 1, segments[2], 0, 0, 0);
        c.set(14, 0);
        return new Some((Object)BoxesRunTime.boxToInteger((int)((int)(c.getTimeInMillis() / 86400000L))));
    }

    private boolean isInvalidDate(int year, int month, int day) {
        if (year < 0 || year > 9999 || month < 1 || month > 12 || day < 1 || day > 31) {
            return true;
        }
        if (month == 2) {
            if (this.isLeapYear(year) && day > 29) {
                return true;
            }
            if (!this.isLeapYear(year) && day > 28) {
                return true;
            }
        } else if (!this.MonthOf31Days().contains((Object)BoxesRunTime.boxToInteger((int)month)) && day > 30) {
            return true;
        }
        return false;
    }

    private long absoluteMicroSecond(long microsec) {
        return microsec + 630160732800000000L;
    }

    private long localTimestamp(long microsec) {
        return this.localTimestamp(microsec, this.defaultTimeZone());
    }

    private long localTimestamp(long microsec, TimeZone timeZone) {
        return this.absoluteMicroSecond(microsec) + (long)timeZone.getOffset(microsec / 1000L) * 1000L;
    }

    public int getHours(long microsec) {
        return (int)(this.localTimestamp(microsec) / 1000000L / 3600L % 24L);
    }

    public int getHours(long microsec, TimeZone timeZone) {
        return (int)(this.localTimestamp(microsec, timeZone) / 1000000L / 3600L % 24L);
    }

    public int getMinutes(long microsec) {
        return (int)(this.localTimestamp(microsec) / 1000000L / 60L % 60L);
    }

    public int getMinutes(long microsec, TimeZone timeZone) {
        return (int)(this.localTimestamp(microsec, timeZone) / 1000000L / 60L % 60L);
    }

    public int getSeconds(long microsec) {
        return (int)(this.localTimestamp(microsec) / 1000000L % 60L);
    }

    public int getSeconds(long microsec, TimeZone timeZone) {
        return (int)(this.localTimestamp(microsec, timeZone) / 1000000L % 60L);
    }

    private boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private int yearBoundary(int year) {
        return year * 365 + (year / 4 - year / 100 + year / 400);
    }

    private Tuple2<Object, Object> numYears(int days) {
        int year = days / 365;
        int boundary = this.yearBoundary(year);
        return days > boundary ? new Tuple2.mcII.sp(year, days - boundary) : new Tuple2.mcII.sp(year - 1, days - this.yearBoundary(year - 1));
    }

    private Tuple2<Object, Object> getYearAndDayInYear(int daysSince1970) {
        int daysSince1970Tmp = daysSince1970;
        if (daysSince1970 <= -141428) {
            daysSince1970Tmp -= 10;
        }
        int daysNormalized = daysSince1970Tmp + 7293527;
        int numOfQuarterCenturies = daysNormalized / this.daysIn400Years();
        int daysInThis400 = daysNormalized % this.daysIn400Years() + 1;
        Tuple2<Object, Object> tuple2 = this.numYears(daysInThis400);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int years = tuple2._1$mcI$sp();
            int dayInYear = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(years, dayInYear);
            int years2 = sp3._1$mcI$sp();
            int dayInYear2 = sp3._2$mcI$sp();
            int year = -17999 + 400 * numOfQuarterCenturies + years2;
            return new Tuple2.mcII.sp(year, dayInYear2);
        }
        throw new MatchError(tuple2);
    }

    public int getDayInYear(int date) {
        return this.getYearAndDayInYear(date)._2$mcI$sp();
    }

    public int getYear(int date) {
        return this.getYearAndDayInYear(date)._1$mcI$sp();
    }

    public int getQuarter(int date) {
        Tuple2<Object, Object> tuple2 = this.getYearAndDayInYear(date);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int year = tuple2._1$mcI$sp();
            int dayInYear = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(year, dayInYear);
            int year2 = sp3._1$mcI$sp();
            int dayInYear2 = sp3._2$mcI$sp();
            if (this.isLeapYear(year2)) {
                --dayInYear2;
            }
            return dayInYear2 <= 90 ? 1 : (dayInYear2 <= 181 ? 2 : (dayInYear2 <= 273 ? 3 : 4));
        }
        throw new MatchError(tuple2);
    }

    public Tuple4<Object, Object, Object, Object> splitDate(int date) {
        Tuple2<Object, Object> tuple2 = this.getYearAndDayInYear(date);
        if (tuple2 != null) {
            Tuple4 tuple4;
            Tuple2.mcII.sp sp2;
            int year = tuple2._1$mcI$sp();
            int dayInYear = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(year, dayInYear);
            int year2 = sp3._1$mcI$sp();
            int dayInYear2 = sp3._2$mcI$sp();
            boolean isLeap = this.isLeapYear(year2);
            if (isLeap && dayInYear2 == 60) {
                tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)29), (Object)BoxesRunTime.boxToInteger((int)0));
            } else {
                if (isLeap && dayInYear2 > 60) {
                    --dayInYear2;
                }
                tuple4 = dayInYear2 <= 181 ? (dayInYear2 <= 31 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)dayInYear2), (Object)BoxesRunTime.boxToInteger((int)(31 - dayInYear2))) : (dayInYear2 <= 59 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 31)), (Object)(isLeap ? BoxesRunTime.boxToInteger((int)(60 - dayInYear2)) : BoxesRunTime.boxToInteger((int)(59 - dayInYear2)))) : (dayInYear2 <= 90 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 59)), (Object)BoxesRunTime.boxToInteger((int)(90 - dayInYear2))) : (dayInYear2 <= 120 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 90)), (Object)BoxesRunTime.boxToInteger((int)(120 - dayInYear2))) : (dayInYear2 <= 151 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 120)), (Object)BoxesRunTime.boxToInteger((int)(151 - dayInYear2))) : new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 151)), (Object)BoxesRunTime.boxToInteger((int)(181 - dayInYear2)))))))) : (dayInYear2 <= 212 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 181)), (Object)BoxesRunTime.boxToInteger((int)(212 - dayInYear2))) : (dayInYear2 <= 243 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 212)), (Object)BoxesRunTime.boxToInteger((int)(243 - dayInYear2))) : (dayInYear2 <= 273 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)9), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 243)), (Object)BoxesRunTime.boxToInteger((int)(273 - dayInYear2))) : (dayInYear2 <= 304 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 273)), (Object)BoxesRunTime.boxToInteger((int)(304 - dayInYear2))) : (dayInYear2 <= 334 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)11), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 304)), (Object)BoxesRunTime.boxToInteger((int)(334 - dayInYear2))) : new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 334)), (Object)BoxesRunTime.boxToInteger((int)(365 - dayInYear2))))))));
            }
            return tuple4;
        }
        throw new MatchError(tuple2);
    }

    public int getMonth(int date) {
        Tuple2<Object, Object> tuple2 = this.getYearAndDayInYear(date);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int year = tuple2._1$mcI$sp();
            int dayInYear = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(year, dayInYear);
            int year2 = sp3._1$mcI$sp();
            int dayInYear2 = sp3._2$mcI$sp();
            if (this.isLeapYear(year2)) {
                if (dayInYear2 == 60) {
                    return 2;
                }
                if (dayInYear2 > 60) {
                    --dayInYear2;
                }
            }
            return dayInYear2 <= 31 ? 1 : (dayInYear2 <= 59 ? 2 : (dayInYear2 <= 90 ? 3 : (dayInYear2 <= 120 ? 4 : (dayInYear2 <= 151 ? 5 : (dayInYear2 <= 181 ? 6 : (dayInYear2 <= 212 ? 7 : (dayInYear2 <= 243 ? 8 : (dayInYear2 <= 273 ? 9 : (dayInYear2 <= 304 ? 10 : (dayInYear2 <= 334 ? 11 : 12))))))))));
        }
        throw new MatchError(tuple2);
    }

    public int getDayOfMonth(int date) {
        Tuple2<Object, Object> tuple2 = this.getYearAndDayInYear(date);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int year = tuple2._1$mcI$sp();
            int dayInYear = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(year, dayInYear);
            int year2 = sp3._1$mcI$sp();
            int dayInYear2 = sp3._2$mcI$sp();
            if (this.isLeapYear(year2)) {
                if (dayInYear2 == 60) {
                    return 29;
                }
                if (dayInYear2 > 60) {
                    --dayInYear2;
                }
            }
            return dayInYear2 <= 31 ? dayInYear2 : (dayInYear2 <= 59 ? dayInYear2 - 31 : (dayInYear2 <= 90 ? dayInYear2 - 59 : (dayInYear2 <= 120 ? dayInYear2 - 90 : (dayInYear2 <= 151 ? dayInYear2 - 120 : (dayInYear2 <= 181 ? dayInYear2 - 151 : (dayInYear2 <= 212 ? dayInYear2 - 181 : (dayInYear2 <= 243 ? dayInYear2 - 212 : (dayInYear2 <= 273 ? dayInYear2 - 243 : (dayInYear2 <= 304 ? dayInYear2 - 273 : (dayInYear2 <= 334 ? dayInYear2 - 304 : dayInYear2 - 334))))))))));
        }
        throw new MatchError(tuple2);
    }

    private int[] monthDays() {
        return this.monthDays;
    }

    private int firstDayOfMonth(int absoluteMonth) {
        int absoluteYear = absoluteMonth / 12;
        int monthInYear = absoluteMonth - absoluteYear * 12;
        int date = this.getDateFromYear(absoluteYear);
        if (monthInYear >= 2 && this.isLeapYear(absoluteYear + -17999)) {
            ++date;
        }
        while (monthInYear > 0) {
            date += this.monthDays()[monthInYear - 1];
            --monthInYear;
        }
        return date;
    }

    private int getDateFromYear(int absoluteYear) {
        int absoluteDays = absoluteYear * 365 + absoluteYear / 400 - absoluteYear / 100 + absoluteYear / 4;
        return absoluteDays - 7293527;
    }

    public int dateAddMonths(int days, int months) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.splitDate(days);
        if (tuple4 != null) {
            Tuple4 tuple42;
            int year = BoxesRunTime.unboxToInt((Object)tuple4._1());
            int monthInYear = BoxesRunTime.unboxToInt((Object)tuple4._2());
            int dayOfMonth = BoxesRunTime.unboxToInt((Object)tuple4._3());
            int daysToMonthEnd = BoxesRunTime.unboxToInt((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year), (Object)BoxesRunTime.boxToInteger((int)monthInYear), (Object)BoxesRunTime.boxToInteger((int)dayOfMonth), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd));
            int year2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
            int monthInYear2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
            int dayOfMonth2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
            int daysToMonthEnd2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
            int absoluteMonth = (year2 - -17999) * 12 + monthInYear2 - 1 + months;
            int nonNegativeMonth = absoluteMonth >= 0 ? absoluteMonth : 0;
            int currentMonthInYear = nonNegativeMonth % 12;
            int currentYear = nonNegativeMonth / 12;
            int leapDay = currentMonthInYear == 1 && this.isLeapYear(currentYear + -17999) ? 1 : 0;
            int lastDayOfMonth = this.monthDays()[currentMonthInYear] + leapDay;
            int currentDayInMonth = daysToMonthEnd2 == 0 || dayOfMonth2 >= lastDayOfMonth ? lastDayOfMonth : dayOfMonth2;
            return this.firstDayOfMonth(nonNegativeMonth) + currentDayInMonth - 1;
        }
        throw new MatchError(tuple4);
    }

    public long timestampAddInterval(long start, int months, long microseconds) {
        return this.timestampAddInterval(start, months, microseconds, this.defaultTimeZone());
    }

    public long timestampAddInterval(long start, int months, long microseconds, TimeZone timeZone) {
        int days = this.millisToDays(start / 1000L, timeZone);
        int newDays = this.dateAddMonths(days, months);
        return start + this.daysToMillis(newDays, timeZone) * 1000L - this.daysToMillis(days, timeZone) * 1000L + microseconds;
    }

    public double monthsBetween(long time1, long time2, boolean roundOff, TimeZone timeZone) {
        long millis1 = time1 / 1000L;
        long millis2 = time2 / 1000L;
        int date1 = this.millisToDays(millis1, timeZone);
        int date2 = this.millisToDays(millis2, timeZone);
        Tuple4<Object, Object, Object, Object> tuple4 = this.splitDate(date1);
        if (tuple4 != null) {
            Tuple4 tuple42;
            int year1 = BoxesRunTime.unboxToInt((Object)tuple4._1());
            int monthInYear1 = BoxesRunTime.unboxToInt((Object)tuple4._2());
            int dayInMonth1 = BoxesRunTime.unboxToInt((Object)tuple4._3());
            int daysToMonthEnd1 = BoxesRunTime.unboxToInt((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year1), (Object)BoxesRunTime.boxToInteger((int)monthInYear1), (Object)BoxesRunTime.boxToInteger((int)dayInMonth1), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd1));
            int year12 = BoxesRunTime.unboxToInt((Object)tuple43._1());
            int monthInYear12 = BoxesRunTime.unboxToInt((Object)tuple43._2());
            int dayInMonth12 = BoxesRunTime.unboxToInt((Object)tuple43._3());
            int daysToMonthEnd12 = BoxesRunTime.unboxToInt((Object)tuple43._4());
            Tuple4<Object, Object, Object, Object> tuple44 = this.splitDate(date2);
            if (tuple44 != null) {
                Tuple4 tuple45;
                int year2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
                int monthInYear2 = BoxesRunTime.unboxToInt((Object)tuple44._2());
                int dayInMonth2 = BoxesRunTime.unboxToInt((Object)tuple44._3());
                int daysToMonthEnd2 = BoxesRunTime.unboxToInt((Object)tuple44._4());
                Tuple4 tuple46 = tuple45 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)monthInYear2), (Object)BoxesRunTime.boxToInteger((int)dayInMonth2), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd2));
                int year22 = BoxesRunTime.unboxToInt((Object)tuple46._1());
                int monthInYear22 = BoxesRunTime.unboxToInt((Object)tuple46._2());
                int dayInMonth22 = BoxesRunTime.unboxToInt((Object)tuple46._3());
                int daysToMonthEnd22 = BoxesRunTime.unboxToInt((Object)tuple46._4());
                int months1 = year12 * 12 + monthInYear12;
                int months2 = year22 * 12 + monthInYear22;
                double monthDiff = months1 - months2;
                if (dayInMonth12 == dayInMonth22 || daysToMonthEnd12 == 0 && daysToMonthEnd22 == 0) {
                    return monthDiff;
                }
                long secondsInDay1 = (millis1 - this.daysToMillis(date1, timeZone)) / 1000L;
                long secondsInDay2 = (millis2 - this.daysToMillis(date2, timeZone)) / 1000L;
                long secondsDiff = (long)(dayInMonth12 - dayInMonth22) * 86400L + secondsInDay1 - secondsInDay2;
                double diff = monthDiff + (double)secondsDiff / 2678400.0;
                return roundOff ? (double)package$.MODULE$.round(diff * 1.0E8) / 1.0E8 : diff;
            }
            throw new MatchError(tuple44);
        }
        throw new MatchError(tuple4);
    }

    private int SUNDAY() {
        return this.SUNDAY;
    }

    private int MONDAY() {
        return this.MONDAY;
    }

    private int TUESDAY() {
        return this.TUESDAY;
    }

    private int WEDNESDAY() {
        return this.WEDNESDAY;
    }

    private int THURSDAY() {
        return this.THURSDAY;
    }

    private int FRIDAY() {
        return this.FRIDAY;
    }

    private int SATURDAY() {
        return this.SATURDAY;
    }

    public int getDayOfWeekFromString(UTF8String string) {
        int n;
        String dowString = string.toString().toUpperCase(Locale.ROOT);
        String string2 = dowString;
        boolean bl = "SU".equals(string2) ? true : ("SUN".equals(string2) ? true : "SUNDAY".equals(string2));
        if (bl) {
            n = this.SUNDAY();
        } else {
            boolean bl2 = "MO".equals(string2) ? true : ("MON".equals(string2) ? true : "MONDAY".equals(string2));
            if (bl2) {
                n = this.MONDAY();
            } else {
                boolean bl3 = "TU".equals(string2) ? true : ("TUE".equals(string2) ? true : "TUESDAY".equals(string2));
                if (bl3) {
                    n = this.TUESDAY();
                } else {
                    boolean bl4 = "WE".equals(string2) ? true : ("WED".equals(string2) ? true : "WEDNESDAY".equals(string2));
                    if (bl4) {
                        n = this.WEDNESDAY();
                    } else {
                        boolean bl5 = "TH".equals(string2) ? true : ("THU".equals(string2) ? true : "THURSDAY".equals(string2));
                        if (bl5) {
                            n = this.THURSDAY();
                        } else {
                            boolean bl6 = "FR".equals(string2) ? true : ("FRI".equals(string2) ? true : "FRIDAY".equals(string2));
                            if (bl6) {
                                n = this.FRIDAY();
                            } else {
                                boolean bl7 = "SA".equals(string2) ? true : ("SAT".equals(string2) ? true : "SATURDAY".equals(string2));
                                n = bl7 ? this.SATURDAY() : -1;
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    public int getNextDateForDayOfWeek(int startDate, int dayOfWeek) {
        return startDate + 1 + ((dayOfWeek - 1 - startDate) % 7 + 7) % 7;
    }

    public int getLastDayOfMonth(int date) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.splitDate(date);
        if (tuple4 != null) {
            int daysToMonthEnd;
            int n;
            int daysToMonthEnd2 = n = (daysToMonthEnd = BoxesRunTime.unboxToInt((Object)tuple4._4()));
            return date + daysToMonthEnd2;
        }
        throw new MatchError(tuple4);
    }

    public int TRUNC_TO_YEAR() {
        return this.TRUNC_TO_YEAR;
    }

    public int TRUNC_TO_MONTH() {
        return this.TRUNC_TO_MONTH;
    }

    public int TRUNC_TO_QUARTER() {
        return this.TRUNC_TO_QUARTER;
    }

    public int TRUNC_TO_WEEK() {
        return this.TRUNC_TO_WEEK;
    }

    public int TRUNC_TO_DAY() {
        return this.TRUNC_TO_DAY;
    }

    public int TRUNC_TO_HOUR() {
        return this.TRUNC_TO_HOUR;
    }

    public int TRUNC_TO_MINUTE() {
        return this.TRUNC_TO_MINUTE;
    }

    public int TRUNC_TO_SECOND() {
        return this.TRUNC_TO_SECOND;
    }

    public int TRUNC_INVALID() {
        return this.TRUNC_INVALID;
    }

    public int truncDate(int d, int level) {
        block4: {
            int n;
            block3: {
                block2: {
                    if (level != this.TRUNC_TO_YEAR()) break block2;
                    n = d - this.getDayInYear(d) + 1;
                    break block3;
                }
                if (level != this.TRUNC_TO_MONTH()) break block4;
                n = d - this.getDayOfMonth(d) + 1;
            }
            return n;
        }
        throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid trunc level: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)level)})));
    }

    public long truncTimestamp(long t, int level, TimeZone timeZone) {
        block16: {
            long l;
            block9: {
                int n;
                int quarter;
                int n2;
                long millis;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block8: {
                                            millis = t / 1000L;
                                            n2 = level;
                                            if (this.TRUNC_TO_YEAR() != n2) break block8;
                                            int dDays = this.millisToDays(millis, timeZone);
                                            l = this.daysToMillis(this.truncDate(dDays, level), timeZone);
                                            break block9;
                                        }
                                        if (this.TRUNC_TO_MONTH() != n2) break block10;
                                        int dDays = this.millisToDays(millis, timeZone);
                                        l = this.daysToMillis(this.truncDate(dDays, level), timeZone);
                                        break block9;
                                    }
                                    if (this.TRUNC_TO_DAY() != n2) break block11;
                                    int offset = timeZone.getOffset(millis);
                                    l = (millis += (long)offset) - millis % 86400000L - (long)offset;
                                    break block9;
                                }
                                if (this.TRUNC_TO_HOUR() != n2) break block12;
                                int offset = timeZone.getOffset(millis);
                                l = (millis += (long)offset) - millis % 3600000L - (long)offset;
                                break block9;
                            }
                            if (this.TRUNC_TO_MINUTE() != n2) break block13;
                            l = millis - millis % 60000L;
                            break block9;
                        }
                        if (this.TRUNC_TO_SECOND() != n2) break block14;
                        l = millis - millis % 1000L;
                        break block9;
                    }
                    if (this.TRUNC_TO_WEEK() != n2) break block15;
                    int dDays = this.millisToDays(millis, timeZone);
                    int prevMonday = this.getNextDateForDayOfWeek(dDays - 7, this.MONDAY());
                    l = this.daysToMillis(prevMonday, timeZone);
                    break block9;
                }
                if (this.TRUNC_TO_QUARTER() != n2) break block16;
                int dDays = this.millisToDays(millis, timeZone);
                millis = this.daysToMillis(this.truncDate(dDays, this.TRUNC_TO_MONTH()), timeZone);
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(millis);
                int n3 = quarter = this.getQuarter(dDays);
                switch (n3) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n3));
                    }
                    case 4: {
                        n = 9;
                        break;
                    }
                    case 3: {
                        n = 6;
                        break;
                    }
                    case 2: {
                        n = 3;
                        break;
                    }
                    case 1: {
                        n = 0;
                    }
                }
                int month = n;
                cal.set(2, month);
                l = cal.getTimeInMillis();
            }
            long truncated = l;
            return truncated * 1000L;
        }
        throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid trunc level: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)level)})));
    }

    public long truncTimestamp(long d, int level) {
        return this.truncTimestamp(d, level, this.defaultTimeZone());
    }

    public int parseTruncLevel(UTF8String format2) {
        int n;
        if (format2 == null) {
            n = this.TRUNC_INVALID();
        } else {
            boolean bl;
            boolean bl2;
            String string = format2.toString().toUpperCase(Locale.ROOT);
            boolean bl3 = "YEAR".equals(string) ? true : ("YYYY".equals(string) ? true : "YY".equals(string));
            int n2 = bl3 ? this.TRUNC_TO_YEAR() : ((bl2 = "MON".equals(string) ? true : ("MONTH".equals(string) ? true : "MM".equals(string))) ? this.TRUNC_TO_MONTH() : ((bl = "DAY".equals(string) ? true : "DD".equals(string)) ? this.TRUNC_TO_DAY() : ("HOUR".equals(string) ? this.TRUNC_TO_HOUR() : ("MINUTE".equals(string) ? this.TRUNC_TO_MINUTE() : ("SECOND".equals(string) ? this.TRUNC_TO_SECOND() : ("WEEK".equals(string) ? this.TRUNC_TO_WEEK() : ("QUARTER".equals(string) ? this.TRUNC_TO_QUARTER() : this.TRUNC_INVALID())))))));
            n = n2;
        }
        return n;
    }

    public long getOffsetFromLocalMillis(long millisLocal, TimeZone tz) {
        int guess = tz.getRawOffset();
        int offset = tz.getOffset(millisLocal - (long)guess);
        if (offset != guess && (guess = tz.getOffset(millisLocal - (long)offset)) != offset) {
            int days = (int)Math.floor((double)millisLocal / (double)86400000L);
            int year = this.getYear(days);
            int month = this.getMonth(days);
            int day = this.getDayOfMonth(days);
            int millisOfDay = (int)(millisLocal % 86400000L);
            if (millisOfDay < 0) {
                millisOfDay += (int)86400000L;
            }
            int seconds = (int)((long)millisOfDay / 1000L);
            int hh = seconds / 3600;
            int mm = seconds / 60 % 60;
            int ss = seconds % 60;
            int ms = millisOfDay % 1000;
            Calendar calendar = Calendar.getInstance(tz);
            calendar.set(year, month - 1, day, hh, mm, ss);
            calendar.set(14, ms);
            guess = (int)(millisLocal - calendar.getTimeInMillis());
        }
        return guess;
    }

    public long convertTz(long ts, TimeZone fromZone, TimeZone toZone) {
        long l;
        long l2;
        TimeZone localZone = this.defaultTimeZone();
        String string = fromZone.getID();
        String string2 = localZone.getID();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            l2 = ts;
        } else {
            long localTs = ts + (long)localZone.getOffset(ts / 1000L) * 1000L;
            l2 = localTs - this.getOffsetFromLocalMillis(localTs / 1000L, fromZone) * 1000L;
        }
        long utcTs = l2;
        String string3 = toZone.getID();
        String string4 = localZone.getID();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            l = utcTs;
        } else {
            long localTs = utcTs + (long)toZone.getOffset(utcTs / 1000L) * 1000L;
            l = localTs - this.getOffsetFromLocalMillis(localTs / 1000L, localZone) * 1000L;
        }
        return l;
    }

    public long fromUTCTime(long time, String timeZone) {
        return this.convertTz(time, this.TimeZoneGMT(), this.getTimeZone(timeZone));
    }

    public long toUTCTime(long time, String timeZone) {
        return this.convertTz(time, this.getTimeZone(timeZone), this.TimeZoneGMT());
    }

    public void resetThreadLocals() {
        this.threadLocalGmtCalendar().remove();
        this.threadLocalTimestampFormat().remove();
        this.threadLocalDateFormat().remove();
    }

    private DateTimeUtils$() {
        MODULE$ = this;
        this.daysIn400Years = 146097;
        this.TimeZoneGMT = TimeZone.getTimeZone("GMT");
        this.TimeZoneUTC = TimeZone.getTimeZone("UTC");
        this.MonthOf31Days = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 8, 10, 12}));
        this.TIMEZONE_OPTION = "timeZone";
        this.threadLocalGmtCalendar = new ThreadLocal<Calendar>(){

            public Calendar initialValue() {
                return Calendar.getInstance(DateTimeUtils$.MODULE$.TimeZoneGMT());
            }
        };
        this.threadLocalTimestampFormat = new ThreadLocal<DateFormat>(){

            public SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            }
        };
        this.threadLocalDateFormat = new ThreadLocal<DateFormat>(){

            public SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            }
        };
        this.computedTimeZones = new ConcurrentHashMap();
        this.computeTimeZone = new Function<String, TimeZone>(){

            public TimeZone apply(String timeZoneId) {
                return TimeZone.getTimeZone(timeZoneId);
            }
        };
        this.monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        this.SUNDAY = 3;
        this.MONDAY = 4;
        this.TUESDAY = 5;
        this.WEDNESDAY = 6;
        this.THURSDAY = 0;
        this.FRIDAY = 1;
        this.SATURDAY = 2;
        this.TRUNC_TO_YEAR = 1;
        this.TRUNC_TO_MONTH = 2;
        this.TRUNC_TO_QUARTER = 3;
        this.TRUNC_TO_WEEK = 4;
        this.TRUNC_TO_DAY = 5;
        this.TRUNC_TO_HOUR = 6;
        this.TRUNC_TO_MINUTE = 7;
        this.TRUNC_TO_SECOND = 8;
        this.TRUNC_INVALID = -1;
    }
}

