/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.FetchPlan;
import javax.jdo.JDOException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jdo.JDOFetchPlan;
import org.datanucleus.api.jdo.NucleusJDOHelper;
import org.datanucleus.api.jdo.query.AbstractTypesafeQuery;
import org.datanucleus.api.jdo.query.BooleanExpressionImpl;
import org.datanucleus.api.jdo.query.ByteExpressionImpl;
import org.datanucleus.api.jdo.query.CharacterExpressionImpl;
import org.datanucleus.api.jdo.query.CollectionExpressionImpl;
import org.datanucleus.api.jdo.query.ComparableExpressionImpl;
import org.datanucleus.api.jdo.query.DateExpressionImpl;
import org.datanucleus.api.jdo.query.DateTimeExpressionImpl;
import org.datanucleus.api.jdo.query.EnumExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionType;
import org.datanucleus.api.jdo.query.JDOTypesafeSubquery;
import org.datanucleus.api.jdo.query.ListExpressionImpl;
import org.datanucleus.api.jdo.query.MapExpressionImpl;
import org.datanucleus.api.jdo.query.NumericExpressionImpl;
import org.datanucleus.api.jdo.query.ObjectExpressionImpl;
import org.datanucleus.api.jdo.query.OrderExpressionImpl;
import org.datanucleus.api.jdo.query.StringExpressionImpl;
import org.datanucleus.api.jdo.query.TimeExpressionImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.typesafe.BooleanExpression;
import org.datanucleus.query.typesafe.CharacterExpression;
import org.datanucleus.query.typesafe.CollectionExpression;
import org.datanucleus.query.typesafe.DateExpression;
import org.datanucleus.query.typesafe.DateTimeExpression;
import org.datanucleus.query.typesafe.ListExpression;
import org.datanucleus.query.typesafe.MapExpression;
import org.datanucleus.query.typesafe.NumericExpression;
import org.datanucleus.query.typesafe.OrderExpression;
import org.datanucleus.query.typesafe.PersistableExpression;
import org.datanucleus.query.typesafe.StringExpression;
import org.datanucleus.query.typesafe.TimeExpression;
import org.datanucleus.query.typesafe.TypesafeQuery;
import org.datanucleus.query.typesafe.TypesafeSubquery;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOTypesafeQuery<T>
extends AbstractTypesafeQuery<T>
implements TypesafeQuery<T> {
    FetchPlan fp;
    boolean ignoreCache = false;
    boolean subclasses = true;
    Class resultClass = null;
    boolean unique = false;
    protected Collection<T> candidates = null;
    protected ExpressionImpl rangeLowerExpr;
    protected ExpressionImpl rangeUpperExpr;
    protected Map<String, Object> extensions = null;
    protected Map<String, ExpressionImpl> parameterExprByName = null;
    protected Map<String, Object> parameterValuesByName = null;
    protected transient Set<JDOTypesafeSubquery> subqueries = null;
    protected transient Set<Query> internalQueries = null;
    String queryString = null;

    public JDOTypesafeQuery(PersistenceManager pm, Class<T> candidateClass) {
        super(pm, candidateClass, "this");
    }

    @Override
    public PersistableExpression candidate() {
        String candName = this.candidateCls.getName();
        int pos = candName.lastIndexOf(46);
        String qName = candName.substring(0, pos + 1) + JDOTypesafeQuery.getQueryClassNameForClassName(candName.substring(pos + 1));
        try {
            Class qClass = this.ec.getClassLoaderResolver().classForName(qName);
            Method method = qClass.getMethod("candidate", new Class[0]);
            Object candObj = method.invoke(null, (Object[])null);
            if (candObj == null || !(candObj instanceof PersistableExpression)) {
                throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
            }
            return (PersistableExpression)candObj;
        }
        catch (NoSuchMethodException nsfe) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
        }
        catch (InvocationTargetException ite) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
        }
        catch (IllegalAccessException iae) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
        }
    }

    @Override
    public org.datanucleus.query.typesafe.Expression parameter(String name, Class type) {
        this.discardCompiled();
        ExpressionImpl paramExpr = null;
        if (type == Boolean.class || type == Boolean.TYPE) {
            paramExpr = new BooleanExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (type == Byte.class || type == Byte.TYPE) {
            paramExpr = new ByteExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (type == Character.class || type == Character.TYPE) {
            paramExpr = new CharacterExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (type == Double.class || type == Double.TYPE) {
            paramExpr = new NumericExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (type == Float.class || type == Float.TYPE) {
            paramExpr = new NumericExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (type == Integer.class || type == Integer.TYPE) {
            paramExpr = new NumericExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (type == Long.class || type == Long.TYPE) {
            paramExpr = new NumericExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (type == Short.class || type == Short.TYPE) {
            paramExpr = new NumericExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (type == String.class) {
            paramExpr = new StringExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (Time.class.isAssignableFrom(type)) {
            paramExpr = new TimeExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (Date.class.isAssignableFrom(type)) {
            paramExpr = new DateExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (java.util.Date.class.isAssignableFrom(type)) {
            paramExpr = new DateTimeExpressionImpl(type, name, ExpressionType.PARAMETER);
        } else if (this.ec.getApiAdapter().isPersistable(type)) {
            String typeName = type.getName();
            int pos = typeName.lastIndexOf(46);
            String qName = typeName.substring(0, pos + 1) + JDOTypesafeQuery.getQueryClassNameForClassName(typeName.substring(pos + 1));
            try {
                Class qClass = this.ec.getClassLoaderResolver().classForName(qName);
                Constructor ctr = qClass.getConstructor(Class.class, String.class, ExpressionType.class);
                Object candObj = ctr.newInstance(new Object[]{type, name, ExpressionType.PARAMETER});
                paramExpr = (ExpressionImpl)candObj;
            }
            catch (NoSuchMethodException nsme) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for parameters");
            }
            catch (IllegalAccessException iae) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for parameters");
            }
            catch (InvocationTargetException ite) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for parameters");
            }
            catch (InstantiationException ie) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for parameters");
            }
        } else {
            paramExpr = new ObjectExpressionImpl(type, name, ExpressionType.PARAMETER);
        }
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public StringExpression stringParameter(String name) {
        StringExpressionImpl paramExpr = new StringExpressionImpl(String.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public CharacterExpression characterParameter(String name) {
        CharacterExpressionImpl paramExpr = new CharacterExpressionImpl(Character.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public NumericExpression<Long> longParameter(String name) {
        NumericExpressionImpl<Long> paramExpr = new NumericExpressionImpl<Long>((Class<Number>)Long.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public NumericExpression<Integer> integerParameter(String name) {
        NumericExpressionImpl<Integer> paramExpr = new NumericExpressionImpl<Integer>((Class<Number>)Integer.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public NumericExpression<Short> shortParameter(String name) {
        NumericExpressionImpl<Short> paramExpr = new NumericExpressionImpl<Short>((Class<Number>)Short.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public NumericExpression<Double> doubleParameter(String name) {
        NumericExpressionImpl<Double> paramExpr = new NumericExpressionImpl<Double>((Class<Number>)Double.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public NumericExpression<Float> floatParameter(String name) {
        NumericExpressionImpl<Float> paramExpr = new NumericExpressionImpl<Float>((Class<Number>)Float.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public DateExpression<Date> dateParameter(String name) {
        DateExpressionImpl paramExpr = new DateExpressionImpl((Class<java.util.Date>)Date.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public TimeExpression<Time> timeParameter(String name) {
        TimeExpressionImpl paramExpr = new TimeExpressionImpl((Class<java.util.Date>)Date.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public DateTimeExpression<java.util.Date> datetimeParameter(String name) {
        DateTimeExpressionImpl paramExpr = new DateTimeExpressionImpl(java.util.Date.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public CollectionExpression collectionParameter(String name) {
        CollectionExpressionImpl paramExpr = new CollectionExpressionImpl(Collection.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public MapExpression mapParameter(String name) {
        MapExpressionImpl paramExpr = new MapExpressionImpl(Map.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public ListExpression listParameter(String name) {
        ListExpressionImpl paramExpr = new ListExpressionImpl(List.class, name, ExpressionType.PARAMETER);
        if (this.parameterExprByName == null) {
            this.parameterExprByName = new HashMap<String, ExpressionImpl>();
        }
        this.parameterExprByName.put(name, paramExpr);
        return paramExpr;
    }

    @Override
    public org.datanucleus.query.typesafe.Expression variable(String name, Class type) {
        this.discardCompiled();
        org.datanucleus.query.typesafe.Expression<Boolean> varExpr = null;
        if (this.ec.getApiAdapter().isPersistable(type)) {
            String typeName = type.getName();
            int pos = typeName.lastIndexOf(46);
            String qName = typeName.substring(0, pos + 1) + JDOTypesafeQuery.getQueryClassNameForClassName(typeName.substring(pos + 1));
            try {
                Class qClass = this.ec.getClassLoaderResolver().classForName(qName);
                Constructor ctr = qClass.getConstructor(Class.class, String.class, ExpressionType.class);
                Object candObj = ctr.newInstance(new Object[]{type, name, ExpressionType.VARIABLE});
                varExpr = (org.datanucleus.query.typesafe.Expression)candObj;
            }
            catch (NoSuchMethodException nsme) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for variables");
            }
            catch (IllegalAccessException iae) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for variables");
            }
            catch (InvocationTargetException ite) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for variables");
            }
            catch (InstantiationException ie) {
                throw new JDOException("Class " + typeName + " has a Query class but has no constructor for variables");
            }
        } else {
            varExpr = type == Boolean.class || type == Boolean.TYPE ? new BooleanExpressionImpl(type, name, ExpressionType.VARIABLE) : (type == Byte.class || type == Byte.TYPE ? new ByteExpressionImpl(type, name, ExpressionType.VARIABLE) : (type == Character.class || type == Character.TYPE ? new CharacterExpressionImpl(type, name, ExpressionType.VARIABLE) : (type == Double.class || type == Double.TYPE ? new NumericExpressionImpl(type, name, ExpressionType.VARIABLE) : (type == Float.class || type == Float.TYPE ? new NumericExpressionImpl(type, name, ExpressionType.VARIABLE) : (type == Integer.class || type == Integer.TYPE ? new NumericExpressionImpl(type, name, ExpressionType.VARIABLE) : (type == Long.class || type == Long.TYPE ? new NumericExpressionImpl(type, name, ExpressionType.VARIABLE) : (type == Short.class || type == Short.TYPE ? new NumericExpressionImpl(type, name, ExpressionType.VARIABLE) : (type == String.class ? new StringExpressionImpl(type, name, ExpressionType.VARIABLE) : (Time.class.isAssignableFrom(type) ? new TimeExpressionImpl(type, name, ExpressionType.VARIABLE) : (Date.class.isAssignableFrom(type) ? new DateExpressionImpl(type, name, ExpressionType.VARIABLE) : (java.util.Date.class.isAssignableFrom(type) ? new DateTimeExpressionImpl(type, name, ExpressionType.VARIABLE) : new ObjectExpressionImpl(type, name, ExpressionType.VARIABLE))))))))))));
        }
        return varExpr;
    }

    @Override
    public TypesafeQuery<T> excludeSubclasses() {
        this.subclasses = false;
        return this;
    }

    @Override
    public TypesafeQuery<T> includeSubclasses() {
        this.subclasses = true;
        return this;
    }

    @Override
    public TypesafeQuery<T> filter(BooleanExpression expr) {
        this.discardCompiled();
        this.filter = (BooleanExpressionImpl)expr;
        return this;
    }

    @Override
    public TypesafeQuery<T> groupBy(org.datanucleus.query.typesafe.Expression ... exprs) {
        this.discardCompiled();
        if (exprs != null && exprs.length > 0) {
            this.grouping = new ArrayList();
            for (int i = 0; i < exprs.length; ++i) {
                this.grouping.add((ExpressionImpl)exprs[i]);
            }
        }
        return this;
    }

    @Override
    public TypesafeQuery<T> having(org.datanucleus.query.typesafe.Expression expr) {
        this.discardCompiled();
        this.having = (ExpressionImpl)expr;
        return this;
    }

    @Override
    public TypesafeQuery<T> orderBy(OrderExpression ... exprs) {
        this.discardCompiled();
        if (exprs != null && exprs.length > 0) {
            this.ordering = new ArrayList();
            for (int i = 0; i < exprs.length; ++i) {
                this.ordering.add((OrderExpressionImpl)exprs[i]);
            }
        }
        return this;
    }

    @Override
    public TypesafeQuery<T> range(long lowerIncl, long upperExcl) {
        this.discardCompiled();
        this.rangeLowerExpr = new NumericExpressionImpl((Expression)new Literal((Object)lowerIncl));
        this.rangeUpperExpr = new NumericExpressionImpl((Expression)new Literal((Object)upperExcl));
        return this;
    }

    @Override
    public TypesafeQuery<T> range(NumericExpression lowerInclExpr, NumericExpression upperExclExpr) {
        this.discardCompiled();
        this.rangeLowerExpr = (ExpressionImpl)((Object)lowerInclExpr);
        this.rangeUpperExpr = (ExpressionImpl)((Object)upperExclExpr);
        return this;
    }

    @Override
    public TypesafeQuery<T> range(org.datanucleus.query.typesafe.Expression paramLowerInclExpr, org.datanucleus.query.typesafe.Expression paramUpperExclExpr) {
        this.discardCompiled();
        if (!((ExpressionImpl)paramLowerInclExpr).isParameter()) {
            throw new JDOUserException("lower inclusive expression should be a parameter");
        }
        if (!((ExpressionImpl)paramUpperExclExpr).isParameter()) {
            throw new JDOUserException("upper exclusive expression should be a parameter");
        }
        this.rangeLowerExpr = (ExpressionImpl)paramLowerInclExpr;
        this.rangeUpperExpr = (ExpressionImpl)paramUpperExclExpr;
        return this;
    }

    @Override
    public <S> TypesafeSubquery<S> subquery(Class<S> candidateClass, String candidateAlias) {
        JDOTypesafeSubquery<S> subquery = new JDOTypesafeSubquery<S>(this.pm, candidateClass, candidateAlias, this);
        if (this.subqueries == null) {
            this.subqueries = new HashSet<JDOTypesafeSubquery>();
        }
        this.subqueries.add(subquery);
        return subquery;
    }

    @Override
    public TypesafeSubquery<T> subquery(String candidateAlias) {
        JDOTypesafeSubquery subquery = new JDOTypesafeSubquery(this.pm, this.candidateCls, candidateAlias, this);
        if (this.subqueries == null) {
            this.subqueries = new HashSet<JDOTypesafeSubquery>();
        }
        this.subqueries.add(subquery);
        return subquery;
    }

    @Override
    public TypesafeQuery<T> setParameter(org.datanucleus.query.typesafe.Expression paramExpr, Object value) {
        this.discardCompiled();
        ParameterExpression internalParamExpr = (ParameterExpression)((ExpressionImpl)paramExpr).getQueryExpression();
        if (this.parameterExprByName == null || this.parameterExprByName != null && !this.parameterExprByName.containsKey(internalParamExpr.getAlias())) {
            throw new JDOUserException("Parameter with name " + internalParamExpr.getAlias() + " doesnt exist for this query");
        }
        if (this.parameterValuesByName == null) {
            this.parameterValuesByName = new HashMap<String, Object>();
        }
        this.parameterValuesByName.put(internalParamExpr.getAlias(), value);
        return this;
    }

    @Override
    public TypesafeQuery<T> setParameter(String paramName, Object value) {
        this.discardCompiled();
        if (this.parameterExprByName == null || this.parameterExprByName != null && !this.parameterExprByName.containsKey(paramName)) {
            throw new JDOUserException("Parameter with name " + paramName + " doesnt exist for this query");
        }
        if (this.parameterValuesByName == null) {
            this.parameterValuesByName = new HashMap<String, Object>();
        }
        this.parameterValuesByName.put(paramName, value);
        return this;
    }

    @Override
    public TypesafeQuery<T> setCandidates(Collection<T> candidates) {
        this.candidates = candidates != null ? new ArrayList<T>(candidates) : null;
        return null;
    }

    @Override
    public <T> List<T> executeList() {
        if (this.result != null || this.resultDistinct != null || this.resultClass != null) {
            this.discardCompiled();
            this.result = null;
            this.resultClass = null;
            this.resultDistinct = null;
        }
        this.type = AbstractTypesafeQuery.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.unique = false;
        return (List)this.executeInternalQuery(this.getInternalQuery());
    }

    @Override
    public <T> T executeUnique() {
        if (this.result != null || this.resultDistinct != null || this.resultClass != null) {
            this.discardCompiled();
            this.result = null;
            this.resultClass = null;
            this.resultDistinct = null;
        }
        this.type = AbstractTypesafeQuery.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.unique = true;
        return (T)this.executeInternalQuery(this.getInternalQuery());
    }

    @Override
    public List<Object[]> executeResultList(boolean distinct, org.datanucleus.query.typesafe.Expression ... exprs) {
        this.discardCompiled();
        this.type = AbstractTypesafeQuery.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.result = null;
        if (exprs != null && exprs.length > 0) {
            this.result = new ArrayList();
            for (int i = 0; i < exprs.length; ++i) {
                this.result.add((ExpressionImpl)exprs[i]);
            }
        }
        this.resultClass = null;
        this.resultDistinct = distinct;
        return (List)this.executeInternalQuery(this.getInternalQuery());
    }

    @Override
    public List<Object> executeResultList(boolean distinct, org.datanucleus.query.typesafe.Expression expr) {
        this.discardCompiled();
        this.type = AbstractTypesafeQuery.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.result = null;
        if (expr != null) {
            this.result = new ArrayList();
            this.result.add((ExpressionImpl)expr);
        }
        this.resultClass = null;
        this.resultDistinct = distinct;
        return (List)this.executeInternalQuery(this.getInternalQuery());
    }

    @Override
    public <R> List<R> executeResultList(Class<R> resultCls, boolean distinct, org.datanucleus.query.typesafe.Expression ... exprs) {
        this.discardCompiled();
        this.type = AbstractTypesafeQuery.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.result = null;
        if (exprs != null && exprs.length > 0) {
            this.result = new ArrayList();
            for (int i = 0; i < exprs.length; ++i) {
                this.result.add((ExpressionImpl)exprs[i]);
            }
        }
        this.resultClass = resultCls;
        this.resultDistinct = distinct;
        this.unique = false;
        return (List)this.executeInternalQuery(this.getInternalQuery());
    }

    @Override
    public Object[] executeResultUnique(boolean distinct, org.datanucleus.query.typesafe.Expression ... exprs) {
        this.discardCompiled();
        this.type = AbstractTypesafeQuery.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.result = null;
        if (exprs != null && exprs.length > 0) {
            this.result = new ArrayList();
            for (int i = 0; i < exprs.length; ++i) {
                this.result.add((ExpressionImpl)exprs[i]);
            }
        }
        this.resultClass = null;
        this.resultDistinct = distinct;
        this.unique = true;
        return (Object[])this.executeInternalQuery(this.getInternalQuery());
    }

    @Override
    public Object executeResultUnique(boolean distinct, org.datanucleus.query.typesafe.Expression expr) {
        this.discardCompiled();
        this.type = AbstractTypesafeQuery.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.result = null;
        if (expr != null) {
            this.result = new ArrayList();
            this.result.add((ExpressionImpl)expr);
        }
        this.resultClass = null;
        this.resultDistinct = distinct;
        this.unique = true;
        return this.executeInternalQuery(this.getInternalQuery());
    }

    @Override
    public <R> R executeResultUnique(Class<R> resultCls, boolean distinct, org.datanucleus.query.typesafe.Expression ... exprs) {
        this.discardCompiled();
        this.type = AbstractTypesafeQuery.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.result = null;
        if (exprs != null && exprs.length > 0) {
            this.result = new ArrayList();
            for (int i = 0; i < exprs.length; ++i) {
                this.result.add((ExpressionImpl)exprs[i]);
            }
        }
        this.resultClass = resultCls;
        this.resultDistinct = distinct;
        this.unique = true;
        return (R)this.executeInternalQuery(this.getInternalQuery());
    }

    protected Query getInternalQuery() {
        Query internalQuery = this.ec.getStoreManager().getQueryManager().newQuery("JDOQL", this.ec, (Object)this.toString());
        internalQuery.setIgnoreCache(this.ignoreCache);
        if (!this.subclasses) {
            internalQuery.setSubclasses(false);
        }
        if (this.type == AbstractTypesafeQuery.QueryType.SELECT) {
            if (this.resultDistinct != null) {
                internalQuery.setResultDistinct(this.resultDistinct.booleanValue());
            }
            internalQuery.setResultClass(this.resultClass);
            internalQuery.setUnique(this.unique);
        }
        if (this.extensions != null) {
            internalQuery.setExtensions(this.extensions);
        }
        if (this.fp != null) {
            internalQuery.setFetchPlan(((JDOFetchPlan)this.fp).getInternalFetchPlan());
        }
        if (this.type == AbstractTypesafeQuery.QueryType.SELECT && this.candidates != null) {
            internalQuery.setCandidates(this.candidates);
        }
        QueryCompilation compilation = this.getCompilation();
        internalQuery.setCompilation(compilation);
        return internalQuery;
    }

    protected Object executeInternalQuery(Query internalQuery) {
        if (this.internalQueries == null) {
            this.internalQueries = new HashSet<Query>();
        }
        this.internalQueries.add(internalQuery);
        try {
            if (this.parameterValuesByName != null || this.parameterExprByName != null) {
                this.validateParameters();
                return internalQuery.executeWithMap(this.parameterValuesByName);
            }
            return internalQuery.execute();
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    @Override
    public long deletePersistentAll() {
        if (this.result != null || this.resultClass != null) {
            this.discardCompiled();
            this.result = null;
            this.resultClass = null;
        }
        this.type = AbstractTypesafeQuery.QueryType.SELECT;
        this.updateExprs = null;
        this.updateVals = null;
        this.unique = false;
        try {
            Query internalQuery = this.getInternalQuery();
            if (this.parameterValuesByName != null || this.parameterExprByName != null) {
                this.validateParameters();
                return internalQuery.deletePersistentAll(this.parameterValuesByName);
            }
            return internalQuery.deletePersistentAll();
        }
        catch (NucleusException jpe) {
            throw NucleusJDOHelper.getJDOExceptionForNucleusException(jpe);
        }
    }

    private void validateParameters() {
        int numValues;
        int numParams = this.parameterExprByName != null ? this.parameterExprByName.size() : 0;
        int n = numValues = this.parameterValuesByName != null ? this.parameterValuesByName.size() : 0;
        if (numParams != numValues) {
            throw new JDOUserException("Query has " + numParams + " but " + numValues + " values have been provided");
        }
        for (String paramName : this.parameterExprByName.keySet()) {
            if (this.parameterValuesByName.containsKey(paramName)) continue;
            throw new JDOUserException("Query has a parameter " + paramName + " defined but no value supplied");
        }
    }

    public TypesafeQuery<T> set(org.datanucleus.query.typesafe.Expression expr, Object val) {
        this.type = AbstractTypesafeQuery.QueryType.BULK_UPDATE;
        if (this.updateExprs == null) {
            this.updateExprs = new ArrayList();
            this.updateVals = new ArrayList();
        }
        ComparableExpressionImpl valExpr = null;
        Literal literalExpr = new Literal(val);
        if (val instanceof String) {
            valExpr = new StringExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Number) {
            valExpr = new NumericExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Time) {
            valExpr = new TimeExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Date) {
            valExpr = new DateExpressionImpl((Expression)literalExpr);
        } else if (val instanceof java.util.Date) {
            valExpr = new DateTimeExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Boolean) {
            valExpr = new BooleanExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Byte) {
            valExpr = new ByteExpressionImpl((Expression)literalExpr);
        } else if (val instanceof Enum) {
            valExpr = new EnumExpressionImpl((Expression)literalExpr);
        }
        this.updateExprs.add((ExpressionImpl)expr);
        this.updateVals.add(valExpr);
        return this;
    }

    public long update() {
        this.type = AbstractTypesafeQuery.QueryType.BULK_UPDATE;
        if (this.updateExprs == null || this.updateExprs.size() == 0) {
            throw new JDOUserException("No update expressions defined. Use set() method");
        }
        return (Long)this.executeInternalQuery(this.getInternalQuery());
    }

    public long delete() {
        this.type = AbstractTypesafeQuery.QueryType.BULK_DELETE;
        this.updateExprs = null;
        this.updateVals = null;
        return (Long)this.executeInternalQuery(this.getInternalQuery());
    }

    @Override
    public FetchPlan getFetchPlan() {
        if (this.fp == null) {
            this.fp = new JDOFetchPlan(this.ec.getFetchPlan().getCopy());
        }
        return this.fp;
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this.pm;
    }

    @Override
    public TypesafeQuery setIgnoreCache(boolean ignore) {
        this.ignoreCache = ignore;
        return this;
    }

    @Override
    public TypesafeQuery addExtension(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(key, value);
        return this;
    }

    @Override
    public TypesafeQuery setExtensions(Map<String, Object> extensions) {
        this.extensions = new HashMap<String, Object>(extensions);
        return this;
    }

    @Override
    public void close(Object result) {
        if (this.internalQueries != null) {
            for (Query query : this.internalQueries) {
                query.close(result);
            }
        }
    }

    @Override
    public void closeAll() {
        if (this.internalQueries != null) {
            for (Query query : this.internalQueries) {
                query.closeAll();
            }
            this.internalQueries.clear();
            this.internalQueries = null;
        }
    }

    @Override
    public QueryCompilation compile(MetaDataManager mmgr, ClassLoaderResolver clr) {
        QueryCompilation compilation = super.compile(mmgr, clr);
        if (this.subqueries != null && !this.subqueries.isEmpty()) {
            for (JDOTypesafeSubquery subquery : this.subqueries) {
                QueryCompilation subqueryCompilation = subquery.getCompilation();
                compilation.addSubqueryCompilation(subquery.getAlias(), subqueryCompilation);
            }
        }
        return compilation;
    }

    @Override
    public String toString() {
        if (this.queryString == null) {
            Iterator iter;
            StringBuffer str = null;
            str = this.type == AbstractTypesafeQuery.QueryType.BULK_UPDATE ? new StringBuffer("UPDATE") : (this.type == AbstractTypesafeQuery.QueryType.BULK_DELETE ? new StringBuffer("DELETE") : new StringBuffer("SELECT"));
            if (this.type == AbstractTypesafeQuery.QueryType.SELECT) {
                if (this.unique) {
                    str.append(" UNIQUE");
                }
                if (this.result != null && !this.result.isEmpty()) {
                    if (this.resultDistinct != null && this.resultDistinct.booleanValue()) {
                        str.append(" DISTINCT");
                    }
                    str.append(" ");
                    iter = this.result.iterator();
                    while (iter.hasNext()) {
                        ExpressionImpl resultExpr = (ExpressionImpl)iter.next();
                        str.append(JDOQLQueryHelper.getJDOQLForExpression((Expression)resultExpr.getQueryExpression()));
                        if (!iter.hasNext()) continue;
                        str.append(",");
                    }
                }
                if (this.resultClass != null) {
                    str.append(" INTO ").append(this.resultClass.getName());
                }
            }
            if (this.type == AbstractTypesafeQuery.QueryType.SELECT || this.type == AbstractTypesafeQuery.QueryType.BULK_DELETE) {
                str.append(" FROM ").append(this.candidateCls.getName());
            } else {
                str.append(" " + this.candidateCls.getName());
            }
            if (!this.subclasses) {
                str.append(" EXCLUDE SUBCLASSES");
            }
            if (this.type == AbstractTypesafeQuery.QueryType.BULK_UPDATE) {
                str.append(" SET");
                Iterator exprIter = this.updateExprs.iterator();
                Iterator valIter = this.updateVals.iterator();
                while (exprIter.hasNext()) {
                    ExpressionImpl expr = (ExpressionImpl)exprIter.next();
                    ExpressionImpl val = (ExpressionImpl)valIter.next();
                    str.append(" ").append(JDOQLQueryHelper.getJDOQLForExpression((Expression)expr.getQueryExpression()));
                    str.append(" = ").append(JDOQLQueryHelper.getJDOQLForExpression((Expression)val.getQueryExpression()));
                    if (!exprIter.hasNext()) continue;
                    str.append(",");
                }
            }
            if (this.filter != null) {
                str.append(" WHERE ");
                str.append(JDOQLQueryHelper.getJDOQLForExpression((Expression)this.filter.getQueryExpression()));
            }
            if (this.type == AbstractTypesafeQuery.QueryType.SELECT) {
                if (this.grouping != null && !this.grouping.isEmpty()) {
                    str.append(" GROUP BY ");
                    iter = this.grouping.iterator();
                    while (iter.hasNext()) {
                        ExpressionImpl groupExpr = (ExpressionImpl)iter.next();
                        str.append(JDOQLQueryHelper.getJDOQLForExpression((Expression)groupExpr.getQueryExpression()));
                        if (!iter.hasNext()) continue;
                        str.append(",");
                    }
                }
                if (this.having != null) {
                    str.append(" HAVING ");
                    str.append(JDOQLQueryHelper.getJDOQLForExpression((Expression)this.having.getQueryExpression()));
                }
                if (this.ordering != null && !this.ordering.isEmpty()) {
                    str.append(" ORDER BY ");
                    iter = this.ordering.iterator();
                    while (iter.hasNext()) {
                        OrderExpressionImpl orderExpr = (OrderExpressionImpl)iter.next();
                        str.append(JDOQLQueryHelper.getJDOQLForExpression((Expression)((ExpressionImpl)orderExpr.getExpression()).getQueryExpression()));
                        str.append(" " + (orderExpr.getDirection() == OrderExpression.OrderDirection.ASC ? "ASCENDING" : "DESCENDING"));
                        if (!iter.hasNext()) continue;
                        str.append(",");
                    }
                }
                if (this.rangeLowerExpr != null && this.rangeUpperExpr != null) {
                    str.append(" RANGE ");
                    str.append(JDOQLQueryHelper.getJDOQLForExpression((Expression)this.rangeLowerExpr.getQueryExpression()));
                    str.append(",");
                    str.append(JDOQLQueryHelper.getJDOQLForExpression((Expression)this.rangeUpperExpr.getQueryExpression()));
                }
            }
            this.queryString = str.toString();
        }
        return this.queryString;
    }

    @Override
    protected void discardCompiled() {
        super.discardCompiled();
        this.queryString = null;
    }

    public static String getQueryClassNameForClassName(String name) {
        return "Q" + name;
    }
}

