/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.metadata;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Extension;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchPlan;
import javax.jdo.annotations.ForeignKey;
import javax.jdo.annotations.ForeignKeyAction;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceModifier;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.SequenceStrategy;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.VersionStrategy;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.api.jdo.metadata.JDOAnnotationUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.FetchGroupMemberMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.annotations.AbstractAnnotationReader;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.Member;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JDOAnnotationReader
extends AbstractAnnotationReader {
    public JDOAnnotationReader(MetaDataManager mgr) {
        super(mgr);
        this.setSupportedAnnotationPackages(new String[]{"javax.jdo", "org.datanucleus"});
    }

    protected AbstractClassMetaData processClassAnnotations(PackageMetaData pmd, Class cls, AnnotationObject[] annotations, ClassLoaderResolver clr) {
        Object cmd = null;
        if (annotations != null && annotations.length > 0) {
            int i;
            AnnotationObject pcAnnotation = this.isClassPersistenceCapable(cls);
            if (pcAnnotation != null) {
                cmd = cls.isInterface() ? pmd.newInterfaceMetadata(ClassUtils.getClassNameForClass((Class)cls)) : pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
                cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
                HashMap annotationValues = pcAnnotation.getNameValueMap();
                cmd.setTable((String)annotationValues.get("table"));
                cmd.setCatalog((String)annotationValues.get("catalog"));
                cmd.setSchema((String)annotationValues.get("schema"));
                String detachableStr = (String)annotationValues.get("detachable");
                if (this.mgr.getNucleusContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.metadata.alwaysDetachable")) {
                    cmd.setDetachable(true);
                } else {
                    cmd.setDetachable(detachableStr);
                }
                cmd.setRequiresExtent((String)annotationValues.get("requiresExtent"));
                String idClassName = null;
                Class idClass = (Class)annotationValues.get("objectIdClass");
                if (idClass != null && idClass != Void.TYPE) {
                    idClassName = idClass.getName();
                }
                cmd.setObjectIdClass(idClassName);
                cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
                cmd.setEmbeddedOnly((String)annotationValues.get("embeddedOnly"));
                javax.jdo.annotations.IdentityType idTypeVal = (javax.jdo.annotations.IdentityType)annotationValues.get("identityType");
                String identityType = JDOAnnotationUtils.getIdentityTypeString(idTypeVal);
                cmd.setIdentityType(IdentityType.getIdentityType((String)identityType));
                cmd.setCacheable((String)annotationValues.get("cacheable"));
                String serializeRead = (String)annotationValues.get("serializeRead");
                if (serializeRead != null) {
                    cmd.setSerializeRead(serializeRead.equals("true"));
                }
                JDOAnnotationUtils.addExtensionsToMetaData((MetaData)cmd, (Extension[])annotationValues.get("extensions"));
                Persistent[] members = (Persistent[])annotationValues.get("members");
                if (members != null) {
                    for (int j = 0; j < members.length; ++j) {
                        String memberName = members[j].name();
                        if (memberName.indexOf(46) > 0) {
                            memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                        }
                        boolean isField = this.isMemberOfClassAField(cls, memberName);
                        AbstractMemberMetaData fmd = this.getFieldMetaDataForPersistent((MetaData)cmd, members[j], isField);
                        cmd.addMember(fmd);
                    }
                }
            } else if (this.isClassPersistenceAware(cls)) {
                cmd = pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
                cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_AWARE);
            } else if (this.doesClassHaveNamedQueries(cls)) {
                cmd = pmd.newClassMetadata(ClassUtils.getClassNameForClass((Class)cls));
                cmd.setPersistenceModifier(ClassPersistenceModifier.NON_PERSISTENT);
            } else {
                return null;
            }
            this.processNamedQueries((AbstractClassMetaData)cmd, cls, annotations);
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                return cmd;
            }
            InheritanceMetaData inhmd = null;
            DiscriminatorMetaData dismd = null;
            IdentityMetaData idmd = null;
            PrimaryKeyMetaData pkmd = null;
            VersionMetaData vermd = null;
            JoinMetaData[] joins = null;
            FetchPlanMetaData[] fetchPlans = null;
            FetchGroupMetaData[] fetchGroups = null;
            SequenceMetaData seqmd = null;
            String cacheable = null;
            boolean embeddedOnly = false;
            ColumnMetaData[] unmappedColumns = null;
            HashSet<IndexMetaData> indices = null;
            HashSet<UniqueMetaData> uniqueKeys = null;
            HashSet<ForeignKeyMetaData> fks = null;
            HashSet<ExtensionMetaData> extensions = null;
            for (i = 0; i < annotations.length; ++i) {
                ColumnMetaData colmd;
                Column[] columns;
                HashMap annotationValues = annotations[i].getNameValueMap();
                String annName = annotations[i].getName();
                if (annName.equals(JDOAnnotationUtils.EMBEDDED_ONLY)) {
                    embeddedOnly = true;
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.VERSION)) {
                    VersionStrategy versionStrategy = (VersionStrategy)annotationValues.get("strategy");
                    String strategy = JDOAnnotationUtils.getVersionStrategyString(versionStrategy);
                    String indexed = (String)annotationValues.get("indexed");
                    String column = (String)annotationValues.get("column");
                    columns = (Column[])annotationValues.get("columns");
                    vermd = new VersionMetaData();
                    vermd.setStrategy(strategy);
                    vermd.setColumnName(column);
                    vermd.setIndexed(IndexedValue.getIndexedValue((String)indexed));
                    if (columns != null && columns.length > 0) {
                        colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columns[0]);
                        vermd.setColumnMetaData(colmd);
                    }
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)vermd, (Extension[])annotationValues.get("extensions"));
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.DATASTORE_IDENTITY)) {
                    String strategy = JDOAnnotationUtils.getIdentityStrategyString((IdGeneratorStrategy)annotationValues.get("strategy"));
                    String customStrategy = (String)annotationValues.get("customStrategy");
                    if (!StringUtils.isWhitespace((String)customStrategy)) {
                        strategy = customStrategy;
                    }
                    String sequence = (String)annotationValues.get("sequence");
                    String column = (String)annotationValues.get("column");
                    columns = (Column[])annotationValues.get("columns");
                    idmd = new IdentityMetaData();
                    idmd.setColumnName(column);
                    idmd.setValueStrategy(IdentityStrategy.getIdentityStrategy((String)strategy));
                    idmd.setSequence(sequence);
                    if (columns != null && columns.length > 0) {
                        colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columns[0]);
                        idmd.setColumnMetaData(colmd);
                    }
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)idmd, (Extension[])annotationValues.get("extensions"));
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.PRIMARY_KEY)) {
                    String pkName = (String)annotationValues.get("name");
                    String pkColumn = (String)annotationValues.get("column");
                    Column[] columns2 = (Column[])annotationValues.get("columns");
                    pkmd = new PrimaryKeyMetaData();
                    pkmd.setName(pkName);
                    pkmd.setColumnName(pkColumn);
                    if (columns2 == null || columns2.length <= 0) continue;
                    for (int j = 0; j < columns2.length; ++j) {
                        pkmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columns2[j]));
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.JOINS)) {
                    Join[] js;
                    if (joins != null) {
                        NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044210", (Object)cmd.getFullClassName()));
                    }
                    if ((js = (Join[])annotationValues.get("value")) == null || js.length <= 0) continue;
                    joins = new JoinMetaData[js.length];
                    for (int j = 0; j < js.length; ++j) {
                        joins[j] = new JoinMetaData();
                        joins[j].setTable(js[j].table());
                        joins[j].setColumnName(js[j].column());
                        joins[j].setIndexed(IndexedValue.getIndexedValue((String)js[j].indexed()));
                        joins[j].setOuter(MetaDataUtils.getBooleanForString((String)js[j].outer(), (boolean)false));
                        joins[j].setUnique(js[j].unique());
                        joins[j].setDeleteAction(JDOAnnotationUtils.getForeignKeyActionString(js[j].deleteAction()));
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.JOIN)) {
                    if (joins != null) {
                        NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044210", (Object)cmd.getFullClassName()));
                    }
                    joins = new JoinMetaData[]{new JoinMetaData()};
                    joins[0].setTable((String)annotationValues.get("table"));
                    joins[0].setColumnName((String)annotationValues.get("column"));
                    joins[0].setIndexed(IndexedValue.getIndexedValue((String)((String)annotationValues.get("indexed"))));
                    joins[0].setOuter(MetaDataUtils.getBooleanForString((String)((String)annotationValues.get("outer")), (boolean)false));
                    joins[0].setUnique((String)annotationValues.get("unique"));
                    joins[0].setDeleteAction(((ForeignKeyAction)annotationValues.get("deleteAction")).toString());
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)joins[0], (Extension[])annotationValues.get("extensions"));
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.INHERITANCE)) {
                    String strategy = JDOAnnotationUtils.getInheritanceStrategyString((InheritanceStrategy)annotationValues.get("strategy"));
                    String customStrategy = (String)annotationValues.get("customStrategy");
                    if (!StringUtils.isWhitespace((String)customStrategy)) {
                        strategy = customStrategy;
                    }
                    inhmd = new InheritanceMetaData();
                    inhmd.setStrategy(strategy);
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.DISCRIMINATOR)) {
                    DiscriminatorStrategy discriminatorStrategy = (DiscriminatorStrategy)annotationValues.get("strategy");
                    String strategy = JDOAnnotationUtils.getDiscriminatorStrategyString(discriminatorStrategy);
                    String column = (String)annotationValues.get("column");
                    String indexed = (String)annotationValues.get("indexed");
                    String value = (String)annotationValues.get("value");
                    Column[] columns3 = (Column[])annotationValues.get("columns");
                    dismd = new DiscriminatorMetaData();
                    dismd.setColumnName(column);
                    dismd.setValue(value);
                    dismd.setStrategy(strategy);
                    dismd.setIndexed(indexed);
                    if (columns3 == null || columns3.length <= 0) continue;
                    ColumnMetaData colmd2 = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columns3[0]);
                    dismd.setColumnMetaData(colmd2);
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.FETCHPLANS)) {
                    if (fetchPlans != null) {
                        NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044207", (Object)cmd.getFullClassName()));
                    }
                    FetchPlan[] plans = (FetchPlan[])annotationValues.get("value");
                    fetchPlans = new FetchPlanMetaData[plans.length];
                    for (int j = 0; j < plans.length; ++j) {
                        fetchPlans[j] = new FetchPlanMetaData(plans[j].name());
                        fetchPlans[j].setMaxFetchDepth(plans[j].maxFetchDepth());
                        fetchPlans[j].setFetchSize(plans[j].fetchSize());
                        int numGroups = plans[j].fetchGroups().length;
                        for (int k = 0; k < numGroups; ++k) {
                            FetchGroupMetaData fgmd = new FetchGroupMetaData(plans[j].fetchGroups()[k]);
                            fetchPlans[j].addFetchGroup(fgmd);
                        }
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.FETCHPLAN)) {
                    if (fetchPlans != null) {
                        NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044207", (Object)cmd.getFullClassName()));
                    }
                    fetchPlans = new FetchPlanMetaData[1];
                    int maxFetchDepth = (Integer)annotationValues.get("maxFetchDepth");
                    int fetchSize = (Integer)annotationValues.get("fetchSize");
                    fetchPlans[0] = new FetchPlanMetaData((String)annotationValues.get("name"));
                    fetchPlans[0].setMaxFetchDepth(maxFetchDepth);
                    fetchPlans[0].setFetchSize(fetchSize);
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.FETCHGROUPS)) {
                    if (fetchGroups != null) {
                        NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044208", (Object)cmd.getFullClassName()));
                    }
                    FetchGroup[] groups = (FetchGroup[])annotationValues.get("value");
                    fetchGroups = new FetchGroupMetaData[groups.length];
                    for (int j = 0; j < groups.length; ++j) {
                        fetchGroups[j] = new FetchGroupMetaData(groups[j].name());
                        if (!StringUtils.isWhitespace((String)groups[j].postLoad())) {
                            fetchGroups[j].setPostLoad(Boolean.valueOf(groups[j].postLoad()));
                        }
                        int numFields = groups[j].members().length;
                        for (int k = 0; k < numFields; ++k) {
                            FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData((MetaData)fetchGroups[j], groups[j].members()[k].name());
                            fgmmd.setRecursionDepth(groups[j].members()[k].recursionDepth());
                            fetchGroups[j].addMember(fgmmd);
                        }
                        int numGroups = groups[j].fetchGroups().length;
                        for (int k = 0; k < numGroups; ++k) {
                            FetchGroupMetaData subgrp = new FetchGroupMetaData(groups[j].fetchGroups()[k]);
                            fetchGroups[j].addFetchGroup(subgrp);
                        }
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.FETCHGROUP)) {
                    Persistent[] fields;
                    if (fetchGroups != null) {
                        NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044208", (Object)cmd.getFullClassName()));
                    }
                    fetchGroups = new FetchGroupMetaData[]{new FetchGroupMetaData((String)annotationValues.get("name"))};
                    String postLoadStr = (String)annotationValues.get("postLoad");
                    if (!StringUtils.isWhitespace((String)postLoadStr)) {
                        fetchGroups[0].setPostLoad(Boolean.valueOf(postLoadStr));
                    }
                    if ((fields = (Persistent[])annotationValues.get("members")) == null) continue;
                    for (int j = 0; j < fields.length; ++j) {
                        FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData((MetaData)fetchGroups[0], fields[j].name());
                        fgmmd.setRecursionDepth(fields[j].recursionDepth());
                        fetchGroups[0].addMember(fgmmd);
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.SEQUENCE)) {
                    String seqName = (String)annotationValues.get("name");
                    String seqStrategy = JDOAnnotationUtils.getSequenceStrategyString((SequenceStrategy)annotationValues.get("strategy"));
                    String seqSeq = (String)annotationValues.get("datastoreSequence");
                    Class seqFactory = (Class)annotationValues.get("factoryClass");
                    String seqFactoryClassName = null;
                    if (seqFactory != null && seqFactory != Void.TYPE) {
                        seqFactoryClassName = seqFactory.getName();
                    }
                    Integer seqSize = (Integer)annotationValues.get("allocationSize");
                    Integer seqStart = (Integer)annotationValues.get("initialValue");
                    if (StringUtils.isWhitespace((String)seqName)) {
                        throw new InvalidClassMetaDataException(LOCALISER, "044155", cmd.getFullClassName());
                    }
                    seqmd = new SequenceMetaData(seqName, seqStrategy);
                    seqmd.setFactoryClass(seqFactoryClassName);
                    seqmd.setDatastoreSequence(seqSeq);
                    if (seqSize != null) {
                        seqmd.setAllocationSize(seqSize.intValue());
                    }
                    if (seqStart != null) {
                        seqmd.setInitialValue(seqStart.intValue());
                    }
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)seqmd, (Extension[])annotationValues.get("extensions"));
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.INDICES)) {
                    Index[] values = (Index[])annotationValues.get("value");
                    if (values == null || values.length <= 0) continue;
                    indices = new HashSet<IndexMetaData>(values.length);
                    for (int j = 0; j < values.length; ++j) {
                        IndexMetaData idxmd = JDOAnnotationUtils.getIndexMetaData(values[j].name(), values[j].table(), "" + values[j].unique(), values[j].members(), values[j].columns());
                        if (idxmd.getNumberOfColumns() == 0 && idxmd.getNumberOfMembers() == 0) {
                            NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044204", (Object)cls.getName()));
                            continue;
                        }
                        indices.add(idxmd);
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.INDEX)) {
                    String[] members;
                    String unique;
                    String table;
                    String name = (String)annotationValues.get("name");
                    IndexMetaData idxmd = JDOAnnotationUtils.getIndexMetaData(name, table = (String)annotationValues.get("table"), unique = (String)annotationValues.get("unique"), members = (String[])annotationValues.get("members"), columns = (Column[])annotationValues.get("columns"));
                    if (idxmd.getNumberOfColumns() == 0 && idxmd.getNumberOfMembers() == 0) {
                        NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044204", (Object)cls.getName()));
                        continue;
                    }
                    indices = new HashSet(1);
                    indices.add(idxmd);
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.UNIQUES)) {
                    Unique[] values = (Unique[])annotationValues.get("value");
                    if (values == null || values.length <= 0) continue;
                    uniqueKeys = new HashSet<UniqueMetaData>(values.length);
                    for (int j = 0; j < values.length; ++j) {
                        UniqueMetaData unimd = JDOAnnotationUtils.getUniqueMetaData(values[j].name(), values[j].table(), "" + values[j].deferred(), values[j].members(), values[j].columns());
                        if (unimd.getNumberOfColumns() == 0 && unimd.getNumberOfMembers() == 0) {
                            NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044205", (Object)cls.getName()));
                            continue;
                        }
                        uniqueKeys.add(unimd);
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.UNIQUE)) {
                    String[] members;
                    String deferred;
                    String table;
                    String name = (String)annotationValues.get("name");
                    UniqueMetaData unimd = JDOAnnotationUtils.getUniqueMetaData(name, table = (String)annotationValues.get("table"), deferred = (String)annotationValues.get("deferred"), members = (String[])annotationValues.get("members"), columns = (Column[])annotationValues.get("columns"));
                    if (unimd.getNumberOfColumns() == 0 && unimd.getNumberOfMembers() == 0) {
                        NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044205", (Object)cls.getName()));
                        continue;
                    }
                    uniqueKeys = new HashSet(1);
                    uniqueKeys.add(unimd);
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.FOREIGNKEYS)) {
                    ForeignKey[] values = (ForeignKey[])annotationValues.get("value");
                    if (values == null || values.length <= 0) continue;
                    fks = new HashSet<ForeignKeyMetaData>(values.length);
                    for (int j = 0; j < values.length; ++j) {
                        String deleteAction = JDOAnnotationUtils.getForeignKeyActionString(values[j].deleteAction());
                        String updateAction = JDOAnnotationUtils.getForeignKeyActionString(values[j].updateAction());
                        ForeignKeyMetaData fkmd = JDOAnnotationUtils.getFKMetaData(values[j].name(), values[j].table(), values[j].unique(), "" + values[j].deferred(), deleteAction, updateAction, values[j].members(), values[j].columns());
                        if (fkmd.getNumberOfColumns() == 0 && fkmd.getNumberOfMembers() == 0) {
                            NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044206", (Object)cls.getName()));
                            continue;
                        }
                        fks.add(fkmd);
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.FOREIGNKEY)) {
                    Column[] columns4;
                    String[] members;
                    String updateAction;
                    String deleteAction;
                    String deferred;
                    String unique;
                    String table;
                    String name = (String)annotationValues.get("name");
                    ForeignKeyMetaData fkmd = JDOAnnotationUtils.getFKMetaData(name, table = (String)annotationValues.get("table"), unique = (String)annotationValues.get("unique"), deferred = (String)annotationValues.get("deferred"), deleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction")), updateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("updateAction")), members = (String[])annotationValues.get("members"), columns4 = (Column[])annotationValues.get("columns"));
                    if (fkmd.getNumberOfColumns() == 0 && fkmd.getNumberOfMembers() == 0) {
                        NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044206", (Object)cls.getName()));
                        continue;
                    }
                    fks = new HashSet(1);
                    fks.add(fkmd);
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.COLUMNS)) {
                    Column[] cols = (Column[])annotationValues.get("value");
                    if (cols == null || cols.length <= 0) continue;
                    unmappedColumns = new ColumnMetaData[cols.length];
                    for (int j = 0; j < cols.length; ++j) {
                        unmappedColumns[j] = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(cols[j]);
                        JDOAnnotationUtils.addExtensionsToMetaData((MetaData)unmappedColumns[j], cols[j].extensions());
                    }
                    continue;
                }
                if (annName.equals("javax.jdo.annotations.Cacheable")) {
                    String cache = (String)annotationValues.get("value");
                    if (cache == null) continue;
                    cacheable = cache;
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.EXTENSIONS)) {
                    Extension[] values = (Extension[])annotationValues.get("value");
                    if (values == null || values.length <= 0) continue;
                    extensions = new HashSet<ExtensionMetaData>(values.length);
                    for (int j = 0; j < values.length; ++j) {
                        ExtensionMetaData extmd = new ExtensionMetaData(values[j].vendorName(), values[j].key().toString(), values[j].value().toString());
                        extensions.add(extmd);
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.EXTENSION)) {
                    ExtensionMetaData extmd = new ExtensionMetaData((String)annotationValues.get("vendorName"), (String)annotationValues.get("key"), (String)annotationValues.get("value"));
                    extensions = new HashSet(1);
                    extensions.add(extmd);
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.PERSISTENCE_CAPABLE) || annName.equals(JDOAnnotationUtils.PERSISTENCE_AWARE) || annName.equals(JDOAnnotationUtils.QUERIES) || annName.equals(JDOAnnotationUtils.QUERY)) continue;
                NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044203", (Object)cls.getName(), (Object)annotations[i].getName()));
            }
            NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044200", (Object)cls.getName(), (Object)"JDO"));
            if (embeddedOnly) {
                cmd.setEmbeddedOnly(true);
            }
            if (idmd != null) {
                idmd.setParent((MetaData)cmd);
                cmd.setIdentityMetaData(idmd);
            }
            if (pkmd != null) {
                pkmd.setParent((MetaData)cmd);
                cmd.setPrimaryKeyMetaData(pkmd);
            }
            if (vermd != null) {
                vermd.setParent((MetaData)cmd);
                cmd.setVersionMetaData(vermd);
            }
            if (inhmd != null) {
                if (dismd != null) {
                    inhmd.setDiscriminatorMetaData(dismd);
                }
                inhmd.setParent((MetaData)cmd);
                cmd.setInheritanceMetaData(inhmd);
            } else if (dismd != null) {
                inhmd = new InheritanceMetaData();
                inhmd.setDiscriminatorMetaData(dismd);
                cmd.setInheritanceMetaData(inhmd);
            }
            if (joins != null && joins.length > 0) {
                for (i = 0; i < joins.length; ++i) {
                    cmd.addJoin((JoinMetaData)joins[i]);
                }
            }
            if (fetchGroups != null && fetchGroups.length > 0) {
                for (i = 0; i < fetchGroups.length; ++i) {
                    fetchGroups[i].setParent((MetaData)cmd);
                    cmd.addFetchGroup((FetchGroupMetaData)fetchGroups[i]);
                }
            }
            if (seqmd != null) {
                cmd.getPackageMetaData().addSequence(seqmd);
            }
            if (indices != null) {
                for (IndexMetaData idxmd : indices) {
                    idxmd.setParent((MetaData)cmd);
                    cmd.addIndex(idxmd);
                }
            }
            if (uniqueKeys != null) {
                for (UniqueMetaData unimd : uniqueKeys) {
                    unimd.setParent((MetaData)cmd);
                    cmd.addUniqueConstraint(unimd);
                }
            }
            if (fks != null) {
                for (ForeignKeyMetaData fkmd : fks) {
                    fkmd.setParent((MetaData)cmd);
                    cmd.addForeignKey(fkmd);
                }
            }
            if (unmappedColumns != null) {
                for (int i2 = 0; i2 < unmappedColumns.length; ++i2) {
                    void colmd = unmappedColumns[i2];
                    colmd.setParent((MetaData)cmd);
                    cmd.addUnmappedColumn((ColumnMetaData)colmd);
                }
            }
            if (cacheable != null && cacheable.equalsIgnoreCase("false")) {
                cmd.setCacheable(false);
            }
            if (extensions != null) {
                for (ExtensionMetaData extmd : extensions) {
                    cmd.addExtension(extmd.getVendorName(), extmd.getKey(), extmd.getValue());
                }
            }
        }
        return cmd;
    }

    protected void processNamedQueries(AbstractClassMetaData cmd, Class cls, AnnotationObject[] annotations) {
        int i;
        QueryMetaData[] queries = null;
        for (i = 0; i < annotations.length; ++i) {
            HashMap annotationValues = annotations[i].getNameValueMap();
            String annName = annotations[i].getName();
            if (annName.equals(JDOAnnotationUtils.QUERIES)) {
                if (queries != null) {
                    NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044209", (Object)cmd.getFullClassName()));
                }
                Query[] qs = (Query[])annotationValues.get("value");
                queries = new QueryMetaData[qs.length];
                for (int j = 0; j < queries.length; ++j) {
                    String resultClassName;
                    String lang = JDOAnnotationUtils.getQueryLanguageName(qs[j].language());
                    String string = resultClassName = qs[j].resultClass() != null && qs[j].resultClass() != Void.TYPE ? qs[j].resultClass().getName() : null;
                    if (StringUtils.isWhitespace((String)qs[j].name())) {
                        throw new InvalidClassMetaDataException(LOCALISER, "044154", cmd.getFullClassName());
                    }
                    queries[j] = new QueryMetaData(qs[j].name());
                    queries[j].setScope(cls.getName());
                    queries[j].setLanguage(lang);
                    queries[j].setUnmodifiable(qs[j].unmodifiable());
                    queries[j].setResultClass(resultClassName);
                    queries[j].setUnique(qs[j].unique());
                    queries[j].setFetchPlanName(qs[j].fetchPlan());
                    queries[j].setQuery(qs[j].value());
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)queries[j], qs[j].extensions());
                }
                continue;
            }
            if (!annName.equals(JDOAnnotationUtils.QUERY)) continue;
            if (queries != null) {
                NucleusLogger.METADATA.warn((Object)LOCALISER.msg("044209", (Object)cmd.getFullClassName()));
            }
            queries = new QueryMetaData[1];
            String unmodifiable = "" + annotationValues.get("unmodifiable");
            Class resultClassValue = (Class)annotationValues.get("resultClass");
            String resultClassName = resultClassValue != null && resultClassValue != Void.TYPE ? resultClassValue.getName() : null;
            String lang = JDOAnnotationUtils.getQueryLanguageName((String)annotationValues.get("language"));
            if (StringUtils.isWhitespace((String)((String)annotationValues.get("name")))) {
                throw new InvalidClassMetaDataException(LOCALISER, "044154", cmd.getFullClassName());
            }
            queries[0] = new QueryMetaData((String)annotationValues.get("name"));
            queries[0].setScope(cls.getName());
            queries[0].setLanguage(lang);
            queries[0].setUnmodifiable(unmodifiable);
            queries[0].setResultClass(resultClassName);
            queries[0].setUnique((String)annotationValues.get("unique"));
            queries[0].setFetchPlanName((String)annotationValues.get("fetchPlan"));
            queries[0].setQuery((String)annotationValues.get("value"));
            JDOAnnotationUtils.addExtensionsToMetaData((MetaData)queries[0], (Extension[])annotationValues.get("extensions"));
        }
        if (queries != null && queries.length > 0) {
            for (i = 0; i < queries.length; ++i) {
                queries[i].setParent((MetaData)cmd);
                cmd.addQuery((QueryMetaData)queries[i]);
            }
        }
    }

    protected AbstractMemberMetaData processMemberAnnotations(AbstractClassMetaData cmd, Member member, AnnotationObject[] annotations, boolean propertyAccessor) {
        Object mmd = null;
        if (annotations != null && annotations.length > 0) {
            boolean primaryKey = false;
            boolean serialised = false;
            boolean nonPersistentField = false;
            boolean transactionalField = false;
            String cacheable = null;
            Class[] elementTypes = null;
            String embeddedElement = null;
            String serializedElement = null;
            String dependentElement = null;
            Class keyType = null;
            String embeddedKey = null;
            String serializedKey = null;
            String dependentKey = null;
            Class valueType = null;
            String embeddedValue = null;
            String serializedValue = null;
            String dependentValue = null;
            String embeddedOwnerField = null;
            String embeddedNullIndicatorColumn = null;
            String embeddedNullIndicatorValue = null;
            Persistent[] embeddedMembers = null;
            Persistent[] embeddedElementMembers = null;
            Persistent[] embeddedKeyMembers = null;
            Persistent[] embeddedValueMembers = null;
            ColumnMetaData[] colmds = null;
            JoinMetaData joinmd = null;
            ElementMetaData elemmd = null;
            KeyMetaData keymd = null;
            ValueMetaData valuemd = null;
            OrderMetaData ordermd = null;
            IndexMetaData idxmd = null;
            UniqueMetaData unimd = null;
            ForeignKeyMetaData fkmd = null;
            HashSet<ExtensionMetaData> extensions = null;
            for (int i = 0; i < annotations.length; ++i) {
                Column[] columns;
                String unique;
                String name;
                EmbeddedMetaData embmd;
                String uniqueName;
                String unique2;
                String indexName;
                String indexed;
                String generateFK;
                String fkName;
                String annName = annotations[i].getName();
                HashMap annotationValues = annotations[i].getNameValueMap();
                if (annName.equals(JDOAnnotationUtils.PERSISTENT)) {
                    int j;
                    FieldPersistenceModifier modifier;
                    String pkStr = "" + annotationValues.get("primaryKey");
                    Boolean pk = null;
                    if (!StringUtils.isWhitespace((String)pkStr)) {
                        pk = Boolean.valueOf(pkStr);
                    }
                    String dfgStr = (String)annotationValues.get("defaultFetchGroup");
                    Boolean dfg = null;
                    if (!StringUtils.isWhitespace((String)dfgStr)) {
                        dfg = Boolean.valueOf(dfgStr);
                    }
                    String nullValue = JDOAnnotationUtils.getNullValueString((NullValue)annotationValues.get("nullValue"));
                    String embStr = (String)annotationValues.get("embedded");
                    Boolean embedded = null;
                    if (!StringUtils.isWhitespace((String)embStr)) {
                        embedded = Boolean.valueOf(embStr);
                    }
                    String serStr = (String)annotationValues.get("serialized");
                    Boolean serialized = null;
                    if (!StringUtils.isWhitespace((String)serStr)) {
                        serialized = Boolean.valueOf(serStr);
                    }
                    String depStr = (String)annotationValues.get("dependent");
                    Boolean dependent = null;
                    if (!StringUtils.isWhitespace((String)depStr)) {
                        dependent = Boolean.valueOf(depStr);
                    }
                    String valueStrategy = JDOAnnotationUtils.getIdentityStrategyString((IdGeneratorStrategy)annotationValues.get("valueStrategy"));
                    String customValueStrategy = (String)annotationValues.get("customValueStrategy");
                    if (!StringUtils.isWhitespace((String)customValueStrategy)) {
                        valueStrategy = customValueStrategy;
                    }
                    if ((modifier = JDOAnnotationUtils.getFieldPersistenceModifier((PersistenceModifier)annotationValues.get("persistenceModifier"))) == null) {
                        modifier = FieldPersistenceModifier.PERSISTENT;
                    }
                    String sequence = (String)annotationValues.get("sequence");
                    String mappedBy = (String)annotationValues.get("mappedBy");
                    String table = (String)annotationValues.get("table");
                    String column = (String)annotationValues.get("column");
                    String loadFetchGroup = (String)annotationValues.get("loadFetchGroup");
                    String fieldTypeName = null;
                    int recursionDepth = (Integer)annotationValues.get("recursionDepth");
                    cacheable = (String)annotationValues.get("cacheable");
                    Class[] fieldTypes = (Class[])annotationValues.get("types");
                    if (fieldTypes != null && fieldTypes.length > 0) {
                        StringBuilder typeStr = new StringBuilder();
                        for (j = 0; j < fieldTypes.length; ++j) {
                            if (typeStr.length() > 0) {
                                typeStr.append(',');
                            }
                            if (fieldTypes[j] == null || fieldTypes[j] == Void.TYPE) continue;
                            typeStr.append(fieldTypes[j].getName());
                        }
                        fieldTypeName = typeStr.toString();
                    }
                    dependentElement = (String)annotationValues.get("dependentElement");
                    serializedElement = (String)annotationValues.get("serializedElement");
                    embeddedElement = (String)annotationValues.get("embeddedElement");
                    dependentKey = (String)annotationValues.get("dependentKey");
                    serializedKey = (String)annotationValues.get("serializedKey");
                    embeddedKey = (String)annotationValues.get("embeddedKey");
                    dependentValue = (String)annotationValues.get("dependentValue");
                    serializedValue = (String)annotationValues.get("serializedValue");
                    embeddedValue = (String)annotationValues.get("embeddedValue");
                    mmd = member.isProperty() ? new PropertyMetaData((MetaData)cmd, member.getName()) : new FieldMetaData((MetaData)cmd, member.getName());
                    if (modifier != null) {
                        mmd.setPersistenceModifier(modifier);
                    }
                    if (dfg != null) {
                        mmd.setDefaultFetchGroup(dfg.booleanValue());
                    }
                    if (pk != null) {
                        mmd.setPrimaryKey(pk.booleanValue());
                    }
                    if (embedded != null) {
                        mmd.setEmbedded(embedded.booleanValue());
                    }
                    if (serialized != null) {
                        mmd.setSerialised(serialized.booleanValue());
                    }
                    if (dependent != null) {
                        mmd.setDependent(dependent.booleanValue());
                    }
                    mmd.setNullValue(org.datanucleus.metadata.NullValue.getNullValue((String)nullValue));
                    mmd.setMappedBy(mappedBy);
                    mmd.setColumn(column);
                    mmd.setTable(table);
                    mmd.setRecursionDepth(recursionDepth);
                    mmd.setLoadFetchGroup(loadFetchGroup);
                    mmd.setValueStrategy(valueStrategy);
                    mmd.setSequence(sequence);
                    mmd.setFieldTypes(fieldTypeName);
                    Column[] columns2 = (Column[])annotationValues.get("columns");
                    if (columns2 != null && columns2.length > 0) {
                        for (j = 0; j < columns2.length; ++j) {
                            mmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columns2[j]));
                        }
                    }
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)mmd, (Extension[])annotationValues.get("extensions"));
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.PRIMARY_KEY)) {
                    primaryKey = true;
                    if (cmd.getIdentityType() != IdentityType.DATASTORE) continue;
                    cmd.setIdentityType(IdentityType.APPLICATION);
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.SERIALIZED)) {
                    serialised = true;
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.NOTPERSISTENT)) {
                    nonPersistentField = true;
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.TRANSACTIONAL)) {
                    transactionalField = true;
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.COLUMNS)) {
                    Column[] cols = (Column[])annotationValues.get("value");
                    if (cols == null || cols.length <= 0) continue;
                    colmds = new ColumnMetaData[cols.length];
                    for (int j = 0; j < cols.length; ++j) {
                        colmds[j] = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(cols[j]);
                        JDOAnnotationUtils.addExtensionsToMetaData((MetaData)colmds[j], cols[j].extensions());
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.COLUMN)) {
                    colmds = new ColumnMetaData[]{JDOAnnotationUtils.getColumnMetaDataForAnnotations(annotationValues)};
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)colmds[0], (Extension[])annotationValues.get("extensions"));
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.JOIN)) {
                    String joinColumn = (String)annotationValues.get("column");
                    String joinOuter = (String)annotationValues.get("outer");
                    String deleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                    String pkName = (String)annotationValues.get("primaryKey");
                    String fkName2 = (String)annotationValues.get("foreignKey");
                    String generateFK2 = (String)annotationValues.get("generateForeignKey");
                    String indexed2 = (String)annotationValues.get("indexed");
                    String indexName2 = (String)annotationValues.get("index");
                    String unique3 = (String)annotationValues.get("unique");
                    String uniqueName2 = (String)annotationValues.get("uniqueKey");
                    String generatePK = (String)annotationValues.get("generatePrimaryKey");
                    if (!StringUtils.isWhitespace((String)uniqueName2)) {
                        unique3 = "true";
                    }
                    if (!StringUtils.isWhitespace((String)indexName2)) {
                        indexed2 = "true";
                    }
                    Column[] joinColumns = (Column[])annotationValues.get("columns");
                    joinmd = new JoinMetaData();
                    joinmd.setColumnName(joinColumn);
                    joinmd.setOuter(MetaDataUtils.getBooleanForString((String)joinOuter, (boolean)false));
                    joinmd.setIndexed(IndexedValue.getIndexedValue((String)indexed2));
                    joinmd.setUnique(unique3);
                    joinmd.setDeleteAction(deleteAction);
                    if (!StringUtils.isWhitespace((String)pkName)) {
                        PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData();
                        pkmd.setName(pkName);
                        joinmd.setPrimaryKeyMetaData(pkmd);
                    } else if (generatePK != null && generatePK.equalsIgnoreCase("true")) {
                        joinmd.setPrimaryKeyMetaData(new PrimaryKeyMetaData());
                    }
                    if (!StringUtils.isWhitespace((String)fkName2)) {
                        ForeignKeyMetaData joinFkmd = joinmd.getForeignKeyMetaData();
                        if (joinFkmd == null) {
                            joinFkmd = new ForeignKeyMetaData();
                            joinFkmd.setName(fkName2);
                            joinmd.setForeignKeyMetaData(joinFkmd);
                        } else {
                            joinFkmd.setName(fkName2);
                        }
                    } else if (generateFK2 != null && generateFK2.equalsIgnoreCase("true")) {
                        joinmd.setForeignKeyMetaData(new ForeignKeyMetaData());
                    }
                    if (!StringUtils.isWhitespace((String)indexName2)) {
                        IndexMetaData joinIdxmd = joinmd.getIndexMetaData();
                        if (joinIdxmd == null) {
                            joinIdxmd = new IndexMetaData();
                            joinmd.setIndexMetaData(joinIdxmd);
                        }
                        joinIdxmd.setName(indexName2);
                    }
                    if (!StringUtils.isWhitespace((String)uniqueName2)) {
                        UniqueMetaData joinUnimd = joinmd.getUniqueMetaData();
                        if (joinUnimd == null) {
                            joinUnimd = new UniqueMetaData();
                            joinmd.setUniqueMetaData(joinUnimd);
                        }
                        joinUnimd.setName(uniqueName2);
                    }
                    if (joinColumns != null && joinColumns.length > 0) {
                        for (int j = 0; j < joinColumns.length; ++j) {
                            joinmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(joinColumns[j]));
                        }
                    }
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)joinmd, (Extension[])annotationValues.get("extensions"));
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.ELEMENT)) {
                    elementTypes = (Class[])annotationValues.get("types");
                    embeddedElement = (String)annotationValues.get("embedded");
                    serializedElement = (String)annotationValues.get("serialized");
                    dependentElement = (String)annotationValues.get("dependent");
                    String elementColumn = (String)annotationValues.get("column");
                    String elementDeleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                    String elementUpdateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("updateAction"));
                    String elementMappedBy = (String)annotationValues.get("mappedBy");
                    Column[] elementColumns = (Column[])annotationValues.get("columns");
                    String fkName3 = (String)annotationValues.get("foreignKey");
                    String generateFK3 = (String)annotationValues.get("generateForeignKey");
                    String indexed3 = (String)annotationValues.get("indexed");
                    String indexName3 = (String)annotationValues.get("index");
                    String unique4 = (String)annotationValues.get("unique");
                    String uniqueName3 = (String)annotationValues.get("uniqueKey");
                    if (!StringUtils.isWhitespace((String)uniqueName3)) {
                        unique4 = "true";
                    }
                    if (!StringUtils.isWhitespace((String)indexName3)) {
                        indexed3 = "true";
                    }
                    elemmd = new ElementMetaData();
                    elemmd.setColumnName(elementColumn);
                    elemmd.setDeleteAction(elementDeleteAction);
                    elemmd.setUpdateAction(elementUpdateAction);
                    elemmd.setIndexed(IndexedValue.getIndexedValue((String)indexed3));
                    elemmd.setUnique(MetaDataUtils.getBooleanForString((String)unique4, (boolean)false));
                    elemmd.setMappedBy(elementMappedBy);
                    if (!StringUtils.isWhitespace((String)fkName3)) {
                        ForeignKeyMetaData elemFkmd = elemmd.getForeignKeyMetaData();
                        if (elemFkmd == null) {
                            elemFkmd = new ForeignKeyMetaData();
                            elemFkmd.setName(fkName3);
                            elemmd.setForeignKeyMetaData(elemFkmd);
                        } else {
                            elemFkmd.setName(fkName3);
                        }
                    } else if (generateFK3 != null && generateFK3.equalsIgnoreCase("true")) {
                        elemmd.setForeignKeyMetaData(new ForeignKeyMetaData());
                    }
                    if (!StringUtils.isWhitespace((String)indexName3)) {
                        IndexMetaData elemIdxmd = elemmd.getIndexMetaData();
                        if (elemIdxmd == null) {
                            elemIdxmd = new IndexMetaData();
                            elemmd.setIndexMetaData(elemIdxmd);
                        }
                        elemIdxmd.setName(indexName3);
                    }
                    if (!StringUtils.isWhitespace((String)uniqueName3)) {
                        UniqueMetaData elemUnimd = elemmd.getUniqueMetaData();
                        if (elemUnimd == null) {
                            elemUnimd = new UniqueMetaData();
                            elemmd.setUniqueMetaData(elemUnimd);
                        }
                        elemUnimd.setName(uniqueName3);
                    }
                    if (elementColumns != null && elementColumns.length > 0) {
                        for (int j = 0; j < elementColumns.length; ++j) {
                            elemmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(elementColumns[j]));
                        }
                    }
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)elemmd, (Extension[])annotationValues.get("extensions"));
                    Embedded[] embeddedMappings = (Embedded[])annotationValues.get("embeddedMapping");
                    if (embeddedMappings == null || embeddedMappings.length <= 0) continue;
                    EmbeddedMetaData embmd2 = new EmbeddedMetaData();
                    embmd2.setOwnerMember(embeddedMappings[0].ownerMember());
                    embmd2.setNullIndicatorColumn(embeddedMappings[0].nullIndicatorColumn());
                    embmd2.setNullIndicatorValue(embeddedMappings[0].nullIndicatorValue());
                    try {
                        Discriminator disc = embeddedMappings[0].discriminatorColumnName();
                        if (disc != null) {
                            DiscriminatorMetaData dismd = embmd2.newDiscriminatorMetadata();
                            dismd.setColumnName(disc.column());
                            dismd.setStrategy(JDOAnnotationUtils.getDiscriminatorStrategyString(disc.strategy()));
                        }
                    }
                    catch (Throwable thr) {
                        // empty catch block
                    }
                    elemmd.setEmbeddedMetaData(embmd2);
                    embeddedElementMembers = embeddedMappings[0].members();
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.KEY)) {
                    Class[] keyTypes = (Class[])annotationValues.get("types");
                    if (keyTypes != null && keyTypes.length > 0) {
                        keyType = keyTypes[0];
                    }
                    embeddedKey = (String)annotationValues.get("embedded");
                    serializedKey = (String)annotationValues.get("serialized");
                    dependentKey = (String)annotationValues.get("dependent");
                    String keyColumn = (String)annotationValues.get("column");
                    String keyDeleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                    String keyUpdateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("updateAction"));
                    String keyMappedBy = (String)annotationValues.get("mappedBy");
                    Column[] keyColumns = (Column[])annotationValues.get("columns");
                    fkName = (String)annotationValues.get("foreignKey");
                    generateFK = (String)annotationValues.get("generateForeignKey");
                    indexed = (String)annotationValues.get("indexed");
                    indexName = (String)annotationValues.get("index");
                    unique2 = (String)annotationValues.get("unique");
                    uniqueName = (String)annotationValues.get("uniqueKey");
                    if (!StringUtils.isWhitespace((String)uniqueName)) {
                        unique2 = "true";
                    }
                    if (!StringUtils.isWhitespace((String)indexName)) {
                        indexed = "true";
                    }
                    keymd = new KeyMetaData();
                    keymd.setColumnName(keyColumn);
                    keymd.setDeleteAction(keyDeleteAction);
                    keymd.setUpdateAction(keyUpdateAction);
                    keymd.setIndexed(IndexedValue.getIndexedValue((String)indexed));
                    keymd.setUnique(MetaDataUtils.getBooleanForString((String)unique2, (boolean)false));
                    keymd.setMappedBy(keyMappedBy);
                    if (!StringUtils.isWhitespace((String)fkName)) {
                        ForeignKeyMetaData keyFkmd = keymd.getForeignKeyMetaData();
                        if (keyFkmd == null) {
                            keyFkmd = new ForeignKeyMetaData();
                            keyFkmd.setName(fkName);
                            keymd.setForeignKeyMetaData(keyFkmd);
                        } else {
                            keyFkmd.setName(fkName);
                        }
                    } else if (generateFK != null && generateFK.equalsIgnoreCase("true")) {
                        keymd.setForeignKeyMetaData(new ForeignKeyMetaData());
                    }
                    if (!StringUtils.isWhitespace((String)indexName)) {
                        IndexMetaData keyIdxmd = keymd.getIndexMetaData();
                        if (keyIdxmd == null) {
                            keyIdxmd = new IndexMetaData();
                            keymd.setIndexMetaData(keyIdxmd);
                        }
                        keyIdxmd.setName(indexName);
                    }
                    if (!StringUtils.isWhitespace((String)uniqueName)) {
                        UniqueMetaData keyUnimd = keymd.getUniqueMetaData();
                        if (keyUnimd == null) {
                            keyUnimd = new UniqueMetaData();
                            keymd.setUniqueMetaData(keyUnimd);
                        }
                        keyUnimd.setName(uniqueName);
                    }
                    if (keyColumns != null && keyColumns.length > 0) {
                        for (int j = 0; j < keyColumns.length; ++j) {
                            keymd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(keyColumns[j]));
                        }
                    }
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)keymd, (Extension[])annotationValues.get("extensions"));
                    Embedded[] embeddedMappings = (Embedded[])annotationValues.get("embeddedMapping");
                    if (embeddedMappings == null || embeddedMappings.length <= 0) continue;
                    embmd = new EmbeddedMetaData();
                    embmd.setOwnerMember(embeddedMappings[0].ownerMember());
                    embmd.setNullIndicatorColumn(embeddedMappings[0].nullIndicatorColumn());
                    embmd.setNullIndicatorValue(embeddedMappings[0].nullIndicatorValue());
                    keymd.setEmbeddedMetaData(embmd);
                    embeddedKeyMembers = embeddedMappings[0].members();
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.VALUE)) {
                    Class[] valueTypes = (Class[])annotationValues.get("types");
                    if (valueTypes != null && valueTypes.length > 0) {
                        valueType = valueTypes[0];
                    }
                    embeddedValue = (String)annotationValues.get("embedded");
                    serializedValue = (String)annotationValues.get("serialized");
                    dependentValue = (String)annotationValues.get("dependent");
                    String valueColumn = (String)annotationValues.get("column");
                    String valueDeleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                    String valueUpdateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("updateAction"));
                    String valueMappedBy = (String)annotationValues.get("mappedBy");
                    Column[] valueColumns = (Column[])annotationValues.get("columns");
                    fkName = (String)annotationValues.get("foreignKey");
                    generateFK = (String)annotationValues.get("generateForeignKey");
                    indexed = (String)annotationValues.get("indexed");
                    indexName = (String)annotationValues.get("index");
                    unique2 = (String)annotationValues.get("unique");
                    uniqueName = (String)annotationValues.get("uniqueKey");
                    if (!StringUtils.isWhitespace((String)uniqueName)) {
                        unique2 = "true";
                    }
                    if (!StringUtils.isWhitespace((String)indexName)) {
                        indexed = "true";
                    }
                    valuemd = new ValueMetaData();
                    valuemd.setColumnName(valueColumn);
                    valuemd.setDeleteAction(valueDeleteAction);
                    valuemd.setUpdateAction(valueUpdateAction);
                    valuemd.setIndexed(IndexedValue.getIndexedValue((String)indexed));
                    valuemd.setUnique(MetaDataUtils.getBooleanForString((String)unique2, (boolean)false));
                    valuemd.setMappedBy(valueMappedBy);
                    if (!StringUtils.isWhitespace((String)fkName)) {
                        ForeignKeyMetaData valueFkmd = valuemd.getForeignKeyMetaData();
                        if (valueFkmd == null) {
                            valueFkmd = new ForeignKeyMetaData();
                            valueFkmd.setName(fkName);
                            valuemd.setForeignKeyMetaData(valueFkmd);
                        } else {
                            valueFkmd.setName(fkName);
                        }
                    } else if (generateFK != null && generateFK.equalsIgnoreCase("true")) {
                        valuemd.setForeignKeyMetaData(new ForeignKeyMetaData());
                    }
                    if (!StringUtils.isWhitespace((String)indexName)) {
                        IndexMetaData valueIdxmd = valuemd.getIndexMetaData();
                        if (valueIdxmd == null) {
                            valueIdxmd = new IndexMetaData();
                            valuemd.setIndexMetaData(valueIdxmd);
                        }
                        valueIdxmd.setName(indexName);
                    }
                    if (!StringUtils.isWhitespace((String)uniqueName)) {
                        UniqueMetaData valueUnimd = valuemd.getUniqueMetaData();
                        if (valueUnimd == null) {
                            valueUnimd = new UniqueMetaData();
                            valuemd.setUniqueMetaData(valueUnimd);
                        }
                        valueUnimd.setName(uniqueName);
                    }
                    if (valueColumns != null && valueColumns.length > 0) {
                        for (int j = 0; j < valueColumns.length; ++j) {
                            valuemd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(valueColumns[j]));
                        }
                    }
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)valuemd, (Extension[])annotationValues.get("extensions"));
                    Embedded[] embeddedMappings = (Embedded[])annotationValues.get("embeddedMapping");
                    if (embeddedMappings == null || embeddedMappings.length <= 0) continue;
                    embmd = new EmbeddedMetaData();
                    embmd.setOwnerMember(embeddedMappings[0].ownerMember());
                    embmd.setNullIndicatorColumn(embeddedMappings[0].nullIndicatorColumn());
                    embmd.setNullIndicatorValue(embeddedMappings[0].nullIndicatorValue());
                    valuemd.setEmbeddedMetaData(embmd);
                    embeddedValueMembers = embeddedMappings[0].members();
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.ORDER)) {
                    String orderColumn = (String)annotationValues.get("column");
                    String orderMappedBy = (String)annotationValues.get("mappedBy");
                    Column[] orderColumns = (Column[])annotationValues.get("columns");
                    ordermd = new OrderMetaData();
                    ordermd.setColumnName(orderColumn);
                    ordermd.setMappedBy(orderMappedBy);
                    if (orderColumns != null && orderColumns.length > 0) {
                        for (int j = 0; j < orderColumns.length; ++j) {
                            ordermd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(orderColumns[j]));
                        }
                    }
                    JDOAnnotationUtils.addExtensionsToMetaData((MetaData)ordermd, (Extension[])annotationValues.get("extensions"));
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.EMBEDDED)) {
                    embeddedOwnerField = (String)annotationValues.get("ownerMember");
                    embeddedNullIndicatorColumn = (String)annotationValues.get("nullIndicatorColumn");
                    embeddedNullIndicatorValue = (String)annotationValues.get("nullIndicatorValue");
                    embeddedMembers = (Persistent[])annotationValues.get("members");
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.INDEX)) {
                    name = (String)annotationValues.get("name");
                    String table = (String)annotationValues.get("table");
                    unique = (String)annotationValues.get("unique");
                    String[] members = (String[])annotationValues.get("members");
                    columns = (Column[])annotationValues.get("columns");
                    idxmd = JDOAnnotationUtils.getIndexMetaData(name, table, unique, members, columns);
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.UNIQUE)) {
                    name = (String)annotationValues.get("name");
                    String table = (String)annotationValues.get("table");
                    String deferred = (String)annotationValues.get("deferred");
                    String[] members = (String[])annotationValues.get("members");
                    columns = (Column[])annotationValues.get("columns");
                    unimd = JDOAnnotationUtils.getUniqueMetaData(name, table, deferred, members, columns);
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.FOREIGNKEY)) {
                    name = (String)annotationValues.get("name");
                    String table = (String)annotationValues.get("table");
                    unique = (String)annotationValues.get("unique");
                    String deferred = (String)annotationValues.get("deferred");
                    String deleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("deleteAction"));
                    String updateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)annotationValues.get("updateAction"));
                    String[] members = (String[])annotationValues.get("members");
                    Column[] columns3 = (Column[])annotationValues.get("columns");
                    fkmd = JDOAnnotationUtils.getFKMetaData(name, table, unique, deferred, deleteAction, updateAction, members, columns3);
                    continue;
                }
                if (annName.equals("javax.jdo.annotations.Cacheable")) {
                    String cache = (String)annotationValues.get("value");
                    if (cache == null) continue;
                    cacheable = cache;
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.EXTENSIONS)) {
                    Extension[] values = (Extension[])annotationValues.get("value");
                    if (values == null || values.length <= 0) continue;
                    extensions = new HashSet<ExtensionMetaData>(values.length);
                    for (int j = 0; j < values.length; ++j) {
                        ExtensionMetaData extmd = new ExtensionMetaData(values[j].vendorName(), values[j].key().toString(), values[j].value().toString());
                        extensions.add(extmd);
                    }
                    continue;
                }
                if (annName.equals(JDOAnnotationUtils.EXTENSION)) {
                    ExtensionMetaData extmd = new ExtensionMetaData((String)annotationValues.get("vendorName"), (String)annotationValues.get("key"), (String)annotationValues.get("value"));
                    extensions = new HashSet(1);
                    extensions.add(extmd);
                    continue;
                }
                NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044211", (Object)cmd.getFullClassName(), (Object)member.getName(), (Object)annotations[i].getName()));
            }
            if (mmd == null && (transactionalField || nonPersistentField || primaryKey || colmds != null || serialised || embeddedOwnerField != null || embeddedNullIndicatorColumn != null || embeddedNullIndicatorValue != null || embeddedMembers != null || elemmd != null || keymd != null || valuemd != null || ordermd != null || idxmd != null || unimd != null || fkmd != null || joinmd != null || extensions != null)) {
                mmd = member.isProperty() ? new PropertyMetaData((MetaData)cmd, member.getName()) : new FieldMetaData((MetaData)cmd, member.getName());
                if (primaryKey) {
                    mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT);
                    mmd.setPrimaryKey(primaryKey);
                }
                if (serialised) {
                    mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT);
                }
            }
            if (mmd != null) {
                AbstractMemberMetaData embfmd;
                cmd.addMember(mmd);
                if (primaryKey) {
                    mmd.setPrimaryKey(true);
                }
                if (serialised) {
                    mmd.setSerialised(true);
                }
                if (nonPersistentField) {
                    mmd.setNotPersistent();
                }
                if (transactionalField) {
                    mmd.setTransactional();
                }
                if (embeddedOwnerField != null || embeddedNullIndicatorColumn != null || embeddedNullIndicatorValue != null || embeddedMembers != null) {
                    EmbeddedMetaData embmd = new EmbeddedMetaData();
                    embmd.setOwnerMember(embeddedOwnerField);
                    embmd.setNullIndicatorColumn(embeddedNullIndicatorColumn);
                    embmd.setNullIndicatorValue(embeddedNullIndicatorValue);
                    mmd.setEmbeddedMetaData(embmd);
                    if (embeddedMembers != null && embeddedMembers.length > 0) {
                        for (int j = 0; j < embeddedMembers.length; ++j) {
                            String memberName = embeddedMembers[j].name();
                            if (memberName.indexOf(46) > 0) {
                                memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                            }
                            AbstractMemberMetaData embfmd2 = this.getFieldMetaDataForPersistent((MetaData)embmd, (Persistent)embeddedMembers[j], this.isMemberOfClassAField(member.getType(), memberName));
                            embmd.addMember(embfmd2);
                        }
                    }
                }
                CollectionMetaData contmd = null;
                if (Collection.class.isAssignableFrom(member.getType())) {
                    Class collectionElementType = null;
                    StringBuilder elementTypeStr = new StringBuilder();
                    if (elementTypes != null && elementTypes.length > 0 && elementTypes[0] != Void.TYPE) {
                        for (int j = 0; j < elementTypes.length; ++j) {
                            if (elementTypeStr.length() > 0) {
                                elementTypeStr.append(',');
                            }
                            elementTypeStr.append(elementTypes[j].getName());
                        }
                        collectionElementType = elementTypes[0];
                    } else {
                        collectionElementType = ClassUtils.getCollectionElementType((Class)member.getType(), (Type)member.getGenericType());
                    }
                    CollectionMetaData collmd = contmd = new CollectionMetaData();
                    collmd.setElementType(elementTypeStr.toString());
                    if (!StringUtils.isWhitespace((String)embeddedElement)) {
                        collmd.setEmbeddedElement(Boolean.valueOf(embeddedElement).booleanValue());
                    }
                    if (!StringUtils.isWhitespace(serializedElement)) {
                        collmd.setSerializedElement(Boolean.valueOf(serializedElement).booleanValue());
                    }
                    if (!StringUtils.isWhitespace(dependentElement)) {
                        collmd.setDependentElement(Boolean.valueOf(dependentElement).booleanValue());
                    }
                    if ((embeddedElementMembers != null || "true".equalsIgnoreCase(embeddedElement)) && elemmd == null) {
                        elemmd = new ElementMetaData();
                        mmd.setElementMetaData(elemmd);
                    }
                    if ("true".equalsIgnoreCase(embeddedElement) && elemmd.getEmbeddedMetaData() == null) {
                        EmbeddedMetaData embmd = new EmbeddedMetaData();
                        elemmd.setEmbeddedMetaData(embmd);
                    }
                    if (embeddedElementMembers != null) {
                        EmbeddedMetaData embmd = elemmd.getEmbeddedMetaData();
                        for (int j = 0; j < embeddedElementMembers.length; ++j) {
                            String memberName = embeddedElementMembers[j].name();
                            if (memberName.indexOf(46) > 0) {
                                memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                            }
                            embfmd = this.getFieldMetaDataForPersistent((MetaData)embmd, (Persistent)embeddedElementMembers[j], this.isMemberOfClassAField(collectionElementType, memberName));
                            embmd.addMember(embfmd);
                        }
                    }
                } else if (member.getType().isArray()) {
                    StringBuilder elementTypeStr = new StringBuilder();
                    if (elementTypes != null && elementTypes.length > 0 && elementTypes[0] != Void.TYPE) {
                        for (int j = 0; j < elementTypes.length; ++j) {
                            if (elementTypeStr.length() > 0) {
                                elementTypeStr.append(',');
                            }
                            elementTypeStr.append(elementTypes[j].getName());
                        }
                    } else {
                        elementTypeStr.append(member.getType().getComponentType().getName());
                    }
                    contmd = new ArrayMetaData();
                    ArrayMetaData arrmd = (ArrayMetaData)contmd;
                    arrmd.setElementType(elementTypeStr.toString());
                    if (!StringUtils.isWhitespace((String)embeddedElement)) {
                        arrmd.setEmbeddedElement(Boolean.valueOf(embeddedElement).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)serializedElement)) {
                        arrmd.setSerializedElement(Boolean.valueOf(serializedElement).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)dependentElement)) {
                        arrmd.setDependentElement(Boolean.valueOf(dependentElement).booleanValue());
                    }
                } else if (Map.class.isAssignableFrom(member.getType())) {
                    Class mapKeyType = null;
                    mapKeyType = keyType != null && keyType != Void.TYPE ? keyType : ClassUtils.getMapKeyType((Class)member.getType(), (Type)member.getGenericType());
                    Class mapValueType = null;
                    mapValueType = valueType != null && valueType != Void.TYPE ? valueType : ClassUtils.getMapValueType((Class)member.getType(), (Type)member.getGenericType());
                    contmd = new MapMetaData();
                    MapMetaData mapmd = (MapMetaData)contmd;
                    mapmd.setKeyType(mapKeyType != null ? mapKeyType.getName() : null);
                    if (!StringUtils.isWhitespace((String)embeddedKey)) {
                        mapmd.setEmbeddedKey(Boolean.valueOf(embeddedKey).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)serializedKey)) {
                        mapmd.setSerializedKey(Boolean.valueOf(serializedKey).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)dependentKey)) {
                        mapmd.setDependentKey(Boolean.valueOf(dependentKey).booleanValue());
                    }
                    mapmd.setValueType(mapValueType != null ? mapValueType.getName() : null);
                    if (!StringUtils.isWhitespace((String)embeddedValue)) {
                        mapmd.setEmbeddedValue(Boolean.valueOf(embeddedValue).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)serializedValue)) {
                        mapmd.setSerializedValue(Boolean.valueOf(serializedValue).booleanValue());
                    }
                    if (!StringUtils.isWhitespace((String)dependentValue)) {
                        mapmd.setDependentValue(Boolean.valueOf(dependentValue).booleanValue());
                    }
                    if ((embeddedKeyMembers != null || "true".equalsIgnoreCase(embeddedKey)) && keymd == null) {
                        keymd = new KeyMetaData();
                        mmd.setKeyMetaData(keymd);
                    }
                    if ("true".equalsIgnoreCase(embeddedKey) && keymd.getEmbeddedMetaData() == null) {
                        EmbeddedMetaData embmd = new EmbeddedMetaData();
                        keymd.setEmbeddedMetaData(embmd);
                    }
                    if (embeddedKeyMembers != null) {
                        EmbeddedMetaData embmd = keymd.getEmbeddedMetaData();
                        for (int j = 0; j < embeddedKeyMembers.length; ++j) {
                            String memberName = embeddedKeyMembers[j].name();
                            if (memberName.indexOf(46) > 0) {
                                memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                            }
                            embfmd = this.getFieldMetaDataForPersistent((MetaData)embmd, (Persistent)embeddedKeyMembers[j], this.isMemberOfClassAField(mapKeyType, memberName));
                            embmd.addMember(embfmd);
                        }
                    }
                    if ((embeddedKeyMembers != null || "true".equalsIgnoreCase(embeddedKey)) && valuemd == null) {
                        valuemd = new ValueMetaData();
                        mmd.setValueMetaData(valuemd);
                    }
                    if ("true".equalsIgnoreCase(embeddedValue) && valuemd.getEmbeddedMetaData() == null) {
                        EmbeddedMetaData embmd = new EmbeddedMetaData();
                        valuemd.setEmbeddedMetaData(embmd);
                    }
                    if (embeddedValueMembers != null) {
                        EmbeddedMetaData embmd = valuemd.getEmbeddedMetaData();
                        for (int j = 0; j < embeddedValueMembers.length; ++j) {
                            String memberName = embeddedValueMembers[j].name();
                            if (memberName.indexOf(46) > 0) {
                                memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                            }
                            embfmd = this.getFieldMetaDataForPersistent((MetaData)embmd, (Persistent)embeddedValueMembers[j], this.isMemberOfClassAField(mapValueType, memberName));
                            embmd.addMember(embfmd);
                        }
                    }
                }
                if (contmd != null) {
                    mmd.setContainer(contmd);
                    if (elemmd != null) {
                        elemmd.setParent((MetaData)mmd);
                        mmd.setElementMetaData(elemmd);
                        if (elemmd.getMappedBy() != null && mmd.getMappedBy() == null) {
                            mmd.setMappedBy(elemmd.getMappedBy());
                        }
                    }
                    if (keymd != null) {
                        keymd.setParent((MetaData)mmd);
                        mmd.setKeyMetaData(keymd);
                    }
                    if (valuemd != null) {
                        valuemd.setParent((MetaData)mmd);
                        mmd.setValueMetaData(valuemd);
                    }
                    if (ordermd != null) {
                        ordermd.setParent((MetaData)mmd);
                        mmd.setOrderMetaData(ordermd);
                    }
                }
                if (joinmd != null) {
                    mmd.setJoinMetaData(joinmd);
                }
                if (colmds != null) {
                    for (int i = 0; i < colmds.length; ++i) {
                        mmd.addColumn(colmds[i]);
                    }
                }
                if (idxmd != null) {
                    mmd.setIndexMetaData(idxmd);
                }
                if (unimd != null) {
                    mmd.setUniqueMetaData(unimd);
                }
                if (fkmd != null) {
                    mmd.setForeignKeyMetaData(fkmd);
                }
                if (cacheable != null && cacheable.equalsIgnoreCase("false")) {
                    mmd.setCacheable(false);
                }
                if (extensions != null) {
                    for (ExtensionMetaData extmd : extensions) {
                        mmd.addExtension(extmd.getVendorName(), extmd.getKey(), extmd.getValue());
                    }
                }
            }
        }
        return mmd;
    }

    protected void processMethodAnnotations(AbstractClassMetaData cmd, Method method) {
    }

    private AbstractMemberMetaData getFieldMetaDataForPersistent(MetaData parent, Persistent member, boolean isField) {
        FieldPersistenceModifier modifier = JDOAnnotationUtils.getFieldPersistenceModifier(member.persistenceModifier());
        String nullValue = JDOAnnotationUtils.getNullValueString(member.nullValue());
        String valueStrategy = JDOAnnotationUtils.getIdentityStrategyString(member.valueStrategy());
        String fieldTypeName = null;
        Class[] fieldTypes = member.types();
        if (fieldTypes != null && fieldTypes.length > 0) {
            StringBuilder typeStr = new StringBuilder();
            for (int j = 0; j < fieldTypes.length; ++j) {
                if (typeStr.length() > 0) {
                    typeStr.append(',');
                }
                if (fieldTypes[j] == null || fieldTypes[j] == Void.TYPE) continue;
                typeStr.append(fieldTypes[j].getName());
            }
            fieldTypeName = typeStr.toString();
        }
        Object fmd = null;
        fmd = isField ? new FieldMetaData(parent, member.name()) : new PropertyMetaData(parent, member.name());
        if (modifier != null) {
            fmd.setPersistenceModifier(modifier);
        }
        if (!StringUtils.isWhitespace((String)member.defaultFetchGroup())) {
            fmd.setDefaultFetchGroup(Boolean.valueOf(member.defaultFetchGroup()).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)member.primaryKey())) {
            fmd.setPrimaryKey(Boolean.valueOf(member.primaryKey()).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)member.embedded())) {
            fmd.setEmbedded(Boolean.valueOf(member.embedded()).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)member.serialized())) {
            fmd.setSerialised(Boolean.valueOf(member.serialized()).booleanValue());
        }
        if (!StringUtils.isWhitespace((String)member.dependent())) {
            fmd.setDependent(Boolean.valueOf(member.dependent()).booleanValue());
        }
        fmd.setNullValue(org.datanucleus.metadata.NullValue.getNullValue((String)nullValue));
        fmd.setMappedBy(member.mappedBy());
        fmd.setColumn(member.column());
        fmd.setTable(member.table());
        fmd.setLoadFetchGroup(member.loadFetchGroup());
        fmd.setValueStrategy(valueStrategy);
        fmd.setSequence(member.sequence());
        fmd.setFieldTypes(fieldTypeName);
        Column[] columns = member.columns();
        if (columns != null && columns.length > 0) {
            for (int j = 0; j < columns.length; ++j) {
                fmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columns[j]));
            }
        }
        return fmd;
    }

    private boolean isMemberOfClassAField(Class cls, String memberName) {
        try {
            cls.getDeclaredField(memberName);
        }
        catch (NoSuchFieldException nsfe) {
            return false;
        }
        return true;
    }

    protected AnnotationObject isClassPersistenceCapable(Class cls) {
        AnnotationObject[] annotations = this.getClassAnnotationsForClass(cls);
        for (int i = 0; i < annotations.length; ++i) {
            String annClassName = annotations[i].getName();
            if (!annClassName.equals(JDOAnnotationUtils.PERSISTENCE_CAPABLE)) continue;
            return annotations[i];
        }
        return null;
    }

    protected boolean isClassPersistenceAware(Class cls) {
        AnnotationObject[] annotations = this.getClassAnnotationsForClass(cls);
        for (int i = 0; i < annotations.length; ++i) {
            String annName = annotations[i].getName();
            if (!annName.equals(JDOAnnotationUtils.PERSISTENCE_AWARE)) continue;
            return true;
        }
        return false;
    }

    protected boolean doesClassHaveNamedQueries(Class cls) {
        AnnotationObject[] annotations = this.getClassAnnotationsForClass(cls);
        for (int i = 0; i < annotations.length; ++i) {
            String annClassName = annotations[i].getName();
            if (!annClassName.equals(JDOAnnotationUtils.QUERIES) && !annClassName.equals(JDOAnnotationUtils.QUERY)) continue;
            return true;
        }
        return false;
    }
}

