/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.util.Arrays;
import org.apache.spark.sql.execution.vectorized.MutableColumnarRow;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.spark_project.guava.annotations.VisibleForTesting;

public class AggregateHashMap {
    private OnHeapColumnVector[] columnVectors;
    private MutableColumnarRow aggBufferRow;
    private int[] buckets;
    private int numBuckets;
    private int numRows = 0;
    private int maxSteps = 3;
    private static int DEFAULT_CAPACITY = 65536;
    private static double DEFAULT_LOAD_FACTOR = 0.25;
    private static int DEFAULT_MAX_STEPS = 3;

    public AggregateHashMap(StructType schema2, int capacity, double loadFactor, int maxSteps) {
        assert (schema2.size() == 2 && schema2.fields()[0].dataType() == DataTypes.LongType && schema2.fields()[1].dataType() == DataTypes.LongType);
        assert (capacity > 0 && (capacity & capacity - 1) == 0);
        this.maxSteps = maxSteps;
        this.numBuckets = (int)((double)capacity / loadFactor);
        this.columnVectors = OnHeapColumnVector.allocateColumns(capacity, schema2);
        this.aggBufferRow = new MutableColumnarRow(this.columnVectors);
        this.buckets = new int[this.numBuckets];
        Arrays.fill(this.buckets, -1);
    }

    public AggregateHashMap(StructType schema2) {
        this(schema2, DEFAULT_CAPACITY, DEFAULT_LOAD_FACTOR, DEFAULT_MAX_STEPS);
    }

    public MutableColumnarRow findOrInsert(long key) {
        int idx = this.find(key);
        if (idx != -1 && this.buckets[idx] == -1) {
            this.columnVectors[0].putLong(this.numRows, key);
            this.columnVectors[1].putLong(this.numRows, 0L);
            ++this.numRows;
        }
        this.aggBufferRow.rowId = this.buckets[idx];
        return this.aggBufferRow;
    }

    @VisibleForTesting
    public int find(long key) {
        long h = this.hash(key);
        int idx = (int)h & this.numBuckets - 1;
        for (int step = 0; step < this.maxSteps; ++step) {
            if (this.buckets[idx] == -1) {
                return idx;
            }
            if (this.equals(idx, key)) {
                return idx;
            }
            idx = idx + 1 & this.numBuckets - 1;
        }
        return -1;
    }

    private long hash(long key) {
        return key;
    }

    private boolean equals(int idx, long key1) {
        return this.columnVectors[0].getLong(this.buckets[idx]) == key1;
    }
}

