/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.IOException;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.UnsafeKVExternalSorter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.KVIterator;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.map.BytesToBytesMap;

public final class UnsafeFixedWidthAggregationMap {
    private final byte[] emptyAggregationBuffer;
    private final StructType aggregationBufferSchema;
    private final StructType groupingKeySchema;
    private final UnsafeProjection groupingKeyProjection;
    private final BytesToBytesMap map;
    private final UnsafeRow currentAggregationBuffer;

    public static boolean supportsAggregationBufferSchema(StructType schema2) {
        for (StructField field : schema2.fields()) {
            if (UnsafeRow.isMutable((DataType)field.dataType())) continue;
            return false;
        }
        return true;
    }

    public UnsafeFixedWidthAggregationMap(InternalRow emptyAggregationBuffer, StructType aggregationBufferSchema, StructType groupingKeySchema, TaskContext taskContext, int initialCapacity, long pageSizeBytes) {
        this.aggregationBufferSchema = aggregationBufferSchema;
        this.currentAggregationBuffer = new UnsafeRow(aggregationBufferSchema.length());
        this.groupingKeyProjection = UnsafeProjection.create((StructType)groupingKeySchema);
        this.groupingKeySchema = groupingKeySchema;
        this.map = new BytesToBytesMap(taskContext.taskMemoryManager(), initialCapacity, pageSizeBytes, true);
        UnsafeProjection valueProjection = UnsafeProjection.create((StructType)aggregationBufferSchema);
        this.emptyAggregationBuffer = valueProjection.apply(emptyAggregationBuffer).getBytes();
        taskContext.addTaskCompletionListener(context -> this.free());
    }

    public UnsafeRow getAggregationBuffer(InternalRow groupingKey) {
        UnsafeRow unsafeGroupingKeyRow = this.groupingKeyProjection.apply(groupingKey);
        return this.getAggregationBufferFromUnsafeRow(unsafeGroupingKeyRow);
    }

    public UnsafeRow getAggregationBufferFromUnsafeRow(UnsafeRow key) {
        return this.getAggregationBufferFromUnsafeRow(key, key.hashCode());
    }

    public UnsafeRow getAggregationBufferFromUnsafeRow(UnsafeRow key, int hash2) {
        boolean putSucceeded;
        BytesToBytesMap.Location loc = this.map.lookup(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), hash2);
        if (!loc.isDefined() && !(putSucceeded = loc.append(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), (Object)this.emptyAggregationBuffer, (long)Platform.BYTE_ARRAY_OFFSET, this.emptyAggregationBuffer.length))) {
            return null;
        }
        this.currentAggregationBuffer.pointTo(loc.getValueBase(), loc.getValueOffset(), loc.getValueLength());
        return this.currentAggregationBuffer;
    }

    public KVIterator<UnsafeRow, UnsafeRow> iterator() {
        return new KVIterator<UnsafeRow, UnsafeRow>(){
            private final BytesToBytesMap.MapIterator mapLocationIterator;
            private final UnsafeRow key;
            private final UnsafeRow value;
            {
                this.mapLocationIterator = UnsafeFixedWidthAggregationMap.this.map.destructiveIterator();
                this.key = new UnsafeRow(UnsafeFixedWidthAggregationMap.this.groupingKeySchema.length());
                this.value = new UnsafeRow(UnsafeFixedWidthAggregationMap.this.aggregationBufferSchema.length());
            }

            public boolean next() {
                if (this.mapLocationIterator.hasNext()) {
                    BytesToBytesMap.Location loc = this.mapLocationIterator.next();
                    this.key.pointTo(loc.getKeyBase(), loc.getKeyOffset(), loc.getKeyLength());
                    this.value.pointTo(loc.getValueBase(), loc.getValueOffset(), loc.getValueLength());
                    return true;
                }
                return false;
            }

            public UnsafeRow getKey() {
                return this.key;
            }

            public UnsafeRow getValue() {
                return this.value;
            }

            public void close() {
            }
        };
    }

    public long getPeakMemoryUsedBytes() {
        return this.map.getPeakMemoryUsedBytes();
    }

    public void free() {
        this.map.free();
    }

    public double getAverageProbesPerLookup() {
        return this.map.getAverageProbesPerLookup();
    }

    public UnsafeKVExternalSorter destructAndCreateExternalSorter() throws IOException {
        return new UnsafeKVExternalSorter(this.groupingKeySchema, this.aggregationBufferSchema, SparkEnv.get().blockManager(), SparkEnv.get().serializerManager(), this.map.getPageSizeBytes(), (Integer)SparkEnv.get().conf().get(package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD()), this.map);
    }
}

