/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.classification.DecisionTreeClassifier;
import org.apache.spark.ml.feature.IndexToString;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.DecisionTreeClassifierWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;

public final class DecisionTreeClassifierWrapper$
implements MLReadable<DecisionTreeClassifierWrapper> {
    public static final DecisionTreeClassifierWrapper$ MODULE$;
    private final String PREDICTED_LABEL_INDEX_COL;
    private final String PREDICTED_LABEL_COL;

    static {
        new DecisionTreeClassifierWrapper$();
    }

    public String PREDICTED_LABEL_INDEX_COL() {
        return this.PREDICTED_LABEL_INDEX_COL;
    }

    public String PREDICTED_LABEL_COL() {
        return this.PREDICTED_LABEL_COL;
    }

    public DecisionTreeClassifierWrapper fit(Dataset<Row> data, String formula, int maxDepth, int maxBins, String impurity, int minInstancesPerNode, double minInfoGain, int checkpointInterval, String seed, int maxMemoryInMB, boolean cacheNodeIds, String handleInvalid) {
        RFormula rFormula = new RFormula().setFormula(formula).setForceIndexLabel(true).setHandleInvalid(handleInvalid);
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        Tuple2<String[], String[]> tuple2 = RWrapperUtils$.MODULE$.getFeaturesAndLabels((RFormulaModel)rFormulaModel, data);
        if (tuple2 != null) {
            Tuple2 tuple22;
            String[] features = (String[])tuple2._1();
            String[] labels = (String[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)features, (Object)labels);
            String[] features2 = (String[])tuple23._1();
            String[] labels2 = (String[])tuple23._2();
            DecisionTreeClassifier dtc = (DecisionTreeClassifier)((Predictor)((Predictor)new DecisionTreeClassifier().setMaxDepth(maxDepth).setMaxBins(maxBins).setImpurity(impurity).setMinInstancesPerNode(minInstancesPerNode).setMinInfoGain(minInfoGain).setCheckpointInterval(checkpointInterval).setMaxMemoryInMB(maxMemoryInMB).setCacheNodeIds(cacheNodeIds).setFeaturesCol(rFormula.getFeaturesCol())).setLabelCol(rFormula.getLabelCol())).setPredictionCol(this.PREDICTED_LABEL_INDEX_COL());
            Object object = seed != null && seed.length() > 0 ? dtc.setSeed(new StringOps(Predef$.MODULE$.augmentString(seed)).toLong()) : BoxedUnit.UNIT;
            IndexToString idxToStr = new IndexToString().setInputCol(this.PREDICTED_LABEL_INDEX_COL()).setOutputCol(this.PREDICTED_LABEL_COL()).setLabels(labels2);
            Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, dtc, idxToStr})).fit((Dataset)data);
            return new DecisionTreeClassifierWrapper((PipelineModel)pipeline, formula, features2);
        }
        throw new MatchError(tuple2);
    }

    @Override
    public MLReader<DecisionTreeClassifierWrapper> read() {
        return new DecisionTreeClassifierWrapper.DecisionTreeClassifierWrapperReader();
    }

    @Override
    public DecisionTreeClassifierWrapper load(String path) {
        return (DecisionTreeClassifierWrapper)MLReadable$class.load(this, path);
    }

    private DecisionTreeClassifierWrapper$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
        this.PREDICTED_LABEL_INDEX_COL = "pred_label_idx";
        this.PREDICTED_LABEL_COL = "prediction";
    }
}

