/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.util.UUID;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;

public final class StructuredKafkaWordCount$ {
    public static final StructuredKafkaWordCount$ MODULE$;

    static {
        new StructuredKafkaWordCount$();
    }

    public void main(String[] args) {
        String[] stringArray;
        Option option;
        if (args.length < 3) {
            System.err.println("Usage: StructuredKafkaWordCount <bootstrap-servers> <subscribe-type> <topics> [<checkpoint-location>]");
            System.exit(1);
        }
        if (!(option = Array$.MODULE$.unapplySeq((Object)(stringArray = args))).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) >= 0) {
            Tuple3 tuple3;
            String bootstrapServers = (String)((SeqLike)option.get()).apply(0);
            String subscribeType = (String)((SeqLike)option.get()).apply(1);
            String topics = (String)((SeqLike)option.get()).apply(2);
            Tuple3 tuple32 = tuple3 = new Tuple3((Object)bootstrapServers, (Object)subscribeType, (Object)topics);
            String bootstrapServers2 = (String)tuple32._1();
            String subscribeType2 = (String)tuple32._2();
            String topics2 = (String)tuple32._3();
            String checkpointLocation = args.length > 3 ? args[3] : new StringBuilder().append((Object)"/tmp/temporary-").append((Object)UUID.randomUUID().toString()).toString();
            SparkSession spark = SparkSession$.MODULE$.builder().appName("StructuredKafkaWordCount").getOrCreate();
            Dataset lines = spark.readStream().format("kafka").option("kafka.bootstrap.servers", bootstrapServers2).option(subscribeType2, topics2).load().selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(value AS STRING)"})).as(spark.implicits().newStringEncoder());
            Dataset wordCounts = lines.flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<String> apply(String x$2) {
                    return Predef$.MODULE$.refArrayOps((Object[])x$2.split(" "));
                }
            }, spark.implicits().newStringEncoder()).groupBy("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
            StreamingQuery query = wordCounts.writeStream().outputMode("complete").format("console").option("checkpointLocation", checkpointLocation).start();
            query.awaitTermination();
            return;
        }
        throw new MatchError((Object)stringArray);
    }

    private StructuredKafkaWordCount$() {
        MODULE$ = this;
    }
}

