/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.MovieLensALS;
import org.apache.spark.examples.mllib.MovieLensALS$Params$;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BitSet;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scopt.OptionParser;
import scopt.Read$;

public final class MovieLensALS$ {
    public static final MovieLensALS$ MODULE$;

    static {
        new MovieLensALS$();
    }

    public void main(String[] args) {
        MovieLensALS.Params defaultParams = new MovieLensALS.Params(MovieLensALS$Params$.MODULE$.apply$default$1(), MovieLensALS$Params$.MODULE$.apply$default$2(), MovieLensALS$Params$.MODULE$.apply$default$3(), MovieLensALS$Params$.MODULE$.apply$default$4(), MovieLensALS$Params$.MODULE$.apply$default$5(), MovieLensALS$Params$.MODULE$.apply$default$6(), MovieLensALS$Params$.MODULE$.apply$default$7(), MovieLensALS$Params$.MODULE$.apply$default$8());
        OptionParser<MovieLensALS.Params> parser = new OptionParser<MovieLensALS.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MovieLensALS: an example app for ALS on MovieLens data."}));
                this.opt("rank", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rank, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.rank())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(int x, MovieLensALS.Params c) {
                        int x$5 = x;
                        String x$6 = c.copy$default$1();
                        boolean x$7 = c.copy$default$2();
                        int x$8 = c.copy$default$3();
                        double x$9 = c.copy$default$4();
                        int x$10 = c.copy$default$6();
                        int x$11 = c.copy$default$7();
                        boolean x$12 = c.copy$default$8();
                        return c.copy(x$6, x$7, x$8, x$9, x$5, x$10, x$11, x$12);
                    }
                });
                this.opt("numIterations", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of iterations, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.numIterations())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(int x, MovieLensALS.Params c) {
                        int x$13 = x;
                        String x$14 = c.copy$default$1();
                        boolean x$15 = c.copy$default$2();
                        double x$16 = c.copy$default$4();
                        int x$17 = c.copy$default$5();
                        int x$18 = c.copy$default$6();
                        int x$19 = c.copy$default$7();
                        boolean x$20 = c.copy$default$8();
                        return c.copy(x$14, x$15, x$13, x$16, x$17, x$18, x$19, x$20);
                    }
                });
                this.opt("lambda", Read$.MODULE$.doubleRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lambda (smoothing constant), default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.lambda())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(double x, MovieLensALS.Params c) {
                        double x$21 = x;
                        String x$22 = c.copy$default$1();
                        boolean x$23 = c.copy$default$2();
                        int x$24 = c.copy$default$3();
                        int x$25 = c.copy$default$5();
                        int x$26 = c.copy$default$6();
                        int x$27 = c.copy$default$7();
                        boolean x$28 = c.copy$default$8();
                        return c.copy(x$22, x$23, x$24, x$21, x$25, x$26, x$27, x$28);
                    }
                });
                this.opt("kryo", Read$.MODULE$.unitRead()).text("use Kryo serialization").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(BoxedUnit x$1, MovieLensALS.Params c) {
                        boolean x$29 = true;
                        String x$30 = c.copy$default$1();
                        int x$31 = c.copy$default$3();
                        double x$32 = c.copy$default$4();
                        int x$33 = c.copy$default$5();
                        int x$34 = c.copy$default$6();
                        int x$35 = c.copy$default$7();
                        boolean x$36 = c.copy$default$8();
                        return c.copy(x$30, x$29, x$31, x$32, x$33, x$34, x$35, x$36);
                    }
                });
                this.opt("numUserBlocks", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of user blocks, default: ", " (auto)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.numUserBlocks())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(int x, MovieLensALS.Params c) {
                        int x$37 = x;
                        String x$38 = c.copy$default$1();
                        boolean x$39 = c.copy$default$2();
                        int x$40 = c.copy$default$3();
                        double x$41 = c.copy$default$4();
                        int x$42 = c.copy$default$5();
                        int x$43 = c.copy$default$7();
                        boolean x$44 = c.copy$default$8();
                        return c.copy(x$38, x$39, x$40, x$41, x$42, x$37, x$43, x$44);
                    }
                });
                this.opt("numProductBlocks", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of product blocks, default: ", " (auto)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.numProductBlocks())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(int x, MovieLensALS.Params c) {
                        int x$45 = x;
                        String x$46 = c.copy$default$1();
                        boolean x$47 = c.copy$default$2();
                        int x$48 = c.copy$default$3();
                        double x$49 = c.copy$default$4();
                        int x$50 = c.copy$default$5();
                        int x$51 = c.copy$default$6();
                        boolean x$52 = c.copy$default$8();
                        return c.copy(x$46, x$47, x$48, x$49, x$50, x$51, x$45, x$52);
                    }
                });
                this.opt("implicitPrefs", Read$.MODULE$.unitRead()).text("use implicit preference").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(BoxedUnit x$2, MovieLensALS.Params c) {
                        boolean x$53 = true;
                        String x$54 = c.copy$default$1();
                        boolean x$55 = c.copy$default$2();
                        int x$56 = c.copy$default$3();
                        double x$57 = c.copy$default$4();
                        int x$58 = c.copy$default$5();
                        int x$59 = c.copy$default$6();
                        int x$60 = c.copy$default$7();
                        return c.copy(x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$53);
                    }
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).required().text("input paths to a MovieLens dataset of ratings").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MovieLensALS.Params apply(String x, MovieLensALS.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8());
                    }
                });
                this.note(new StringOps(Predef$.MODULE$.augmentString("\n          |For example, the following command runs this app on a synthetic dataset:\n          |\n          | bin/spark-submit --class org.apache.spark.examples.mllib.MovieLensALS \\\n          |  examples/target/scala-*/spark-examples-*.jar \\\n          |  --rank 5 --numIterations 20 --lambda 1.0 --kryo \\\n          |  data/mllib/sample_movielens_data.txt\n        ")).stripMargin());
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            MovieLensALS.Params params = (MovieLensALS.Params)some.x();
            this.run(params);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw scala.sys.package$.MODULE$.exit(1);
    }

    public void run(MovieLensALS.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MovieLensALS with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        Object object = params.kryo() ? conf.registerKryoClasses((Class[])((Object[])new Class[]{BitSet.class, Rating.class})).set("spark.kryoserializer.buffer", "8m") : BoxedUnit.UNIT;
        SparkContext sc = new SparkContext(conf);
        Logger.getRootLogger().setLevel(Level.WARN);
        boolean implicitPrefs = params.implicitPrefs();
        RDD ratings = sc.textFile(params.input(), sc.textFile$default$2()).map((Function1)new Serializable(implicitPrefs){
            public static final long serialVersionUID = 0L;
            private final boolean implicitPrefs$1;

            public final Rating apply(String line) {
                String[] fields = line.split("::");
                return this.implicitPrefs$1 ? new Rating(new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[2])).toDouble() - 2.5) : new Rating(new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[2])).toDouble());
            }
            {
                this.implicitPrefs$1 = implicitPrefs$1;
            }
        }, ClassTag$.MODULE$.apply(Rating.class)).cache();
        long numRatings = ratings.count();
        long numUsers = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Rating x$3) {
                return x$3.user();
            }
        }, ClassTag$.MODULE$.Int()).distinct().count();
        long numMovies = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Rating x$4) {
                return x$4.product();
            }
        }, ClassTag$.MODULE$.Int()).distinct().count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ", " ratings from ", " users on ", " movies."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numRatings), BoxesRunTime.boxToLong((long)numUsers), BoxesRunTime.boxToLong((long)numMovies)})));
        RDD[] splits = ratings.randomSplit(new double[]{0.8, 0.2}, ratings.randomSplit$default$2());
        RDD training = splits[0].cache();
        RDD test = params.implicitPrefs() ? splits[1].map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Rating apply(Rating x) {
                return new Rating(x.user(), x.product(), x.rating() > 0.0 ? 1.0 : 0.0);
            }
        }, ClassTag$.MODULE$.apply(Rating.class)) : splits[1].cache();
        long numTraining = training.count();
        long numTest = test.count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training: ", ", test: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numTraining), BoxesRunTime.boxToLong((long)numTest)})));
        ratings.unpersist(false);
        MatrixFactorizationModel model = new ALS().setRank(params.rank()).setIterations(params.numIterations()).setLambda(params.lambda()).setImplicitPrefs(params.implicitPrefs()).setUserBlocks(params.numUserBlocks()).setProductBlocks(params.numProductBlocks()).run(training);
        double rmse2 = this.computeRmse(model, (RDD<Rating>)test, params.implicitPrefs());
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test RMSE = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rmse2)})));
        sc.stop();
    }

    public double computeRmse(MatrixFactorizationModel model, RDD<Rating> data, boolean implicitPrefs) {
        RDD predictions = model.predict(data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Rating x) {
                return new Tuple2.mcII.sp(x.user(), x.product());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        RDD predictionsAndRatings = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(predictions.map((Function1)new Serializable(implicitPrefs){
            public static final long serialVersionUID = 0L;
            private final boolean implicitPrefs$2;

            public final Tuple2<Tuple2<Object, Object>, Object> apply(Rating x) {
                return new Tuple2((Object)new Tuple2.mcII.sp(x.user(), x.product()), (Object)BoxesRunTime.boxToDouble((double)MovieLensALS$.MODULE$.org$apache$spark$examples$mllib$MovieLensALS$$mapPredictedRating$1(x.rating(), this.implicitPrefs$2)));
            }
            {
                this.implicitPrefs$2 = implicitPrefs$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).join(data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Object> apply(Rating x) {
                return new Tuple2((Object)new Tuple2.mcII.sp(x.user(), x.product()), (Object)BoxesRunTime.boxToDouble((double)x.rating()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).values();
        return package$.MODULE$.sqrt(RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(predictionsAndRatings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x) {
                return (x._1$mcD$sp() - x._2$mcD$sp()) * (x._1$mcD$sp() - x._2$mcD$sp());
            }
        }, ClassTag$.MODULE$.Double())).mean());
    }

    public final double org$apache$spark$examples$mllib$MovieLensALS$$mapPredictedRating$1(double r, boolean implicitPrefs$2) {
        return implicitPrefs$2 ? package$.MODULE$.max(package$.MODULE$.min(r, 1.0), 0.0) : r;
    }

    private MovieLensALS$() {
        MODULE$ = this;
    }
}

