/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator$class;
import org.apache.spark.mllib.util.MLUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005-a!B\u0001\u0003\u0001\u0019q!A\u0005'pO&\u001cH/[2BO\u001e\u0014XmZ1u_JT!a\u0001\u0003\u0002\u0015\u0005<wM]3hCR|'O\u0003\u0002\u0006\r\u0005)q\u000e\u001d;j[*\u0011q\u0001C\u0001\u0003[2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0005\u0001=)\u0002\u0005\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0005-]Ir$D\u0001\u0003\u0013\tA\"A\u0001\u000fES\u001a4WM]3oi&\f'\r\\3M_N\u001c\u0018iZ4sK\u001e\fGo\u001c:\u0011\u0005iiR\"A\u000e\u000b\u0005q1\u0011a\u00024fCR,(/Z\u0005\u0003=m\u0011\u0001\"\u00138ti\u0006t7-\u001a\t\u0003-\u0001\u0001\"!\t\u0013\u000e\u0003\tR!a\t\u0005\u0002\u0011%tG/\u001a:oC2L!!\n\u0012\u0003\u000f1{wmZ5oO\"Aq\u0005\u0001B\u0001B\u0003%\u0011&A\u0007cG\u001a+\u0017\r^;sKN\u001cF\u000fZ\u0002\u0001!\rQSfL\u0007\u0002W)\u0011A\u0006C\u0001\nEJ|\u0017\rZ2bgRL!AL\u0016\u0003\u0013\t\u0013x.\u00193dCN$\bc\u0001\t1e%\u0011\u0011'\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003!MJ!\u0001N\t\u0003\r\u0011{WO\u00197f\u0011!1\u0004A!A!\u0002\u00139\u0014A\u00038v[\u000ec\u0017m]:fgB\u0011\u0001\u0003O\u0005\u0003sE\u00111!\u00138u\u0011!Y\u0004A!A!\u0002\u0013a\u0014\u0001\u00044ji&sG/\u001a:dKB$\bC\u0001\t>\u0013\tq\u0014CA\u0004C_>dW-\u00198\t\u0011\u0001\u0003!\u0011!Q\u0001\nq\n1\"\\;mi&tw.\\5bY\"A!\t\u0001B\u0001B\u0003%1)\u0001\bcG\u000e{WM\u001a4jG&,g\u000e^:\u0011\u0007)jC\t\u0005\u0002F\u00116\taI\u0003\u0002H\r\u00051A.\u001b8bY\u001eL!!\u0013$\u0003\rY+7\r^8s\u0011\u0015Y\u0005\u0001\"\u0001M\u0003\u0019a\u0014N\\5u}Q)Qj\u0014)R%R\u0011qD\u0014\u0005\u0006\u0005*\u0003\ra\u0011\u0005\u0006O)\u0003\r!\u000b\u0005\u0006m)\u0003\ra\u000e\u0005\u0006w)\u0003\r\u0001\u0010\u0005\u0006\u0001*\u0003\r\u0001\u0010\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003-qW/\u001c$fCR,(/Z:\u0016\u0003]Baa\u0016\u0001!\u0002\u00139\u0014\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003bB-\u0001\u0005\u0004%I!V\u0001\u0019]Vlg)Z1ukJ,7\u000f\u00157vg&sG/\u001a:dKB$\bBB.\u0001A\u0003%q'A\rok64U-\u0019;ve\u0016\u001c\b\u000b\\;t\u0013:$XM]2faR\u0004\u0003bB/\u0001\u0005\u0004%I!V\u0001\u0010G>,gMZ5dS\u0016tGoU5{K\"1q\f\u0001Q\u0001\n]\n\u0001cY8fM\u001aL7-[3oiNK'0\u001a\u0011\t\u000f\u0005\u0004!\u0019!C)+\u0006\u0019A-[7\t\r\r\u0004\u0001\u0015!\u00038\u0003\u0011!\u0017.\u001c\u0011\t\u0011\u0015\u0004\u0001R1A\u0005\n\u0019\f\u0011cY8fM\u001aL7-[3oiN\f%O]1z+\u0005y\u0003\u0002\u00035\u0001\u0011\u0003\u0005\u000b\u0015B\u0018\u0002%\r|WM\u001a4jG&,g\u000e^:BeJ\f\u0017\u0010\t\u0015\u0003O*\u0004\"\u0001E6\n\u00051\f\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u0015q\u0007\u0001\"\u0003p\u0003M\u0011\u0017N\\1ssV\u0003H-\u0019;f\u0013:\u0004F.Y2f)\u0011\u00018/^<\u0011\u0005A\t\u0018B\u0001:\u0012\u0005\u0011)f.\u001b;\t\u000bQl\u0007\u0019\u0001#\u0002\u0011\u0019,\u0017\r^;sKNDQA^7A\u0002I\naa^3jO\"$\b\"\u0002=n\u0001\u0004\u0011\u0014!\u00027bE\u0016d\u0007\"\u0002>\u0001\t\u0013Y\u0018\u0001G7vYRLgn\\7jC2,\u0006\u000fZ1uK&s\u0007\u000b\\1dKR!\u0001\u000f`?\u007f\u0011\u0015!\u0018\u00101\u0001E\u0011\u00151\u0018\u00101\u00013\u0011\u0015A\u0018\u00101\u00013\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007\t1!\u00193e)\u0011\t)!a\u0002\u000e\u0003\u0001Aa!!\u0003\u0000\u0001\u0004I\u0012\u0001C5ogR\fgnY3")
public class LogisticAggregator
implements DifferentiableLossAggregator<Instance, LogisticAggregator>,
Logging {
    private final Broadcast<double[]> bcFeaturesStd;
    public final int org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses;
    private final boolean fitIntercept;
    private final boolean multinomial;
    private final Broadcast<Vector> bcCoefficients;
    private final int org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeatures;
    private final int org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeaturesPlusIntercept;
    private final int org$apache$spark$ml$optim$aggregator$LogisticAggregator$$coefficientSize;
    private final int dim;
    private transient double[] coefficientsArray;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private double weightSum;
    private double lossSum;
    private final double[] gradientSumArray;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    private double[] coefficientsArray$lzycompute() {
        LogisticAggregator logisticAggregator = this;
        synchronized (logisticAggregator) {
            block5: {
                if (!this.bitmap$trans$0) {
                    double[] values;
                    DenseVector denseVector;
                    Option option;
                    Vector vector = (Vector)this.bcCoefficients.value();
                    if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) break block5;
                    double[] dArray = values = (double[])option.get();
                    this.coefficientsArray = dArray;
                    this.bitmap$trans$0 = true;
                }
                return this.coefficientsArray;
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients only supports dense vector but "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"got type ", ".)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bcCoefficients.value().getClass()}))).toString());
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    @Override
    public double weightSum() {
        return this.weightSum;
    }

    @Override
    @TraitSetter
    public void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    @Override
    public double lossSum() {
        return this.lossSum;
    }

    @Override
    @TraitSetter
    public void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        LogisticAggregator logisticAggregator = this;
        synchronized (logisticAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = DifferentiableLossAggregator$class.gradientSumArray(this);
                this.bitmap$0 = true;
            }
            return this.gradientSumArray;
        }
    }

    @Override
    public double[] gradientSumArray() {
        return this.bitmap$0 ? this.gradientSumArray : this.gradientSumArray$lzycompute();
    }

    @Override
    public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
        return DifferentiableLossAggregator$class.merge(this, other);
    }

    @Override
    public Vector gradient() {
        return DifferentiableLossAggregator$class.gradient(this);
    }

    @Override
    public double weight() {
        return DifferentiableLossAggregator$class.weight(this);
    }

    @Override
    public double loss() {
        return DifferentiableLossAggregator$class.loss(this);
    }

    public int org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeatures() {
        return this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeatures;
    }

    public int org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeaturesPlusIntercept() {
        return this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeaturesPlusIntercept;
    }

    public int org$apache$spark$ml$optim$aggregator$LogisticAggregator$$coefficientSize() {
        return this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$coefficientSize;
    }

    @Override
    public int dim() {
        return this.dim;
    }

    private double[] coefficientsArray() {
        return this.bitmap$trans$0 ? this.coefficientsArray : this.coefficientsArray$lzycompute();
    }

    private void binaryUpdateInPlace(Vector features, double weight, double label) {
        double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
        double[] localCoefficients = this.coefficientsArray();
        double[] localGradientArray = this.gradientSumArray();
        DoubleRef sum = DoubleRef.create((double)0.0);
        features.foreachActive((Function2)new Serializable(this, localFeaturesStd, localCoefficients, sum){
            public static final long serialVersionUID = 0L;
            private final double[] localFeaturesStd$1;
            private final double[] localCoefficients$1;
            private final DoubleRef sum$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                    this.sum$1.elem += this.localCoefficients$1[index2] * value / this.localFeaturesStd$1[index2];
                }
            }
            {
                this.localFeaturesStd$1 = localFeaturesStd$1;
                this.localCoefficients$1 = localCoefficients$1;
                this.sum$1 = sum$1;
            }
        });
        if (this.fitIntercept) {
            sum.elem += localCoefficients[this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeaturesPlusIntercept() - 1];
        }
        double margin = -sum.elem;
        double multiplier = weight * (1.0 / (1.0 + package$.MODULE$.exp(margin)) - label);
        features.foreachActive((Function2)new Serializable(this, localFeaturesStd, localGradientArray, multiplier){
            public static final long serialVersionUID = 0L;
            private final double[] localFeaturesStd$1;
            private final double[] localGradientArray$1;
            private final double multiplier$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                    this.localGradientArray$1[index2] = this.localGradientArray$1[index2] + this.multiplier$1 * value / this.localFeaturesStd$1[index2];
                }
            }
            {
                this.localFeaturesStd$1 = localFeaturesStd$1;
                this.localGradientArray$1 = localGradientArray$1;
                this.multiplier$1 = multiplier$1;
            }
        });
        if (this.fitIntercept) {
            int n = this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeaturesPlusIntercept() - 1;
            localGradientArray[n] = localGradientArray[n] + multiplier;
        }
        if (label > 0.0) {
            this.lossSum_$eq(this.lossSum() + weight * MLUtils$.MODULE$.log1pExp(margin));
        } else {
            this.lossSum_$eq(this.lossSum() + weight * (MLUtils$.MODULE$.log1pExp(margin) - margin));
        }
    }

    private void multinomialUpdateInPlace(Vector features, double weight, double label) {
        double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
        double[] localCoefficients = this.coefficientsArray();
        double[] localGradientArray = this.gradientSumArray();
        double marginOfLabel = 0.0;
        double maxMargin = Double.NEGATIVE_INFINITY;
        double[] margins = new double[this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses];
        features.foreachActive((Function2)new Serializable(this, localFeaturesStd, localCoefficients, margins){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticAggregator $outer;
            private final double[] localFeaturesStd$2;
            private final double[] localCoefficients$2;
            private final double[] margins$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                if (this.localFeaturesStd$2[index2] != 0.0 && value != 0.0) {
                    double stdValue = value / this.localFeaturesStd$2[index2];
                    for (int j = 0; j < this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses; ++j) {
                        int n = j;
                        this.margins$1[n] = this.margins$1[n] + this.localCoefficients$2[index2 * this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses + j] * stdValue;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.localFeaturesStd$2 = localFeaturesStd$2;
                this.localCoefficients$2 = localCoefficients$2;
                this.margins$1 = margins$1;
            }
        });
        for (int i = 0; i < this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses; ++i) {
            if (this.fitIntercept) {
                int n = i;
                margins[n] = margins[n] + localCoefficients[this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses * this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeatures() + i];
            }
            if (i == (int)label) {
                marginOfLabel = margins[i];
            }
            if (!(margins[i] > maxMargin)) continue;
            maxMargin = margins[i];
        }
        double[] multipliers = new double[this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses];
        double temp = 0.0;
        for (int i = 0; i < this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses; ++i) {
            if (maxMargin > 0.0) {
                int n = i;
                margins[n] = margins[n] - maxMargin;
            }
            double exp = package$.MODULE$.exp(margins[i]);
            temp += exp;
            multipliers[i] = exp;
        }
        double sum = temp;
        Predef$.MODULE$.doubleArrayOps(margins).indices().foreach$mVc$sp((Function1)new Serializable(this, label, multipliers, sum){
            public static final long serialVersionUID = 0L;
            private final double label$1;
            private final double[] multipliers$1;
            private final double sum$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.multipliers$1[i] = this.multipliers$1[i] / this.sum$2 - (this.label$1 == (double)i ? 1.0 : 0.0);
            }
            {
                this.label$1 = label$1;
                this.multipliers$1 = multipliers$1;
                this.sum$2 = sum$2;
            }
        });
        features.foreachActive((Function2)new Serializable(this, weight, localFeaturesStd, localGradientArray, multipliers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticAggregator $outer;
            private final double weight$1;
            private final double[] localFeaturesStd$2;
            private final double[] localGradientArray$2;
            private final double[] multipliers$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                if (this.localFeaturesStd$2[index2] != 0.0 && value != 0.0) {
                    double stdValue = value / this.localFeaturesStd$2[index2];
                    for (int j = 0; j < this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses; ++j) {
                        int n = index2 * this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses + j;
                        this.localGradientArray$2[n] = this.localGradientArray$2[n] + this.weight$1 * this.multipliers$1[j] * stdValue;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.weight$1 = weight$1;
                this.localFeaturesStd$2 = localFeaturesStd$2;
                this.localGradientArray$2 = localGradientArray$2;
                this.multipliers$1 = multipliers$1;
            }
        });
        if (this.fitIntercept) {
            for (int i = 0; i < this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses; ++i) {
                int n = this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeatures() * this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses + i;
                localGradientArray[n] = localGradientArray[n] + weight * multipliers[i];
            }
        }
        double loss2 = maxMargin > 0.0 ? package$.MODULE$.log(sum) - marginOfLabel + maxMargin : package$.MODULE$.log(sum) - marginOfLabel;
        this.lossSum_$eq(this.lossSum() + weight * loss2);
    }

    @Override
    public LogisticAggregator add(Instance instance) {
        Instance instance2 = instance;
        if (instance2 != null) {
            double label = instance2.label();
            double weight = instance2.weight();
            Vector features = instance2.features();
            Predef$.MODULE$.require(this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeatures() == features.size(), (Function0)new Serializable(this, features){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticAggregator $outer;
                private final Vector features$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimensions mismatch when adding new instance."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Expecting ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeatures()), BoxesRunTime.boxToInteger((int)this.features$1.size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.features$1 = features$1;
                }
            });
            Predef$.MODULE$.require(weight >= 0.0, (Function0)new Serializable(this, weight){
                public static final long serialVersionUID = 0L;
                private final double weight$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"instance weight, ", " has to be >= 0.0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.weight$2)}));
                }
                {
                    this.weight$2 = weight$2;
                }
            });
            if (weight == 0.0) {
                return this;
            }
            if (this.multinomial) {
                this.multinomialUpdateInPlace(features, weight, label);
            } else {
                this.binaryUpdateInPlace(features, weight, label);
            }
            this.weightSum_$eq(this.weightSum() + weight);
            LogisticAggregator logisticAggregator = this;
            return logisticAggregator;
        }
        throw new MatchError((Object)instance2);
    }

    public LogisticAggregator(Broadcast<double[]> bcFeaturesStd, int numClasses, boolean fitIntercept, boolean multinomial, Broadcast<Vector> bcCoefficients) {
        this.bcFeaturesStd = bcFeaturesStd;
        this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses = numClasses;
        this.fitIntercept = fitIntercept;
        this.multinomial = multinomial;
        this.bcCoefficients = bcCoefficients;
        DifferentiableLossAggregator$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeatures = ((double[])bcFeaturesStd.value()).length;
        this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeaturesPlusIntercept = fitIntercept ? this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeatures() + 1 : this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeatures();
        this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$coefficientSize = ((Vector)bcCoefficients.value()).size();
        this.dim = this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$coefficientSize();
        if (multinomial) {
            Predef$.MODULE$.require(numClasses == this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$coefficientSize() / this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeaturesPlusIntercept(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticAggregator $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients should be ", " but was ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses * this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeaturesPlusIntercept())), BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$coefficientSize())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            Predef$.MODULE$.require(this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$coefficientSize() == this.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeaturesPlusIntercept(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticAggregator $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numFeaturesPlusIntercept())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$coefficientSize())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Predef$.MODULE$.require(numClasses == 1 || numClasses == 2, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticAggregator $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Binary logistic aggregator requires numClasses "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in {1, 2} but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$ml$optim$aggregator$LogisticAggregator$$numClasses)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (multinomial && numClasses <= 2) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multinomial logistic regression for binary classification yields separate "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients for positive and negative classes. When no regularization is applied, the"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result will be effectively the same as binary logistic regression. When regularization"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is applied, multinomial loss will produce a result different from binary loss."})).s((Seq)Nil$.MODULE$)).toString();
                }
            });
        }
    }
}

