/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesEmptyDirVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesHostPathVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesPVCVolumeConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$$anonfun$parseVolumesWithPrefix$1$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class KubernetesVolumeUtils$ {
    public static final KubernetesVolumeUtils$ MODULE$;

    static {
        new KubernetesVolumeUtils$();
    }

    public Iterable<Try<KubernetesVolumeSpec<? extends KubernetesVolumeSpecificConf>>> parseVolumesWithPrefix(SparkConf sparkConf, String prefix) {
        Map properties = Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAllWithPrefix(prefix)).toMap(Predef$.MODULE$.$conforms());
        return (Iterable)this.getVolumeTypesAndNames((Map<String, String>)properties).map((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            public final Map properties$1;

            public final Try<KubernetesVolumeSpec<KubernetesVolumeSpecificConf>> apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String volumeType = (String)tuple2._1();
                    String volumeName = (String)tuple2._2();
                    String pathKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{volumeType, volumeName, Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_PATH_KEY()}));
                    String readOnlyKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{volumeType, volumeName, Config$.MODULE$.KUBERNETES_VOLUMES_MOUNT_READONLY_KEY()}));
                    Try try_ = KubernetesVolumeUtils$.MODULE$.org$apache$spark$deploy$k8s$KubernetesVolumeUtils$$MapOps(this.properties$1).getTry(pathKey).flatMap((Function1)new Serializable(this, volumeType, volumeName, readOnlyKey){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.parseVolumesWithPrefix.1 $outer;
                        private final String volumeType$1;
                        public final String volumeName$1;
                        public final String readOnlyKey$1;

                        public final Try<KubernetesVolumeSpec<KubernetesVolumeSpecificConf>> apply(String path) {
                            return KubernetesVolumeUtils$.MODULE$.org$apache$spark$deploy$k8s$KubernetesVolumeUtils$$parseVolumeSpecificConf((Map<String, String>)this.$outer.properties$1, this.volumeType$1, this.volumeName$1).map((Function1)new Serializable(this, path){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$parseVolumesWithPrefix$1$$anonfun$apply$1 $outer;
                                private final String path$1;

                                public final KubernetesVolumeSpec<KubernetesVolumeSpecificConf> apply(KubernetesVolumeSpecificConf volumeConf) {
                                    return new KubernetesVolumeSpec<KubernetesVolumeSpecificConf>(this.$outer.volumeName$1, this.path$1, this.$outer.org$apache$spark$deploy$k8s$KubernetesVolumeUtils$$anonfun$$anonfun$$$outer().properties$1.get((Object)this.$outer.readOnlyKey$1).exists((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(String x$1) {
                                            return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
                                        }
                                    }), volumeConf);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.path$1 = path$1;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.parseVolumesWithPrefix.1 org$apache$spark$deploy$k8s$KubernetesVolumeUtils$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.volumeType$1 = volumeType$1;
                            this.volumeName$1 = volumeName$1;
                            this.readOnlyKey$1 = readOnlyKey$1;
                        }
                    });
                    return try_;
                }
                throw new MatchError(tuple2);
            }
            {
                this.properties$1 = properties$1;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private Set<Tuple2<String, String>> getVolumeTypesAndNames(Map<String, String> properties) {
        return ((TraversableOnce)properties.keys().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Iterable<Tuple2<String, String>> apply(String k) {
                List list = Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(k)).split('.')).toList();
                if (!(list instanceof .colon.colon)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                .colon.colon colon2 = (.colon.colon)list;
                String tpe = (String)colon2.head();
                List list2 = colon2.tl$1();
                if (!(list2 instanceof .colon.colon)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                .colon.colon colon3 = (.colon.colon)list2;
                String name = (String)colon3.head();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)tpe, (Object)name)));
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    public Try<KubernetesVolumeSpecificConf> org$apache$spark$deploy$k8s$KubernetesVolumeUtils$$parseVolumeSpecificConf(Map<String, String> options, String volumeType, String volumeName) {
        Failure failure;
        String string = volumeType;
        String string2 = Config$.MODULE$.KUBERNETES_VOLUMES_HOSTPATH_TYPE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String pathKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{volumeType, volumeName, Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_PATH_KEY()}));
            failure = this.org$apache$spark$deploy$k8s$KubernetesVolumeUtils$$MapOps(options).getTry(pathKey).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final KubernetesHostPathVolumeConf apply(String path) {
                    return new KubernetesHostPathVolumeConf(path);
                }
            });
        } else {
            String string4 = Config$.MODULE$.KUBERNETES_VOLUMES_PVC_TYPE();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                String claimNameKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{volumeType, volumeName, Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_CLAIM_NAME_KEY()}));
                failure = this.org$apache$spark$deploy$k8s$KubernetesVolumeUtils$$MapOps(options).getTry(claimNameKey).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final KubernetesPVCVolumeConf apply(String claimName) {
                        return new KubernetesPVCVolumeConf(claimName);
                    }
                });
            } else {
                String string6 = Config$.MODULE$.KUBERNETES_VOLUMES_EMPTYDIR_TYPE();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    String mediumKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{volumeType, volumeName, Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_MEDIUM_KEY()}));
                    String sizeLimitKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{volumeType, volumeName, Config$.MODULE$.KUBERNETES_VOLUMES_OPTIONS_SIZE_LIMIT_KEY()}));
                    failure = new Success((Object)new KubernetesEmptyDirVolumeConf((Option<String>)options.get((Object)mediumKey), (Option<String>)options.get((Object)sizeLimitKey)));
                } else {
                    failure = new Failure((Throwable)new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kubernetes Volume type `", "` is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{volumeType}))));
                }
            }
        }
        return failure;
    }

    public <A, B> KubernetesVolumeUtils.MapOps<A, B> org$apache$spark$deploy$k8s$KubernetesVolumeUtils$$MapOps(Map<A, B> m) {
        return new KubernetesVolumeUtils.MapOps<A, B>(m);
    }

    private KubernetesVolumeUtils$() {
        MODULE$ = this;
    }
}

