/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.util.Permutation;

public class ProjectMergeRule
extends RelOptRule {
    public static final ProjectMergeRule INSTANCE = new ProjectMergeRule();
    private final boolean force;
    private final RelFactories.ProjectFactory projectFactory;

    private ProjectMergeRule() {
        this(false, RelFactories.DEFAULT_PROJECT_FACTORY);
    }

    public ProjectMergeRule(boolean force, RelFactories.ProjectFactory projectFactory) {
        super(ProjectMergeRule.operand(Project.class, ProjectMergeRule.operand(Project.class, ProjectMergeRule.any()), new RelOptRuleOperand[0]), "ProjectMergeRule" + (force ? ":force_mode" : ""));
        this.force = force;
        this.projectFactory = projectFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        RexBuilder rexBuilder = topProject.getCluster().getRexBuilder();
        Permutation topPermutation = topProject.getPermutation();
        if (topPermutation != null) {
            if (topPermutation.isIdentity()) {
                return;
            }
            Permutation bottomPermutation = bottomProject.getPermutation();
            if (bottomPermutation != null) {
                if (bottomPermutation.isIdentity()) {
                    return;
                }
                Permutation product = topPermutation.product(bottomPermutation);
                call.transformTo(RelOptUtil.projectMapping(bottomProject.getInput(), product.inverse(), topProject.getRowType().getFieldNames(), this.projectFactory));
                return;
            }
        }
        if (!this.force && RelOptUtil.checkProjAndChildInputs(topProject, false)) {
            return;
        }
        RexProgram bottomProgram = RexProgram.create(bottomProject.getInput().getRowType(), bottomProject.getProjects(), null, bottomProject.getRowType(), rexBuilder);
        List<RexNode> projects = topProject.getProjects();
        RexProgram topProgram = RexProgram.create(bottomProject.getRowType(), projects, null, topProject.getRowType(), rexBuilder);
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        int projectCount = projects.size();
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
        List<RexLocalRef> projectRefs = mergedProgram.getProjectList();
        for (int i = 0; i < projectCount; ++i) {
            newProjects.add(mergedProgram.expandLocalRef(projectRefs.get(i)));
        }
        RelNode newProjectRel = this.projectFactory.createProject(bottomProject.getInput(), newProjects, topProject.getRowType().getFieldNames());
        call.transformTo(newProjectRel);
    }
}

