/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.ImmutableBitSet;

public abstract class BuiltInMetadata {

    static interface All
    extends Selectivity,
    UniqueKeys,
    RowCount,
    DistinctRowCount,
    PercentageOriginalRows,
    ColumnUniqueness,
    ColumnOrigin,
    Predicates,
    Collation,
    Distribution,
    Size,
    Parallelism,
    Memory {
    }

    public static interface Memory
    extends Metadata {
        public Double memory();

        public Double cumulativeMemoryWithinPhase();

        public Double cumulativeMemoryWithinPhaseSplit();
    }

    public static interface Parallelism
    extends Metadata {
        public Boolean isPhaseTransition();

        public Integer splitCount();
    }

    public static interface Predicates
    extends Metadata {
        public RelOptPredicateList getPredicates();
    }

    public static interface ExplainVisibility
    extends Metadata {
        public Boolean isVisibleInExplain(SqlExplainLevel var1);
    }

    public static interface NonCumulativeCost
    extends Metadata {
        public RelOptCost getNonCumulativeCost();
    }

    public static interface CumulativeCost
    extends Metadata {
        public RelOptCost getCumulativeCost();
    }

    public static interface ColumnOrigin
    extends Metadata {
        public Set<RelColumnOrigin> getColumnOrigins(int var1);
    }

    public static interface Size
    extends Metadata {
        public Double averageRowSize();

        public List<Double> averageColumnSizes();
    }

    public static interface PopulationSize
    extends Metadata {
        public Double getPopulationSize(ImmutableBitSet var1);
    }

    public static interface PercentageOriginalRows
    extends Metadata {
        public Double getPercentageOriginalRows();
    }

    public static interface DistinctRowCount
    extends Metadata {
        public Double getDistinctRowCount(ImmutableBitSet var1, RexNode var2);
    }

    public static interface RowCount
    extends Metadata {
        public Double getRowCount();
    }

    public static interface Distribution
    extends Metadata {
        public RelDistribution distribution();
    }

    public static interface Collation
    extends Metadata {
        public ImmutableList<RelCollation> collations();
    }

    public static interface ColumnUniqueness
    extends Metadata {
        public Boolean areColumnsUnique(ImmutableBitSet var1, boolean var2);
    }

    public static interface UniqueKeys
    extends Metadata {
        public Set<ImmutableBitSet> getUniqueKeys(boolean var1);
    }

    public static interface Selectivity
    extends Metadata {
        public Double getSelectivity(RexNode var1);
    }
}

