/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;

public enum SqlTypeFamily implements RelDataTypeFamily
{
    CHARACTER,
    BINARY,
    NUMERIC,
    DATE,
    TIME,
    TIMESTAMP,
    BOOLEAN,
    INTERVAL_YEAR_MONTH,
    INTERVAL_DAY_TIME,
    STRING,
    APPROXIMATE_NUMERIC,
    EXACT_NUMERIC,
    INTEGER,
    DATETIME,
    DATETIME_INTERVAL,
    MULTISET,
    ARRAY,
    MAP,
    NULL,
    ANY,
    CURSOR,
    COLUMN_LIST;

    private static final Map<Integer, SqlTypeFamily> JDBC_TYPE_TO_FAMILY;

    public static SqlTypeFamily getFamilyForJdbcType(int jdbcType) {
        return JDBC_TYPE_TO_FAMILY.get(jdbcType);
    }

    public List<SqlTypeName> getTypeNames() {
        switch (this) {
            case CHARACTER: {
                return SqlTypeName.CHAR_TYPES;
            }
            case BINARY: {
                return SqlTypeName.BINARY_TYPES;
            }
            case NUMERIC: {
                return SqlTypeName.NUMERIC_TYPES;
            }
            case DATE: {
                return ImmutableList.of((Object)((Object)SqlTypeName.DATE));
            }
            case TIME: {
                return ImmutableList.of((Object)((Object)SqlTypeName.TIME));
            }
            case TIMESTAMP: {
                return ImmutableList.of((Object)((Object)SqlTypeName.TIMESTAMP));
            }
            case BOOLEAN: {
                return SqlTypeName.BOOLEAN_TYPES;
            }
            case INTERVAL_YEAR_MONTH: {
                return ImmutableList.of((Object)((Object)SqlTypeName.INTERVAL_YEAR_MONTH));
            }
            case INTERVAL_DAY_TIME: {
                return ImmutableList.of((Object)((Object)SqlTypeName.INTERVAL_DAY_TIME));
            }
            case STRING: {
                return SqlTypeName.STRING_TYPES;
            }
            case APPROXIMATE_NUMERIC: {
                return SqlTypeName.APPROX_TYPES;
            }
            case EXACT_NUMERIC: {
                return SqlTypeName.EXACT_TYPES;
            }
            case INTEGER: {
                return SqlTypeName.INT_TYPES;
            }
            case DATETIME: {
                return SqlTypeName.DATETIME_TYPES;
            }
            case DATETIME_INTERVAL: {
                return SqlTypeName.INTERVAL_TYPES;
            }
            case MULTISET: {
                return ImmutableList.of((Object)((Object)SqlTypeName.MULTISET));
            }
            case ARRAY: {
                return ImmutableList.of((Object)((Object)SqlTypeName.ARRAY));
            }
            case MAP: {
                return ImmutableList.of((Object)((Object)SqlTypeName.MAP));
            }
            case NULL: {
                return ImmutableList.of((Object)((Object)SqlTypeName.NULL));
            }
            case ANY: {
                return SqlTypeName.ALL_TYPES;
            }
            case CURSOR: {
                return ImmutableList.of((Object)((Object)SqlTypeName.CURSOR));
            }
            case COLUMN_LIST: {
                return ImmutableList.of((Object)((Object)SqlTypeName.COLUMN_LIST));
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean contains(RelDataType type) {
        return SqlTypeUtil.isOfSameTypeName(this.getTypeNames(), type);
    }

    static {
        JDBC_TYPE_TO_FAMILY = ImmutableMap.builder().put((Object)-7, (Object)NUMERIC).put((Object)-6, (Object)NUMERIC).put((Object)5, (Object)NUMERIC).put((Object)-5, (Object)NUMERIC).put((Object)4, (Object)NUMERIC).put((Object)2, (Object)NUMERIC).put((Object)3, (Object)NUMERIC).put((Object)6, (Object)NUMERIC).put((Object)7, (Object)NUMERIC).put((Object)8, (Object)NUMERIC).put((Object)1, (Object)CHARACTER).put((Object)12, (Object)CHARACTER).put((Object)-1, (Object)CHARACTER).put((Object)2005, (Object)CHARACTER).put((Object)-2, (Object)BINARY).put((Object)-3, (Object)BINARY).put((Object)-4, (Object)BINARY).put((Object)2004, (Object)BINARY).put((Object)91, (Object)DATE).put((Object)92, (Object)TIME).put((Object)93, (Object)TIMESTAMP).put((Object)16, (Object)BOOLEAN).put((Object)2012, (Object)CURSOR).put((Object)2003, (Object)ARRAY).build();
    }
}

