/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.io.Writable;

public class CustomVertexConfiguration
implements Writable {
    private int numBuckets;
    private TezWork.VertexType vertexType = TezWork.VertexType.AUTO_INITIALIZED_EDGES;
    private int numInputs;
    private String inputName;

    public CustomVertexConfiguration() {
    }

    public CustomVertexConfiguration(int numBuckets, TezWork.VertexType vertexType) {
        this(numBuckets, vertexType, "", 1);
    }

    public CustomVertexConfiguration(int numBuckets, TezWork.VertexType vertexType, String inputName, int numInputs) {
        this.numBuckets = numBuckets;
        this.vertexType = vertexType;
        this.numInputs = numInputs;
        this.inputName = inputName;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.vertexType.ordinal());
        out.writeInt(this.numBuckets);
        out.writeInt(this.numInputs);
        out.writeUTF(this.inputName);
    }

    public void readFields(DataInput in) throws IOException {
        this.vertexType = TezWork.VertexType.values()[in.readInt()];
        this.numBuckets = in.readInt();
        this.numInputs = in.readInt();
        this.inputName = in.readUTF();
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public TezWork.VertexType getVertexType() {
        return this.vertexType;
    }

    public String getInputName() {
        return this.inputName;
    }

    public int getNumInputs() {
        return this.numInputs;
    }
}

