/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;

public class RelMdUniqueKeys {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.UNIQUE_KEYS.method, new RelMdUniqueKeys());

    private RelMdUniqueKeys() {
    }

    public Set<ImmutableBitSet> getUniqueKeys(Filter rel, boolean ignoreNulls) {
        return RelMetadataQuery.getUniqueKeys(rel.getInput(), ignoreNulls);
    }

    public Set<ImmutableBitSet> getUniqueKeys(Sort rel, boolean ignoreNulls) {
        return RelMetadataQuery.getUniqueKeys(rel.getInput(), ignoreNulls);
    }

    public Set<ImmutableBitSet> getUniqueKeys(Correlate rel, boolean ignoreNulls) {
        return RelMetadataQuery.getUniqueKeys(rel.getLeft(), ignoreNulls);
    }

    public Set<ImmutableBitSet> getUniqueKeys(Project rel, boolean ignoreNulls) {
        HashMap<Integer, Integer> mapInToOutPos = new HashMap<Integer, Integer>();
        List<RexNode> projExprs = rel.getProjects();
        HashSet<ImmutableBitSet> projUniqueKeySet = new HashSet<ImmutableBitSet>();
        for (int i = 0; i < projExprs.size(); ++i) {
            RexNode projExpr = projExprs.get(i);
            if (!(projExpr instanceof RexInputRef)) continue;
            mapInToOutPos.put(((RexInputRef)projExpr).getIndex(), i);
        }
        if (mapInToOutPos.isEmpty()) {
            return projUniqueKeySet;
        }
        Set<ImmutableBitSet> childUniqueKeySet = RelMetadataQuery.getUniqueKeys(rel.getInput(), ignoreNulls);
        if (childUniqueKeySet != null) {
            for (ImmutableBitSet colMask : childUniqueKeySet) {
                ImmutableBitSet.Builder tmpMask = ImmutableBitSet.builder();
                boolean completeKeyProjected = true;
                for (int bit : BitSets.toIter(colMask)) {
                    if (mapInToOutPos.containsKey(bit)) {
                        tmpMask.set((Integer)mapInToOutPos.get(bit));
                        continue;
                    }
                    completeKeyProjected = false;
                    break;
                }
                if (!completeKeyProjected) continue;
                projUniqueKeySet.add(tmpMask.build());
            }
        }
        return projUniqueKeySet;
    }

    public Set<ImmutableBitSet> getUniqueKeys(Join rel, boolean ignoreNulls) {
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        HashSet<ImmutableBitSet> retSet = new HashSet<ImmutableBitSet>();
        Set<ImmutableBitSet> leftSet = RelMetadataQuery.getUniqueKeys(left, ignoreNulls);
        HashSet<ImmutableBitSet> rightSet = null;
        Set<ImmutableBitSet> tmpRightSet = RelMetadataQuery.getUniqueKeys(right, ignoreNulls);
        int nFieldsOnLeft = left.getRowType().getFieldCount();
        if (tmpRightSet != null) {
            rightSet = new HashSet<ImmutableBitSet>();
            for (ImmutableBitSet colMask : tmpRightSet) {
                ImmutableBitSet.Builder tmpMask = ImmutableBitSet.builder();
                for (int bit : colMask) {
                    tmpMask.set(bit + nFieldsOnLeft);
                }
                rightSet.add(tmpMask.build());
            }
            if (leftSet != null) {
                for (ImmutableBitSet colMaskRight : rightSet) {
                    for (ImmutableBitSet colMaskLeft : leftSet) {
                        retSet.add(colMaskLeft.union(colMaskRight));
                    }
                }
            }
        }
        JoinInfo joinInfo = rel.analyzeCondition();
        Boolean leftUnique = RelMetadataQuery.areColumnsUnique(left, joinInfo.leftSet(), ignoreNulls);
        Boolean rightUnique = RelMetadataQuery.areColumnsUnique(right, joinInfo.rightSet(), ignoreNulls);
        if (rightUnique != null && rightUnique.booleanValue() && leftSet != null && !rel.getJoinType().generatesNullsOnLeft()) {
            retSet.addAll(leftSet);
        }
        if (leftUnique != null && leftUnique.booleanValue() && rightSet != null && !rel.getJoinType().generatesNullsOnRight()) {
            retSet.addAll(rightSet);
        }
        return retSet;
    }

    public Set<ImmutableBitSet> getUniqueKeys(SemiJoin rel, boolean ignoreNulls) {
        return RelMetadataQuery.getUniqueKeys(rel.getLeft(), ignoreNulls);
    }

    public Set<ImmutableBitSet> getUniqueKeys(Aggregate rel, boolean ignoreNulls) {
        return ImmutableSet.of((Object)rel.getGroupSet());
    }

    public Set<ImmutableBitSet> getUniqueKeys(RelNode rel, boolean ignoreNulls) {
        return null;
    }
}

