/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;

public class RelMdSelectivity {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.SELECTIVITY.method, new RelMdSelectivity());

    protected RelMdSelectivity() {
    }

    public Double getSelectivity(Union rel, RexNode predicate) {
        if (rel.getInputs().size() == 0 || predicate == null) {
            return 1.0;
        }
        double sumRows = 0.0;
        double sumSelectedRows = 0.0;
        int[] adjustments = new int[rel.getRowType().getFieldCount()];
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        for (RelNode input : rel.getInputs()) {
            Double nRows = RelMetadataQuery.getRowCount(input);
            if (nRows == null) {
                return null;
            }
            RexNode modifiedPred = predicate.accept(new RelOptUtil.RexInputConverter(rexBuilder, null, input.getRowType().getFieldList(), adjustments));
            double sel = RelMetadataQuery.getSelectivity(input, modifiedPred);
            sumRows += nRows.doubleValue();
            sumSelectedRows += nRows * sel;
        }
        if (sumRows < 1.0) {
            sumRows = 1.0;
        }
        return sumSelectedRows / sumRows;
    }

    public Double getSelectivity(Sort rel, RexNode predicate) {
        return RelMetadataQuery.getSelectivity(rel.getInput(), predicate);
    }

    public Double getSelectivity(Filter rel, RexNode predicate) {
        if (predicate != null) {
            return RelMetadataQuery.getSelectivity(rel.getInput(), RelMdUtil.minusPreds(rel.getCluster().getRexBuilder(), predicate, rel.getCondition()));
        }
        return RelMetadataQuery.getSelectivity(rel.getInput(), rel.getCondition());
    }

    public Double getSelectivity(SemiJoin rel, RexNode predicate) {
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode newPred = RelMdUtil.makeSemiJoinSelectivityRexNode(rel);
        if (predicate != null) {
            newPred = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newPred, predicate);
        }
        return RelMetadataQuery.getSelectivity(rel.getLeft(), newPred);
    }

    public Double getSelectivity(Aggregate rel, RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(rel.getGroupSet(), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        Double selectivity = RelMetadataQuery.getSelectivity(rel.getInput(), childPred);
        if (selectivity == null) {
            return null;
        }
        RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return selectivity * RelMdUtil.guessSelectivity(pred);
    }

    public Double getSelectivity(Project rel, RexNode predicate) {
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(ImmutableBitSet.range(rel.getRowType().getFieldCount()), predicate, pushable, notPushable);
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RexNode childPred = RexUtil.composeConjunction(rexBuilder, pushable, true);
        RexNode modifiedPred = childPred == null ? null : RelOptUtil.pushFilterPastProject(childPred, rel);
        Double selectivity = RelMetadataQuery.getSelectivity(rel.getInput(), modifiedPred);
        if (selectivity == null) {
            return null;
        }
        RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
        return selectivity * RelMdUtil.guessSelectivity(pred);
    }

    public Double getSelectivity(RelNode rel, RexNode predicate) {
        return RelMdUtil.guessSelectivity(predicate);
    }
}

