/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.AggregateFunction;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class CalciteCatalogReader
implements Prepare.CatalogReader,
SqlOperatorTable {
    final CalciteSchema rootSchema;
    final JavaTypeFactory typeFactory;
    private final List<String> defaultSchema;
    private final boolean elideRecord = true;
    private final boolean caseSensitive;

    public CalciteCatalogReader(CalciteSchema rootSchema, boolean caseSensitive, List<String> defaultSchema, JavaTypeFactory typeFactory) {
        assert (rootSchema != defaultSchema);
        this.rootSchema = rootSchema;
        this.caseSensitive = caseSensitive;
        this.defaultSchema = defaultSchema;
        this.typeFactory = typeFactory;
    }

    @Override
    public CalciteCatalogReader withSchemaPath(List<String> schemaPath) {
        return new CalciteCatalogReader(this.rootSchema, this.caseSensitive, schemaPath, this.typeFactory);
    }

    @Override
    public RelOptTableImpl getTable(List<String> names) {
        RelOptTableImpl table;
        if (this.defaultSchema != null && (table = this.getTableFrom(names, this.defaultSchema)) != null) {
            return table;
        }
        return this.getTableFrom(names, (List<String>)ImmutableList.of());
    }

    private RelOptTableImpl getTableFrom(List<String> names, List<String> schemaNames) {
        CalciteSchema schema = this.getSchema(Iterables.concat(schemaNames, Util.skipLast(names)));
        if (schema == null) {
            return null;
        }
        String name = Util.last(names);
        Pair<String, Table> pair = schema.getTable(name, this.caseSensitive);
        if (pair == null) {
            pair = schema.getTableBasedOnNullaryFunction(name, this.caseSensitive);
        }
        if (pair != null) {
            Table table = pair.getValue();
            String name2 = pair.getKey();
            return RelOptTableImpl.create((RelOptSchema)this, table.getRowType(this.typeFactory), schema.add(name2, table), null);
        }
        return null;
    }

    private Collection<org.apache.calcite.schema.Function> getFunctionsFrom(List<String> names) {
        CalciteSchema schema;
        ArrayList functions2 = Lists.newArrayList();
        Object schemaNameList = names.size() > 1 ? ImmutableList.of((Object)ImmutableList.of()) : ((schema = this.getSchema(this.defaultSchema)) == null ? ImmutableList.of() : schema.getPath());
        for (List schemaNames : schemaNameList) {
            CalciteSchema schema2 = this.getSchema(Iterables.concat((Iterable)schemaNames, Util.skipLast(names)));
            if (schema2 == null) continue;
            String name = Util.last(names);
            functions2.addAll(schema2.getFunctions(name, true));
        }
        return functions2;
    }

    private CalciteSchema getSchema(Iterable<String> schemaNames) {
        CalciteSchema schema = this.rootSchema;
        for (String schemaName : schemaNames) {
            if ((schema = schema.getSubSchema(schemaName, this.caseSensitive)) != null) continue;
            return null;
        }
        return schema;
    }

    @Override
    public RelDataType getNamedType(SqlIdentifier typeName) {
        return null;
    }

    @Override
    public List<SqlMoniker> getAllSchemaObjectNames(List<String> names) {
        CalciteSchema schema = this.getSchema(names);
        if (schema == null) {
            return ImmutableList.of();
        }
        ArrayList<SqlMoniker> result = new ArrayList<SqlMoniker>();
        NavigableMap<String, CalciteSchema> schemaMap = schema.getSubSchemaMap();
        for (String subSchema : schemaMap.keySet()) {
            result.add(new SqlMonikerImpl(schema.path(subSchema), SqlMonikerType.SCHEMA));
        }
        for (String table : schema.getTableNames()) {
            result.add(new SqlMonikerImpl(schema.path(table), SqlMonikerType.TABLE));
        }
        NavigableSet<String> functions = schema.getFunctionNames();
        for (String function : functions) {
            result.add(new SqlMonikerImpl(schema.path(function), SqlMonikerType.FUNCTION));
        }
        return result;
    }

    @Override
    public List<String> getSchemaName() {
        return this.defaultSchema;
    }

    @Override
    public RelOptTableImpl getTableForMember(List<String> names) {
        return this.getTable((List)names);
    }

    @Override
    public RelDataTypeField field(RelDataType rowType, String alias) {
        return SqlValidatorUtil.lookupField(this.caseSensitive, true, rowType, alias);
    }

    @Override
    public int fieldOrdinal(RelDataType rowType, String alias) {
        RelDataTypeField field = this.field(rowType, alias);
        return field != null ? field.getIndex() : -1;
    }

    @Override
    public boolean matches(String string, String name) {
        return Util.matches(this.caseSensitive, string, name);
    }

    @Override
    public int match(List<String> strings, String name) {
        return Util.findMatch(strings, name, this.caseSensitive);
    }

    @Override
    public RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList) {
        return SqlValidatorUtil.createTypeFromProjection(type, columnNameList, this.typeFactory, this.caseSensitive, true);
    }

    @Override
    public void lookupOperatorOverloads(final SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        if (syntax != SqlSyntax.FUNCTION) {
            return;
        }
        Collection<org.apache.calcite.schema.Function> functions = this.getFunctionsFrom((List<String>)opName.names);
        if (functions.isEmpty()) {
            return;
        }
        operatorList.addAll(Collections2.transform(functions, (Function)new Function<org.apache.calcite.schema.Function, SqlOperator>(){

            public SqlOperator apply(org.apache.calcite.schema.Function function) {
                return CalciteCatalogReader.this.toOp(opName, function);
            }
        }));
    }

    private SqlOperator toOp(SqlIdentifier name, org.apache.calcite.schema.Function function) {
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        ArrayList<SqlTypeFamily> typeFamilies = new ArrayList<SqlTypeFamily>();
        for (FunctionParameter o : function.getParameters()) {
            RelDataType type = o.getType(this.typeFactory);
            argTypes.add(type);
            typeFamilies.add(Util.first(type.getSqlTypeName().getFamily(), SqlTypeFamily.ANY));
        }
        if (function instanceof ScalarFunction) {
            return new SqlUserDefinedFunction(name, (SqlReturnTypeInference)ReturnTypes.explicit(Schemas.proto((ScalarFunction)function)), InferTypes.explicit(argTypes), (SqlOperandTypeChecker)OperandTypes.family(typeFamilies), this.toSql(argTypes), function);
        }
        if (function instanceof AggregateFunction) {
            RelDataType returnType = ((AggregateFunction)function).getReturnType(this.typeFactory);
            return new SqlUserDefinedAggFunction(name, ReturnTypes.explicit(returnType), InferTypes.explicit(argTypes), OperandTypes.family(typeFamilies), (AggregateFunction)function);
        }
        if (function instanceof TableMacro) {
            return new SqlUserDefinedTableMacro(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), OperandTypes.family(typeFamilies), (TableMacro)function);
        }
        if (function instanceof TableFunction) {
            return new SqlUserDefinedTableFunction(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), (SqlOperandTypeChecker)OperandTypes.family(typeFamilies), this.toSql(argTypes), (TableFunction)function);
        }
        throw new AssertionError((Object)("unknown function type " + function));
    }

    private List<RelDataType> toSql(List<RelDataType> types) {
        return Lists.transform(types, (Function)new Function<RelDataType, RelDataType>(){

            public RelDataType apply(RelDataType input) {
                if (input instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)input).getJavaClass() == Object.class) {
                    return CalciteCatalogReader.this.typeFactory.createTypeWithNullability(CalciteCatalogReader.this.typeFactory.createSqlType(SqlTypeName.ANY), true);
                }
                return CalciteCatalogReader.this.typeFactory.toSql(input);
            }
        });
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return null;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void registerRules(RelOptPlanner planner) throws Exception {
    }
}

