/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.frequency;

import com.clearspring.analytics.stream.frequency.CountMinSketch;
import com.clearspring.analytics.stream.membership.Filter;

public class ConservativeAddSketch
extends CountMinSketch {
    ConservativeAddSketch() {
    }

    public ConservativeAddSketch(int depth, int width, int seed) {
        super(depth, width, seed);
    }

    public ConservativeAddSketch(double epsOfTotalCount, double confidence, int seed) {
        super(epsOfTotalCount, confidence, seed);
    }

    ConservativeAddSketch(int depth, int width, int size, long[] hashA, long[][] table) {
        super(depth, width, size, hashA, table);
    }

    @Override
    public void add(long item, long count) {
        int i;
        if (count < 0L) {
            throw new IllegalArgumentException("Negative increments not implemented");
        }
        int[] buckets = new int[this.depth];
        for (int i2 = 0; i2 < this.depth; ++i2) {
            buckets[i2] = this.hash(item, i2);
        }
        long min = this.table[0][buckets[0]];
        for (i = 1; i < this.depth; ++i) {
            min = Math.min(min, this.table[i][buckets[i]]);
        }
        for (i = 0; i < this.depth; ++i) {
            long newVal;
            this.table[i][buckets[i]] = newVal = Math.max(this.table[i][buckets[i]], min + count);
        }
        this.size += count;
    }

    @Override
    public void add(String item, long count) {
        int i;
        if (count < 0L) {
            throw new IllegalArgumentException("Negative increments not implemented");
        }
        int[] buckets = Filter.getHashBuckets(item, this.depth, this.width);
        long min = this.table[0][buckets[0]];
        for (i = 1; i < this.depth; ++i) {
            min = Math.min(min, this.table[i][buckets[i]]);
        }
        for (i = 0; i < this.depth; ++i) {
            long newVal;
            this.table[i][buckets[i]] = newVal = Math.max(this.table[i][buckets[i]], min + count);
        }
        this.size += count;
    }
}

