/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;

public class FilterSetOpTransposeRule
extends RelOptRule {
    public static final FilterSetOpTransposeRule INSTANCE = new FilterSetOpTransposeRule(RelFactories.DEFAULT_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public FilterSetOpTransposeRule(RelFactories.FilterFactory filterFactory) {
        super(FilterSetOpTransposeRule.operand(Filter.class, FilterSetOpTransposeRule.operand(SetOp.class, FilterSetOpTransposeRule.any()), new RelOptRuleOperand[0]));
        this.filterFactory = filterFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        SetOp setOp = (SetOp)call.rel(1);
        RexNode condition = filterRel.getCondition();
        RexBuilder rexBuilder = filterRel.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = setOp.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        ArrayList<RelNode> newSetOpInputs = new ArrayList<RelNode>();
        for (RelNode input : setOp.getInputs()) {
            RexNode newCondition = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, input.getRowType().getFieldList(), adjustments));
            newSetOpInputs.add(this.filterFactory.createFilter(input, newCondition));
        }
        RelNode newSetOp = setOp.copy(setOp.getTraitSet(), newSetOpInputs);
        call.transformTo(newSetOp);
    }
}

