/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;

@Explain(displayName="Drop Table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DropTableDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tableName;
    ArrayList<PartSpec> partSpecs;
    boolean expectView;
    boolean ifExists;
    boolean ifPurge;
    boolean ignoreProtection;
    ReplicationSpec replicationSpec;

    public DropTableDesc() {
    }

    public DropTableDesc(String tableName, boolean expectView, boolean ifExists, boolean ifPurge, ReplicationSpec replicationSpec) {
        this.tableName = tableName;
        this.partSpecs = null;
        this.expectView = expectView;
        this.ifExists = ifExists;
        this.ifPurge = ifPurge;
        this.ignoreProtection = false;
        this.replicationSpec = replicationSpec;
    }

    public DropTableDesc(String tableName, Map<Integer, List<ExprNodeGenericFuncDesc>> partSpecs, boolean expectView, boolean ignoreProtection, boolean ifPurge, ReplicationSpec replicationSpec) {
        this.tableName = tableName;
        this.partSpecs = new ArrayList(partSpecs.size());
        for (Map.Entry<Integer, List<ExprNodeGenericFuncDesc>> partSpec : partSpecs.entrySet()) {
            int prefixLength = partSpec.getKey();
            for (ExprNodeGenericFuncDesc expr : partSpec.getValue()) {
                this.partSpecs.add(new PartSpec(expr, prefixLength));
            }
        }
        this.ignoreProtection = ignoreProtection;
        this.expectView = expectView;
        this.ifPurge = ifPurge;
        this.replicationSpec = replicationSpec;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ArrayList<PartSpec> getPartSpecs() {
        return this.partSpecs;
    }

    public boolean getIgnoreProtection() {
        return this.ignoreProtection;
    }

    public void setIgnoreProtection(boolean ignoreProtection) {
        this.ignoreProtection = ignoreProtection;
    }

    public boolean getExpectView() {
        return this.expectView;
    }

    public void setExpectView(boolean expectView) {
        this.expectView = expectView;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public boolean getIfPurge() {
        return this.ifPurge;
    }

    public void setIfPurge(boolean ifPurge) {
        this.ifPurge = ifPurge;
    }

    public ReplicationSpec getReplicationSpec() {
        if (this.replicationSpec == null) {
            this.replicationSpec = new ReplicationSpec();
        }
        return this.replicationSpec;
    }

    public static class PartSpec {
        private static final long serialVersionUID = 1L;
        private ExprNodeGenericFuncDesc partSpec;
        private int prefixLength;

        public PartSpec(ExprNodeGenericFuncDesc partSpec, int prefixLength) {
            this.partSpec = partSpec;
            this.prefixLength = prefixLength;
        }

        public ExprNodeGenericFuncDesc getPartSpec() {
            return this.partSpec;
        }

        public int getPrefixLength() {
            return this.prefixLength;
        }
    }
}

