/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

@InterfaceAudience.Private
public class VirtualColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final VirtualColumn FILENAME = new VirtualColumn("INPUT__FILE__NAME", TypeInfoFactory.stringTypeInfo);
    public static final VirtualColumn BLOCKOFFSET = new VirtualColumn("BLOCK__OFFSET__INSIDE__FILE", TypeInfoFactory.longTypeInfo);
    public static final VirtualColumn ROWOFFSET = new VirtualColumn("ROW__OFFSET__INSIDE__BLOCK", TypeInfoFactory.longTypeInfo);
    public static final VirtualColumn RAWDATASIZE = new VirtualColumn("RAW__DATA__SIZE", TypeInfoFactory.longTypeInfo);
    public static final VirtualColumn ROWID = new VirtualColumn("ROW__ID", RecordIdentifier.StructInfo.typeInfo, true, RecordIdentifier.StructInfo.oi);
    public static final VirtualColumn GROUPINGID = new VirtualColumn("GROUPING__ID", TypeInfoFactory.intTypeInfo);
    public static ImmutableSet<String> VIRTUAL_COLUMN_NAMES = ImmutableSet.of((Object)FILENAME.getName(), (Object)BLOCKOFFSET.getName(), (Object)ROWOFFSET.getName(), (Object)RAWDATASIZE.getName(), (Object)GROUPINGID.getName(), (Object)ROWID.getName(), (Object[])new String[0]);
    private final String name;
    private final TypeInfo typeInfo;
    private final boolean isHidden;
    private final ObjectInspector oi;

    private VirtualColumn(String name, PrimitiveTypeInfo typeInfo) {
        this(name, typeInfo, true, PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(typeInfo));
    }

    private VirtualColumn(String name, TypeInfo typeInfo, boolean isHidden, ObjectInspector oi) {
        this.name = name;
        this.typeInfo = typeInfo;
        this.isHidden = isHidden;
        this.oi = oi;
    }

    public static List<VirtualColumn> getStatsRegistry(Configuration conf) {
        ArrayList<VirtualColumn> l = new ArrayList<VirtualColumn>();
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_STATS_COLLECT_RAWDATASIZE)) {
            l.add(RAWDATASIZE);
        }
        return l;
    }

    public static List<VirtualColumn> getRegistry(Configuration conf) {
        ArrayList<VirtualColumn> l = new ArrayList<VirtualColumn>();
        l.add(BLOCKOFFSET);
        l.add(FILENAME);
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVEROWOFFSET)) {
            l.add(ROWOFFSET);
        }
        l.add(ROWID);
        return l;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean getIsHidden() {
        return this.isHidden;
    }

    public ObjectInspector getObjectInspector() {
        return this.oi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualColumn)) {
            return false;
        }
        VirtualColumn c = (VirtualColumn)o;
        return this.name.equals(c.name) && this.typeInfo.getTypeName().equals(c.getTypeInfo().getTypeName());
    }

    public int hashCode() {
        int c = 19;
        c = 31 * this.name.hashCode() + c;
        return 31 * this.typeInfo.getTypeName().hashCode() + c;
    }

    public static Collection<String> removeVirtualColumns(Collection<String> columns) {
        Iterables.removeAll(columns, VIRTUAL_COLUMN_NAMES);
        return columns;
    }

    public static List<TypeInfo> removeVirtualColumnTypes(List<String> columnNames, List<TypeInfo> columnTypes) {
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalArgumentException("Number of column names in configuration " + columnNames.size() + " differs from column types " + columnTypes.size());
        }
        int i = 0;
        ListIterator<TypeInfo> it = columnTypes.listIterator();
        while (it.hasNext()) {
            it.next();
            if (VIRTUAL_COLUMN_NAMES.contains((Object)columnNames.get(i))) {
                it.remove();
            }
            ++i;
        }
        return columnTypes;
    }

    public static StructObjectInspector getVCSObjectInspector(List<VirtualColumn> vcs) {
        ArrayList<String> names = new ArrayList<String>(vcs.size());
        ArrayList<ObjectInspector> inspectors = new ArrayList<ObjectInspector>(vcs.size());
        for (VirtualColumn vc : vcs) {
            names.add(vc.getName());
            inspectors.add(vc.oi);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(names, inspectors);
    }
}

