/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams$class;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth$class;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r%h\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dea\u0002\u0003B\b\u0011%ai\u0011AA\u0005\u0003#\t\u0011\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0007Y&t\u0017\r\\4\n\u0005]!\"A\u0002,fGR|'\u000f\u0005\u0002\u0010\u0001A\u0011qBG\u0005\u00037\t\u0011\u0001\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]B\u000b'/Y7t!\ti\u0002%D\u0001\u001f\u0015\tyB!\u0001\u0003vi&d\u0017BA\u0011\u001f\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\tG\u0001\u0011)\u0019!C!I\u0005\u0019Q/\u001b3\u0016\u0003\u0015\u0002\"A\n\u0017\u000f\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003W!B3A\t\u00197!\t\tD'D\u00013\u0015\t\u0019d!\u0001\u0006b]:|G/\u0019;j_:L!!\u000e\u001a\u0003\u000bMKgnY3\"\u0003]\nQ!\r\u00185]AB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0005k&$\u0007\u0005K\u00029aYB\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!P\u0001\u0012G>,gMZ5dS\u0016tG/T1ue&DX#\u0001 \u0011\u0005My\u0014B\u0001!\u0015\u0005\u0019i\u0015\r\u001e:jq\"\u001a1\b\r\"\"\u0003\r\u000bQA\r\u00182]AB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IAP\u0001\u0013G>,gMZ5dS\u0016tG/T1ue&D\b\u0005K\u0002Ea\tC\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!S\u0001\u0010S:$XM]2faR4Vm\u0019;peV\t!\u0003K\u0002Ha\tC\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006IAE\u0001\u0011S:$XM]2faR4Vm\u0019;pe\u0002B3a\u0013\u0019C\u0011!y\u0005A!b\u0001\n\u0003\u0002\u0016A\u00038v[\u000ec\u0017m]:fgV\t\u0011\u000b\u0005\u0002(%&\u00111\u000b\u000b\u0002\u0004\u0013:$\bf\u0001(1+\u0006\na+A\u00032]Mr\u0003\u0007\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003R\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\u0007]\u0003T\u000b\u0003\u0005\\\u0001\t\u0015\r\u0011\"\u0003]\u00035I7/T;mi&tw.\\5bYV\tQ\f\u0005\u0002(=&\u0011q\f\u000b\u0002\b\u0005>|G.Z1o\u0011!\t\u0007A!A!\u0002\u0013i\u0016AD5t\u001bVdG/\u001b8p[&\fG\u000e\t\u0005\u0007G\u0002!\tA\u00023\u0002\rqJg.\u001b;?)\u0019ARmZ5l[\")1E\u0019a\u0001K!\u001aQ\r\r\u001c\t\u000bq\u0012\u0007\u0019\u0001 )\u0007\u001d\u0004$\tC\u0003IE\u0002\u0007!\u0003K\u0002ja\tCQa\u00142A\u0002EC3a\u001b\u0019V\u0011\u0015Y&\r1\u0001^\u0011\u0019\u0019\u0007\u0001\"\u0001\u0007_R!\u0001\u0004]9t\u0011\u0015\u0019c\u000e1\u0001&\u0011\u0015\u0011h\u000e1\u0001\u0013\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t\u0011\u0015!h\u000e1\u0001v\u0003%Ig\u000e^3sG\u0016\u0004H\u000f\u0005\u0002(m&\u0011q\u000f\u000b\u0002\u0007\t>,(\r\\3\t\u000bI\u0004A\u0011A%)\u0007a\u0004$0I\u0001|\u0003\u0015\u0011d\u0006\r\u00181\u0011!i\b\u0001#b\u0001\n\u0013I\u0015!D0d_\u00164g-[2jK:$8\u000f\u0003\u0005\u0000\u0001!\u0005\t\u0015)\u0003\u0013\u00039y6m\\3gM&\u001c\u0017.\u001a8ug\u0002Ba\u0001\u001e\u0001\u0005\u0002\u0005\rQ#A;)\t\u0005\u0005\u0001'\u0016\u0005\u000b\u0003\u0013\u0001\u0001R1A\u0005\n\u0005\r\u0011AC0j]R,'oY3qi\"I\u0011Q\u0002\u0001\t\u0002\u0003\u0006K!^\u0001\f?&tG/\u001a:dKB$\b\u0005C\u0004\u0002\u0012\u0001!\t%a\u0005\u0002\u0019M,G\u000f\u00165sKNDw\u000e\u001c3\u0015\t\u0005U\u0011qC\u0007\u0002\u0001!9\u0011\u0011DA\b\u0001\u0004)\u0018!\u0002<bYV,\u0007&BA\ba\u0005u\u0011EAA\u0010\u0003\u0015\td&\u000e\u00181\u0011\u001d\t\u0019\u0003\u0001C!\u0003\u0007\tAbZ3u)\"\u0014Xm\u001d5pY\u0012DS!!\t1\u0003;Aq!!\u000b\u0001\t\u0003\nY#A\u0007tKR$\u0006N]3tQ>dGm\u001d\u000b\u0005\u0003+\ti\u0003\u0003\u0005\u0002\u001a\u0005\u001d\u0002\u0019AA\u0018!\u00119\u0013\u0011G;\n\u0007\u0005M\u0002FA\u0003BeJ\f\u0017\u0010K\u0003\u0002(A\ni\u0002C\u0004\u0002:\u0001!\t%a\u000f\u0002\u001b\u001d,G\u000f\u00165sKNDw\u000e\u001c3t+\t\ty\u0003K\u0003\u00028A\ni\u0002C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D\u00051Q.\u0019:hS:,\"!!\u0012\u0011\u000b\u001d\n9EE;\n\u0007\u0005%\u0003FA\u0005Gk:\u001cG/[8oc!A\u0011Q\n\u0001!\u0002\u0013\t)%A\u0004nCJ<\u0017N\u001c\u0011\t\u0013\u0005E\u0003A1A\u0005\n\u0005M\u0013aB7be\u001eLgn]\u000b\u0003\u0003+\u0002RaJA$%IA\u0001\"!\u0017\u0001A\u0003%\u0011QK\u0001\t[\u0006\u0014x-\u001b8tA!I\u0011Q\f\u0001C\u0002\u0013%\u00111I\u0001\u0006g\u000e|'/\u001a\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002F\u000511oY8sK\u0002B\u0001\"!\u001a\u0001\u0005\u0004%\t\u0005U\u0001\f]Vlg)Z1ukJ,7\u000fK\u0003\u0002dA\nI'\t\u0002\u0002l\u0005)\u0011G\f\u001c/a!9\u0011q\u000e\u0001!\u0002\u0013\t\u0016\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003&BA7a\u0005%\u0004\"CA;\u0001\u0001\u0007I\u0011BA<\u0003=!(/Y5oS:<7+^7nCJLXCAA=!\u00159\u00131PA@\u0013\r\ti\b\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007=\t\t)C\u0002\u0002\u0004\n\u0011\u0011\u0005T8hSN$\u0018n\u0019*fOJ,7o]5p]R\u0013\u0018-\u001b8j]\u001e\u001cV/\\7befD\u0011\"a\"\u0001\u0001\u0004%I!!#\u0002'Q\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef|F%Z9\u0015\t\u0005-\u0015\u0011\u0013\t\u0004O\u00055\u0015bAAHQ\t!QK\\5u\u0011)\t\u0019*!\"\u0002\u0002\u0003\u0007\u0011\u0011P\u0001\u0004q\u0012\n\u0004\u0002CAL\u0001\u0001\u0006K!!\u001f\u0002!Q\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef\u0004\u0003bBAN\u0001\u0011\u0005\u0011QT\u0001\bgVlW.\u0019:z+\t\ty\bK\u0003\u0002\u001aB\ni\u0002C\u0004\u0002$\u0002!\t!!*\u0002\u001b\tLg.\u0019:z'VlW.\u0019:z+\t\t9\u000bE\u0002\u0010\u0003SK1!a+\u0003\u0005\u001d\u0012\u0015N\\1ss2{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\u001c+sC&t\u0017N\\4Tk6l\u0017M]=)\u000b\u0005\u0005\u0006'a,\"\u0005\u0005E\u0016!\u0002\u001a/g9\u0002\u0004\u0002CA[\u0001\u0011\u0005!!a.\u0002!\u0019Lg\u000eZ*v[6\f'/_'pI\u0016dGCAA]!\u00199\u00131\u0018\r&K%\u0019\u0011Q\u0018\u0015\u0003\rQ+\b\u000f\\34\u0011!\t\t\r\u0001C\u0001\u0005\u0005\r\u0017AC:fiN+X.\\1ssR!\u0011QCAc\u0011!\tY*a0A\u0002\u0005e\u0004BBAe\u0001\u0011\u0005A,\u0001\u0006iCN\u001cV/\\7befDS!a21\u0003;Aq!a4\u0001\t\u0003\t\t.\u0001\u0005fm\u0006dW/\u0019;f)\u0011\t\u0019.!7\u0011\u0007=\t).C\u0002\u0002X\n\u0011\u0011\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]N+X.\\1ss\"A\u00111\\Ag\u0001\u0004\ti.A\u0004eCR\f7/\u001a;1\t\u0005}\u0017q\u001e\t\u0007\u0003C\f9/a;\u000e\u0005\u0005\r(bAAs\r\u0005\u00191/\u001d7\n\t\u0005%\u00181\u001d\u0002\b\t\u0006$\u0018m]3u!\u0011\ti/a<\r\u0001\u0011a\u0011\u0011_Am\u0003\u0003\u0005\tQ!\u0001\u0002t\n\u0019q\fJ\u001a\u0012\t\u0005U\u00181 \t\u0004O\u0005]\u0018bAA}Q\t9aj\u001c;iS:<\u0007cA\u0014\u0002~&\u0019\u0011q \u0015\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\u0002NBR\bb\u0002B\u0003\u0001\u0011\u0005#qA\u0001\baJ,G-[2u)\r)(\u0011\u0002\u0005\b\u0005\u0017\u0011\u0019\u00011\u0001\u0013\u0003!1W-\u0019;ve\u0016\u001c\bb\u0002B\b\u0001\u0011E#\u0011C\u0001\u0017e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5us&s\u0007\u000b\\1dKR\u0019!Ca\u0005\t\u000f\tU!Q\u0002a\u0001%\u0005i!/Y<Qe\u0016$\u0017n\u0019;j_:DqA!\u0007\u0001\t#\u0012Y\"\u0001\u0006qe\u0016$\u0017n\u0019;SC^$2A\u0005B\u000f\u0011\u001d\u0011YAa\u0006A\u0002IAqA!\t\u0001\t\u0003\u0012\u0019#\u0001\u0003d_BLHc\u0001\r\u0003&!A!q\u0005B\u0010\u0001\u0004\u0011I#A\u0003fqR\u0014\u0018\r\u0005\u0003\u0003,\tERB\u0001B\u0017\u0015\r\u0011y\u0003B\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0005g\u0011iC\u0001\u0005QCJ\fW.T1qQ\u0011\u0011y\u0002\r\u001c\t\u000f\te\u0002\u0001\"\u0015\u0003<\u0005q!/Y<3aJ,G-[2uS>tGcA;\u0003>!9!Q\u0003B\u001c\u0001\u0004\u0011\u0002b\u0002B!\u0001\u0011E#1I\u0001\u0017aJ|'-\u00192jY&$\u0018P\r9sK\u0012L7\r^5p]R\u0019QO!\u0012\t\u000f\t\u001d#q\ba\u0001%\u0005Y\u0001O]8cC\nLG.\u001b;z\u0011\u001d\u0011Y\u0005\u0001C!\u0005\u001b\nQa\u001e:ji\u0016,\"Aa\u0014\u0011\u0007u\u0011\t&C\u0002\u0003Ty\u0011\u0001\"\u0014'Xe&$XM\u001d\u0015\u0006\u0005\u0013\u0002\u0014\u0011\u000e\u0005\b\u00053\u0002A\u0011\tB.\u0003!!xn\u0015;sS:<G#A\u0013)\u0007\u0001\u0001dgB\u0004\u0003b\tA\tAa\u0019\u0002/1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007cA\b\u0003f\u00191\u0011A\u0001E\u0001\u0005O\u001a\u0002B!\u001a\u0003j\t=$Q\u000f\t\u0004O\t-\u0014b\u0001B7Q\t1\u0011I\\=SK\u001a\u0004B!\bB91%\u0019!1\u000f\u0010\u0003\u00155c%+Z1eC\ndW\rE\u0002(\u0005oJ1A!\u001f)\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001d\u0019'Q\rC\u0001\u0005{\"\"Aa\u0019\t\u0011\t\u0005%Q\rC!\u0005\u0007\u000bAA]3bIV\u0011!Q\u0011\t\u0005;\t\u001d\u0005$C\u0002\u0003\nz\u0011\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u0006\u0005\u007f\u0002\u0014\u0011\u000e\u0005\t\u0005\u001f\u0013)\u0007\"\u0011\u0003\u0012\u0006!An\\1e)\rA\"1\u0013\u0005\b\u0005+\u0013i\t1\u0001&\u0003\u0011\u0001\u0018\r\u001e5)\u000b\t5\u0005'!\u001b\u0007\u0013\tm%Q\r\u0001\u0003f\tu%!\b'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:lu\u000eZ3m/JLG/\u001a:\u0014\r\te%q\nBP!\u0011\u0011\tKa*\u000e\u0005\t\r&b\u0001BS\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0003\u0003*\n\r&a\u0002'pO\u001eLgn\u001a\u0005\u000b\u0005[\u0013IJ!A!\u0002\u0013A\u0012\u0001C5ogR\fgnY3\t\u000f\r\u0014I\n\"\u0001\u00032R!!1\u0017B\\!\u0011\u0011)L!'\u000e\u0005\t\u0015\u0004b\u0002BW\u0005_\u0003\r\u0001\u0007\u0004\b\u0005w\u0013I\n\u0012B_\u0005\u0011!\u0015\r^1\u0014\u0011\te&\u0011\u000eB`\u0005k\u00022a\nBa\u0013\r\u0011\u0019\r\u000b\u0002\b!J|G-^2u\u0011%y%\u0011\u0018BK\u0002\u0013\u0005\u0001\u000bC\u0005Y\u0005s\u0013\t\u0012)A\u0005#\"Q\u0011Q\rB]\u0005+\u0007I\u0011\u0001)\t\u0015\u0005=$\u0011\u0018B\tB\u0003%\u0011\u000bC\u0005I\u0005s\u0013)\u001a!C\u0001\u0013\"IAJ!/\u0003\u0012\u0003\u0006IA\u0005\u0005\ny\te&Q3A\u0005\u0002uB\u0011\"\u0012B]\u0005#\u0005\u000b\u0011\u0002 \t\u0013m\u0013IL!f\u0001\n\u0003a\u0006\"C1\u0003:\nE\t\u0015!\u0003^\u0011\u001d\u0019'\u0011\u0018C\u0001\u00057$BB!8\u0003b\n\r(Q\u001dBt\u0005S\u0004BAa8\u0003:6\u0011!\u0011\u0014\u0005\u0007\u001f\ne\u0007\u0019A)\t\u000f\u0005\u0015$\u0011\u001ca\u0001#\"1\u0001J!7A\u0002IAa\u0001\u0010Bm\u0001\u0004q\u0004BB.\u0003Z\u0002\u0007Q\f\u0003\u0006\u0003\"\te\u0016\u0011!C\u0001\u0005[$BB!8\u0003p\nE(1\u001fB{\u0005oD\u0001b\u0014Bv!\u0003\u0005\r!\u0015\u0005\n\u0003K\u0012Y\u000f%AA\u0002EC\u0001\u0002\u0013Bv!\u0003\u0005\rA\u0005\u0005\ty\t-\b\u0013!a\u0001}!A1La;\u0011\u0002\u0003\u0007Q\f\u0003\u0006\u0003|\ne\u0016\u0013!C\u0001\u0005{\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u0000*\u001a\u0011k!\u0001,\u0005\r\r\u0001\u0003BB\u0003\u0007\u001bi!aa\u0002\u000b\t\r%11B\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\r\u0015\n\t\r=1q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCB\n\u0005s\u000b\n\u0011\"\u0001\u0003~\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004BCB\f\u0005s\u000b\n\u0011\"\u0001\u0004\u001a\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAB\u000eU\r\u00112\u0011\u0001\u0005\u000b\u0007?\u0011I,%A\u0005\u0002\r\u0005\u0012AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007GQ3APB\u0001\u0011)\u00199C!/\u0012\u0002\u0013\u00051\u0011F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019YCK\u0002^\u0007\u0003A!ba\f\u0003:\u0006\u0005I\u0011IB\u0019\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u001111\u0007\t\u0005\u0007k\u0019y$\u0004\u0002\u00048)!1\u0011HB\u001e\u0003\u0011a\u0017M\\4\u000b\u0005\ru\u0012\u0001\u00026bm\u0006L1!LB\u001c\u0011%\u0019\u0019E!/\u0002\u0002\u0013\u0005\u0001+\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010\u0003\u0006\u0004H\te\u0016\u0011!C\u0001\u0007\u0013\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002|\u000e-\u0003\"CAJ\u0007\u000b\n\t\u00111\u0001R\u0011)\u0019yE!/\u0002\u0002\u0013\u00053\u0011K\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u001111\u000b\t\u0007\u0007+\u001aY&a?\u000e\u0005\r]#bAB-Q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\ru3q\u000b\u0002\t\u0013R,'/\u0019;pe\"Q1\u0011\rB]\u0003\u0003%\taa\u0019\u0002\u0011\r\fg.R9vC2$2!XB3\u0011)\t\u0019ja\u0018\u0002\u0002\u0003\u0007\u00111 \u0005\u000b\u0007S\u0012I,!A\u0005B\r-\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003EC!B!\u0017\u0003:\u0006\u0005I\u0011IB8)\t\u0019\u0019\u0004\u0003\u0006\u0004t\te\u0016\u0011!C!\u0007k\na!Z9vC2\u001cHcA/\u0004x!Q\u00111SB9\u0003\u0003\u0005\r!a?\b\u0015\rm$\u0011TA\u0001\u0012\u0013\u0019i(\u0001\u0003ECR\f\u0007\u0003\u0002Bp\u0007\u007f2!Ba/\u0003\u001a\u0006\u0005\t\u0012BBA'\u0019\u0019yha!\u0003vAY1QQBF#F\u0013b(\u0018Bo\u001b\t\u00199IC\u0002\u0004\n\"\nqA];oi&lW-\u0003\u0003\u0004\u000e\u000e\u001d%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ok!91ma \u0005\u0002\rEECAB?\u0011)\u0011Ifa \u0002\u0002\u0013\u00153q\u000e\u0005\u000b\u0007/\u001by(!A\u0005\u0002\u000ee\u0015!B1qa2LH\u0003\u0004Bo\u00077\u001bija(\u0004\"\u000e\r\u0006BB(\u0004\u0016\u0002\u0007\u0011\u000bC\u0004\u0002f\rU\u0005\u0019A)\t\r!\u001b)\n1\u0001\u0013\u0011\u0019a4Q\u0013a\u0001}!11l!&A\u0002uC!ba*\u0004\u0000\u0005\u0005I\u0011QBU\u0003\u001d)h.\u00199qYf$Baa+\u00044B)q%a\u001f\u0004.BAqea,R#JqT,C\u0002\u00042\"\u0012a\u0001V;qY\u0016,\u0004BCB[\u0007K\u000b\t\u00111\u0001\u0003^\u0006\u0019\u0001\u0010\n\u0019\t\u0011\re&\u0011\u0014C)\u0007w\u000b\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0003\u0017\u001bi\fC\u0004\u0003\u0016\u000e]\u0006\u0019A\u0013\u0007\u000f\r\u0005'Q\r\u0003\u0004D\niBj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\u001c*fC\u0012,'o\u0005\u0003\u0004@\n\u0015\u0005bB2\u0004@\u0012\u00051q\u0019\u000b\u0003\u0007\u0013\u0004BA!.\u0004@\"Q1QZB`\u0005\u0004%Ia!\r\u0002\u0013\rd\u0017m]:OC6,\u0007\"CBi\u0007\u007f\u0003\u000b\u0011BB\u001a\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u0005\t\u0005\u001f\u001by\f\"\u0011\u0004VR\u0019\u0001da6\t\u000f\tU51\u001ba\u0001K!Q11\u001cB3\u0003\u0003%Ia!8\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007?\u0004Ba!\u000e\u0004b&!11]B\u001c\u0005\u0019y%M[3di\"*!Q\r\u0019\u0002j!*!q\f\u0019\u0002j\u0001")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements LogisticRegressionParams,
MLWritable {
    private final String uid;
    private final Matrix coefficientMatrix;
    private final Vector interceptVector;
    private final int numClasses;
    private final boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    private Vector org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients;
    private double org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept;
    private final Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    private final Function1<Vector, Vector> margins;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final Param<String> family;
    private final Param<Matrix> lowerBoundsOnCoefficients;
    private final Param<Matrix> upperBoundsOnCoefficients;
    private final Param<Vector> lowerBoundsOnIntercepts;
    private final Param<Vector> upperBoundsOnIntercepts;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;
    private volatile byte bitmap$0;

    public static LogisticRegressionModel load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    private Vector org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Vector vector;
                Predef$.MODULE$.require(this.coefficientMatrix().isTransposed(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "LogisticRegressionModel coefficients should be row major for binomial model.";
                    }
                });
                Matrix matrix = this.coefficientMatrix();
                if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    vector = Vectors$.MODULE$.dense(denseMatrix.values());
                } else {
                    if (!(matrix instanceof SparseMatrix)) {
                        throw new MatchError((Object)matrix);
                    }
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    vector = Vectors$.MODULE$.sparse(this.coefficientMatrix().numCols(), sparseMatrix.rowIndices(), sparseMatrix.values());
                }
                this.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients = vector;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients;
        }
    }

    private double org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.interceptVector().toArray()).head());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept;
        }
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams$class.getFamily(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams$class.getLowerBoundsOnCoefficients(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams$class.getUpperBoundsOnCoefficients(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams$class.getLowerBoundsOnIntercepts(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams$class.getUpperBoundsOnIntercepts(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams$class.usingBoundConstrainedOptimization(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth$class.getAggregationDepth(this);
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Matrix coefficientMatrix() {
        return this.coefficientMatrix;
    }

    public Vector interceptVector() {
        return this.interceptVector;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    }

    public Vector coefficients() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a matrix of coefficients, use coefficientMatrix instead.");
        }
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients();
    }

    public Vector org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients$lzycompute() : this.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients;
    }

    public double intercept() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a vector of intercepts, use interceptVector instead.");
        }
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept();
    }

    public double org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept$lzycompute() : this.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept;
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    public Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    }

    private Function1<Vector, Vector> margins() {
        return this.margins;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    private Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("No training summary available for this LogisticRegressionModel");
            }
        });
    }

    public BinaryLogisticRegressionTrainingSummary binarySummary() {
        LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = this.summary();
        if (logisticRegressionTrainingSummary instanceof BinaryLogisticRegressionTrainingSummary) {
            BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary;
            BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary2 = binaryLogisticRegressionTrainingSummary = (BinaryLogisticRegressionTrainingSummary)logisticRegressionTrainingSummary;
            return binaryLogisticRegressionTrainingSummary2;
        }
        throw new RuntimeException(new StringBuilder().append((Object)"Cannot create a binary summary for a non-binary model").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(numClasses=", "), use summary instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses())}))).toString());
    }

    public Tuple3<LogisticRegressionModel, String, String> findSummaryModel() {
        LogisticRegressionModel model = this.$(this.probabilityCol()).isEmpty() && this.$(this.predictionCol()).isEmpty() ? (LogisticRegressionModel)((PredictionModel)this.copy(ParamMap$.MODULE$.empty()).setProbabilityCol(new StringBuilder().append((Object)"probability_").append((Object)UUID.randomUUID().toString()).toString())).setPredictionCol(new StringBuilder().append((Object)"prediction_").append((Object)UUID.randomUUID().toString()).toString()) : (this.$(this.probabilityCol()).isEmpty() ? (LogisticRegressionModel)this.copy(ParamMap$.MODULE$.empty()).setProbabilityCol(new StringBuilder().append((Object)"probability_").append((Object)UUID.randomUUID().toString()).toString()) : (this.$(this.predictionCol()).isEmpty() ? (LogisticRegressionModel)this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(new StringBuilder().append((Object)"prediction_").append((Object)UUID.randomUUID().toString()).toString()) : this));
        return new Tuple3((Object)model, (Object)model.getProbabilityCol(), (Object)model.getPredictionCol());
    }

    public LogisticRegressionModel setSummary(Option<LogisticRegressionTrainingSummary> summary2) {
        this.trainingSummary_$eq(summary2);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple3<LogisticRegressionModel, String, String> tuple3 = this.findSummaryModel();
        if (tuple3 != null) {
            Tuple3 tuple32;
            LogisticRegressionModel summaryModel = (LogisticRegressionModel)tuple3._1();
            String probabilityColName = (String)tuple3._2();
            String predictionColName = (String)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
            LogisticRegressionModel summaryModel2 = (LogisticRegressionModel)tuple33._1();
            String probabilityColName2 = (String)tuple33._2();
            String predictionColName2 = (String)tuple33._3();
            return this.numClasses() > 2 ? new LogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol())) : new BinaryLogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()));
        }
        throw new MatchError(tuple3);
    }

    @Override
    public double predict(Vector features) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.predict(features) : (BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this.getThreshold() ? 1.0 : 0.0);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector;
            DenseVector denseVector2 = (DenseVector)vector;
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
                int size = denseVector2.size();
                double[] values = denseVector2.values();
                int maxMarginIndex = rawPrediction.argmax();
                double maxMargin = rawPrediction.apply(maxMarginIndex);
                if (maxMargin == Double.POSITIVE_INFINITY) {
                    for (int k = 0; k < size; ++k) {
                        values[k] = k == maxMarginIndex ? 1.0 : 0.0;
                    }
                } else {
                    double temp = 0.0;
                    for (int k = 0; k < this.numClasses(); ++k) {
                        values[k] = maxMargin > 0.0 ? scala.math.package$.MODULE$.exp(values[k] - maxMargin) : scala.math.package$.MODULE$.exp(values[k]);
                        temp += values[k];
                    }
                    double sum = temp;
                    BLAS$.MODULE$.scal(1.0 / sum, (Vector)denseVector2);
                }
                denseVector = denseVector2;
            } else {
                int size = denseVector2.size();
                for (int i = 0; i < size; ++i) {
                    denseVector2.values()[i] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-denseVector2.values()[i]));
                }
                denseVector = denseVector2;
            }
            DenseVector denseVector3 = denseVector;
            return denseVector3;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public Vector predictRaw(Vector features) {
        Vector vector;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            vector = (Vector)this.margins().apply((Object)features);
        } else {
            double m = BoxesRunTime.unboxToDouble((Object)this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin().apply((Object)features));
            vector = Vectors$.MODULE$.dense(-m, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
        }
        return vector;
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficientMatrix(), this.interceptVector(), this.numClasses(), this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()), extra);
        return (LogisticRegressionModel)newModel.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        double d;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            d = super.raw2prediction(rawPrediction);
        } else {
            double t = this.getThreshold();
            double rawThreshold = t == 0.0 ? Double.NEGATIVE_INFINITY : (t == 1.0 ? Double.POSITIVE_INFINITY : scala.math.package$.MODULE$.log(t / (1.0 - t)));
            d = rawPrediction.apply(1) > rawThreshold ? 1.0 : 0.0;
        }
        return d;
    }

    @Override
    public double probability2prediction(Vector probability) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.probability2prediction(probability) : (probability.apply(1) > this.getThreshold() ? 1.0 : 0.0);
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionModel: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uid = ", ", numClasses = ", ", numFeatures = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Identifiable$class.toString(this), BoxesRunTime.boxToInteger((int)this.numClasses()), BoxesRunTime.boxToInteger((int)this.numFeatures())}))).toString();
    }

    public LogisticRegressionModel(String uid, Matrix coefficientMatrix, Vector interceptVector, int numClasses, boolean isMultinomial) {
        this.uid = uid;
        this.coefficientMatrix = coefficientMatrix;
        this.interceptVector = interceptVector;
        this.numClasses = numClasses;
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial = isMultinomial;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasThreshold$class.$init$(this);
        HasAggregationDepth$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        Predef$.MODULE$.require(coefficientMatrix.numRows() == interceptVector.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch! Expected "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficientMatrix.numRows == interceptVector.size, but ", " != "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.coefficientMatrix().numRows())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.interceptVector().size())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;

            public final double apply(Vector features) {
                return BLAS$.MODULE$.dot(features, this.$outer.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients()) + this.$outer.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.margins = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;

            /*
             * WARNING - void declaration
             */
            public final DenseVector apply(Vector features) {
                void var2_2;
                DenseVector m = this.$outer.interceptVector().toDense().copy();
                BLAS$.MODULE$.gemv(1.0, this.$outer.coefficientMatrix(), features, 1.0, m);
                return var2_2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.score = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;

            public final double apply(Vector features) {
                double m = BoxesRunTime.unboxToDouble((Object)this.$outer.org$apache$spark$ml$classification$LogisticRegressionModel$$margin().apply((Object)features));
                return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-m));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.numFeatures = coefficientMatrix.numCols();
        this.trainingSummary = None$.MODULE$;
    }

    public LogisticRegressionModel(String uid, Vector coefficients2, double intercept) {
        this(uid, (Matrix)new DenseMatrix(1, coefficients2.size(), coefficients2.toArray(), true), Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 2, false);
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private final LogisticRegressionModel instance;
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$lzycompute() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module != null) return this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module;
                this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                return this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module;
            }
        }

        public LogisticRegressionModel$LogisticRegressionModelWriter$Data$ org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data() {
            return this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module == null ? this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$lzycompute() : this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data().apply(this.instance.numClasses(), this.instance.numFeatures(), this.instance.interceptVector(), this.instance.coefficientMatrix(), this.instance.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(this))).repartition(1).write().parquet(dataPath);
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final Vector interceptVector;
            private final Matrix coefficientMatrix;
            private final boolean isMultinomial;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public Vector interceptVector() {
                return this.interceptVector;
            }

            public Matrix coefficientMatrix() {
                return this.coefficientMatrix;
            }

            public boolean isMultinomial() {
                return this.isMultinomial;
            }

            public Data copy(int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, interceptVector, coefficientMatrix, isMultinomial);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public Vector copy$default$3() {
                return this.interceptVector();
            }

            public Matrix copy$default$4() {
                return this.coefficientMatrix();
            }

            public boolean copy$default$5() {
                return this.isMultinomial();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 4: {
                        object = BoxesRunTime.boxToBoolean((boolean)this.isMultinomial());
                        break;
                    }
                    case 3: {
                        object = this.coefficientMatrix();
                        break;
                    }
                    case 2: {
                        object = this.interceptVector();
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.numFeatures());
                        break;
                    }
                    case 0: {
                        object = BoxesRunTime.boxToInteger((int)this.numClasses());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interceptVector()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficientMatrix()));
                n = Statics.mix((int)n, (int)(this.isMultinomial() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)5);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                Vector vector = this.interceptVector();
                Vector vector2 = data.interceptVector();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.coefficientMatrix();
                Matrix matrix2 = data.coefficientMatrix();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                if (this.isMultinomial() != data.isMultinomial()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.interceptVector = interceptVector;
                this.coefficientMatrix = coefficientMatrix;
                this.isMultinomial = isMultinomial;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            Tuple2 tuple2;
            block2: {
                Row row;
                block6: {
                    LogisticRegressionModel logisticRegressionModel;
                    DefaultParamsReader.Metadata metadata;
                    block5: {
                        Tuple5 tuple5;
                        Dataset data;
                        block3: {
                            Row row2;
                            block4: {
                                Tuple4 tuple4;
                                Tuple2.mcII.sp sp2;
                                metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                if (tuple2 == null) break block2;
                                int major = tuple2._1$mcI$sp();
                                int minor = tuple2._2$mcI$sp();
                                Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(major, minor);
                                int major2 = sp3._1$mcI$sp();
                                int minor2 = sp3._2$mcI$sp();
                                String dataPath = new Path(path, "data").toString();
                                data = this.sparkSession().read().format("parquet").load(dataPath);
                                if (major2 >= 2 && (major2 != 2 || minor2 != 0)) break block3;
                                row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
                                Some some = Row$.MODULE$.unapplySeq(row2);
                                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) break block4;
                                Object numClasses = ((SeqLike)some.get()).apply(0);
                                Object numFeatures = ((SeqLike)some.get()).apply(1);
                                Object intercept = ((SeqLike)some.get()).apply(2);
                                Object coefficients2 = ((SeqLike)some.get()).apply(3);
                                if (!(numClasses instanceof Integer)) break block4;
                                int n = BoxesRunTime.unboxToInt((Object)numClasses);
                                if (!(numFeatures instanceof Integer)) break block4;
                                int n2 = BoxesRunTime.unboxToInt((Object)numFeatures);
                                if (!(intercept instanceof Double)) break block4;
                                double d = BoxesRunTime.unboxToDouble((Object)intercept);
                                if (!(coefficients2 instanceof Vector)) break block4;
                                Vector vector = (Vector)coefficients2;
                                Tuple4 tuple42 = tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector);
                                int numClasses2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
                                int numFeatures2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
                                double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                                Vector coefficients3 = (Vector)tuple42._4();
                                DenseMatrix coefficientMatrix = new DenseMatrix(1, coefficients3.size(), coefficients3.toArray(), true);
                                Vector interceptVector = Vectors$.MODULE$.dense(intercept2, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                                logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), (Matrix)coefficientMatrix, interceptVector, numClasses2, false);
                                break block5;
                            }
                            throw new MatchError((Object)row2);
                        }
                        row = (Row)data.select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "interceptVector", "coefficientMatrix", "isMultinomial"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(5) != 0) break block6;
                        Object numClasses = ((SeqLike)some.get()).apply(0);
                        Object numFeatures = ((SeqLike)some.get()).apply(1);
                        Object interceptVector = ((SeqLike)some.get()).apply(2);
                        Object coefficientMatrix = ((SeqLike)some.get()).apply(3);
                        Object isMultinomial = ((SeqLike)some.get()).apply(4);
                        if (!(numClasses instanceof Integer)) break block6;
                        int n = BoxesRunTime.unboxToInt((Object)numClasses);
                        if (!(numFeatures instanceof Integer)) break block6;
                        int n3 = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (!(interceptVector instanceof Vector)) break block6;
                        Vector vector = (Vector)interceptVector;
                        if (!(coefficientMatrix instanceof Matrix)) break block6;
                        Matrix matrix = (Matrix)coefficientMatrix;
                        if (!(isMultinomial instanceof Boolean)) break block6;
                        boolean bl = BoxesRunTime.unboxToBoolean((Object)isMultinomial);
                        Tuple5 tuple52 = tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n3), (Object)vector, (Object)matrix, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                        int numClasses3 = BoxesRunTime.unboxToInt((Object)tuple52._1());
                        int numFeatures3 = BoxesRunTime.unboxToInt((Object)tuple52._2());
                        Vector interceptVector2 = (Vector)tuple52._3();
                        Matrix coefficientMatrix2 = (Matrix)tuple52._4();
                        boolean isMultinomial2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
                        logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), coefficientMatrix2, interceptVector2, numClasses3, isMultinomial2);
                    }
                    LogisticRegressionModel model = logisticRegressionModel;
                    metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
                    return model;
                }
                throw new MatchError((Object)row);
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

