/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.HashMap;
import java.util.Map;

public enum PrivilegeType {
    ALL(795, "All"),
    ALTER_DATA(796, "Update"),
    ALTER_METADATA(797, "Alter"),
    CREATE(798, "Create"),
    DROP(800, "Drop"),
    INDEX(801, "Index"),
    LOCK(803, "Lock"),
    SELECT(806, "Select"),
    SHOW_DATABASE(807, "Show_Database"),
    INSERT(802, "Insert"),
    DELETE(799, "Delete"),
    UNKNOWN(null, null);

    private final String name;
    private final Integer token;
    private static Map<Integer, PrivilegeType> token2Type;
    private static Map<String, PrivilegeType> name2Type;

    private PrivilegeType(Integer token, String name) {
        this.name = name;
        this.token = token;
    }

    public String toString() {
        return this.name == null ? "unkown" : this.name;
    }

    public Integer getToken() {
        return this.token;
    }

    public static PrivilegeType getPrivTypeByToken(int token) {
        PrivilegeType.populateToken2Type();
        PrivilegeType privType = token2Type.get(token);
        if (privType != null) {
            return privType;
        }
        return UNKNOWN;
    }

    private static synchronized void populateToken2Type() {
        if (token2Type != null) {
            return;
        }
        token2Type = new HashMap<Integer, PrivilegeType>();
        for (PrivilegeType privType : PrivilegeType.values()) {
            token2Type.put(privType.getToken(), privType);
        }
    }

    public static PrivilegeType getPrivTypeByName(String privilegeName) {
        PrivilegeType.populateName2Type();
        String canonicalizedName = privilegeName.toLowerCase();
        PrivilegeType privType = name2Type.get(canonicalizedName);
        if (privType != null) {
            return privType;
        }
        return UNKNOWN;
    }

    private static synchronized void populateName2Type() {
        if (name2Type != null) {
            return;
        }
        name2Type = new HashMap<String, PrivilegeType>();
        for (PrivilegeType privType : PrivilegeType.values()) {
            name2Type.put(privType.toString().toLowerCase(), privType);
        }
    }
}

