/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import java.util.Calendar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFTimestampFieldLong;

public final class VectorUDFYearLong
extends VectorUDFTimestampFieldLong {
    private static final long serialVersionUID = 1L;
    private static final transient long[] YEAR_BOUNDARIES = new long[622];
    private static final transient int MIN_YEAR = 1678;
    private static final transient int MAX_YEAR = 2300;

    @Override
    protected long getTimestampField(long time) {
        int year = Arrays.binarySearch(YEAR_BOUNDARIES, time);
        if (year >= 0) {
            return 1679 + year;
        }
        return 1677 - year;
    }

    public VectorUDFYearLong(int colNum, int outputColumn) {
        super(1, colNum, outputColumn);
    }

    public VectorUDFYearLong() {
    }

    static {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(0L);
        for (int year = 1679; year <= 2300; ++year) {
            c.set(year, 0, 1, 0, 0, 0);
            VectorUDFYearLong.YEAR_BOUNDARIES[year - 1678 - 1] = c.getTimeInMillis() * 1000L * 1000L;
        }
    }
}

