/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.library.api.KeyValuesReader;

public class KeyValuesInputMerger
extends KeyValuesReader {
    public static final Log l4j = LogFactory.getLog(KeyValuesInputMerger.class);
    private PriorityQueue<KeyValuesReader> pQueue = null;
    private final List<KeyValuesReader> nextKVReaders = new ArrayList<KeyValuesReader>();
    KeyValuesIterable kvsIterable = null;

    public KeyValuesInputMerger(List<? extends Input> shuffleInputs) throws Exception {
        int initialCapacity = shuffleInputs.size();
        this.kvsIterable = new KeyValuesIterable(initialCapacity);
        this.pQueue = new PriorityQueue<KeyValuesReader>(initialCapacity, new KVReaderComparator());
        for (Input input : shuffleInputs) {
            this.addToQueue((KeyValuesReader)input.getReader());
        }
    }

    private void addToQueue(KeyValuesReader kvsReadr) throws IOException {
        if (kvsReadr.next()) {
            this.pQueue.add(kvsReadr);
        }
    }

    public boolean next() throws IOException {
        if (!this.nextKVReaders.isEmpty()) {
            for (KeyValuesReader kvReader : this.nextKVReaders) {
                this.addToQueue(kvReader);
            }
            this.nextKVReaders.clear();
        }
        KeyValuesReader nextKVReader = null;
        nextKVReader = this.pQueue.poll();
        if (nextKVReader != null) {
            this.nextKVReaders.add(nextKVReader);
        }
        while (this.pQueue.peek() != null) {
            KeyValuesReader equalValueKVReader = this.pQueue.poll();
            if (this.pQueue.comparator().compare(nextKVReader, equalValueKVReader) == 0) {
                this.nextKVReaders.add(equalValueKVReader);
                continue;
            }
            this.pQueue.add(equalValueKVReader);
            break;
        }
        return !this.nextKVReaders.isEmpty();
    }

    public Object getCurrentKey() throws IOException {
        return this.nextKVReaders.get(0).getCurrentKey();
    }

    public Iterable<Object> getCurrentValues() throws IOException {
        this.kvsIterable.init(this.nextKVReaders);
        return this.kvsIterable;
    }

    class KVReaderComparator
    implements Comparator<KeyValuesReader> {
        KVReaderComparator() {
        }

        @Override
        public int compare(KeyValuesReader kvReadr1, KeyValuesReader kvReadr2) {
            try {
                BinaryComparable key1 = (BinaryComparable)kvReadr1.getCurrentKey();
                BinaryComparable key2 = (BinaryComparable)kvReadr2.getCurrentKey();
                return key1.compareTo(key2);
            }
            catch (IOException e) {
                l4j.error((Object)"Caught exception while reading shuffle input", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private class KeyValuesIterator
    implements Iterator<Object> {
        KeyValuesReader[] readerArray = null;
        Iterator<Object> currentIterator = null;
        int currentIndex = 0;
        int loadedSize = 0;

        KeyValuesIterator(int size) {
            this.readerArray = new KeyValuesReader[size];
        }

        public void init(List<KeyValuesReader> readerList) {
            for (int i = 0; i < readerList.size(); ++i) {
                this.readerArray[i] = null;
            }
            this.loadedSize = 0;
            Iterator<KeyValuesReader> i$ = readerList.iterator();
            while (i$.hasNext()) {
                KeyValuesReader kvsReader;
                this.readerArray[this.loadedSize] = kvsReader = i$.next();
                ++this.loadedSize;
            }
            this.currentIterator = null;
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                if (this.currentIndex == this.loadedSize) {
                    return false;
                }
                try {
                    if (this.readerArray[this.currentIndex] == null) {
                        return false;
                    }
                    this.currentIterator = this.readerArray[this.currentIndex].getCurrentValues().iterator();
                    ++this.currentIndex;
                    return this.currentIterator.hasNext();
                }
                catch (IOException e) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object next() {
            l4j.info((Object)("next called on " + this.currentIterator));
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
        }
    }

    private class KeyValuesIterable
    implements Iterable<Object> {
        KeyValuesIterator currentIterator = null;

        KeyValuesIterable(int size) {
            this.currentIterator = new KeyValuesIterator(size);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.currentIterator;
        }

        public void init(List<KeyValuesReader> readerList) {
            this.currentIterator.init(readerList);
        }
    }
}

