/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class MapJoinKeyObject
extends MapJoinKey {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private Object[] key;

    public MapJoinKeyObject(Object[] key) {
        this.key = key;
    }

    public MapJoinKeyObject() {
        this(EMPTY_OBJECT_ARRAY);
    }

    public Object[] getKeyObjects() {
        return this.key;
    }

    public void setKeyObjects(Object[] key) {
        this.key = key;
    }

    public int getKeyLength() {
        return this.key.length;
    }

    @Override
    public boolean hasAnyNulls(int fieldCount, boolean[] nullsafes) {
        assert (fieldCount == this.key.length);
        if (this.key != null && this.key.length > 0) {
            for (int i = 0; i < this.key.length; ++i) {
                if (this.key[i] != null || nullsafes != null && nullsafes[i]) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapJoinKeyObject other = (MapJoinKeyObject)obj;
        return Arrays.equals(this.key, other.key);
    }

    public void read(MapJoinObjectSerDeContext context, ObjectInputStream in, Writable container) throws IOException, SerDeException {
        container.readFields((DataInput)in);
        this.read(context, container);
    }

    public void read(MapJoinObjectSerDeContext context, Writable container) throws SerDeException {
        this.read(context.getSerDe().getObjectInspector(), context.getSerDe().deserialize(container));
    }

    protected void read(ObjectInspector oi, Object obj) throws SerDeException {
        List value = (List)ObjectInspectorUtils.copyToStandardObject(obj, oi, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        this.key = value == null ? EMPTY_OBJECT_ARRAY : value.toArray();
    }

    @Override
    public void write(MapJoinObjectSerDeContext context, ObjectOutputStream out) throws IOException, SerDeException {
        SerDe serde = context.getSerDe();
        ObjectInspector objectInspector = context.getStandardOI();
        Writable container = serde.serialize(this.key, objectInspector);
        container.write((DataOutput)out);
    }

    public void readFromRow(Object[] fieldObjs, List<ObjectInspector> keyFieldsOI) throws HiveException {
        if (this.key == null || this.key.length != fieldObjs.length) {
            this.key = new Object[fieldObjs.length];
        }
        for (int keyIndex = 0; keyIndex < fieldObjs.length; ++keyIndex) {
            this.key[keyIndex] = ObjectInspectorUtils.copyToStandardObject(fieldObjs[keyIndex], keyFieldsOI.get(keyIndex), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
    }

    protected boolean[] getNulls() {
        boolean[] nulls = null;
        for (int i = 0; i < this.key.length; ++i) {
            if (this.key[i] != null) continue;
            if (nulls == null) {
                nulls = new boolean[this.key.length];
            }
            nulls[i] = true;
        }
        return nulls;
    }

    public void readFromVector(VectorHashKeyWrapper kw, VectorExpressionWriter[] keyOutputWriters, VectorHashKeyWrapperBatch keyWrapperBatch) throws HiveException {
        if (this.key == null || this.key.length != keyOutputWriters.length) {
            this.key = new Object[keyOutputWriters.length];
        }
        for (int keyIndex = 0; keyIndex < keyOutputWriters.length; ++keyIndex) {
            this.key[keyIndex] = keyWrapperBatch.getWritableKeyValue(kw, keyIndex, keyOutputWriters[keyIndex]);
        }
    }
}

