/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.mllib.stat.test.BinarySample;
import org.apache.spark.mllib.stat.test.StreamingTest;
import org.apache.spark.mllib.stat.test.StreamingTestResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class StreamingTestExample$ {
    public static final StreamingTestExample$ MODULE$;

    static {
        new StreamingTestExample$();
    }

    public void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: StreamingTestExample <dataDir> <batchDuration> <numBatchesTimeout>");
            System.exit(1);
        }
        String dataDir = args[0];
        Duration batchDuration = Seconds$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(args[1])).toLong());
        int numBatchesTimeout = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        SparkConf conf = new SparkConf().setMaster("local").setAppName("StreamingTestExample");
        StreamingContext ssc = new StreamingContext(conf, batchDuration);
        File dir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        ssc.checkpoint(dir.toString());
        DStream data = ssc.textFileStream(dataDir).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BinarySample apply(String line) {
                String[] stringArray = line.split(",");
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    String label = (String)((SeqLike)option.get()).apply(0);
                    String value = (String)((SeqLike)option.get()).apply(1);
                    BinarySample binarySample = new BinarySample(new StringOps(Predef$.MODULE$.augmentString(label)).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(value)).toDouble());
                    return binarySample;
                }
                throw new MatchError((Object)stringArray);
            }
        }, ClassTag$.MODULE$.apply(BinarySample.class));
        StreamingTest streamingTest = new StreamingTest().setPeacePeriod(0).setWindowSize(0).setTestMethod("welch");
        DStream out = streamingTest.registerStream(data);
        out.print();
        IntRef timeoutCounter = IntRef.create((int)numBatchesTimeout);
        out.foreachRDD((Function1)new Serializable(timeoutCounter){
            public static final long serialVersionUID = 0L;
            private final IntRef timeoutCounter$1;

            public final void apply(RDD<StreamingTestResult> rdd) {
                --this.timeoutCounter$1.elem;
                boolean anySignificant = BoxesRunTime.unboxToBoolean((Object)rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(StreamingTestResult x$1) {
                        return x$1.pValue() < 0.05;
                    }
                }, ClassTag$.MODULE$.Boolean()).fold((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(boolean x$2, boolean x$3) {
                        return x$2 || x$3;
                    }
                }));
                if (this.timeoutCounter$1.elem == 0 || anySignificant) {
                    rdd.context().stop();
                }
            }
            {
                this.timeoutCounter$1 = timeoutCounter$1;
            }
        });
        ssc.start();
        ssc.awaitTermination();
    }

    private StreamingTestExample$() {
        MODULE$ = this;
    }
}

