/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RecommendationExample$ {
    public static final RecommendationExample$ MODULE$;

    static {
        new RecommendationExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("CollaborativeFilteringExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile("data/mllib/als/test.data", sc.textFile$default$2());
        RDD ratings = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Rating apply(String x$1) {
                String[] stringArray = new StringOps(Predef$.MODULE$.augmentString(x$1)).split(',');
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
                    String user = (String)((SeqLike)option.get()).apply(0);
                    String item = (String)((SeqLike)option.get()).apply(1);
                    String rate = (String)((SeqLike)option.get()).apply(2);
                    Rating rating = new Rating(new StringOps(Predef$.MODULE$.augmentString(user)).toInt(), new StringOps(Predef$.MODULE$.augmentString(item)).toInt(), new StringOps(Predef$.MODULE$.augmentString(rate)).toDouble());
                    return rating;
                }
                throw new MatchError((Object)stringArray);
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
        int rank = 10;
        int numIterations = 10;
        MatrixFactorizationModel model = ALS$.MODULE$.train(ratings, rank, numIterations, 0.01);
        RDD usersProducts = ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Rating x0$1) {
                Rating rating = x0$1;
                if (rating != null) {
                    int user = rating.user();
                    int product = rating.product();
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(user, product);
                    return sp2;
                }
                throw new MatchError((Object)rating);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD predictions = model.predict(usersProducts).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Object> apply(Rating x0$2) {
                Rating rating = x0$2;
                if (rating != null) {
                    int user = rating.user();
                    int product = rating.product();
                    double rate = rating.rating();
                    Tuple2 tuple2 = new Tuple2((Object)new Tuple2.mcII.sp(user, product), (Object)BoxesRunTime.boxToDouble((double)rate));
                    return tuple2;
                }
                throw new MatchError((Object)rating);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD ratesAndPreds = RDD$.MODULE$.rddToPairRDDFunctions(ratings.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Object> apply(Rating x0$3) {
                Rating rating = x0$3;
                if (rating != null) {
                    int user = rating.user();
                    int product = rating.product();
                    double rate = rating.rating();
                    Tuple2 tuple2 = new Tuple2((Object)new Tuple2.mcII.sp(user, product), (Object)BoxesRunTime.boxToDouble((double)rate));
                    return tuple2;
                }
                throw new MatchError((Object)rating);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).join(predictions);
        double MSE = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(ratesAndPreds.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x0$4) {
                Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> tuple2 = x0$4;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null && tuple23 != null) {
                        double r1 = tuple23._1$mcD$sp();
                        double r2 = tuple23._2$mcD$sp();
                        double err = r1 - r2;
                        double d = err * err;
                        return d;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.Double())).mean();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mean Squared Error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)MSE)})));
        model.save(sc, "target/tmp/myCollaborativeFilter");
        MatrixFactorizationModel sameModel = MatrixFactorizationModel$.MODULE$.load(sc, "target/tmp/myCollaborativeFilter");
        sc.stop();
    }

    private RecommendationExample$() {
        MODULE$ = this;
    }
}

