/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.DecisionTreeRunner$;
import org.apache.spark.examples.mllib.GradientBoostedTreesRunner;
import org.apache.spark.examples.mllib.GradientBoostedTreesRunner$;
import org.apache.spark.examples.mllib.GradientBoostedTreesRunner$Params$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy$;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Either;
import scopt.OptionParser;
import scopt.Read$;

public final class GradientBoostedTreesRunner$ {
    public static final GradientBoostedTreesRunner$ MODULE$;

    static {
        new GradientBoostedTreesRunner$();
    }

    public void main(String[] args) {
        GradientBoostedTreesRunner.Params defaultParams = new GradientBoostedTreesRunner.Params(GradientBoostedTreesRunner$Params$.MODULE$.apply$default$1(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$2(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$3(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$4(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$5(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$6(), GradientBoostedTreesRunner$Params$.MODULE$.apply$default$7());
        OptionParser<GradientBoostedTreesRunner.Params> parser = new OptionParser<GradientBoostedTreesRunner.Params>(defaultParams){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GradientBoostedTrees: an example decision tree app."}));
                this.opt("algo", Read$.MODULE$.stringRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"algorithm (", "), default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Algo$.MODULE$.values().mkString(","), defaultParams$1.algo()}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GradientBoostedTreesRunner.Params apply(String x, GradientBoostedTreesRunner.Params c) {
                        String x$2 = x;
                        String x$3 = c.copy$default$1();
                        String x$4 = c.copy$default$2();
                        String x$5 = c.copy$default$3();
                        int x$6 = c.copy$default$5();
                        int x$7 = c.copy$default$6();
                        double x$8 = c.copy$default$7();
                        return c.copy(x$3, x$4, x$5, x$2, x$6, x$7, x$8);
                    }
                });
                this.opt("maxDepth", Read$.MODULE$.intRead()).text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"max depth of the tree, default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.maxDepth())}))).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GradientBoostedTreesRunner.Params apply(int x, GradientBoostedTreesRunner.Params c) {
                        int x$9 = x;
                        String x$10 = c.copy$default$1();
                        String x$11 = c.copy$default$2();
                        String x$12 = c.copy$default$3();
                        String x$13 = c.copy$default$4();
                        int x$14 = c.copy$default$6();
                        double x$15 = c.copy$default$7();
                        return c.copy(x$10, x$11, x$12, x$13, x$9, x$14, x$15);
                    }
                });
                this.opt("numIterations", Read$.MODULE$.intRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of iterations of boosting,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultParams$1.numIterations())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GradientBoostedTreesRunner.Params apply(int x, GradientBoostedTreesRunner.Params c) {
                        int x$16 = x;
                        String x$17 = c.copy$default$1();
                        String x$18 = c.copy$default$2();
                        String x$19 = c.copy$default$3();
                        String x$20 = c.copy$default$4();
                        int x$21 = c.copy$default$5();
                        double x$22 = c.copy$default$7();
                        return c.copy(x$17, x$18, x$19, x$20, x$21, x$16, x$22);
                    }
                });
                this.opt("fracTest", Read$.MODULE$.doubleRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fraction of data to hold out for testing.  If given option testInput, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this option is ignored. default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)defaultParams$1.fracTest())}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GradientBoostedTreesRunner.Params apply(double x, GradientBoostedTreesRunner.Params c) {
                        double x$23 = x;
                        String x$24 = c.copy$default$1();
                        String x$25 = c.copy$default$2();
                        String x$26 = c.copy$default$3();
                        String x$27 = c.copy$default$4();
                        int x$28 = c.copy$default$5();
                        int x$29 = c.copy$default$6();
                        return c.copy(x$24, x$25, x$26, x$27, x$28, x$29, x$23);
                    }
                });
                this.opt("testInput", Read$.MODULE$.stringRead()).text(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input path to test dataset.  If given, option fracTest is ignored."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" default: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultParams$1.testInput()}))).toString()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GradientBoostedTreesRunner.Params apply(String x, GradientBoostedTreesRunner.Params c) {
                        String x$30 = x;
                        String x$31 = c.copy$default$1();
                        String x$32 = c.copy$default$3();
                        String x$33 = c.copy$default$4();
                        int x$34 = c.copy$default$5();
                        int x$35 = c.copy$default$6();
                        double x$36 = c.copy$default$7();
                        return c.copy(x$31, x$30, x$32, x$33, x$34, x$35, x$36);
                    }
                });
                this.opt("dataFormat", Read$.MODULE$.stringRead()).text("data format: libsvm (default), dense (deprecated in Spark v1.1)").action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GradientBoostedTreesRunner.Params apply(String x, GradientBoostedTreesRunner.Params c) {
                        String x$37 = x;
                        String x$38 = c.copy$default$1();
                        String x$39 = c.copy$default$2();
                        String x$40 = c.copy$default$4();
                        int x$41 = c.copy$default$5();
                        int x$42 = c.copy$default$6();
                        double x$43 = c.copy$default$7();
                        return c.copy(x$38, x$39, x$37, x$40, x$41, x$42, x$43);
                    }
                });
                this.arg("<input>", Read$.MODULE$.stringRead()).text("input path to labeled examples").required().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GradientBoostedTreesRunner.Params apply(String x, GradientBoostedTreesRunner.Params c) {
                        return c.copy(x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7());
                    }
                });
                this.checkConfig((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;

                    public final Either<String, BoxedUnit> apply(GradientBoostedTreesRunner.Params params) {
                        return params.fracTest() < 0.0 || params.fracTest() > 1.0 ? this.$outer.failure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fracTest ", " value incorrect; should be in [0,1]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)params.fracTest())}))) : this.$outer.success();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (option instanceof Some) {
            Some some = (Some)option;
            GradientBoostedTreesRunner.Params params = (GradientBoostedTreesRunner.Params)some.x();
            this.run(params);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw package$.MODULE$.exit(1);
    }

    public void run(GradientBoostedTreesRunner.Params params) {
        SparkConf conf = new SparkConf().setAppName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GradientBoostedTreesRunner with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        SparkContext sc = new SparkContext(conf);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GradientBoostedTreesRunner with parameters:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params})));
        Tuple3<RDD<LabeledPoint>, RDD<LabeledPoint>, Object> tuple3 = DecisionTreeRunner$.MODULE$.loadDatasets(sc, params.input(), params.dataFormat(), params.testInput(), Algo$.MODULE$.withName(params.algo()), params.fracTest());
        if (tuple3 != null) {
            Tuple3 tuple32;
            RDD training = (RDD)tuple3._1();
            RDD test = (RDD)tuple3._2();
            int numClasses = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)training, (Object)test, (Object)BoxesRunTime.boxToInteger((int)numClasses));
            RDD training2 = (RDD)tuple33._1();
            RDD test2 = (RDD)tuple33._2();
            int numClasses2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
            BoostingStrategy boostingStrategy = BoostingStrategy$.MODULE$.defaultParams(params.algo());
            boostingStrategy.treeStrategy().numClasses_$eq(numClasses2);
            boostingStrategy.numIterations_$eq(params.numIterations());
            boostingStrategy.treeStrategy().maxDepth_$eq(params.maxDepth());
            int randomSeed = Utils$.MODULE$.random().nextInt();
            String string = params.algo();
            String string2 = "Classification";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                long startTime = System.nanoTime();
                GradientBoostedTreesModel model = GradientBoostedTrees$.MODULE$.train(training2, boostingStrategy);
                double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training time: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)elapsedTime)})));
                if (model.totalNumNodes() < 30) {
                    Predef$.MODULE$.println((Object)model.toDebugString());
                } else {
                    Predef$.MODULE$.println((Object)model);
                }
                double trainAccuracy = new MulticlassMetrics(training2.map((Function1)new Serializable(model){
                    public static final long serialVersionUID = 0L;
                    private final GradientBoostedTreesModel model$1;

                    public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                        return new Tuple2.mcDD.sp(this.model$1.predict(lp.features()), lp.label());
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Train accuracy = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainAccuracy)})));
                double testAccuracy = new MulticlassMetrics(test2.map((Function1)new Serializable(model){
                    public static final long serialVersionUID = 0L;
                    private final GradientBoostedTreesModel model$1;

                    public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                        return new Tuple2.mcDD.sp(this.model$1.predict(lp.features()), lp.label());
                    }
                    {
                        this.model$1 = model$1;
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class))).accuracy();
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test accuracy = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)testAccuracy)})));
            } else {
                String string3 = params.algo();
                String string4 = "Regression";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    long startTime = System.nanoTime();
                    GradientBoostedTreesModel model = GradientBoostedTrees$.MODULE$.train(training2, boostingStrategy);
                    double elapsedTime = (double)(System.nanoTime() - startTime) / 1.0E9;
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training time: ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)elapsedTime)})));
                    if (model.totalNumNodes() < 30) {
                        Predef$.MODULE$.println((Object)model.toDebugString());
                    } else {
                        Predef$.MODULE$.println((Object)model);
                    }
                    double trainMSE = DecisionTreeRunner$.MODULE$.meanSquaredError(model, (RDD<LabeledPoint>)training2);
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Train mean squared error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)trainMSE)})));
                    double testMSE = DecisionTreeRunner$.MODULE$.meanSquaredError(model, (RDD<LabeledPoint>)test2);
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test mean squared error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)testMSE)})));
                }
            }
            sc.stop();
            return;
        }
        throw new MatchError(tuple3);
    }

    private GradientBoostedTreesRunner$() {
        MODULE$ = this;
    }
}

