/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.examples.ml.ALSExample;
import org.apache.spark.examples.ml.ALSExample$;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.recommendation.ALS;
import org.apache.spark.ml.recommendation.ALSModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class ALSExample$ {
    public static final ALSExample$ MODULE$;

    static {
        new ALSExample$();
    }

    public ALSExample.Rating parseRating(String str) {
        String[] fields = str.split("::");
        Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])fields).size() == 4);
        return new ALSExample.Rating(new StringOps(Predef$.MODULE$.augmentString(fields[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(fields[2])).toFloat(), new StringOps(Predef$.MODULE$.augmentString(fields[3])).toLong());
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("ALSExample").getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_ml_ALSExample$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.ml.ALSExample.Rating").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_ml_ALSExample$$typecreator4$1() {
            }
        }
        Dataset ratings = spark.read().textFile("data/mllib/als/sample_movielens_ratings.txt").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ALSExample.Rating apply(String str) {
                return ALSExample$.MODULE$.parseRating(str);
            }
        }, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_ml_ALSExample$$typecreator4$1()))).toDF();
        Dataset[] datasetArray = ratings.randomSplit(new double[]{0.8, 0.2});
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            Dataset training = (Dataset)((SeqLike)option.get()).apply(0);
            Dataset test = (Dataset)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)training, (Object)test);
            Dataset training2 = (Dataset)tuple22._1();
            Dataset test2 = (Dataset)tuple22._2();
            ALS als = new ALS().setMaxIter(5).setRegParam(0.01).setUserCol("userId").setItemCol("movieId").setRatingCol("rating");
            ALSModel model = als.fit(training2);
            model.setColdStartStrategy("drop");
            Dataset predictions = model.transform(test2);
            RegressionEvaluator evaluator = new RegressionEvaluator().setMetricName("rmse").setLabelCol("rating").setPredictionCol("prediction");
            double rmse2 = evaluator.evaluate(predictions);
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Root-mean-square error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rmse2)})));
            Dataset userRecs = model.recommendForAllUsers(10);
            Dataset movieRecs = model.recommendForAllItems(10);
            Dataset users = ratings.select(als.getUserCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().limit(3);
            Dataset userSubsetRecs = model.recommendForUserSubset(users, 10);
            Dataset movies = ratings.select(als.getItemCol(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).distinct().limit(3);
            Dataset movieSubSetRecs = model.recommendForItemSubset(movies, 10);
            userRecs.show();
            movieRecs.show();
            userSubsetRecs.show();
            movieSubSetRecs.show();
            spark.stop();
            return;
        }
        throw new MatchError((Object)datasetArray);
    }

    private ALSExample$() {
        MODULE$ = this;
    }
}

