/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.mllib.clustering.StreamingKMeans;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LabeledPoint$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.dstream.DStream;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class StreamingKMeansExample$ {
    public static final StreamingKMeansExample$ MODULE$;

    static {
        new StreamingKMeansExample$();
    }

    public void main(String[] args) {
        if (args.length != 5) {
            System.err.println("Usage: StreamingKMeansExample <trainingDir> <testDir> <batchDuration> <numClusters> <numDimensions>");
            System.exit(1);
        }
        SparkConf conf = new SparkConf().setAppName("StreamingKMeansExample");
        StreamingContext ssc = new StreamingContext(conf, Seconds$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(args[2])).toLong()));
        DStream trainingData = ssc.textFileStream(args[0]).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(String s) {
                return Vectors$.MODULE$.parse(s);
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        DStream testData = ssc.textFileStream(args[1]).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(String s) {
                return LabeledPoint$.MODULE$.parse(s);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        StreamingKMeans qual$1 = new StreamingKMeans().setK(new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt()).setDecayFactor(1.0);
        int x$1 = new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt();
        double x$2 = 0.0;
        long x$3 = qual$1.setRandomCenters$default$3();
        StreamingKMeans model = qual$1.setRandomCenters(x$1, x$2, x$3);
        model.trainOn(trainingData);
        model.predictOnValues(testData.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)lp.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double()).print();
        ssc.start();
        ssc.awaitTermination();
    }

    private StreamingKMeansExample$() {
        MODULE$ = this;
    }
}

