/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.evaluation.MultilabelMetrics;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MultiLabelMetricsExample$ {
    public static final MultiLabelMetricsExample$ MODULE$;

    static {
        new MultiLabelMetricsExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("MultiLabelMetricsExample");
        SparkContext sc = new SparkContext(conf);
        RDD scoreAndLabels = sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new double[]{0.0, 1.0}, (Object)new double[]{0.0, 2.0}), new Tuple2((Object)new double[]{0.0, 2.0}, (Object)new double[]{0.0, 1.0}), new Tuple2(Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), (Object)new double[]{0.0}), new Tuple2((Object)new double[]{2.0}, (Object)new double[]{2.0}), new Tuple2((Object)new double[]{2.0, 0.0}, (Object)new double[]{2.0, 0.0}), new Tuple2((Object)new double[]{0.0, 1.0, 2.0}, (Object)new double[]{0.0, 1.0}), new Tuple2((Object)new double[]{1.0}, (Object)new double[]{1.0, 2.0})})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
        MultilabelMetrics metrics = new MultilabelMetrics(scoreAndLabels);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recall = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.recall())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Precision = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.precision())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"F1 measure = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.f1Measure())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accuracy = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.accuracy())})));
        Predef$.MODULE$.doubleArrayOps(metrics.labels()).foreach((Function1)new Serializable(metrics){
            public static final long serialVersionUID = 0L;
            private final MultilabelMetrics metrics$1;

            public final void apply(double label) {
                this.apply$mcVD$sp(label);
            }

            public void apply$mcVD$sp(double label) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Class ", " precision = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)label), BoxesRunTime.boxToDouble((double)this.metrics$1.precision(label))})));
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
        Predef$.MODULE$.doubleArrayOps(metrics.labels()).foreach((Function1)new Serializable(metrics){
            public static final long serialVersionUID = 0L;
            private final MultilabelMetrics metrics$1;

            public final void apply(double label) {
                this.apply$mcVD$sp(label);
            }

            public void apply$mcVD$sp(double label) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Class ", " recall = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)label), BoxesRunTime.boxToDouble((double)this.metrics$1.recall(label))})));
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
        Predef$.MODULE$.doubleArrayOps(metrics.labels()).foreach((Function1)new Serializable(metrics){
            public static final long serialVersionUID = 0L;
            private final MultilabelMetrics metrics$1;

            public final void apply(double label) {
                this.apply$mcVD$sp(label);
            }

            public void apply$mcVD$sp(double label) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Class ", " F1-score = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)label), BoxesRunTime.boxToDouble((double)this.metrics$1.f1Measure(label))})));
            }
            {
                this.metrics$1 = metrics$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Micro recall = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.microRecall())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Micro precision = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.microPrecision())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Micro F1 measure = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.microF1Measure())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hamming loss = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.hammingLoss())})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Subset accuracy = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.subsetAccuracy())})));
        sc.stop();
    }

    private MultiLabelMetricsExample$() {
        MODULE$ = this;
    }
}

